<?php
class mScriptDeleteDirectories
{
    private $db;
    private $root;
    private $paths;
    private $deletedPaths;

    function __construct($db, $paths, $root = null)
    {
        $this->db = $db;
        $this->setRootDir($root);

        $this->paths = $paths;
        $this->deletedPaths = Array();
    }

    private function setRootDir($value = null)
    {
		if(!is_null($value))
		{
			$this->root = $value;
			return;
		}

        if(!is_null($this->db))
        {
            $this->db->ChangeDatabase(DB_WARPIT_MAIN);
            $sql = "SELECT cValue FROM _WarpitConfig WHERE prefix = 'paths' AND cName = 'warpit_webprojects'";
            if(!$res = $this->db->SQLexecute($sql))
            {
                $this->root = "/";
                return;
            }
            $row = $this->db->fetchAssoc($res);
            $this->root = $row["cValue"];
        }

        if(is_null($this->root))
        {
            $this->root = "/";
        }
    }

    private function cleanPath($inPath)
    {
        return str_replace("//", "/", $inPath);
    }

    public function executeDelete()
    {
        foreach($this->paths as $path)
        {
            $fullPath = $this->cleanPath($this->root . $path);
            if(file_exists($fullPath))
            {
                if(is_dir($fullPath))
                {
                    $this->deleteDirectoryRecursive($fullPath);
                }
                else
                {
                    $this->deleteFile($fullPath);
                }
            }
            else
            {
                $this->deletedPaths[] = Array("type" => "non-existing", "path" => $fullPath );
            }
        }
    }

    function deleteDirectoryRecursive($path)
    {
        $path = $this->cleanPath($path);
        
		$dir = opendir($path);
        while(false !== ( $file = readdir($dir)) )
        {
            if (( $file != '.' ) && ( $file != '..' ))
            {
                $filePath = $this->cleanPath($path . '/' . $file);
                if ( is_dir($filePath) )
                {
                    $this->deleteDirectoryRecursive($filePath);
                }
                else
                {
                    $this->deleteFile($filePath);
                }
            }
        }
        closedir($dir);

        $this->deleteDirectory($path);
    }

    private function deleteDirectory($path)
    {
        $this->deletedPaths[] = Array("type" => "dir", "path" => $path );
        rmdir($path);
    }

    private function deleteFile($file)
    {
        $this->deletedPaths[] = Array("type" => "file", "path" => $file );
        unlink($file);
    }

    public function getLogString()
    {
        $logString = "";

        $logPaths = array_reverse($this->deletedPaths);
        foreach($logPaths as $deletedPath)
        {
            $logString .= $deletedPath["type"] . ": " . $deletedPath["path"] . "<br />";
        }
        return $logString;
    }
}

$pathsToDelete = $scriptParams->{"pathsToDelete"};

if(!is_null($pathsToDelete) && count($pathsToDelete) > 0)
{
	$deleteScriptObject = new mScriptDeleteDirectories($this->db, $pathsToDelete);
	$deleteScriptObject->executeDelete();
	//echo "<br />{$deleteScriptObject->getLogString()}<br />";
}
?>

