<?php

	$compName = "WEBpointsManagerList";
	$ajax = "webuserspool/_forms/cati/_ajax/ajax.webpoints-manager-list.php";

?>

    var <?php echo $compName; ?> = new Ext.grid.EditorGridPanel({
        
    	store: new Ext.data.GroupingStore({
			url: '<?php echo $ajax; ?>',
			remoteGroup:true,
			
			reader: new Ext.data.JsonReader({		
				root:'rows',
				totalProperty : "results",
				idProperty:"id"
			},
				new Ext.data.Record.create(
					[
					 	
					 { name:"pointsDate", type: 'string' },
					 { name:"n", type: 'int' },
					  { name:"points", type: 'int' }
					]
				)

			)
    	}),
        id: '<?php echo $compName; ?>',
        border: false,
       
       	columns: [
      		{header: 'Dates',   width:150, sortable: true,dataIndex: 'pointsDate' },
      		{header: 'N',   width:50, sortable: true,dataIndex: 'n' } ,
      		{header: 'Points',   width:50, sortable: true,dataIndex: 'points' }	 	  	
        ],
        
      
		
		sm: new Ext.grid.RowSelectionModel({
                singleSelect: true,
                listeners: {
                	 rowselect: function(smObj, rowIndex, record) {  
                		Ext.getCmp('WEBpointsManagerListResult').getStore().load({
                			params: {
                				pointsDate : record.get('pointsDate'),
                				action: 'loadPoints'
                			}
                		}); 
                	 }
                }     			
       	}),
       /*	listeners: {
       		
       		afteredit : function(e) {
       		
       			Ext.Ajax.request({
       				url:'<?php echo $ajax; ?>',
       				params: { action: 'update' ,
       								
       							  id: e.record.data.id,
							   field: e.field,
								value : e.value
								
       				},
					success : function(resp,opt){ 
						e.record.commit();  
					}							  							
				})
			}
			
		},*/
       	tbar: [{
       		text : 'Add',
       		handler : function() {
       		
       			selectedPoolGroup  = Ext.getCmp('PoolMenu_1').getSelectionModel().getSelectedNode();
       			//console.log(selectedPoolGroup);
       			new Ext.Window({
       				id : 'AddingNewPoolPointsWindow',
	                layout:'fit',
	                bodyStyle:'padding:2px 2px 2px 2px',
	                title: 'Adding new points',
	                width:200,
	                height: 150,
	                closeAction:'close',
	                plain: true,
	                items : [
	                	new Ext.form.Label({ html: 'You will add points for group: <br><br><b>' + selectedPoolGroup.attributes.text + '</b><br><br>Points: '   }),
	                	new Ext.form.TextField({ width:40, id: 'newPointsInput' })
	                ],
	                buttons: [{
	                	text: 'Add',
	                	handler: function() {
	                		//alert(Ext.getCmp('newPointsInput').getValue());
	                		CallScript('<?php echo $ajax; ?>', { action: 'add-new-points', number : Ext.getCmp('newPointsInput').getValue(), groupID : selectedPoolGroup.attributes.id });
	                	}
	                }]
            	}).show();
       		
       			//CallScript('_forms/galerija/ajax/ajax.galerija-seznam.php', { action: 'create', reloadCmp : '<?php echo $compName; ?>' }); 		
       		}
       	},
       	{
       		text : 'Delete',
       		handler : function() {
       				if (<?php echo $compName; ?>.getSelectionModel().hasSelection()) {
       					rec = Ext.getCmp('<?php echo $compName; ?>').getSelectionModel().getSelected();	
			            		Ext.Msg.show({
								   title:'Points Delete',
								   msg: 'Are you sure to delete all points  (' + rec.get('n') + ') in date ' + rec.get('pointsDate'),
								   buttons: Ext.Msg.YESNO,
								   fn: function(selBtn) { 
								   		if (selBtn == 'yes') {
								   			Ext.Ajax.request({
							       				url:'<?php echo $ajax; ?>',
							       				params: {
							       					 action: 'delete' ,
							       					 pointsDate: rec.get('pointsDate')					
							       				},
												success : function(resp,opt){ Ext.getCmp('<?php echo $compName; ?>').getStore().reload() }							  							
											})	
								   		}
								   },
								   animEl: 'elId',
								   icon: Ext.MessageBox.QUESTION
								});
						}		
       		}
       	}]
    });
    
    
<?php echo $compName; ?>.getStore().load();  