<?php 

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."_class/createQuestion/Question.php");
include_once(PATH_TO_ROOT."webrecode/_class/class.autocode.php");


$id_project =  $_POST['id_project'];

$projData = $db->get('_Projects',$id_project,'proj_name,language',DB_WARPIT_WEBCATI_BASE);
$tableName = $projData['proj_name'];
$id_language = $projData['language'];

if($_POST['resetRecode'])
{
	$db->ChangeDatabase(DB_WARPIT_WEBRECODE);
	if($db->TableExists($tableName))
	{
		$db->SQLexecute("DROP TABLE IF EXISTS `$tableName"."`, `$tableName"."_calc`, `$tableName"."_labels`, `$tableName"."_multicode`, `$tableName"."_rec_def`, `$tableName"."_var_lab`;");
		$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		$db->SQLexecute("ALTER TABLE $tableName"."_structure DROP recoded");
	}
	echo "{success:true}";
	exit;
}


// check if I already have autorecoded answers
$autocode = new autocode($db);
$autocodeStatus = $autocode->getCodeStatus($tableName); 
$db->LogWrite($autocodeStatus,true,"autocode status");

//create tables! basic table
$db->ChangeDatabase(DB_WARPIT_WEBCATI);
$sql = "SELECT id,q_name,tip_sql,open_sql,open_answers,variableTypeBase,variableTypeOpen FROM $tableName WHERE tip_sql=4 OR ((tip_sql=1 OR tip_sql=3) AND open_answers != '') ORDER by q_pos";
$db->LogWrite($sql,true,"read all question with open type definition");
$res = $db->SQLexecute($sql);

//auto id from labels!
$x = $db->getAutoIncVal($tableName.'_labels');
if(!$x) $x = 1;
$db->ChangeDatabase(DB_WARPIT_WEBCATI);
while ($row = $db->fetchAssoc($res))
{
	$q = Question::createQuestion($row['tip_sql'],$db,$row);
	$q->fillLanguage($tableName,$row['id'],$id_language);
	//we get the numbers of columns needed! supposly this is the number of other questions!
	$vars = $q->getRecodeVars();
	$recVars = $vars[0];
	$qName = $row['q_name'];
	
	$qRecVars[$qName] = $recVars;
	$qLabels[$qName] = array();
	$qLabCount[$qName] = array();
	
	$db->LogWrite(print_r($recVars,1),true,"recode variables");
	foreach ($recVars as $var) {
		$sqlBasicCols[] = $var;
	}
	$db->LogWrite(print_r($sqlBasicCols,1),true,"basic columns");
	
	
	// 2014.12.19 - Borut add strip tags, this removes BUG inside grid not showing variable labels correctly
	$vpr_sql = addslashes(strip_tags($q->vpr_sql));
	$qIndex = 0;
	foreach ($recVars as $qVar)
	{
		$qIndex++;
		$tmp = explode('_',$qVar);
		$col[] = $qVar;
		$recVarTmp = 'r_'.$tmp[0].'_'.$qIndex;
		$col_r[] = $recVarTmp;
		$recDef['r_'.$qName][] = $qVar;
		$varLab[] = "('".$qVar."' , '". $vpr_sql ."')" ;
		$varLab_r[] = "('$recVarTmp' , '". $vpr_sql ."')" ;
		
		$strucVars[] = $qVar;
	}
	//for better sorting of the var_lab table!!!
	$c = count($col_r);
	for ($i=0;$i<$c;$i++ ) {
		$varLab[] = $varLab_r[$i];
		$col[] = $col_r[$i];
	}
	$varLab_r = array();
	$col_r = array();
	
	$recDefLab['r_'.$qName] = $vpr_sql ;
	
	
	$db->LogWrite(print_r($vars[1],1),true,"answers array");
	// if autocoding for the first time...
	if (!$autocodeStatus) {
		//for sr and mr we fill the labels table with non-open answers!
		foreach ($vars[1] as $ansVar => $ansLab) {
			//in this array we store the labels seperated by questions!
			$qLabels[$qName][$ansVar-1] = $ansLab;
			//in this array we store the count of the labels!
			$qLabCount[$qName][$ansVar-1] = 0;
			//in this array we store the recode variable of this label
			$qLabVarName[$qName][$ansVar-1] = 'r_'.$qName;
			//in this array we store the increment of the AI key that the label will get, to use in the calc table!
			$qLabAutoId[$qName][$ansVar-1] = $x;
			$sqlLabValues[] = "($x,".$ansVar.",'".addslashes($ansLab)."','$qName')";
			$x++;
		}
	}
	
}

$db->LogWrite(print_r($qLabels,1),true,"labels");
$db->LogWrite(print_r($qLabCount,1),true,"labels count");
$db->LogWrite(print_r($qLabVarName,1),true,"recode variable");
$db->LogWrite(print_r($qLabAutoId,1),true,"AI key");
$db->LogWrite(print_r($sqlLabValues,1),true,"values for labels table");


// if yes, load existing into arrays
if ($autocodeStatus) {
	// read in existing coded labels and make index arrays
	$autocode->loadExistingCodes($tableName);
	
	//read the structure table and try to do some autocoding
	$x = $autocode->getLabelsForCoding($x,$strucVars,$tableName,$qRecVars,$recVars,$qLabels,$qLabCount,$qLabVarName,$qLabAutoId,$sqlLabValues); // inside x is stored latest id of indexed label
	
} else { //if not, autocode from start 
	$autocode->createRecodeTables($tableName,$col);	
	$autocode->fillVarLabTable($tableName,$varLab);
	$autocode->fillRecodeDefinitionTable($tableName,$recDef,$recDefLab);

	//read the structure table and try to do some autocoding
	$x = $autocode->getLabelsForCoding($x,$strucVars,$tableName,$qRecVars,$recVars,$qLabels,$qLabCount,$qLabVarName,$qLabAutoId,$sqlLabValues); // inside x is stored latest id of indexed label
}
	

	$db->ChangeDatabase(DB_WARPIT_WEBRECODE);
	$sqlLabValues = $autocode->get_sqlLabValues();
	$sqlBasicVals = $autocode->get_sqlBasicVals();
	$qLabels = $autocode->get_qLabels();
	$qLabCount = $autocode->get_qLabCount();
	$qLabVarName = $autocode->get_qLabVarName();
	$qLabAutoId = $autocode->get_qLabAutoId();
	$qLabCountAll = $autocode->get_qLabCountAll();
	
	if($sqlBasicVals) {
		$db->SQLexecute("INSERT INTO $tableName (id,".implode(',',$sqlBasicCols).") VALUES ".implode(',',$sqlBasicVals) );
	}
	
	if ($sqlLabValues) {
		$db->SQLexecute("INSERT INTO $tableName"."_labels (id,id_var,label,var_name) VALUES ".implode(',',$sqlLabValues) );
	}
	
	foreach ($qLabels as $qName => $qArr) {
		$c = count($qArr);
		$all = $qLabCountAll[$qName];
		
		foreach($qArr as $i => $wtf) {
			if($all == 0) {
				$percent = 0;
			} else {
				$percent = round( $qLabCount[$qName][$i] / $all * 100,2);
			}
			
			$sqlCalcValues[] = "( ".( $qLabAutoId[$qName][$i] ).",".$qLabCount[$qName][$i].",'$percent%','".$qLabVarName[$qName][$i]."')" ;
		}
	}
	$db->SQLexecute("INSERT INTO $tableName"."_calc (id_label,number,procent,var_name) VALUES ".implode(',',$sqlCalcValues) );

	
echo "{success:true}";

?>