<?php

class Installer
{
    private $db;
    
    private $plugin_table;
    
    private $plugin_name;
    
    private $plugin_path;
    
    private $property_list;
    
    private $table;
    
    private $errors;
    
    private $install_path;
    
    public function __construct($db, $path)
    {
        $this->db = $db;
        $this->plugin_table = "_Plugin";
        $this->plugin_name = 'Slider plugin';
        $this->plugin_path = 'slider';
        
        $this->install_path = $path;
        
        $this->errors = array();
    }
    
    public function install()
    {
        $this->init();
        if(!$this->pluginExsist())
        {
            $this->createDatabase();
            
            return TRUE;
        }
        else
        {
            $this->errors[] = "Plugin name already exist in database!";
            return FALSE;
        }
    }
    
    public function getErrors()
    {
        return $this->errors;
    }
    
    
    private function pluginExsist()
    {
       $sql  = "SELECT plugin_name FROM ". DB_WARPIT_WEBCATI_BASE. "." . $this->plugin_table .  "  
            WHERE plugin_path = '" . $this->plugin_name ."'";
            
            
       $res= $this->db->SQLexecute($sql);
       if($this->db->NumRows($res) > 0)
       {
           return TRUE;
       }
       return FALSE;
        
    }
    
    private function init()
    {
        $this->property_list = array(
            //array('name', 'label', 'type', 'default_value'),
            array('upper_bound', 'Upper bound', 'string', ''),
            array('scale_type', 'Scale type', 'string', '1'),
            array('step', 'Step', 'int', '1'),
            array('slider_font', 'Slider font', 'string', 'Arial'),
            array('slider_font_color', 'Slider font color', 'string', 'black'),
            array('slider_font_size', 'Slider font size', 'int', '11'),
            array('extreme_font', 'Extreme font', 'string', 'Arial'),
            array('extreme_font_size', 'Extreme font size', 'int', '11'),
            array('extreme_font_color', 'Extreme font color', 'string', 'black'),
            array('extreme_circle_color', 'Extreme circle color', 'string', '#0094da'),
            array('extreme_radius', 'Extreme radius', 'int', '45'),
            array('slider_type', 'Slider type', 'string', '2'),
            array('extreme_border_width', 'Extreme border width', 'int', '1'),
            array('lower_bound', 'Lower bound', 'string', ''),
            array('scale_font', 'Scale font', 'string', 'Arial'),
            array('slider_width', "Slider width", "int", '800'),
            array('scale_font_color', 'Scale font color', 'string', 'black'),
            array('scale_font_size', 'Scale font size', 'int', '11'),
            array('default_value', 'Default value', 'numberfield', '0'),
            array('default_text', 'Default text', 'string', 'Slide'),
            array('null_value', 'Null value', 'string', '-1'),
            array('interval_to', 'Interval to', 'float', '10'),
            array('interval_from', 'Interval from', 'float', '0'),
            array('show_buttons', 'Show buttons', 'bool', '0'),
            array('scale_values', 'Scale values', 'string', ''),
            array('scale_steps', 'Scale steps', 'string', ''),
            array('pole_image', 'Pole shape image', 'string', ''),
        );
        
    }
    
    private function createDatabase()
    {
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->plugin_table . " SET 
            plugin_name = '" . $this->plugin_name ."', plugin_path = '" . $this->plugin_path . "'
        ";
        
        $this->db->SQLexecute($sql);
        $plugin_id = $this->db->GetLastInsertId();
      
        $sql = file_get_contents($this->install_path . "/install/sql/database.sql");
        $this->db->SQLexecute($sql);
      
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._Plugin_label (name, label, type, default_value, id_plugin) VALUES ";
        $tmpSql = array();
        foreach($this->property_list as $property)
        {
            $tmp = implode("', '", $property);
            $tmpSql[] = "('" . $tmp  ."', " .  $plugin_id .")";
        }
        
        $sql .= implode(",", $tmpSql);
        $this->db->SQLexecute($sql); 
    }
}
?>