<?php

class Installer
{
    private $db;
    
    private $plugin_table;
    
    private $plugin_name;
    
    private $plugin_path;
    
    private $property_list;
    
    private $table;
    
    private $errors;
    
    private $install_path;
    
    public function __construct($db, $path)
    {
        $this->db = $db;
        $this->plugin_table = "_Plugin";
        $this->plugin_name = 'Gallery';
        $this->plugin_path = 'gallery';
        
        $this->install_path = $path;
        
        $this->errors = array();
    }
    
    public function install()
    {
        $this->init();
        if(!$this->pluginExsist())
        {
            $this->createDatabase();
            
            return TRUE;
        }
        else
        {
            $this->errors[] = "Plugin name already exist in database!";
            return FALSE;
        }
    }
    
    public function getErrors()
    {
        return $this->errors;
    }
    
    
    private function pluginExsist()
    {
       $sql  = "SELECT plugin_name FROM ". DB_WARPIT_WEBCATI_BASE. "." . $this->plugin_table .  "  
            WHERE plugin_path = '" . $this->plugin_name ."'";
            
            
       $res= $this->db->SQLexecute($sql);
       if($this->db->NumRows($res) > 0)
       {
           return TRUE;
       }
       return FALSE;
        
    }
    
    private function init()
    {
        $this->property_list = array(
            //array('name', 'label', 'type', 'default_value'),
            array('auto_play', 'Auto play', 'bool', '0', 'Other settings'),
            array('image_height', "Image height",'int', '600', 'Image settings'),
            array('image_width', "Image width", 'int' , '800', 'Image settings'),
            array('images_list', 'Image list', 'string', 'Click to edit image list', 'Image settings'),
            array('next_button_image','Image for next button', 'string', '', 'Button settings'),
            array('next_mouseover_button', 'Image for next button on mouseover', 'string', '', 'Button settings'),
            array('play_button_image', 'Image for play button', 'string', '', 'Button settings'),
            array('play_mouseover_button_image', 'Image for play on mouseover', 'string', '', 'Button settings'),
            array('prev_button_image', 'Image for previous button', 'string', '', 'Button settings'),
            array('prev_mouseover_button_image', 'Image for previous button on mouseover', 'string', '', 'Button settings'),
            array('show_buttons', 'Show buttons', 'bool', '1', 'Other settings'),
            array('show_navigation', 'Show navigation', 'bool', '1', 'Other settings'),
            array('sliding_interval', 'Interval in ms', 'int', '5000', 'Other settings'),
            array('stop_button_image', 'Image for stop button', 'string', '', 'Button settings'),
            array('stop_mouseover_button_image', 'Image for stop button on mouseover', 'string', '', 'Button settings')
        );
        
    }
    
    private function createDatabase()
    {
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->plugin_table . " SET 
            plugin_name = '" . $this->plugin_name ."', plugin_path = '" . $this->plugin_path . "'
        ";
        
        //$this->db->SQLexecute($sql);
        $plugin_id = $this->db->GetLastInsertId();
      
        $sql = file_get_contents($this->install_path . "/install/sql/database.sql");
        //$this->db->SQLexecute($sql);
        
        $sql = file_get_contents($this->install_path . "/install/sql/imageList.sql");
        
       // $this->db->SQLexecute($sql);
        
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._Plugin_label (name, label, type, default_value, group, id_plugin) VALUES ";
        $tmpSql = array();
        foreach($this->property_list as $property)
        {
            $tmp = implode("', '", $property);
            $tmpSql[] = "('" . $tmp  ."', " .  $plugin_id .")";
        }
        
        $sql .= implode(",", $tmpSql);
        $this->errors[] = $sql;
        exit;
        $this->db->SQLexecute($sql); 
    }
}
?>