<?php

class Installer
{
    private $db;
    
    private $plugin_table;
    
    private $plugin_name;
    
    private $plugin_path;
    
    private $property_list;
    
    private $table;
    
    private $errors;
    
    private $install_path;
    
    public function __construct($db, $path)
    {
        $this->db = $db;
        $this->plugin_table = "_Plugin";
        $this->plugin_name = 'dragandrop';
        $this->plugin_path = 'dragandrop';
        
        $this->install_path = $path;
        
        $this->errors = array();
    }
    
    public function install()
    {
        $this->init();
        if(!$this->pluginExsist())
        {
            $this->createDatabase();
            
            return TRUE;
        }
        else
        {
            $this->errors[] = "Plugin name already exist in database!";
            return FALSE;
        }
    }
    
    public function getErrors()
    {
        return $this->errors;
    }
    
    
    private function pluginExsist()
    {
       $sql  = "SELECT plugin_name FROM ". DB_WARPIT_WEBCATI_BASE. "." . $this->plugin_table .  "  
            WHERE plugin_path = '" . $this->plugin_name ."'";
            
            
       $res= $this->db->SQLexecute($sql);
	   
	   $this->errors[] = $sql;
	   $this->errors[] = mysql_error();
	   
       if($this->db->NumRows($res) > 0)
       {
           return TRUE;
       }
       return FALSE;
       
    }
    
    private function init()
    {
        $this->property_list = array(
            //array('name', 'label', 'type', 'default_value'),
            array('boxBaseColor', 'Box base color', 'string', '#999999', 'Box settings'),
            array('boxBgColor', "Box background color",'string', '#ffffff', 'Box settings'),
            array('boxBorderColor', "Box border color", 'string' , '#cccccc', 'Box settings'),
            array('boxCaptionHidden', 'Box caption hidden', 'bool', '0', 'Box settings'),
            array('boxMargin','Box margin', 'int', '20', 'Box settings'),
            array('boxNeutralColor', 'Box neutral color', 'string', '#aaaaaa', 'Box settings'),
            array('boxRoundCorners', 'Box rounded corners', 'int', '2', 'Box settings'),
            array('captionFontSize', 'Caption font size', 'int', '14', 'Other settings'),
            array('cardBaseColor', 'Card base color', 'string', '#fefefe', 'Card settings'),
            array('cardBorderColor', 'Card border color', 'string', '#000000', 'Card settings'),
            array('cardColumns', 'Card columns', 'int', '4', 'Card settings'),
            array('cardFontSize', 'Font size', 'int', '12', 'Card settings'),
            array('cardHeight', 'Card height', 'int', '80', 'Card settings'),
            array('cardPaddingInBox', 'Card padding', 'int', '10', 'Card settings'),
            array('cardRoundCorners', 'Card rounded corners', 'int', '2', 'Card settings'),
            array('cardRows', 'Card rows', 'int', '3', 'Card settings'),
            array('cardShadow', 'Card shadow', 'int', '5', 'Card settings'),
            array('cardShadowColor', 'Card shadow color', 'string', '#3d3d3d', 'Card settings'),
            array('cardsType', 'Cards type', 'int', '1', 'Card settings'),
            array('cardWidth', 'Card width', 'int', '120', 'Card settings'),
            array('centerLineColor', 'Center line color', 'string', '#000000', 'Other settings'),
            array('centerLineWidth', 'Center line width', 'int', '1', 'Other settings'),
            array('centerOffset', 'Center offset', 'int', '20', 'Other settings'),
            array('fullScreenWidth', 'Full screen width', 'bool', '0', 'Other settings'),
            array('horizontal_card_margin', 'Horizontal Card Margin', 'int', '0', 'Other settings'),
            array('itemsAlignHorizontal', 'Horizontal align', 'string', 'center', 'Other settings'),
            array('itemsAlignVertical', 'VerticalAlign', 'string', 'middle', 'Other settings'),
            array('layout', 'Layout', 'string', 'horizontal', 'Other settings'),
            array('neutralMargin', 'Neutral margin', 'int', '50', 'Other settings'),
            array('openAnswerEnabled', 'Open answer enabled', 'bool', '0', 'Open answer settings'),
            array('openAnswerRelQuestion', 'Open answer related question', 'string', '', 'Open answer settings'),
            array('openAnswerText', 'Open answer text', 'string', 'Please insert text: ', 'Open answer settings'),
            array('openAnswerTextArea', 'Open answer as textarea', 'bool', '0', 'Open answer settings'),
            array('resetEnabled', 'Reset enabled', 'bool', '0', 'Other settings'),
            array('resetOffsetLeft', 'Reset button offset left', 'int', '470', 'Other settings'),
            array('resetOffsetTop', 'Reset button offset top', 'int', '164', 'Other settings'),
            array('textAlign', 'Text align', 'string', 'center', 'Other settings')
        );
        
    }
    
    private function createDatabase()
    {
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->plugin_table . " SET 
            plugin_name = '" . $this->plugin_name ."', plugin_path = '" . $this->plugin_path . "'
        ";
        
        $this->db->SQLexecute($sql);
        $plugin_id = $this->db->GetLastInsertId();
      
        $sql = file_get_contents($this->install_path . "/install/sql/database.sql");
        $this->db->SQLexecute($sql);
        
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._Plugin_label (`name`, `label`, `type`, `default_value`, `group`, `id_plugin`) VALUES ";
        $tmpSql = array();
        foreach($this->property_list as $property)
        {
            $tmp = implode("', '", $property);
            $tmpSql[] = "('" . $tmp  ."', " .  $plugin_id .")";
        }
        
        $sql .= implode(",", $tmpSql);
      //  exit;
        $this->db->SQLexecute($sql); 
    }
}
?>