<?php 
class IntervalSelect
{
    private $table = "_plugin_intervalselect";
    
    private $id_plugin = 36;
    
    private $database = DB_WARPIT_WEBCATI_BASE;
    
    private $data;
    
    private $db;
    
    private $forbiddenProperties;
    
    public function __construct($db)
    {
        $this->db = $db;
        
        $this->forbiddenProperties = array(
            'minDate',
            'maxDate',
            'id_project',
            'deleted',
            'id_question'
        );
    }
    
    public function load($idProject, $idQuestion)
    {
        $sql = "SELECT * FROM " . $this->database . "." . $this->table . "
            WHERE id_question = " . $idQuestion . " AND id_project = " . $idProject . " AND deleted = 0";
         $res= $this->db->SQLexecute($sql);
         $this->data = $this->db->fetchAssoc($res);
         
         if(empty($this->data))
         {
            $sql = "SELECT * FROM " .  $this->database . "._Plugin_label
            WHERE id_plugin = " . $this->id_plugin;
            $res= $this->db->SQLexecute($sql);
            while ($dat = $this->db->fetchAssoc($res)) {  
                $this->data[$dat['name']] = $dat['default_value'];
            }
         }
    }
    
    public function getVal($key)
    {
        return $this->data[$key];
    }
    
    public function getOptions($array = NULL)
    {
        $tmpOptions = array();
        foreach($this->data as $option => $value)
        {
            if(!key_exists($option, $array) && !in_array($option, $this->forbiddenProperties))
            {
                if(in_array($value, array('true', 'false', '1', '0')) || is_numeric($value))
                    $tmpOptions[] = $option . " : "  . $value;
                else
                    $tmpOptions[] = $option . " : "  . "'" . $value . "'";
            }
        }
        
        foreach($array as $option => $value)
        {
            if(in_array($value, array('true', 'false', '1', '0')) || is_numeric($value))
                $tmpOptions[] = $option . " : "  . $value;
            else
                $tmpOptions[] = $option . " : "  . "'" . $value . "'";
        }
        
        return "{" . implode(",", $tmpOptions) . "}";
    }
}

?>