<?php

class ErrorReport
{
    public $error;
    
    private $db;
    
    private $tableName;
    
    private $idAttempt;
    
    public function __construct($db, $tableName)
    {
        $this->error = array();
        $this->db = $db;
        $this->tableName = $tableName;
        
         if(!$this->db->TableExists($this->tableName . '_errorReport', DB_WARPIT_WEBCATI_BASE))
            $this->createTable();
    }
    
    public function addError($qName, $msg, array $additionalData = NULL)
    {
        
        if(!is_null($additionalData))
        {
            $this->error[$qName][] = array_merge_recursive(array('msg' => $msg), $additionalData);
        }
        else
        {
            $this->error[$qName][] = array('msg' => $msg);
            
        }
    }
    
    public function toString()
    {
       
        //return var_export($this->error, TRUE); 
    }
    
    public function setIdAttempt($id_attempt)
    {
        $this->idAttempt = $id_attempt;
    }
    
    public function addAttempt()
    {
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->tableName . "_errorReport (id, d_start) VALUES(NULL, NOW())";
        $this->db->SQLexecute($sql);
        
        
        return "{ success: true, id_attempt: " . $this->db->GetLastInsertId() . " }";
    }
    
    public function completeAttempt($id)
    {
        $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "." . $this->tableName . "_errorReport SET d_stop = NOW() WHERE id = " . intval($id);
        //print $sql;
        $this->db->SQLexecute($sql);
        return "{success: true}";
    }
    
    public function save()
    {
        if($this->count() == 0) return;
        
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->tableName . "_errorReport(id_record, id_sup, q_name, msg, additionalData, d_start, d_stop) VALUES ";
        $tmpFields = array();
        foreach($this->error as $qname => $errorsArray)
        {
            foreach($errorsArray as $error)
            {
                $tmpSql = array();
                $tmpSql[] = $_SESSION['id_record'];
                $tmpSql[] = $this->idAttempt;
                $tmpSql[] = "'" . $qname . "'";
                $tmpSql[] = "'" . $error['msg'] . "'";
                $additionalData = "";
                foreach($error as $key => $val)
                {
                    if($key != "msg")
                        $data[$key] = $val;
                }
                $additionalData = json_encode($data);
                
                $tmpSql[] = "'" . mysql_real_escape_string($additionalData) . "'";
                $tmpSql[] = "NOW()";
                $tmpSql[] = "NOW()";
                $tmpFields[] = "(" . implode(',', $tmpSql) . ")";
            }
        }
      $sql .= implode(',', $tmpFields);
      $this->db->SQLexecute($sql);
     // print $sql;
    }
    
    public function createTable()
    {
        $sql = "CREATE TABLE IF NOT EXISTS " . DB_WARPIT_WEBCATI_BASE . ".`". $this->tableName ."_errorReport` (
                      `id` int(11) NOT NULL AUTO_INCREMENT,
                      `id_record` int(11) NOT NULL,
                      `id_sup` int(11) NOT NULL DEFAULT '0',
                      `q_name` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
                      `msg` text COLLATE utf8_unicode_ci NOT NULL,
                      `additionalData` text COLLATE utf8_unicode_ci NOT NULL,
                      `d_start` datetime NOT NULL,
                      `d_stop` datetime NOT NULL,
                      `orderBy` INT NOT NULL DEFAULT  '0',
                      `is_leaf` TINYINT( 1 ) NOT NULL DEFAULT  '1',
                      PRIMARY KEY (`id`)
                    ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;";
        $this->db->SQLexecute($sql);
    }
    
    public function count()
    {
        return count($this->error);
    }
    
    public function errorDump()
    {
        print "<pre>";
        var_dump($this->error);
        print "</pre>";
    }
}

?>