<?php

class capiSampler {

	private $db;
	public $sampleTable;
	public $idCapiTable;
	public $id_project;
	
	public function __construct($db) {
		$this->db = $db;
	}	
	
	
	public function insertCapiSampleAction() {
		$sql = "CREATE TABLE IF NOT EXISTS " . DB_WARPIT_WEBCATI_BASE.".".$this->sampleTable." (
		  `id` int(11) NOT NULL auto_increment,
		  `tdisable` tinyint(4) NOT NULL DEFAULT '0',
		  `id_sample` int(11) NOT NULL,
		  `id_sampleTable` int(11) NOT NULL,
		  `user_id` int(11) NOT NULL,
		  `user_type` tinyint(4) NOT NULL,
		  `planned_visit_time` int(11) NOT NULL,
		  `num_interviews` smallint(6) NOT NULL,
		  PRIMARY KEY  (`id`),
		  INDEX (`id_sample`),
		  UNIQUE `sampleUnique` ( `id_sample` , `id_sampleTable` )
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
		if(!$result = $this->db->SQLexecute($sql)) {
			echo "{success:false,error:'$sql --> " . $this->db->GetError()."'}";
		} 
		else 
		{
			
			$fields = explode(',',$_POST['fields']);
			if ($_POST['comboPodatki']) {
				foreach ($_POST['comboPodatki'] as $data => $value) {
					if(!$value > 0 ) continue;
					$att=array();
					$dataArr = explode('|',$data);
					foreach ($dataArr as $key => $code) {
						//sometimes the label can be after the code
						$code = explode(' ',$code);
						$code = $code[0];
						
						$att[$fields[$key]] = $code;
					}
					$num = $this->insertSample($_POST['type'], $att, $value);
					//$num = $s->get_ids($_POST["type"], $att, $value);
					if($num === false) $failArray[] = $data;
					else if( $num == $value )
					{
						$successArray[] = $data;
					}
					else
					{
						$tmpAr = array();
						$tmpAr[] = $att;
						$tmpAr[] = $num;
						$tmpAr[] = $value;
						$unsuccess[] = $tmpAr; 
					}
						
				}
			}
			else {
				$this->insertSamplePoints();
			}
		//	$this->insertSample($_POST['type']);
		
		
			// mark all addresses with project ID (temporary... at the moment only all address can be used, not partial)!!! 
			$this->markAdresses();
			echo "{success:true,comment:'insertCapiSampleAction'}";
		}
	} 
	

	private function markAdresses() {
		
		$sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE. "." . $this->sampleTable . " INNER JOIN " . DB_WARPIT_WEBCATI_BASE . "." . $this->capiTable . " a ON a.id = id_sample AND a.proj_reserved = 0 SET a.proj_reserved = $this->id_project";
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_04:" . $db->GetError();
			
		$sql = "SELECT max(id) FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->sampleTable;
		$maxId = $this->db->fetchArray($this->db->SQLexecute($sql));
		$maxId = $maxId[0];
		if(!$maxId) $maxId = 0;
		
		$sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE .". _Projects SET capi_reserve = $maxId WHERE id = $this->id_project";
		//echo "/*$sql\r\n*/";
		
		if(!$result = $this->db->SQLexecute($sql)) {
			return false;
		} else {
			return true;
		}
	}
	
	private function prepare_attributes($att)
	{
		$atrribute_pairs=array();
		foreach($att as $key => $value)
		{
			/*if(in_array($key, $this->table_fields)==false)
			{
				$this->errors[]=1; 		// The attribute was not found in the desired telephone table 
				return false;
			}*/
			$atrribute_pairs[]="{$key}='{$value}'";
		}
		$config = configLoader::loadConfig('webcati');
		$moreThenOnce = $config['select_sample_more_then_once'];
		
		if(!$moreThenOnce)
		{
			$atrribute_pairs[] = "proj_reserved = 0";
		}
		$this->joined_att=join(" AND ", $atrribute_pairs);
		
		print "/*" .$this->joined_att . "*/";
		
		return true;
	}
	
	private function insertSample($type, $att, $num_of_samples)
	{
		if(!$this->prepare_attributes($att)) return false;
		
		if($type == 1) $this->get_random_ids($num_of_samples);
		if($type == 2) $this->first_x_samples($num_of_samples);
		if($type == 3) $this->get_every_x_step($num_of_samples);
	}
	
	//TODO check if this actualy works
	private function get_random_ids($num_of_samples) {	
		/**
		 * Borut add 2014.11.20 - 12:00, IGNORE, not sure if this is a good idea, time will tell
		 */
		$sql = "INSERT IGNORE INTO " . DB_WARPIT_WEBCATI_BASE. "." . $this->sampleTable." (`id_sample`,`id_sampleTable`,`user_id`,`user_type`,`num_interviews`) 
			 	SELECT id," . $this->idCapiTable . ",0,0,1 FROM " . DB_WARPIT_WEBCATI_BASE . "." .$this->capiTable."
				WHERE " . $this->joined_att . "
				ORDER BY rand() LIMIT " . $num_of_samples;
		echo "/*$sql*/";
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);		
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_04:" . $this->db->GetError();
		
		return $this->db->affectedRows();	
	}
	
	
	/**
	 * Get first x id`s matching the search criteria
	 *
	 * @param INT $num_of_samples - The number of samples we intend to extract from the telephone table and insert it into the index table
	 * @return bool
	 */
	private function first_x_samples($num_of_samples) {
		/*$sql = "INSERT INTO " . $this->index_table_name . "($this->telIdField, " . $this->att_to_select . ") 
				SELECT id as $this->telIdField, " . $this->att_to_insert . " 
				FROM {$this->telTablePrefix}" . $this->table_name . " 
				WHERE " . $this->joined_att . "$this->specialSelectFilter = 0 AND usp_utime<".$this->getDelayWhere()." AND $this->select_where 
				ORDER BY {$this->telTablePrefix}" . $this->table_name . ".id LIMIT 0," . $num_of_samples;*/
		
		$sql = "INSERT IGNORE INTO " . DB_WARPIT_WEBCATI_BASE . "." .$this->sampleTable." (`id_sample`,`id_sampleTable`,`user_id`,`user_type`,`num_interviews`) 
			 	SELECT id," . $this->idCapiTable . ",0,0,1 FROM ". DB_WARPIT_WEBCATI_BASE . ".".$this->capiTable."
				WHERE " . $this->joined_att . "
				ORDER BY " . DB_WARPIT_WEBCATI_BASE . "." . $this->capiTable . ".id LIMIT " . $num_of_samples;
	//	print $sql;
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);		
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_02:" . $this->db->GetError();
		return $this->db->affectedRows();
	}

	private function get_every_x_step($num_of_samples) {
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);		

		$sql="DROP TEMPORARY TABLE IF EXISTS  rands_capi;";
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_01:" . $this->db->GetError();
		
		$sql="create temporary table rands_capi (rownum INT, id INT)";
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_02:" . $this->db->GetError();
		
		$sql="insert into rands_capi (rownum, id) SELECT @row := @row +1 AS rownum, id FROM (SELECT @row :=0)r," . $this->capiTable  . " WHERE " . $this->joined_att;

		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);		
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_03:" . $this->db->GetError();
				
		$sql="SELECT MAX(rownum) AS max_row FROM  rands_capi";
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_04:" . $this->db->GetError();
				
		$row=$this->db->fetchAssoc($result);
		//echo "MAX: " . $row["max_row"] . "<br/>";
		$max=floor($row["max_row"]/$num_of_samples);
		
		//echo "EVERY: " . $max . " STEP<br/>";		
		
		/*$sql="SET autocommit=0";
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_02:" . $this->db->GetError();*/
		$sql = "INSERT IGNORE INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->sampleTable." (`id_sample`,`id_sampleTable`,`user_id`,`user_type`,`num_interviews`) 
			 	SELECT a.id," . $this->idCapiTable . ",0,0,1 FROM `rands_capi` as a, " . DB_WARPIT_WEBCATI_BASE . "." . $this->capiTable . " as b WHERE  a.rownum % " . $max ." = 0 AND a.id = b.id LIMIT " . $num_of_samples; 
				" WHERE " . $this->joined_att . "  
				ORDER BY " . DB_WARPIT_WEBCATI_BASE . "." . $this->capiTable . ".id LIMIT " . $num_of_samples;

		//$sql="INSERT INTO " . $this->index_table_name . "($this->telIdField, " . $this->att_to_select . ") 
		//SELECT rands_capi.id as $this->telIdField," . $this->temp_table_att . " FROM rands_capi, {$this->telTablePrefix}" . $this->table_name . " WHERE rands_capi.rownum %" . $max . " =0 AND rands_capi.id={$this->telTablePrefix}" . $this->table_name . ".id LIMIT " . $num_of_samples;
		
		/*
		echo "----------------------<br/>";
		echo $sql;
		echo "<br/>-----------------------<br/>";
		*/
		
		if(!$result=$this->db->SQLexecute($sql))
			echo "<br/>ERROR_05:" . $this->db->GetError();
		
		return $this->db->affectedRows();
		//echo "<br/>ST: " . $num . "<br/>";
		if($num==$num_of_samples)
		{
			return true;
			$sql="COMMIT;";
			if(!$result=$this->db->SQLexecute($sql))
				echo "<br/>ERROR_02:" . $this->db->GetError();
		}
		else
		{
			$sql="ROLLBACK;";
			if(!$result=$this->db->SQLexecute($sql))
				echo "<br/>ERROR_02:" . $this->db->GetError();
			$this->errors[]=2; 		// The database does not contain the number of samples that were requested
				return false;
		}
		
		return $this->db->affectedRows();
		
		
	}
	
	
	private function insertSamplePoints() {
		$sql = "INSERT IGNORE INTO `".$this->sampleTable."` (`id_sample`,`id_sampleTable`,`user_id`,`user_type`,`num_interviews`) 
				SELECT id,".$this->idCapiTable.",0,0,1 FROM `".$this->capiTable."`";
		
		if(!$result = $this->db->SQLexecute($sql)) {
			return false;
		} else {
			return true;
		}
	}
	
}
?>