<?php 
class XMLExport
{
	private $db;
	/**
	 * the xml writer
	 *
	 * @var XMLWriter
	 */
	private $wr;
	
	private $inc_create = false;
	
	function __construct(db $db,XMLWriter $wr = null)
	{
		$this->db = $db;
		$this->wr = $wr;
		
		if($this->wr == null)
		{
			$this->wr = new XMLWriter();
			$this->wr->openMemory();
			$this->wr->startDocument('1.0');
			
		}
		
	}
	function includeCreate($b)
	{
		$this->inc_create = $b;
	}
	
	function exportTable($tableName,$tagName = null,$columns='*',$options = '1')
	{
		
		if($this->inc_create)
		{
			if(is_string($this->inc_create))
				$elem = $this->inc_create;
			else 
				$elem = 'create';
			$sql = $this->db->SQLexecute("SHOW CREATE TABLE $tableName");
			$row = $this->db->fetchArray($sql);
			$this->wr->startElement($elem);
			$this->wr->writeAttribute("name",$tableName);
			
			$this->wr->text(str_ireplace("CREATE TABLE `$tableName`","", $row[1]));
			$this->wr->endElement();
			
		}
		
		$sql = $this->db->SQLexecute("SELECT $columns FROM $tableName WHERE $options");
		if(!$sql) echo $this->db->JsonError();
	//	echo "SELECT $columns FROM $tableName WHERE $options";
		
	//	$this->wr->writeAttribute('name',$tableName);
		while ($row = $this->db->fetchAssoc($sql) ) 
			{
				$this->wr->startElement($tagName ? $tagName : $tableName);
				foreach ($row as $col => $value) 
				{
					$this->wr->writeElement($col,addslashes($value) );
				}
				$this->wr->endElement();
			
			}
	
				
	}
	
	function endXML()
	{
		$this->wr->endDocument();
		return $this->wr->flush();
	}
}
?>