<?php 
class ImportProject
{
	
	/**
	 * the connection to the database. It's recieved in the constructor
	 *
	 * @var db
	 */
	private $db;
	//the XMLwriter class
	private $wr;
	public $newProjId;
	/**
	 * Constructor, recieves class.dp.php for database connection
	 *
	 * @param unknown_type $db
	 */
	function __construct($db)
	{
		$this->db = $db;
	}
	//20150609 Tanis added parameter $manualProject
	public function import($xml,$project,$idSup = 0, $manualProject = 0)
	{
        $this->db->ChangeDatabase(DB_WARPIT_MAIN);
        $dbConfig = configLoader::loadConfig('webcati');
        $this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		// borut add stripslases on 7.2.2013, time will tell what we destroy with this...
   		$xml = stripslashes($xml);
		
		$rd = new XMLReader();
		$rd->XML($xml);
		
		while ($rd->read() )
		{
			if($rd->nodeType == XMLReader::ELEMENT)
			{
				if($rd->localName == "Properties")
				{
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
					$sm = new SimpleXMLElement( $rd->readOuterXml());
					$columns = array();
					$values = array();
					//set the basic variables
					$columns[] = 'proj_name';
					$values[] = $project;
					$columns[] = 'created';
					$values[] = date("d.m.Y - H:i");
					$columns[] = 'modify';
					$values[] = date("d.m.Y - H:i");
					if($_SESSION['UserInfo'])
					{
						$userName = $_SESSION['UserInfo']['Firstname']." ".$_SESSION['UserInfo']['Surname'];
						$columns[] = 'creat_name';
						$values[] = $userName;
						$columns[] = 'modi_name';
						$values[] = $userName;
					}
					$columns[] = 'old';
					$values[] = 'N';
					foreach ($sm as $col => $value) 
					{
						
							$columns[] = $col;
							$values[] = $value;
						
					}
                    
                    //20150608 Tanis 
					if($manualProject == 0)
					   $sql = "INSERT INTO _ProjectsTree(id_sup,is_leaf,idLab)VALUES($idSup,1,'$project')";
                    else
                        $sql = "INSERT INTO _ProjectsTree(id_sup,is_leaf,idLab, id)VALUES($idSup,1,'$project', $manualProject)";
                        //12356
                    //20150608 Tanis 
                    
					$this->db->SQLexecute($sql);	
					if($this->db->isError())
						return false;	
                    
					//20150609 Tanis 
                    if($manualProject == 0)
                    {
                        $lastInsertId =  $this->db->GetLastInsertId();
                       $this->newProjId = $lastInsertId;
                       
                    }
                    else 
                    {
                        $this->newProjId = $manualProject;                       
                        $lastInsertId = $manualProject;          
                    }
					$sqlkeyupd = "UPDATE _ProjectsTree SET id_project=$this->newProjId WHERE id='$lastInsertId'";
                    //20150609 Tanis END 
                    
					$this->db->SQLexecute($sqlkeyupd);
					
					$columns[] = 'id';
					$values[] = $this->newProjId;

					$password_chars = array (1,2,3,4,5,6,7,8,9,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','z','x','y','w');
					for ( $n = 0; $n < 10; $n++ ) {
			    			
			    			$pass_string .= $password_chars[rand(0, 34)];
			    		}
			    	$key_proj = $this->newProjId."-".$pass_string; 
			    	
			    	$columns[] = 'key_proj';
			    	$values[] = $key_proj;
					
			    	$columns[] = 'start_date';
					$values[] = date("Y-m-d");
					
                    $end_date = new DateTime();
                    $end_date->add(new DateInterval($dbConfig['end_data_default_interval']));
                    
					$columns[] = 'end_date';
					$values[] = $end_date->format("Y-m-d");
               
			    	
					$sql = "INSERT INTO _Projects (".implode(",",$columns).") VALUES ('".implode("','",$values)."')";
					//Secho $sql;	
					$this->db->SQLexecute($sql);	
					if($this->db->isError())
						return false;	
					
					
		
					
					
				}
				else if($rd->localName == 'Language')
				{
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
					$sm = new SimpleXMLElement( $rd->readOuterXml());
					$idLanguage = $sm->id_language;
					$sql = "INSERT INTO _LanguageProjects (id_language,id_project) VALUES ($idLanguage,$this->newProjId)";
					$this->db->SQLexecute($sql);
				}
				else if($rd->localName == 'Rotations')
				{
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
					$sm = new SimpleXMLElement( $rd->readOuterXml());
					$num_complex = -1;
					$num_packet = -1;
					foreach ($sm as $rot) {
						$tmpComplex = intval($rot->complex); $tmpPacket = intval($rot->packet);
						if($num_complex != $tmpComplex)//we insert a complex!
						{
							$this->db->SQLexecute("INSERT INTO _QuestionRotation(id_project,id_sup,type,orderBy) VALUES ($this->newProjId,0,0,$rot->complex)");
							$id_complex = $this->db->GetLastInsertId();
							$num_complex = intval($rot->complex);
							$num_packet = -1;
						}
						if($num_packet != $tmpPacket)
						{
						    //22.1.2015 Tanis spremenil zaradi napake pri uvozu.Z $rot->orderBy sem zamenjat $rot->packet.    
							$this->db->SQLexecute("INSERT INTO _QuestionRotation(id_project,id_sup,type,orderBy) VALUES ($this->newProjId,$id_complex,1,$rot->orderBy)");
							$id_packet = $this->db->GetLastInsertId();
							$num_packet = intval($rot->packet);
						}
						$this->db->SQLexecute("INSERT INTO _QuestionRotation(id_project,id_question,id_sup,id_complex,type,orderBy) VALUES ($this->newProjId,$rot->id_question,$id_packet,$id_complex,2,$rot->orderBy)");
							
					}
					
				}
                //20150608 Tanis we also want export ExtraVariables
                else if($rd->localName == 'ExtraVariables')
                {
                    $this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
                    $sm = new SimpleXMLElement( $rd->readOuterXml());
                    $tmpSql = array();
                    foreach ($sm as $var) 
                    {
                        $tmpSql[] = "('" . $var->var_name . "', " . $var->var_type . "," . $this->newProjId . ")";   
                    }
			         //20150821 Tanis
                    if(count($tmpSql) > 0)
                    {
                    	//$sql = "INSERT INTO _ProjectExtraVariables(var_name, var_type, id_project) VALUES " . implode(',', $tmpSql);
                    	//$this->db->SQLexecute($sql);
                    }
			        //20150821 Tanis END
                    
                    //$sql = "INSERT INTO _ProjectExtraVariables(var_name, var_type, id_project) VALUES " . implode(',', $tmpSql);
                    //$this->db->SQLexecute($sql);
                    
                }
                //20150508 Tanis END
                elseif($rd->localName == "Designes")
                {
                    $this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
                    $sm = new SimpleXMLElement( $rd->readOuterXml());
                    
                    foreach($sm as $design)
                    {
                        $tmpSql[] = "(
                            " . $design->id_template . ",
                            " . $design->id_question . ",
                            " . $design->id_type . ",
                            " . $design->id_user . ",
                            " . $design->id_qpos . ",
                            " . $design->id_special . ",
                            " . $this->newProjId . ",
                            " . $design->type_device . "
                        )";
                    }
                    //20150821 Tanis
                    if(count($tmpSql) > 0)
					{
						$sql = "INSERT INTO _DesignerManager(id_template, id_question, id_type, id_user, id_qpos, id_special, id_project, type_device) VALUES" . implode(',', $tmpSql);
                    	$this->db->SQLexecute($sql);
					}
                    //20150821 Tanis END
                    
                    
					//$sql = "INSERT INTO _DesignerManager(id_template, id_question, id_type, id_user, id_qpos, id_special, id_project, type_device) VALUES" . implode(',', $tmpSql);
                	//$this->db->SQLexecute($sql);
                   // print $rd->readOuterXml();
                }
				elseif ($rd->localName == "createTable")
				{
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
					$this->db->SQLexecute( "CREATE TABLE $project ".$rd->readString() );
					if($this->db->isError())
						return false;
				}
				elseif ($rd->localName == "createTree")
				{
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
					$this->db->SQLexecute( "CREATE TABLE {$project}_tree ".$rd->readString() );
					if($this->db->isError())
						return false;
				}
				elseif ($rd->localName == "createLanguage")
				{
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
					$this->db->SQLexecute( "CREATE TABLE {$project}_language ".$rd->readString() );
					if($this->db->isError())
						return false;
				}
				elseif ($rd->localName == "createScript")
				{
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
					$this->db->SQLexecute( "CREATE TABLE {$project}_script ".$rd->readString() );
					if($this->db->isError())
						return false;
				}
				
				elseif(in_array( $rd->localName,array("Question","QuestionTree","QuestionLanguage","QuestionScript" )) )
				{
					if($rd->localName == "Question")
						$table = $project;
					else if($rd->localName == "QuestionTree")
						$table = $project.'_tree';
					else if($rd->localName == "QuestionLanguage")
						$table = $project.'_language';
					else if($rd->localName == "QuestionScript")
						$table = $project.'_script';
						
						
					$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
					$sm = new SimpleXMLElement( $rd->readOuterXml());
					$columns = array();
					$values = array();
					foreach ($sm as $col => $value) 
					{
						//if($col != 'id')
						{
							$columns[] = $col;
							$values[] = addslashes( $value );
						}
						
					}
				
					$sql = "INSERT INTO $table (".implode(",",$columns).") VALUES ('".implode("','",$values)."')";
				//	echo $sql;		
					$this->db->SQLexecute($sql);	
					if($this->db->isError())
						return false;		
				}
			}
		}
		//corret auto increment on tree if needed!
		$AI =  $this->db->getAutoIncVal($project);
		$AI_tree = $this->db->getAutoIncVal($project.'_tree');
		if($AI > $AI_tree)
			$this->db->SQLexecute("ALTER TABLE ".$project."_tree AUTO_INCREMENT = $AI");
		
		//create some common project properties...like structure, popup link etc
		//create a popup www_ids link!
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		$sqlTmp = "INSERT INTO _www_ids (`id_user`, `user_type`, `id_project`, `id_site`, `loginSID`) VALUES (0,3,$this->newProjId,0,'".substr(md5(time().$this->newProjId),0,15)."-')";	
		$this->db->SQLexecute($sqlTmp);
		$wwwId = $this->db->GetLastInsertId();
		$sqlTmp = "UPDATE _www_ids SET loginSID = CONCAT(loginSID,id) WHERE id = $wwwId";
		$this->db->SQLexecute($sqlTmp);
		
		 $string ='';    
	    for ($p = 0; $p < $length; $p++) {
	        $string .= $characters[mt_rand(0,$charCnt)];
	    }
		$sqlTmp = "INSERT INTO _www_externalLinks (`id_project`, `linkType`, `loginSID`) VALUES ($this->newProjId,1,'".$string."-')";	
		$this->db->SQLexecute($sqlTmp);
		$wwwId = $this->db->GetLastInsertId();
		$sqlTmp = "UPDATE _www_externalLinks SET loginSID = CONCAT(loginSID,id) WHERE id = $wwwId";
		$this->db->SQLexecute($sqlTmp);

		 $string ='';    
	    for ($p = 0; $p < $length; $p++) {
	        $string .= $characters[mt_rand(0, $charCnt)];
	    }
		$sqlTmp = "INSERT INTO _www_externalLinks (`id_project`, `linkType`, `loginSID`) VALUES ($this->newProjId,2,'".$string."-')";	
		$this->db->SQLexecute($sqlTmp);
		$wwwId = $this->db->GetLastInsertId();
		$sqlTmp = "UPDATE _www_externalLinks SET loginSID = CONCAT(loginSID,id) WHERE id = $wwwId";
		$this->db->SQLexecute($sqlTmp);
			
		 $string ='';    
	    for ($p = 0; $p < $length; $p++) {
	        $string .= $characters[mt_rand(0,$charCnt)];
	    }
		$sqlTmp = "INSERT INTO _www_externalLinks (`id_project`, `linkType`, `loginSID`) VALUES ($this->newProjId,3,'".$string."-')";	
		$this->db->SQLexecute($sqlTmp);
		$wwwId = $this->db->GetLastInsertId();
		$sqlTmp = "UPDATE _www_externalLinks SET loginSID = CONCAT(loginSID,id) WHERE id = $wwwId";
		$this->db->SQLexecute($sqlTmp);
		
		return true;
	}
}
?>