<?php 

include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.gridData.php");
include_once(PATH_TO_ROOT."config.php");

$interviewer = '_Interviewer';
$intStructure = '_InterviewerStructure';

class telStatManipulator extends GridDataManipulator
{
	private $timeSql;  
	
	
	// function returns (builds) sql with filters for given table
	private function createFilterSQL($logTable){
		$this->timeSql = " AND (";
		$sql = "SELECT count(*) as cnt,id_user,status,status_rec,user_type FROM $logTable WHERE";
						
		if($_POST['filterDates'] && $_POST['filterDates'] != 'showAll')
		{
			list( $day, $month,$year) = explode('.', $_POST['filterDates']);
    		$beginTime = mktime(0, 0, 0, $month, $day, $year);
    		$endTime = $beginTime + 86400; // we add one day
    		$sql .= " (call_time > $beginTime AND call_time < $endTime)";
    		$this->timeSql .= " (call_time > $beginTime AND call_time < $endTime)";    		
		}
		
		if($_POST['dateFrom'])
			list( $day, $month, $year) = explode('.', $_POST['dateFrom']);		
		else 
		{
			$day = 1; $month = 1; $year = 1970;	
		}
		
    	if($_POST['timeFrom'])
    		list($hour, $min) = explode(':', $_POST['timeFrom']);
    	else 
    	{
    		$hour = 0; $min = 0;
    	}
		
		$dateFrom = mktime($hour, $min, 0, $month, $day, $year);
        
		
		if($_POST['dateTo'])
			list( $day, $month, $year) = explode('.', $_POST['dateTo']);		
		else 
		{
			$date = new DateTime();
			$day = $date->format('d');
			$month = $date->format('m');
			$year = $date->format('Y');	
			file_put_contents("/tmp/warpit_db_sandek.txt", "dateTo: ".$day."-".$month."-".$year, FILE_APPEND | LOCK_EX);
		}
		
    	if($_POST['timeTo'])
    		list($hour, $min) = explode(':', $_POST['timeTo']);
    	else 
    	{    		
    		$date = new DateTime();
			$hour = $date->format('H');
			$min = $date->format('i');						
    	}
		
	
		$dateTo = mktime($hour, $min, 0, $month, $day, $year);
		//oneDayPicked: if user selected date from combo
		if(!$_POST['oneDayPicked'] && $_POST['filterDates'] && $_POST['filterDates'] != 'showAll')
		{
			$sql .= " OR (call_time > $dateFrom AND call_time < $dateTo)";
			$this->timeSql .= " OR (call_time > $dateFrom AND call_time < $dateTo)";
		}
			
		else//if 
		if($_POST['filterDates'] == 'showAll' || !$_POST['filterDates'])
		{
			$sql .= " (call_time > $dateFrom AND call_time < $dateTo)";
			$this->timeSql .= " (call_time > $dateFrom AND call_time < $dateTo)";	
		}
		$this->timeSql .= ")";			
		$sql .= " GROUP BY status,status_rec,id_user,user_type";
		//$this->db->LogWrite($sql,true,"interviewer statistics SQL-MAIN");						
		return $sql;
	}
	
	public function selectAction()
	{
		
		$userData = array();
		$allData = array();
		
		$logTable = $this->table.'___telLog';		
		$sql = $this->createFilterSQL($logTable);
		
		$res = $this->db->SQLexecute($sql);
		
		// read from config, if we have to show some additional statistics inside interviewer statistics module
		$addStatistics = configLoader::loadConfig('statistics');
		if ($addStatistics['interviewer_addon']) { 
			$addStat_arr = explode(",", $addStatistics['interviewer_addon']);
			// read in all available statuses
			$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
			$sqlStat = "SELECT status, status_rec, opis FROM _TelephoneStatus ORDER BY orderBy";
			$resStat = $this->db->SQLexecute($sqlStat);
			while ($rowStat = $this->db->fetchAssoc($resStat)) {
				$allTelStatus[$rowStat['status']][$rowStat['status_rec']] = $rowStat['opis'];
			}
		}
		
		
		$languagePack = configLoader::loadLanguage(1,'multilanguage','id_default_language','interviewer-statistics');
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		
		$textData['numSucc'] = $languagePack['all_success'];
		$textData['numTest'] = $languagePack['all_test'];
		$textData['all_unsuccess'] = $languagePack['all_unsuccess'];
		$textData['numBusy'] = $languagePack['busy'];
		$textData['numUnavail'] = $languagePack['not_available'];
		$textData['numThrowdown'] = $languagePack['middle_unsuccess'];
		$textData['numAppointment'] = $languagePack['appointments'];
		$textData['numQuota'] = $languagePack['quota_unsuccess'];
		$textData['numError'] = $languagePack['interviewer_error'];
		
		$textData['empty1'] = '';
		
		if ($addStat_arr) {
			foreach($addStat_arr AS $addStat_item) {
				$telStatus_arr = explode("-", $addStat_item);
				$textData[$addStat_item] = $allTelStatus[$telStatus_arr[0]][$telStatus_arr[1]];
				$allData[$addStat_item] = 0;
			}
			$textData['empty2'] = '';
		}
		
		$textData['min_ank'] = $languagePack['min_length'];
		$textData['max_ank'] = $languagePack['max_length'];
		$textData['avg_ank'] = $languagePack['average_complete'];
		$textData['sum_ank'] = $languagePack['sum_completed'];
		$textData['sum_time'] = $languagePack['sum_all'];
        //20150605 Tanis added extra items in statistic grid
        $textData['sum_test'] = $languagePack['sum_test'];
        $textData['sum_real'] = $languagePack['sum_real'];
        $textData['total_time'] = $languagePack['total_time'];
		//20150605 Tanis END
		
		$allData['all_unsuccess'] = 0;
		$allData['numSucc'] = 0;
		$allData['numTest'] = 0;
		$allData['numBusy'] = 0;
		$allData['numUnavail'] = 0;
		$allData['numThrowdown'] = 0;
		$allData['numAppointment'] = 0;
		$allData['numQuota'] = 0;
		$allData['numError'] = 0;
								
		$allData['min_ank'] = 0;
		$allData['max_ank'] = 0;
		$allData['avg_ank'] = 0;
		$allData['sum_ank'] = 0;
		
		$allData['sum_time'] = 0;
        //20150605 Tanis 
		$allData['sum_test'] = 0;
		$allData['sum_real'] = 0;
        $allData['total_time'] = 0;
		//20150605 Tanis END
		while ($row = $this->db->fetchRow($res))
		{
			$status = $row[2];
			$status_rec = $row[3];
			
			if($row[4] == 1)//if user is admin
				$row[1] = 'admin_'.$row[1];
			
			if($status > 1 AND $status < 90)
			{ //stevilo zavrnitev
				$allData['all_unsuccess'] += $row[0];
				$userData['all_unsuccess'][ $row[1] ] += $row[0];
			}
			 
			switch ($status) {
				case 1:
					if($status_rec == 1) {
						$allData['numSucc'] += $row[0];
						$userData['numSucc'][ $row[1] ] += $row[0];
					}
					if($status_rec == 2) {
						$allData['numTest'] += $row[0];
						$userData['numTest'][ $row[1] ] += $row[0];
					}
				break;	
				case 22: //stevilo busy
					
					$allData['numBusy'] += $row[0];
					$userData['numBusy'][ $row[1] ] += $row[0];
				break;
				case 25: //stevilo nedvignjenih
					
					$allData['numUnavail'] += $row[0];
					$userData['numUnavail'][ $row[1] ] += $row[0];
				break;
				case 91: //stevilo dogovorov
					$allData['numAppointment'] += $row[0];
					$userData['numAppointment'][ $row[1] ] += $row[0];
				break;
				case 54: //stevilo prekinjenih na sredini
					$allData['numThrowdown'] += $row[0];
					$userData['numThrowdown'][ $row[1] ] += $row[0];
				break;
				case 51: //stevilo prekinjenih zaradi kvot
					$allData['numQuota'] += $row[0];
					$userData['numQuota'][ $row[1] ] += $row[0];
				break;
				case -1: //stevilo napak zaradi prekinitve
					$allData['numError'] += $row[0];
					$userData['numError'][ $row[1] ] += $row[0];
				break;
				default:
					// if I have additional data requirements 
					if ($addStat_arr) {
						$allData[$status.'-'.$status_rec] += $row[0];
						$userData[$status.'-'.$status_rec][ $row[1] ] += $row[0];
					}
				break;
			}
			
			
		}
		
		// total time spent on the system
		$sql = "SELECT  
				SUM(end_time - call_time) AS sum_ank,id_user,user_type,status, status_rec FROM $logTable 
				WHERE end_time>call_time $this->timeSql 
				GROUP BY id_user,user_type";
//		echo "$select_all<br>";
//print $sql;
		//file_put_contents("/tmp/warpit_db_sandek.txt", $sql, FILE_APPEND | LOCK_EX);
		//$this->db->LogWrite($sql,true,"interviewer statistics SQL (total) sandek writes hereeeee");
		$res = $this->db->SQLexecute($sql);
		
		while ($row = $this->db->fetchRow($res))
		{
			if($row[2] == 1)
				$row[1] = 'admin_'.$row[1];
			
     
			// borut ADD if ($row[1] > 0) on 16.10.2014 because system using -700 user for predicitve dialer, 
			// and this must not count into total statistics
			//20150520 Tanis CHANGE > to >= so we will sum times for admins
			if ($row[1] >= 0) $allData['sum_time'] += round(($row[0]/60),1);
			$userData['sum_time'][$row[1]] = round(($row[0] / 60),1);
            
            
		}
        
        //20150605 Tanis added extra items in statistic grid
        $sql = "SELECT  
                SUM(end_time - call_time) AS sum_ank,id_user,user_type FROM $logTable 
                WHERE (status = 1 AND status_rec = 2) AND end_time>call_time $this->timeSql 
                GROUP BY id_user,user_type";
        $res = $this->db->SQLexecute($sql);
        while ($row = $this->db->fetchRow($res))
        {
            if($row[2] == 1)
                $row[1] = 'admin_'.$row[1];
            
            $allData['sum_test'] += round(($row[0]/60),1);
            $userData['sum_test'][$row[1]] = round(($row[0] / 60),1);
        }
        
        foreach($userData['sum_time'] as $id_user => $time)
        {
            $userData['sum_real'][$id_user] = round($time - $userData['sum_test'][$id_user],1);
            if($userData['numSucc'][$id_user]!=0)
                $userData['total_time'][$id_user] = round($userData['sum_real'][$id_user] / $userData['numSucc'][$id_user],1);             
        }
        $allData['sum_real'] =  round($allData['sum_time'] - $allData['sum_test'],1);
        $allData['total_time'] = round($allData['sum_real']/$allData['numSucc'],1);
        //20150605 END Tanis 
                			
		// minimalna,maximalna,povprecna, sum dolzina v celoti opravljenih anket
		$sql = "SELECT MIN(end_time - call_time) AS min_ank, 
				MAX(end_time - call_time) AS max_ank, 
				AVG(end_time - call_time) AS avg_ank, 
				SUM(end_time - call_time) AS sum_ank,id_user,user_type FROM $logTable 
				WHERE status=1 AND status_rec=1 AND end_time>call_time $this->timeSql  
				GROUP BY id_user,user_type";
//		echo "$select_all<br>";
		//$this->db->LogWrite($sql,true,"interviewer statistics SQL (mean)");
		$res = $this->db->SQLexecute($sql);
		
		while ($row = $this->db->fetchRow($res))
		{
			if($row[5] == 1)
				$row[4] = 'admin_'.$row[4];
			
			$allData['sum_ank'] += round(($row[3]/60),1);
			//$allData['sum_ank_sec'] += round($row[3]);
			
			$userData['min_ank'][$row[4]] = round(($row[0] / 60),1 );
			$userData['max_ank'][$row[4]] =  round(($row[1] / 60),1 );
			$userData['avg_ank'][$row[4]] =   round(($row[2] / 60),1 );
			$userData['sum_ank'][$row[4]] = round(($row[3] / 60),1);
			//$userData['sum_ank_sec'][$row[4]] = round($row[3]);
		}
		if($userData['min_ank'])
		{
			$allData['min_ank'] = min($userData['min_ank'] );
			$allData['max_ank'] = max( $userData['max_ank'] );
			$allData['avg_ank'] = round(array_sum( $userData['avg_ank'] ) / count($userData['avg_ank']),1);
		}
		
		foreach ($textData as $rowId => &$nmb) {
			//each key represents a row!
			$row = array();
			$row['key'] = $rowId;
			$row['title'] = $textData[$rowId];
			$row['total'] = $allData[$rowId];
			if($users = $userData[ $rowId ] )
			foreach ($users as $userId => $userVal) {
				$row['user_'.$userId] = $userVal;
			}
			
			$this->arr[] = $row;
		}
		
		return parent::selectAction();
	}

	public function selectDatesAction()
	{
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		$sql = "SELECT max(call_time) as last_date, min(call_time) as first_date FROM $this->table"."___telLog WHERE call_time IS NOT NULL";
		$row = $this->db->fetchAssoc( $this->db->SQLexecute($sql) );
		
		$this->arr[] = array('id' => 'showAll','date' => 'All dates');
		
		$vpr = date("d.m.Y",$row['first_date']);
		$firstDate = strtotime($vpr);
		
		for($st = $firstDate;$st < ($row['last_date']+86390);$st += 86400 )
		{
			$date = getdate($st);
			$dateId = $date['mday'].'.'.$date['mon'].'.'.$date['year'];
			$date = $date['mday'].'.'.$date['month'].'.'.$date['year'];
			$this->arr[] = array('id' => $dateId, 'date' => $date ) ;
			
		}
		
		return parent::selectAction();
	}
}

	

$db->ChangeDatabase($_POST['database']);

$tableName = $_POST['RMtable'];


$manipulator = new telStatManipulator($db,$_POST['RMtable']);
$manipulator->telIndexTable = $tableName.'___telIndex';
$comm = $_REQUEST['action'].'Action';
if(method_exists($manipulator,$comm))
	echo $manipulator->$comm();
else 
{
	
	echo '{success:false,error:"Unknown action!"}';	
	
}


?>