/* Slider Version: V3*/
var scales = new allScales();
        
function allScales() 
{
    this.scale_src = 'slider/line1.gif';               //default skala
    this.scale_width = 300;                     //default sirina skale
    this.scale_height = 16;                     //default visina skale
    this.cross_src = 'slider/cross.gif';               //default cross
    this.crossOv_src = 'slider/cross2_ov.gif';         //default cross over
    this.cross_width = 17;                      //sirina 
    this.cross_height = 17;                     //visina
    
    this.mode = 'click';                        //default mode: click / slide
    this.labels = new Array();                  //holds labels 
    this.items = new Array();                   //array v katerem so def. skale
    this.slide_clickable = true;                //are slide scales clickable as well?
  
    this.minValue = 0;                          //minimalna vrednost slide-a
    this.maxValue = 10;                         //maximalna vrednost slide-a
    this.korak    = 1;                          //korak v slide-u
    this.classes  = 11;                          //default stevilo skal.
    this.zacSkala = 0;
  
    this.kvadrat = 'slider/transparentpixel.gif';      //transparentna sled 
    this.sled_color = '#FFFFFF';                //default barva sledi
    this.sled_y_pos = 0;                        //default sprememba polozacija sledi po y-osi
    this.sled_height = 5;                       //default visina sledi.
    
    this.scale = scale;
    
    this.init = initScales;
    this.setcrosses = setCrosses;
}


/**
* A single scale with all its values
*
* @param   string     image source of scale
* @param   string     image source of cross
* @param   string     variable name
*/
function theScale() 
{       
    this.element = theScale.arguments[0];
    this.shadow = scales.shadow;
    this.src = scales.scale_src;
    this.width = scales.scale_width;
    this.height = scales.scale_height;
    this.cross = scales.cross_src;
    this.crossOv = scales.crossOv_src;
    this.cross_width = scales.cross_width;
    this.cross_height = scales.cross_height;
    this.mode = scales.mode;    
    this.labels = scales.labels; 
    
    this.slide_clickable = scales.slide_clickable;
    
    this.kvadrat   = scales.kvadrat;
    this.sled_y_pos   = scales.sled_y_pos;  
    this.sled_color  = scales.sled_color;
    this.sled_height=scales.sled_height;
    
    this.minValue    = scales.minValue;
    this.maxValue    = scales.maxValue;
    this.korak       = scales.korak;
    this.classes     = scales.classes;
    this.zacSkala    = scales.zacSkala;
    
    this.print = printScale;
}

/**
* Build new scale
*
* @param  string    variable name
* @param  string    scale mode: click / slide (optional)
* @param  integer   number of classes (optional)
* @param  array     image source, width and height of scale (optional)
* @param  string    image source, width and height of cross (optional)
*/
function scale() 
{
    /* number of item */
    var cnt = this.items.length;        
            
    /* build new scale */
    for(var i = 0; i < scale.arguments.length; i++) 
    {
        switch(i) {
            case 0:     this.items[cnt] = new theScale(scale.arguments[0]);
                        break;
                        
            case 1:     if(scale.arguments[1] == 'click' || scale.arguments[1] == 'slide')
                           this.items[cnt].mode = scale.arguments[1];
                        break;
                        
            case 2:     if (scale.arguments[2].length > 0 && scale.arguments[2].length <= 4)
                        {
                           if(!isNaN(scale.arguments[2][0])) this.items[cnt].minValue = scale.arguments[2][0];
                           if(!isNaN(scale.arguments[2][1])) this.items[cnt].maxValue = scale.arguments[2][1];
                           if(!isNaN(scale.arguments[2][2])) this.items[cnt].korak    = scale.arguments[2][2];
                           if(!isNaN(scale.arguments[2][3])) 
                           {
	                           
                               if (scale.arguments[2][3] < this.items[cnt].minValue)
	                              this.items[cnt].zacVred = this.items[cnt].minValue; 	                           
                               else
                               {
	                              if (scale.arguments[2][3] > this.items[cnt].maxValue)
                                     this.items[cnt].zacVred = this.items[cnt].maxValue;
                                  else
                                     this.items[cnt].zacVred  = scale.arguments[2][3];   // if 4 argument is ok...                                      
                               }
                           }                           
                           else this.items[cnt].zacVred = this.items[cnt].minValue; 
                              
                           
                           this.items[cnt].classes = ((this.items[cnt].maxValue - this.items[cnt].minValue + this.items[cnt].korak)/this.items[cnt].korak);
                           this.items[cnt].classes = this.items[cnt].classes - 1;     // skale stejem od 0 naprej                          
                           
                           this.items[cnt].zacSkala = (this.items[cnt].zacVred - this.items[cnt].minValue + this.items[cnt].korak)/this.items[cnt].korak;
                           this.items[cnt].zacSkala = this.items[cnt].zacSkala - 1;  // skale stejem od 0 naprej
                           
                           break;
                        }                        
            case 3:     /* array */
                        if(scale.arguments[3].length > 0 && scale.arguments[3].length <= 3) 
                        {
                            this.items[cnt].src = scale.arguments[3][0];
                            if(!isNaN(scale.arguments[3][1])) this.items[cnt].width = scale.arguments[3][1];
                            if(!isNaN(scale.arguments[3][2])) this.items[cnt].height = scale.arguments[3][2];
                        /* no array */
                        } else if(scale.arguments[3].length > 0) {
                            this.items[cnt].src = scale.arguments[3];
                        }
                        break;
                        
            case 4:     if(scale.arguments[4].length > 0 && scale.arguments[4].length <= 4)
                        {
                            this.items[cnt].cross = scale.arguments[4][0];
                            if(!isNaN(scale.arguments[4][1])) this.items[cnt].cross_width = scale.arguments[4][1];
                            if(!isNaN(scale.arguments[4][2])) this.items[cnt].cross_height = scale.arguments[4][2];
                            if(scale.arguments[4][3]) this.items[cnt].crossOv = scale.arguments[4][3];
                        /* no array */
                        } else if(scale.arguments[4].length > 0) 
                        {
                            this.items[cnt].cross = scale.arguments[4];
                        }
                        break;
                        
            case 5:     if(scale.arguments[5].length == 2) 
                        {
                            this.items[cnt].labels[0] = scale.arguments[5][0];
                            this.items[cnt].labels[1] = scale.arguments[5][1];
                        }
                        break;
            case 6:     if(scale.arguments[6].length > 0 && scale.arguments[6].length <= 3)
                        {	             
                           this.items[cnt].sled_color = scale.arguments[6][0];
                           if(!isNaN(scale.arguments[6][1])) this.items[cnt].sled_height = scale.arguments[6][1];
                           if(!isNaN(scale.arguments[6][2])) this.items[cnt].sled_y_pos = scale.arguments[6][2];
                        }
             break;
        }
    }    
    this.items[cnt].print(cnt);
}
        
        
/**
* Print scale: image and hidden form element
*
* @param   integer   id    id of current item     
*/
function printScale(id) 
{
    //print label
    if(this.labels.length >= 2) 
    {
        document.writeln('<table border="0"><tr><td>');
        document.writeln('<em>' + this.labels[0] + '</em>');
        document.writeln('</td><td>');
    }
   // document.writeln('<img name="shadow' + id + '" src="' + this.scales.items[id].shadow + '" width="50" height="5" alt="bg" border="0" />');
    document.writeln('<img name="line' + id + '" src="' + this.src + '" width="' + this.width + '" height="' + this.height + '" alt="Lini" border="0" />');

    if(this.labels.length >= 2) 
    {
        document.writeln('</td><td>');
        document.writeln('<em>' + this.labels[1] + '</em>');
        document.writeln('</td></tr></table>');
    }
    
    document.writeln('<img style="border:1px solid black;" id="cross' + id + '" name="cross' + id + '" src="' + scales.items[id].cross + '" width="' + this.cross_width + '" height="' + this.cross_height + '" alt="X" />');
    document.writeln('<img id="kvadratek' + id + '" name="kvadratek' + id + '" src="' + scales.items[id].kvadrat + '" width="1" height="' + scales.items[id].sled_height + '" />');
}


/**
* Initiate some procedures: 
*       1. start dragdrop script        
*       2. set state of crosses
*/        
function initScales() {
    var dragdrop = 'NO_SCROLL';
            
    for(var i = 0; i < this.items.length; i++) 
    {
	dragdrop += ', "cross' + i + '"';
        dragdrop += (this.items[i].mode == 'slide') ? '+HORIZONTAL' : '+NO_DRAG';
        dragdrop += ', "line' + i + '"';
        dragdrop += '+HORIZONTAL+CURSOR_DEFAULT+MAXOFFLEFT+0+MAXOFFRIGHT+0';
        dragdrop += ', "kvadratek' + i + '"';
        dragdrop += '+HORIZONTAL+NO_DRAG';
    }
     
    /* initialise the dragdrop script */
    eval("SET_DHTML(" + dragdrop + ")");

    this.setcrosses();    
}

/**
* Set crosses to their initial states
*/
function setCrosses() 
{
	var init_x_pos;
    for(var i = 0; i < this.items.length; i++) 
    {
        /* hide cross */
        //if(this.items[i].mode == 'click') dd.elements["cross"+i].hide();

        init_x_pos = (this.items[i].width * this.items[i].zacSkala + dd.elements["line"+i].x * this.items[i].classes) / this.items[i].classes;
        
        dd.elements["kvadratek"+i].setBgColor(this.items[i].sled_color);
                
        dd.elements["cross"+i].moveTo(init_x_pos - halfCrossWidth(i), crossY(i));
        dd.elements["line"+i].addChild("cross"+i);
        dd.elements["cross"+i].defx = dd.elements["line"+i].x + (this.items[i].width / 2) - halfCrossWidth(i);        
        
        dd.elements["kvadratek"+i].moveTo(dd.elements["line"+i].x , crossY(i)+ this.items[i].sled_y_pos);
        dd.elements["kvadratek"+i].resizeTo(init_x_pos - dd.elements["line"+i].x, this.items[i].sled_height);
        dd.elements["line"+i].addChild("kvadratek"+i);
        
        if(this.items[i].mode == 'click') dd.elements["line"+i].maximizeZ();
        else dd.elements["cross"+i].maximizeZ();
        
        setFormValue(this.items[i].element, (this.items[i].minValue+(Math.round((Math.round(dd.elements["cross"+i].x+halfCrossWidth(i)-dd.elements["line"+i].x)/this.items[i].width)*this.items[i].classes)-1)*this.items[i].korak)+this.items[i].korak);
    }
}
        
        
/**
* Calculate half width of cross image (rounded)
*
* @param    integer    id    id of cross
* @return   integer          half cross width
*/
function halfCrossWidth(id) {
    return dd.elements["cross"+id].w / 2;
}


/**
* Calculate y position of cross image
*
* @param    integer    id    id of cross
* @return   integer          y position of cross
* @since                     1.3
*/
function crossY(id) {
    // y of line + half height of line - half height of cross
    return dd.elements["line"+id].y + dd.elements["line"+id].h / 2 - dd.elements["cross"+id].h / 2;
}


/**
* Parse string for id (= last number)
*
* @parse   string    string    string to parse
* @return  integer             id
*/
function getId(string) {
    var result = string.match(/^\D+(\d+)$/);
    return result[1];           
}


/**
* Set value of hidden form element
*
* @param  string   name    name of form element
* @param  integer  content value to set form value to
* @return bool
*/
function setFormValue(name, content) 
{	
	document.getElementById('value_'+name).value = content;
    return true;
}        
               
/**
* debug layer
*
* @param   string   msg     message to print
*/        
function debug(msg) {
    if(!debug.box) {
        debug.box = document.createElement("div");
        debug.box.setAttribute("style",
                                "background-color: #FFFFFF; " + 
                                "font-family: monospace; " + 
                                "font-size:10px; " +
                                "border: solid black 3px; " + 
                                "padding: 10px; " + 
                                "position: absolute; " + 
                                "top: 10px; " + 
                                "right: 10px;");
        document.body.appendChild(debug.box);
                
        var h1 = document.createElement("h1");
        h1.appendChild(document.createTextNode("DEBUG REZULT"));
        h1.setAttribute("style", "font-size: 10px;");
        debug.box.appendChild(h1);
    }
            
    var p = document.createElement("p");
    p.appendChild(document.createTextNode(msg));
    debug.box.appendChild(p);
}
/****************
* These functions are processed by wz_dragdrop.js
****************/
        
/**
* my_PickFunc IS AUTOMATICALLY CALLED WHEN AN ITEM STARTS TO BE DRAGGED.
*/
function my_PickFunc() {    
    /* determine image id */
    var xpos, currentclass, id = getId(dd.obj.name);
    
    dd.elements["kvadratek"+id].setBgColor(scales.items[id].sled_color);
       
    if(scales.items[id].mode == 'click' || (scales.items[id].mode == 'slide' && dd.obj.name == 'line' + id && scales.items[id].slide_clickable))     
    {    
        /* if there are classes */
        if(scales.items[id].classes > 1) 
        {	        

            currentclass = Math.round((dd.e.x - dd.obj.x) / (dd.obj.w / scales.items[id].classes))            
            xpos = dd.obj.x - halfCrossWidth(id) + currentclass * (dd.obj.w / scales.items[id].classes);
        } 
        else 
        {
	    if (dd.e.x>= dd.obj.w/2 + dd.obj.x)
	    {            
               xpos = dd.obj.w + dd.obj.x - halfCrossWidth(id);
            }
            else
            {
               xpos = dd.obj.x - halfCrossWidth(id);
            }
        }
   
        /* position and display cross */
        dd.elements["cross"+id].moveTo(xpos, crossY(id));
        if(!dd.elements["cross"+id].visible) dd.elements["cross"+id].show();
        
        /* treba se je vprasati ali sploh spuscam barvo*/
        /* �e tocke dolocujem z pritiski */
        dd.elements["kvadratek"+id].resizeTo(xpos + halfCrossWidth(id) - dd.elements["kvadratek"+id].x, scales.items[id].sled_height);

    /* swap image of slider on drag */
    } else if(scales.items[id].mode == 'slide' && dd.obj.name == 'cross' + id) 
    {
        dd.obj.swapImage(scales.items[id].crossOv);

    }   
}


/**
* my_DragFunc IS CALLED WHILE AN ITEM IS DRAGGED
*/
function my_DragFunc() {
    /* determine image id */
    var id = getId(dd.obj.name);

    //Set left and right limits for the slides
    //if(scales.items[id].mode == 'slide' && dd.obj.name == 'cross' + id && scales.items[id].classes > 1) 
    if(scales.items[id].mode == 'slide' && dd.obj.name == 'cross' + id) 
    {
        /* prevent dragging beyond end of line */
        if(dd.obj.x <= dd.elements["line"+id].x) 
        {
           dd.obj.moveTo((dd.elements["line"+id].x - Math.floor(halfCrossWidth(id))), crossY(id));        
        } 
        else if(dd.obj.x >= (dd.elements["line"+id].x + dd.elements["line"+id].w - Math.floor(halfCrossWidth(id)))) 
        {
            dd.obj.moveTo((dd.elements["line"+id].x + dd.elements["line"+id].w - Math.floor(halfCrossWidth(id))), crossY(id));
        }
        dd.elements["kvadratek"+id].resizeTo(dd.elements["cross" + id].x + halfCrossWidth(id) - dd.elements["kvadratek" + id].x, scales.items[id].sled_height)
        setFormValue(scales.items[id].element, (scales.items[id].minValue+(Math.round((Math.round(dd.elements["cross"+id].x+halfCrossWidth(id)-dd.elements["line"+id].x)/scales.items[id].width)*scales.items[id].classes)-1)*scales.items[id].korak)+scales.items[id].korak);
        
        dd.obj.maximizeZ();
    }
}

/**
* my_DropFunc IS CALLED ONCE AN ITEM IS DROPPED
*/
function my_DropFunc() {
    /* determine image id */
    var currentclass, xpos, id = getId(dd.obj.name);
    
    if(scales.items[id].mode == 'slide' && dd.obj.name != 'cross' + id) 
    {
        dd.obj.swapImage(dd.obj.defsrc);
        
        if(dd.obj.x <= dd.elements["line"+id].x || dd.obj.x >= (dd.elements["line"+id].x + dd.elements["line"+id].w - Math.floor(halfCrossWidth(id))))         
        {
	        //pusti
        }
        else
        {	        
             if(scales.items[id].classes > 1) 
             {
                 /* number of classes on current click */
                 currentclass = Math.round((dd.obj.x - dd.elements["line"+id].x) / (dd.elements["line"+id].w / scales.items[id].classes));
                 /* x position of cross */
                 xpos = dd.elements["line"+id].x - halfCrossWidth(id) + currentclass * ((dd.elements["line"+id].w / scales.items[id].classes));
                 /* set cross */
                 dd.obj.moveTo(xpos, crossY(id));
                 dd.elements["kvadratek"+id].resizeTo(dd.elements["cross" + id].x + halfCrossWidth(id) - dd.elements["kvadratek" + id].x, scales.items[id].sled_height);
             }
        }        
    }  
    dd.obj.swapImage(dd.obj.defsrc);
      
    setFormValue(scales.items[id].element, (scales.items[id].minValue+(Math.round((Math.round(dd.elements["cross"+id].x+halfCrossWidth(id)-dd.elements["line"+id].x)/scales.items[id].width)*scales.items[id].classes)-1)*scales.items[id].korak)+scales.items[id].korak);
    if(window.ratingScalesDropCb) ratingScalesDropCb(id);
}
