<?php
/**
 * Created by PhpStorm.
 * User: Jure
 * Date: 21.5.2014
 * Time: 13:33
 */

require_once '../AutoLoader.php';
include_once("../../_ajaxManipulators/_class/class.treeData.php");
include_once("../../config.php");

$autoloader = new Autoloader();

class NfieldInterviewersManager extends TreeDataManipulator
{

    function uploadInterviewersAction()
    {
        try {
            $interviewerService = new NfieldInterviewersService();
            $projectSamplePointsTableName = $_POST['projectSampleTableName'];

            $sql = "SELECT DISTINCT i.id,i.Firstname,i.Surname,i.password,i.email,i.username
                FROM $projectSamplePointsTableName as p,
                _Interviewer as i
                WHERE i.id = p.user_id";

            $result = $this->db->SQLexecute($sql);
            if (!$result) {
                return "{success:false,error:'Get Capi tables id'}";
            }
            $arrayInterviewers = [];
            while ($row = $this->db->fetchAssoc($result)) {
                $arrayInterviewers[] = $row;
            }

            foreach ($arrayInterviewers as $item) {

                $interviewer = new Interviewer();
                //$interviewer->setClientInterviewerId('11111111');
                $interviewer->setTelephoneNumber($item['/']);
                $interviewer->setLastName($item['Surname']);
                $interviewer->setEmailAddress($item['email']);
                $interviewer->setFirstName($item['Firstname']);
                $interviewer->setUserName($item['username']);
                $interviewer->setPassword($item['password']);
                $interviewerService->add($interviewer);
            }
        } catch (Exception $e) {
            return "{success:false,error:'Required Interviewer password length is six character or interviewer already exist in Nfield project'}";
        }

        return "{success:true,message:'Upload interviewers was success'}";

    }

    function changePasswordAction(){
        $interService = new NfieldInterviewersService();
        try{
            $id = mysql_real_escape_string($_POST['id']);
            $password =  mysql_real_escape_string($_POST['password']);

            $interviewer = new Interviewer();
            $interviewer->setInterviewerId($id);

            $interService->changePassword($interviewer,$password);

        }catch (Exception $e){
            return "{success:false,error:'Required Interviewer password length is six character'}";
        }
        return "{success:true,message:'Change password was success'}";
    }

    //TO DO
    function deleteNfieldInteviewersAction(){

        $interviewers = $_POST['nfieldInterviewers'];
        try{
            $interviewerService = new NfieldInterviewersService();
            $sql = "SELECT i.*
                    FROM _Interviewer as i
                    WHERE i.id IN($interviewers)";

            $result = $this->db->SQLexecute($sql);
            if (!$result) {
                return "{success:false,error:'Get Capi tables id'}";
            }
            $arrayInterviewers = [];
            while ($row = $this->db->fetchAssoc($result)) {
                $arrayInterviewers[] = $row;
            }
            foreach ($arrayInterviewers as $item) {


                //Delete from interviewers
                $sql = "DELETE FROM `_Interviewers`  WHERE id = '" . $item['id'] . "'";
                if (!$this->db->SQLexecute($sql)) {
                    return "{success:false,error:'Delete failed'}";
                }
                //Delete from group link
                $sql = "DELETE FROM `_group_link`  WHERE id = '" . $item['id'] . "' AND id_group = 56";
                if (!$this->db->SQLexecute($sql)) {
                    return "{success:false,error:'Delete failed'}";
                }

                //Check if exist nfield_id then delete from nfield

                //Check If exist then update
                if(is_null($item['nfield_id'])){
                   //Delete from nfield
                   //call service
                }


            }
        }
        catch(Exception $e){
            return "{success:false,error:'Required Interviewer password length is six character and must contain number or interviewer already exist in Nfield project'}";
        }
        return "{success:true,message:'Delete interviewers was success'}";
    }

    function uploadNfieldInterviewersAction(){

        $interviewers = $_POST['nfieldInterviewers'];
        try{
            $interviewerService = new NfieldInterviewersService();
            $sql = "SELECT i.*
                    FROM _Interviewer as i
                    WHERE i.id IN($interviewers)";

            $result = $this->db->SQLexecute($sql);
            if (!$result) {
                return "{success:false,error:'Get Capi tables id'}";
            }
            $arrayInterviewers = [];
            while ($row = $this->db->fetchAssoc($result)) {
                $arrayInterviewers[] = $row;
            }
            foreach ($arrayInterviewers as $item) {

                $interviewer = new Interviewer();
                $interviewer->setTelephoneNumber($item['/']);
                $interviewer->setLastName($item['Surname']);
                $interviewer->setEmailAddress($item['email']);
                $interviewer->setFirstName($item['Firstname']);
                $interviewer->setUserName($item['username']);
                $interviewer->setPassword($item['password']);

                //Check If exist then update
                if(is_null($item['nfield_id'])){
                    $ifExists = false;
                }else{
                    $ifExists = $this->checkIfExistOnNfield($item['nfield_id']);
                }

                if ($ifExists) {
                    $interviewer->setInterviewerId($item['nfield_id']);
                    $interviewerService->update($interviewer);
                }
                else{

                    $interviewerService->add($interviewer);
                }
            }
        }
        catch(Exception $e){
            return "{success:false,error:'Required Interviewer password length is six character and must contain number or interviewer already exist in Nfield project'}";
        }
        return "{success:true,message:'Upload interviewers was success'}";


    }

    private function checkIfExistOnNfield($interviewerID){
        $start_time = time();
        $aa = new NfieldInterviewersService();
        while (true) {
            try {
                if ((time() - $start_time) > 10) {
                    break; // timeout, function took longer than 10 seconds
                }
                $result = $aa->query();
                $samplePointsDecoded = json_decode($result, true);
                if (isset($samplePointsDecoded[0]['InterviewerId'])) {
                    foreach($samplePointsDecoded as $i){
                        if($interviewerID == $i['InterviewerId'] ){
                            return true;
                        }
                    }
                    break;
                }
                sleep(5);
            } catch (Exception $e) {
                return "{success:false,error:'Service not working'}";
            }
            return false;
    }
    }

    private function checkIfExist($interviewerID){
            $sql = "SELECT COUNT(id) as id  FROM _Interviewer WHERE username = '".$interviewerID."'";

            $result = $this->db->SQLexecute($sql);
            $row = $this->db->fetchAssoc($result);
        if($row['id'] >= '1'){return true;}
        else {return false;}

    }

    function saveDownloadedInterviewersAction(){

        $start_time = time();
        $aa = new NfieldInterviewersService();
        while (true) {
            try {
                if ((time() - $start_time) > 10) {
                    break; // timeout, function took longer than 10 seconds
                }
                $result = $aa->query();
                $language = 46;
                $samplePointsDecoded = json_decode($result, true);
                if (isset($samplePointsDecoded[0]['InterviewerId'])) {
                    foreach($samplePointsDecoded as $i){
                        $userName = $i['UserName'];
                        $isChanged = $this->checkIfExist($userName);

                        if($isChanged){

                            $sql = "UPDATE `_Interviewer`
                                SET  username = '" . mysql_real_escape_string($i['UserName']) . "',
                                FirstName = '".mysql_real_escape_string($i['FirstName'])."',
                                Surname = '".mysql_real_escape_string($i['LastName'])."',
                                email = '".mysql_real_escape_string($i['EmailAddress'])."',
                                nfield_id = '".mysql_real_escape_string($i['InterviewerId'])."'
                                WHERE username = '".$userName."'";

                            $result = $this->db->SQLexecute($sql);

                            if (!$result) {
                                return "{success:false,error:'Update interviewer error'}";
                            }
                        }
                        else{
                            $interviewerID = $i['InterviewerId'];
                            $sql = 'INSERT IGNORE INTO _Interviewer (nfield_id,username,FirstName,Surname,email,language)
                             VALUE("'.$interviewerID.'","'.$i['UserName'].'","'.$i['FirstName'].'","'.$i['LastName'].'","'.$i['EmailAddress'].'",'.$language.")";
                            $result = $this->db->SQLexecute($sql);

                            if (!$result) {
                                return "{success:false,error:'Get Capi tables id'}";
                            }
                            $lastID = $this->db->GetLastInsertId();

                            $groupID = 56;
                            $sql = "INSERT IGNORE INTO _group_link(id_group,id) VALUE(" .$groupID . ',' . $lastID . ")";
                            if (!$this->db->SQLexecute($sql)) {
                                return "{success:false,error:'Group link saving error'}";
                            }
                        }


                    }
                    break;
                }
                sleep(5);
            } catch (Exception $e) {
                return "{success:false,error:'Service not working'}";
            }
        }

        return "{success:true,message:'Download interviewers was success'}";
    }

    function getAllInterviewersAction()
    {
        $interviewerService = new NfieldInterviewersService();
        try {
            $result = $interviewerService->query();
            ?>
            {
            success: true,
            results: <?php echo sizeof($result); ?>,
            rows: <?php echo $result; ?>
            }
        <?php

        } catch (Exception $e) {
            echo $e;
        }
    }
}

$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
$comm = $_POST['action'] . 'Action';
$manipulator = new NfieldInterviewersManager($db, $tableName);
if (method_exists($manipulator, $comm))
    echo $manipulator->$comm();
else {
    echo '{success:false,error:"Unknown action!"}';
}

