<?php
/**
 * Created by PhpStorm.
 * User: Jure
 * Date: 6.4.2014
 * Time: 9:04
 */

class NfieldSurveysService implements INfieldSurveysService, INfieldConnectionClientObject
{

    private $client = null;

    public function getClient()
    {
        return $this->client;
    }

    public function setClient(INfieldHttpClient $client)
    {
        $this->client = $client;
    }

    public function add(Survey $survey)
    {
        return $this->initializeNfieldConnection()->post($this->surveyApi(), $survey);
    }

    public function remove(Survey $survey)
    {
        if ($survey == null) {
            throw new Exception('Survey is null');
        }

        return $this->initializeNfieldConnection()->delete($this->surveyApi() . $survey->getSurveyId());
    }

    public function update(Survey $survey)
    {
        if ($survey == null) {
            throw new Exception('Interviewers is null');
        }
        $updatedSurvey = new UpdateSurvey();
        $updatedSurvey->setClientName($survey->getClientName());
        $updatedSurvey->setDescription($survey->getDescription());
        $updatedSurvey->setSurveyName($survey->getSurveyName());

        return $this->initializeNfieldConnection()->
            patch($this->surveyApi() . $survey->getSurveyId(), $updatedSurvey);
    }

    public function query()
    {
        return $this->initializeNfieldConnection()->get($this->surveyApi());
    }

    public function getDetail($surveyId)
    {
        return $this->initializeNfieldConnection()->get($this->surveyApi().$surveyId);
    }

    public function uploadInterviewerFileInstructions($filePath, $surveyId)
    {
        // TODO: Implement uploadInterviewerFileInstructions() method.
    }

    public function downloadInterviewerFileInstructions($surveyId)
    {
        // TODO: Implement downloadInterviewerFileInstructions() method.
    }

    public function deleteInterviewerFileInstructions($surveyId)
    {
        // TODO: Implement deleteInterviewerFileInstructions() method.
    }

    public function quotaQuery($surveyId)
    {
        // TODO: Implement quotaQuery() method.
    }

    public function samplingPointsQuery($surveyId)
    {
        return $this->initializeNfieldConnection()->get
            ($this->surveyApi().$surveyId.'/'.$this->samplingPointsControllerName());
    }

    public function samplingPointQueryDetail($surveyId, $samplingPointId)
    {
        return $this->initializeNfieldConnection()->get
            ($this->surveyApi().$surveyId.'/'.$this->samplingPointsControllerName().'/'.$samplingPointId);
    }

    public function samplingPointUpdate($surveyId, SamplingPoint $samplingPoint)
    {
        if ($samplingPoint == null) {
            throw new Exception('Sampling point is null');
        }
        $updatedSamplePoint = new UpdateSamplingPoint();
        $updatedSamplePoint->setDescription($samplingPoint->getDescription());
        $updatedSamplePoint->setFieldworkOfficeId($samplingPoint->getFieldworkOfficeId());
        $updatedSamplePoint->setName($samplingPoint->getName());
        $updatedSamplePoint->setStratum($samplingPoint->getStratum());

        return $this->initializeNfieldConnection()->
            patch($this->surveyApi() .$surveyId.'/'.$this->samplingPointsControllerName().'/'.$samplingPoint->getId(),$updatedSamplePoint);
    }

    public function samplingPointAdd($surveyId, SamplingPoint $samplingPoint)
    {
        return $this->initializeNfieldConnection()->post($this->surveyApi().$surveyId.'/'.$this->samplingPointsControllerName(), $samplingPoint);
    }

    public function samplingPointDelete($surveyId, SamplingPoint $samplingPoint)
    {
        if ($samplingPoint == null) {
            throw new Exception('Sampling point is null');
        }

        return $this->initializeNfieldConnection()->delete(
            $this->surveyApi().$surveyId.'/'.$this->samplingPointsControllerName().'/'.$samplingPoint->getId());
    }

    public function addInterviewerOnProject(Interviewer $interviewer,$surveyId){

        if ($interviewer == null) {
            throw new Exception('Interviewer is null');
        }
        return $this->initializeNfieldConnection()->post(
            $this->surveyApi().$surveyId.'/'.$this->interviewerControllerName(),$interviewer);
    }

    public function samplingPointQuotaTargetsQuery($surveyId, $samplingPointId)
    {
        // TODO: Implement samplingPointQuotaTargetsQuery() method.
    }

    public function samplingPointQuotaTargetQuery($surveyId, $samplingPointId, $levelId)
    {
        // TODO: Implement samplingPointQuotaTargetQuery() method.
    }

    public function samplingPointQuotaTargetUpdate($surveyId, $samplingPointId, SamplingPointQuotaTarget $samplingPointQuotaTarget)
    {
        // TODO: Implement samplingPointQuotaTargetUpdate() method.
    }

    public function samplingPointImageAdd($surveyId, $samplingPointId, $filePath)
    {
        // TODO: Implement samplingPointImageAdd() method.
    }

    public function samplingPointImageAddAsync($surveyId, $samplingPointId, $filename, $content = array())
    {
        // TODO: Implement samplingPointImageAddAsync() method.
    }

    private function  samplingPointsControllerName()
    {
        return "samplingpoints";
    }


    private  function  quotaControllerName()
    {
        return "quota";
    }

    private  function  samplingPointsQuotaControllerName()
    {
        return "quotatargets";
    }

    private  function  surveyInterviewerInstructionsControllerName()
    {
        return "SurveyInterviewerInstructions";
    }

    private  function  samplingPointImageControllerName()
    {
        return "Surveys";
    }

    private  function  interviewerControllerName()
    {
        return "Interviewers";
    }


    private function surveyApi()
    {

        //Uri must get from connection client
        return 'https://api.nfieldmr.com/v1' . '/Surveys/';
    }

    public function initializeNfieldConnection()
    {
        $this->client = $this->connectionClient();
        return $this->client;
    }


    public function connectionClient()
    {

        $this->client = new NFieldHttpClient('https://api.nfieldmr.com/v1');
        return $this->client;
    }


}

class UpdateSurvey
{
    public $SurveyId;

    public $SurveyName;
    /// <summary>
    /// Name of the survey client
    /// </summary>
    public $ClientName;
    /// <summary>
    /// The description of the survey
    /// </summary>
    public $Description;


    public function getSurveyId()
    {
        return $this->SurveyId;
    }

    public function getSurveyName()
    {
        return $this->SurveyName;
    }

    public function getClientName()
    {
        return $this->ClientName;
    }

    public function getDescription()
    {
        return $this->Description;
    }

    public function setSurveyId($id){
        $this->SurveyId = $id;
    }

    public function setSurveyName($name)
    {
        $this->SurveyName = $name;
    }

    public function setClientName($name)
    {
        $this->ClientName = $name;
    }

    public function setDescription($description)
    {
        $this->Description = $description;
    }
}

class UpdateSamplingPoint
{

    public $Name;
    public $FieldworkOfficeId;
    public $Description;
    public $GroupId;
    public $Stratum;

    public function getName()
    {
        return $this->Name;
    }

    public function getFieldworkOfficeId()
    {
        return $this->FieldworkOfficeId;
    }

    public function getGroupId()
    {
        return $this->GroupId;
    }

    public function getDescription()
    {
        return $this->Description;
    }

    public function getStratum()
    {
        return $this->Stratum;
    }

    public function setName($name)
    {
        $this->Name = $name;
    }

    public function setFieldworkOfficeId($id)
    {
        $this->FieldworkOfficeId = $id;
    }

    public function setDescription($description)
    {
        $this->Description = $description;
    }

    public function setStratum($stratum)
    {
        $this->Stratum = $stratum;
    }
}
