<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Jure
 * Date: 12.3.14
 * Time: 20:50
 * To change this template use File | Settings | File Templates.
 */

class NfieldInterviewersService implements INfieldInterviewersService, INfieldConnectionClientObject
{

    private $client = null;

    public function getClient()
    {
        return $this->client;
    }

    public function setClient(INfieldHttpClient $client)
    {
        $this->client = $client;
    }

    public function add(Interviewer $interviewer)
    {

        return $this->initializeNfieldConnection()->post($this->interviewersApi(), $interviewer);

    }

    public function remove(Interviewer $interviewer)
    {
        if ($interviewer == null) {
            throw new Exception('Interviewers is null');
        }

        return $this->initializeNfieldConnection()->delete($this->interviewersApi() . $interviewer->getInterviewerId());
    }

    public function update(Interviewer $interviewer)
    {
        if ($interviewer == null) {
            throw new Exception('Interviewers is null');
        }
        $updatedInterviewer = new Interviewer();
        $updatedInterviewer->setEmailAddress($interviewer->getEmailAddress());
        $updatedInterviewer->setFirstName($interviewer->getFirstName());
        $updatedInterviewer->setLastName($interviewer->getLastName());
        $updatedInterviewer->setTelephoneNumber($interviewer->getTelephoneNumber());

        return $this->initializeNfieldConnection()->
            patch($this->interviewersApi() . $interviewer->getInterviewerId(), $updatedInterviewer);
    }

    public function query()
    {
        //$this->client->get($this->interviewersApi()); - to je pravilno, ne deluje

        return $this->initializeNfieldConnection()->get($this->interviewersApi());

    }

    public function changePassword(Interviewer $interviewer, $password)
    {
        if ($interviewer == null) {
            throw new Exception('Interviewers is null');
        }

        $pass = new ResetPasswordModel();
        $pass->setPassword($password);
        $res = $this->initializeNfieldConnection()->put($this->interviewersApi() . $interviewer->getInterviewerId(),$pass);

        return $res;

    }

    private function interviewersApi()
    {

        //Uri must get from connection client
        return 'https://api.nfieldmr.com/v1' . '/Interviewers/';
    }

    public function initializeNfieldConnection()
    {
        $this->client = $this->connectionClient();
        return $this->client;
    }


    public function connectionClient()
    {

        $this->client = new NFieldHttpClient('https://api.nfieldmr.com/v1');
        return $this->client;


    }


    public function getDetail($InterviewerId)
    {
        return $this->initializeNfieldConnection()->get($this->interviewersApi() . $InterviewerId);
    }
}

    // Support classes
class ResetPasswordModel
{
    public $Password;
    public function getPassword()
    {
        return $this->Password;
    }
    public function setPassword($pas)
    {
         $this->Password = $pas;
    }



}
