<?php
/**
 * Created by PhpStorm.
 * User: Jure
 * Date: 11.4.2014
 * Time: 11:23
 */

class NfieldBackgroundTasksService implements INfieldBackgroundTasksService, INfieldConnectionClientObject{

    private $client = null;

    public function getClient()
    {
        return $this->client;
    }

    public function setClient(INfieldHttpClient $client)
    {
        $this->client = $client;
    }

    public function get()
    {
        return $this->initializeNfieldConnection()->get($this->backgroudTasksApi().$this->backgroudTasksControllerName());
    }

    public function getDetail($id)
    {
        return $this->initializeNfieldConnection()->get($this->backgroudTasksApi().$this->backgroudTasksControllerName().'/'.$id);

    }

    public function getByProject($surveyId)
    {
        return $this->initializeNfieldConnection()->get($this->backgroudTasksApi().$this->surveyControllerName().'/'.$surveyId.'/'.$this->backgroudTasksControllerName());
    }

    public function getDetailByProject($surveyId, $backgroundId)
    {
        return $this->initializeNfieldConnection()->get($this->backgroudTasksApi().$this->surveyControllerName().'/'.$surveyId.'/'.$this->backgroudTasksControllerName().'/'.$backgroundId);
    }

    public function connectionClient()
    {
        $this->client = new NFieldHttpClient('https://api.nfieldmr.com/v1');
        return $this->client;
    }

    public function initializeNfieldConnection()
    {
        $this->client = $this->connectionClient();
        return $this->client;
    }

    private function backgroudTasksApi()
    {
        //Uri must get from connection client
        return 'https://api.nfieldmr.com/v1/';
    }

    private  function  surveyControllerName()
    {
        return "Surveys";
    }

    private  function  backgroudTasksControllerName()
    {
        return "BackgroundTasks";
    }
}