<?php
/**
 * Created by PhpStorm.
 * User: Jure
 * Date: 6.4.2014
 * Time: 8:42
 */

interface INfieldSurveysService
{
    /// <summary>
    /// Adds a new survey.
    /// </summary>
    public function add(Survey $survey);
    /// <summary>
    /// Removes the survey.
    /// </summary>
    public function remove(Survey $survey);
    /// <summary>
    /// Updates the survey.
    ///
    /// The only properties that can be changed are
    /// SurveyName, ClientName and Description
    /// </summary>
    public function update(Survey $survey);
    /// <summary>
    /// Get all surveys
    /// </summary>
    public function query();

    /// <summary>
    /// Get specific survey
    /// </summary>
    public function getDetail($surveyId);

    public function uploadInterviewerFileInstructions($filePath, $surveyId);

    //return InterviewerInstruction
    public function downloadInterviewerFileInstructions($surveyId);

    public function deleteInterviewerFileInstructions($surveyId);

    /// <summary>
    /// Gets quota definition for survey.
    /// </summary>
    //return QuotaLevel
    public function quotaQuery($surveyId);

    /// <summary>
    /// Gets sampling point queryable object.
    /// </summary>
    /// <param name="surveyId"></param>
    /// <returns>SamplingPoint</returns>
    public function  samplingPointsQuery($surveyId);

    /// <summary>
    /// Gets a specific sampling point.
    /// </summary>
    /// <param name="surveyId"></param>
    /// <param name="samplingPointId"></param>
    /// <returns>SamplingPoint</returns>
    public function samplingPointQueryDetail($surveyId, $samplingPointId);

    /// <summary>
    /// Updates a sampling point
    /// </summary>
    /// <param name="surveyId"></param>
    /// <param name="samplingPoint"></param>
    /// <returns>SamplingPoint</returns>
    public function samplingPointUpdate($surveyId, SamplingPoint $samplingPoint);

    /// <summary>
    /// Adds a sampling point
    /// </summary>
    /// <param name="surveyId"></param>
    /// <param name="samplingPoint"></param>
    /// <returns>SamplingPoint</returns>
    public function samplingPointAdd($surveyId, SamplingPoint $samplingPoint);

    /// <summary>
    /// Deletes a sampling point.
    /// </summary>
    /// <param name="surveyId"></param>
    /// <param name="samplingPoint"></param>
    /// <returns></returns>
    public function samplingPointDelete($surveyId, SamplingPoint $samplingPoint);

    /// <summary>
    /// Gets sampling point's quota targets queryable object
    /// </summary>
    /// <param name="surveyId">id of the survey</param>
    /// <param name="samplingPointId">id of the sampling point</param>
    /// <returns>SamplingPointQuotaTarget</returns>
    public function samplingPointQuotaTargetsQuery($surveyId, $samplingPointId);

    /// <summary>
    /// Gets a specific sampling point's quota target
    /// </summary>
    /// <param name="surveyId">id of the survey</param>
    /// <param name="samplingPointId">id of the sampling point</param>
    /// <param name="levelId">id of the qouta level</param>
    /// <returns>SamplingPointQuotaTarget</returns>
    public function samplingPointQuotaTargetQuery($surveyId, $samplingPointId,$levelId);

    /// <summary>
    /// Updates sampling point's quota target
    /// </summary>
    /// <param name="surveyId">id of the survey</param>
    /// <param name="samplingPointId">id of the sampling point</param>
    /// <param name="samplingPointQuotaTarget"></param>
    /// <returns>SamplingPointQuotaTarget</returns>
    public function samplingPointQuotaTargetUpdate($surveyId, $samplingPointId,SamplingPointQuotaTarget $samplingPointQuotaTarget);

    /// <summary>
    /// Method used to upload an image file associated
    /// with a sampling point (e.g. a map).
    /// The upload of a new image file for an existing
    /// sampling point will replace the image.
    /// </summary>
    /// <param name="surveyId">The id of the survey that the sampling point belongs to</param>
    /// <param name="samplingPointId">The id of the sampling point</param>
    /// <param name="filePath">The full path of the image file</param>
    /// <returns>An message indicating the status of the action</returns>
    public function samplingPointImageAdd($surveyId,$samplingPointId,$filePath);

    /// <summary>
    /// Method used to upload an image file associated
    /// with a sampling point (e.g. a map).
    /// The upload of a new image file for an existing
    /// sampling point will replace the image.
    /// </summary>
    /// <param name="surveyId">The id of the survey that the sampling point belongs to</param>
    /// <param name="samplingPointId">The id of the sampling point</param>
    /// <param name="filename">name of the image file</param>
    /// <param name="content">The content of the image file</param>
    /// <returns>An message indicating the status of the action</returns>
    public function samplingPointImageAddAsync($surveyId,  $samplingPointId,$filename,$content = array());

    public function addInterviewerOnProject(Interviewer $interview,$surveyId);

}