<?php
/**
 * Created by PhpStorm.
 * User: Jure
 * Date: 6.4.2014
 * Time: 8:31
 */
/// <summary>
/// Holds all properties of a sampling point
/// </summary>
class SamplingPoint {

    /// <summary>
    /// Gets or sets the sampling point unique identifier.
    /// </summary>
    public $SamplingPointId;
    /// <summary>
    /// Gets or sets the name of the sampling point.
    /// </summary>
    public $Name;
    /// <summary>
    /// Gets or sets the description.
    /// </summary>
    public $Description;
    /// <summary>
    /// Gets or sets the instruction link, this is a link to a pdf blob storage.
    /// </summary>
    public $Instruction;
    /// <summary>
    /// Gets or sets the associcated fieldwork office id.
    /// </summary>
    public $FieldworkOfficeId;
    /// <summary>
    /// Gets or sets the sampling point group id
    /// </summary>
    public $GroupId;
    /// <summary>
    /// Stratum the sampling point belongs to
    /// </summary>
    public $Stratum;
    /// <summary>
    /// is it a spare sampling point?
    /// </summary>
    public $IsSpare;

    public function getId(){
        return $this->SamplingPointId;
    }

    public function getName()
    {
        return $this->Name;
    }

    public function getFieldworkOfficeId()
    {
        return $this->FieldworkOfficeId;
    }

    public function getGroupId()
    {
        return $this->GroupId;
    }

    public function getDescription()
    {
        return $this->Description;
    }

    public function getStratum()
    {
        return $this->Stratum;
    }

    public function setId($id){
        $this->SamplingPointId = $id;
    }

    public function setName($name)
    {
        $this->Name = $name;
    }

    public function setFieldworkOfficeId($id)
    {
        $this->FieldworkOfficeId = $id;
    }

    public function setDescription($description)
    {
        $this->Description = $description;
    }

    public function setStratum($stratum)
    {
        $this->Stratum = $stratum;
    }

} 