<?php
/**
 * PHPExcel
 *
 * Copyright (C) 2006 - 2012 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2012 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    1.7.8, 2012-10-12
 */

/** Error reporting */

include_once("_dirinfo.php");
/** Include PHPExcel */
require_once '../../../_plugins/excel/PHPExcel.php';
include_once(PATH_TO_ROOT."mystery/init.php");
include_once(PATH_TO_ROOT."mystery/_class/class.mysteryCalculator.php");


//$_GET['projectName'] = "Komercijalna_banka_BIH_dec_2012";
if (!$_GET['projectName']) { echo "No Project name!!!"; exit; } 
$project = $_GET['projectName'];

$calculator = new mysteryCalculator($db,$project);

if ($_SESSION['mysteryReportGraph']) {
	foreach ($_SESSION['mysteryReportGraph'] as $key=>$prop) {
		if (!$prop['checked']) {
			$calculator->hideGroups[$key] = $key;
		}
	}
}

$calculator->LoadQuestionnaireTree();
$calculator->LoadQuestionScores();


	
if ($_GET['id_record']) {
	$calculator->LoadRecords($_GET['id_record']);	
} else {
	$sql = "SELECT id FROM ".DB_WARPIT_WEBCATI_BASE.".".$project."_structure WHERE flag_bad = 101";
	//echo $sql;
	$res = $db->SQLexecute($sql);
	while ($zad = $db->fetchAssoc($res)) {
		$id = $zad['id'];
		$calculator->LoadRecords($id);	
	}
}

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Masmi")
							 ->setLastModifiedBy("Masmi")
							 ->setTitle("Export")
							 ->setSubject("Export")
							 ->setDescription("Export Total");
							 
$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setName('Verdana');
							 
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', "Atributi za ocenjivanje")
            ->setCellValue('B1', "Maksimalan broj poena")
            ->setCellValue('C1', "Postignuce")
            ->setCellValue('D1', "Nedostatak")
            ->setCellValue('E1', "Postignuće(%)")
            ->setCellValue('F1', "Nedostatak(%)")
            ;
//$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('B1:F1')->getAlignment()->setTextRotation(90);
$objPHPExcel->getActiveSheet()->getStyle('A1:A200')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(70);
/*
$objPHPExcel->getActiveSheet()->getStyle('A1:T100')->applyFromArray(
	array('fill' 	=> array(
								'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
								'color'		=> array('argb' => 'FFE0E0E0')
							),
		  'borders' => array(
								'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN),
								'right'		=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)
							)
		 )
	);
*/
$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->applyFromArray(
	array('fill' 	=> array(
								'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
								'color'		=> array('argb' => 'FF00B0F0')
							)
		 )
	);
	
$i = 1;

	foreach ($calculator->FolderStructure['main'] as $idMainFolder => $FolderLab) {

		if (!$calculator->calculatedScoresFolders[$idMainFolder]['total']) continue;
		
		$i++;
		$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':F'.$i)->applyFromArray(
			array('fill' 	=> array(
										'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
										'color'		=> array('argb' => 'FFE0E0E0')
									)
				 )
		);
		
		if ($calculator->calculatedScoresFolders[$idMainFolder]['total']) $percentCalc1 = round(($calculator->calculatedScoresFolders[$idMainFolder]['pos'] / $calculator->calculatedScoresFolders[$idMainFolder]['total'] * 100),0);
				else $percentCalc1 = "";			
			
		if ($calculator->calculatedScoresFolders[$idMainFolder]['total']) $percentCalc2 = round(($calculator->calculatedScoresFolders[$idMainFolder]['neg'] / $calculator->calculatedScoresFolders[$idMainFolder]['total'] * 100),0);
				else $percentCalc2 = "";	
				
		$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A'.$i, $FolderLab)
            ->setCellValue('B'.$i, $calculator->calculatedScoresFolders[$idMainFolder]['total'])
            ->setCellValue('C'.$i, $calculator->calculatedScoresFolders[$idMainFolder]['pos'])
            ->setCellValue('D'.$i, $calculator->calculatedScoresFolders[$idMainFolder]['neg'])
            ->setCellValue('E'.$i, $percentCalc1 )
            ->setCellValue('F'.$i, $percentCalc2 );
           
		
		
		if ( $calculator->FolderStructure['sub'][$idMainFolder] ) {
		
			// foreach subfolders
			foreach ($calculator->FolderStructure['sub'][$idMainFolder] as $idSubFolder => $SubFolderLab) {
				if (!$calculator->calculatedScoresFolders[$idSubFolder]['total']) continue;
				$i++;
				$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':F'.$i)->applyFromArray(
					array('fill' 	=> array(
												'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
												'color'		=> array('argb' => 'FFf4f2f2')
											)
						 )
				);
				
				if ($calculator->calculatedScoresFolders[$idSubFolder]['total']) $percentCalc1 = round(($calculator->calculatedScoresFolders[$idSubFolder]['pos'] / $calculator->calculatedScoresFolders[$idSubFolder]['total'] * 100),0);
						else $percentCalc1 = "";			
					
				if ($calculator->calculatedScoresFolders[$idSubFolder]['total']) $percentCalc2 = round(($calculator->calculatedScoresFolders[$idSubFolder]['neg'] / $calculator->calculatedScoresFolders[$idSubFolder]['total'] * 100),0);
						else $percentCalc2 = "";	
						
				$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A'.$i, $SubFolderLab)
		            ->setCellValue('B'.$i, $calculator->calculatedScoresFolders[$idSubFolder]['total'])
		            ->setCellValue('C'.$i, $calculator->calculatedScoresFolders[$idSubFolder]['pos'])
		            ->setCellValue('D'.$i, $calculator->calculatedScoresFolders[$idSubFolder]['neg'])
		            ->setCellValue('E'.$i, $percentCalc1 )
		            ->setCellValue('F'.$i, $percentCalc2 );
				
	
					// show questions 
					foreach ($calculator->QuestSubStructure[$idSubFolder] as $idQuestion ) {
						$question = $calculator->QuestNames[$idQuestion];
						if (!$calculator->calculatedScores[$question]['total']) continue;
						
						$i++;
						
						if ($calculator->calculatedScoresFolders[$idSubFolder]['total']) $percentCalc1 = round(($calculator->calculatedScores[$question]['pos'] / $calculator->calculatedScores[$question]['total'] * 100),0);
						else $percentCalc1 = "";			
					
						if ($calculator->calculatedScoresFolders[$idSubFolder]['total']) $percentCalc2 = round(($calculator->calculatedScores[$question]['neg'] / $calculator->calculatedScores[$question]['total'] * 100),0);
								else $percentCalc2 = "";	
								
						$objPHPExcel->setActiveSheetIndex(0)
				            ->setCellValue('A'.$i, strip_tags($calculator->QuestNamesLabels[$idQuestion]))
				            ->setCellValue('B'.$i, $calculator->calculatedScores[$question]['total'])
				            ->setCellValue('C'.$i, $calculator->calculatedScores[$question]['pos'])
				            ->setCellValue('D'.$i, $calculator->calculatedScores[$question]['neg'])
				            ->setCellValue('E'.$i, $percentCalc1 )
				            ->setCellValue('F'.$i, $percentCalc2 );
					}	// end show questions	
			}	// end foreach subfolders		 		
		} 
		
			if ($calculator->QuestSubStructure[$idMainFolder]) {
				// show questions 
				foreach ($calculator->QuestSubStructure[$idMainFolder] as $idQuestion ) {
					$question = $calculator->QuestNames[$idQuestion];
					if (!$calculator->calculatedScores[$question]['total']) continue;
					$i++;
						
						if ($calculator->calculatedScoresFolders[$idSubFolder]['total']) $percentCalc1 = round(($calculator->calculatedScores[$question]['pos'] / $calculator->calculatedScores[$question]['total'] * 100),0);
						else $percentCalc1 = "";			
					
						if ($calculator->calculatedScoresFolders[$idSubFolder]['total']) $percentCalc2 = round(($calculator->calculatedScores[$question]['neg'] / $calculator->calculatedScores[$question]['total'] * 100),0);
								else $percentCalc2 = "";	
								
						$objPHPExcel->setActiveSheetIndex(0)
				            ->setCellValue('A'.$i,  strip_tags($calculator->QuestNamesLabels[$idQuestion]))
				            ->setCellValue('B'.$i, $calculator->calculatedScores[$question]['total'])
				            ->setCellValue('C'.$i, $calculator->calculatedScores[$question]['pos'])
				            ->setCellValue('D'.$i, $calculator->calculatedScores[$question]['neg'])
				            ->setCellValue('E'.$i, $percentCalc1 )
				            ->setCellValue('F'.$i, $percentCalc2 );
					
				}
			}	
	}
	$i++;
	
	$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':F'.$i)->applyFromArray(
					array('fill' 	=> array(
												'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
												'color'		=> array('argb' => 'FFE0E0E0')
											)
						 )
				);
	$objPHPExcel->setActiveSheetIndex(0)
				            ->setCellValue('A'.$i, "TOTAL")
				            ->setCellValue('B'.$i, $calculator->calculatedScoresTotal['total'])
				            ->setCellValue('C'.$i, $calculator->calculatedScoresTotal['pos'])
				            ->setCellValue('D'.$i, $calculator->calculatedScoresTotal['neg'])
				            ->setCellValue('E'.$i, (round($calculator->calculatedScoresTotal['pos']/$calculator->calculatedScoresTotal['total'],2)*100) )
				            ->setCellValue('F'.$i, (round($calculator->calculatedScoresTotal['neg']/$calculator->calculatedScoresTotal['total'],2)*100) );

	
// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Export');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel5)
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="Export-Total.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit;
?>