<?php
require_once '../../../_plugins/excel/PHPExcel.php';
// Create new PHPExcel object


function CreateTable(&$aObj, $aX, $aY, $dataArray) {
	
	$i = 0;
	$j = $aY;
	$y = $aY;
	$x = $aX;
	
	foreach ($dataArray['header']['data'] as $val) {
		$i++;
		$aObj->getActiveSheet()->setCellValue(chr($aX+63+$i).$j, $val);	
		
		$aObj->getActiveSheet()->getStyle(chr($aX+63+$i).$j)->applyFromArray(
			array('fill' 	=> array(
										'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
										'color'		=> array('argb' => 'FF00B0F0')
									)
				 )
		);
	}

	foreach ($dataArray['body']['data'] as $rowArr) {
		$i = 0;
		$j++;
		foreach ($rowArr as $val) {
			$i++;
			$aObj->getActiveSheet()->setCellValue(chr($aX+63+$i).$j, $val);	
		}	
	}
	
}


$objPHPExcel = new PHPExcel();
// Set document properties
$objPHPExcel->getProperties()->setCreator("Masmi")
							 ->setLastModifiedBy("Masmi")
							 ->setTitle("Export")
							 ->setSubject("Export")
							 ->setDescription("Export Total");
							 
$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setName('Verdana');
							 
// Add some data
$objPHPExcel->setActiveSheetIndex(0);


$dataArray['header']['data'] = array("Moj lepi naslov","N","%");
$dataArray['body']['data'][] = array("labela 1","10","10.12");
$dataArray['body']['data'][] = array("labela 2","80","77.12");
$dataArray['body']['data'][] = array("labela 3","20","12.12");
CreateTable($objPHPExcel,1,1,$dataArray);

	
// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Export');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel5)
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="Export-Total.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit;
?>