<?php

class ddf2warpit
{
	protected $name_project = null;
	protected $L_cnt = 0;
	protected $S_cnt =-1;
	protected $Q_cnt = 0;
	protected $Qlgn_cnt = 0;
	protected $C_cnt = 0;
	
	protected $AnswerCounter;
	protected $MBRX_cnt;
	
	protected $S_guide = false; // I should read guide for complete S from first MBRQ Question
	protected $S_read_guide = false; // set to false, only if I am sure that next A will give me some instructions I set it to true
	protected $showLegend = false;
	protected $Qvariable = null;
	protected $AnswerCode = null;
	protected $setSwitch = array();
	
	protected $db;
	
	public $language = array();
	public $project = array();
	
	
	public function __construct($db)
	{
		$this->db=$db;
	}
	
	
	public function getActiveProject() {
		$row = $this->db->get("TGI_projects","active=1","id");
		$id_project = $row[0];
		
		$this->db->LogWrite($id_project,true,"get active project");
		
		return $id_project;
	}
	

	public function getActiveProjectName($id_project) {
		$name_project = $this->db->get("TGI_projects",$id_project,"name");
		$this->name_project = $name_project;
		
		return $name_project;
	}
	
	
	protected function checkRow($row) {
		$category = $row['category'];
		
		switch ($category)  {
			
			case "H":
				$this->setSwitch['H'] = true;
				
				$availableLanugages = explode(",", strtoupper($row['variable']));
				foreach ($availableLanugages AS $keyLang => $itemLang) {
					if ($availableLanugages[$keyLang] == "SLV") 
						$this->language[$keyLang] = 91;
					elseif ($availableLanugages[$keyLang] == "ENG") 
						$this->language[$keyLang] = 46;
					else 
						$this->language['language'][$keyLang] = 46;
				}	
				$this->db->LogWrite($this->language[0],true,"inside H, language");
				$this->db->LogWrite($this->language[1],true,"inside H, language");
				
				$this->L_cnt = 0; 
				break;
				
			case "C";
				$this->setSwitch['C'] = true;
				$this->setSwitch['S'] = false;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['A'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['T'] = false;
				$this->C_cnt++;
				
				if ($this->C_cnt < 10) $this->C_cnt = "0".$this->C_cnt;
				$this->project[$this->C_cnt]['name'] = $this->name_project."_".$this->C_cnt;
				
				$this->db->LogWrite($this->project[$this->C_cnt]['name'],true,"inside C, name");
				$this->L_cnt = 0;
				break;
			
			case "L";
				$this->setSwitch['L'] = true;
				
				$this->db->LogWrite("S:".$this->setSwitch['S']." - "."Q:".$this->setSwitch['Q']." - "."A:".$this->setSwitch['A']." - "."T:".$this->setSwitch['T']." - "."C:".$this->setSwitch['C'],true,"inside L");
				$this->db->LogWrite("controlCode_label:".$row['controlCode_label']." --- AnswerCode:".$this->AnswerCode." --- L_cnt:".$this->L_cnt." --- Qvariable:".$this->Qvariable,true,"inside L");
				
				if ($this->setSwitch['A'] == true OR $this->setSwitch['MBRX_A'] == true OR $this->setSwitch['V'] == true OR $this->setSwitch['X'] == true) {
					if ($this->setSwitch['T'] == true) {
						if ($this->showLegend == true) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt]['answers'][$this->AnswerCode][$this->L_cnt] = $this->specCharCheck($row['controlCode_label']."<br>".$row['longer_description']);
							$this->db->LogWrite("Qvariable:".$this->Qvariable." --- Legend counter:".$this->Qlgn_cnt,true,"inside L, T is true, show legend");
						} else {
							unset($this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt]);	
							$this->db->LogWrite("Qvariable:".$this->Qvariable." --- Legend counter:".$this->Qlgn_cnt,true,"inside L, T is true, hide legend");
						}
					} else {
						if ($this->setSwitch['MBRX_A'] == true) {
							// I show always all answers for now, if question is set to be shown 
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
						}
						$this->db->LogWrite($this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode],true,"inside L, T is false, answer visible?");

						if ($this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] == 1) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers'][$this->AnswerCode][$this->L_cnt] = $this->specCharCheck($row['controlCode_label']."<br>".$row['longer_description']);
							$this->db->LogWrite("Qvariable:".$this->Qvariable." --- L_cnt counter:".$this->L_cnt,true,"inside L, T is false, standard answers");
							$this->db->LogWrite("Added label to array:".$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers'][$this->AnswerCode][$this->L_cnt],true,"inside L, T is false, standard answers");
						} else {
							$this->db->LogWrite($this->project[$this->C_cnt]['question'][$this->Qvariable]['answers'][$this->AnswerCode][$this->L_cnt],true,"inside L, T is false, label not added");
						}
					}
					

					// check if guide for S exist...
					if ($this->S_read_guide == true AND $this->L_cnt == 0 AND $this->MBRX_cnt > 0) {
						$this->db->LogWrite("Qvariable:".$this->Qvariable." --- MBRX counter:".$this->MBRX_cnt,true,"inside L, set guide");
						
						$DescriptionVariables = str_replace(" ","",strtoupper($row['longer_description']));
						
						$this->db->LogWrite("keyword:".$this->keyword,true,"inside L, set guide");
						if ($this->keyword == "WEB1") {
							$this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'] = explode(",", $DescriptionVariables);
							$this->db->LogWrite("WEB1",true,"inside L, set guide");
						} elseif ($this->keyword == "WEB2") {
							$this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'] = explode(",", $DescriptionVariables);
							$this->db->LogWrite("WEB2",true,"inside L, set guide");
						} elseif ($this->keyword == "WEB3") {
							$this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer'] = explode(",", $DescriptionVariables);
							$this->db->LogWrite("WEB3",true,"inside L, set guide");
						} elseif ($this->keyword == "WEB4") {
							$this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question'] = explode(",", $DescriptionVariables);
							$this->db->LogWrite("WEB4",true,"inside L, set guide");
						} elseif ($this->keyword == "WEB5") {
							$this->project[$this->C_cnt]['guide'][$this->Svariable]['multi'] = explode(",", $DescriptionVariables);
							$this->db->LogWrite("WEB5",true,"inside L, set guide");
						} elseif ($this->keyword == "WEB6") {
							if ($DescriptionVariables) {
								$web6_array = explode(",", $DescriptionVariables);
								if (!isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'])) $this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'] =  array();
								$this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'] = array_merge($this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'],$web6_array);
								$this->db->LogWrite("WEB6",true,"inside L, set guide");
							}
						}	
						$this->db->LogWrite("MBRX counter:".$this->MBRX_cnt." --- longer description variables:".$DescriptionVariables,true,"inside L, set guide");
					}
					
					$this->db->LogWrite($this->Qvariable,true,"inside L, set answers text");
				} elseif ($this->setSwitch['S'] == true OR $this->setSwitch['Q'] == true) {
					if ($this->setSwitch['T'] == true) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['legend'][$this->Qlgn_cnt][$this->L_cnt] = $row['controlCode_label']."<br>".$row['longer_description'];
						$this->db->LogWrite($this->Qvariable,true,"inside L, set T,Q legend question text");
					} else {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['label'][$this->L_cnt] = $row['controlCode_label']."<br>".$row['longer_description'];
						$this->db->LogWrite($this->Qvariable,true,"inside L, set question text");
					}
				} elseif ($this->setSwitch['T'] == true) {
					if ($this->setSwitch['MBRX'] == true) {
						$this->db->LogWrite($this->Qvariable,true,"inside L, set nothing, A is disabled because ob MBRX");
					} else {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['label'][$this->L_cnt] = $row['controlCode_label']."<br>".$row['longer_description'];
						$this->db->LogWrite($this->Qvariable,true,"inside L, set T question text");
					}
				} elseif ($this->setSwitch['C'] == true) {
					$this->project[$this->C_cnt]['sub_name'][$this->L_cnt] = $row['controlCode_label'];
					$this->db->LogWrite($this->C_cnt,true,"inside L, set C question text");
				} else {
					$this->db->LogWrite($this->Qvariable,true,"inside L, set nothing");
				}
				
				$this->L_cnt++;
				break;
			
			case "S";
				$this->S_cnt++;
				$this->Q_cnt = 0;
				$this->S_guide = true;
				
				$this->setSwitch['S'] = true;
				$this->setSwitch['A'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['T'] = false;
				$this->setSwitch['C'] = false;
				
				$this->Qvariable = $this->getSQname($this->S_cnt,$this->Q_cnt);
				$this->Svariable = $this->getSname($this->S_cnt);
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 5; // info qustion
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['subtype'] = 0; // ni legende
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 1; // show question
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['must_answer'] = 0; // disable must answer
				
				$this->db->LogWrite($this->S_cnt.":S and Q:".$this->Q_cnt,true,"inside S");
				$this->L_cnt = 0;
				break;
			
			case "T";
				$this->setSwitch['T'] = true;
				$this->setSwitch['A'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['S'] = false; // izklopim S ker sem ze opravil z info vprasanjem
				$this->setSwitch['MBRX'] = false;
				$this->AnswerCode = null;
				$this->Qlgn_cnt = 0;
				$this->Q_cnt++;
				$this->Qvariable = $this->getSQname($this->S_cnt,$this->Q_cnt);
				
				// ce je izklpoljen grid prikaz se obnasam kot da Tja ni
				if (strtoupper($row['variable']) == "NOSHOW") {
					$this->setSwitch['T'] = false;
				}
				
				$this->db->LogWrite($this->setSwitch['T'],true,"inside T, setSwitch");
				
				$this->L_cnt = 0;
				break;
			
			case "Q";
				$this->setSwitch['Q'] = true;
				$this->setSwitch['A'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['S'] = false;
				$this->setSwitch['MBRX'] = false;
				$this->setSwitch['MBRX_A'] = false;
				$this->S_read_guide = false; // I set on all Q this to false, at this point I do not know if this will be instructions for me
				$this->AnswerCode = null;
				$this->db->LogWrite("controlCode_label:".$row['controlCode_label']." --- variable:".$row['variable'],true,"inside Q");
				
				if ($this->setSwitch['T'] == true) { 
					$this->db->LogWrite("set type to 2",true,"inside Q");
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 2; // default is scale
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['subtype'] = 1; // z legendo
					
					$this->showLegend = true;
					$this->Qlgn_cnt++;
				} else {
					$this->Q_cnt++;
					$this->Qvariable = $this->getSQname($this->S_cnt,$this->Q_cnt);
					
					$this->db->LogWrite("set type to 1",true,"inside Q");
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 1; // single
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['subtype'] = 0; // brez legende
				}	
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 1; // show question
				$this->project[$this->C_cnt]['question'][$this->Qvariable]['must_answer'] = 0; // disable must answer
				$this->db->LogWrite($this->Qvariable,true,"inside Q, Qvariable");
				$this->db->LogWrite($this->S_guide,true,"inside Q, S_guide");
				
				// preverim MRBX kodo, ce je noter, ne naredim nic, razen ce je seveda to koda za navodilo za sklop
				if ($row['controlCode_label'] == "MRBX") {
					if ($this->S_guide == true) {
						$this->MBRX_cnt = 0;
						$this->S_read_guide = true;
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide question
						$this->db->LogWrite("setting S_read_guide to true",true,"inside Q");
					}
					
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide question
					// after first MBRX I try to read guide for whole S, if possible, if not I disable reading till end of S
				}
				
									
				$this->S_guide = false; // ce ni navodil na prvem Q zapisu po S, potem preskocim navodila in jih ne iscem vec
				$this->L_cnt = 0;
				break;
			
			case "V";
				// ne nardim nič, izklopim samo S in Q
				$this->setSwitch['S'] = false;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['A'] = false;
				
				$this->AnswerCode = strtoupper($row['variable']);
				$this->db->LogWrite("setting S, Q and A to false, AnswerCode:".$this->AnswerCode,true,"inside V");
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) {
					$this->db->LogWrite("show answer is set".print_r($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'],1),true,"inside V");
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) {
						$this->db->LogWrite("answerCode found in show_answer array",true,"inside V");
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
						$this->setSwitch['V'] = true;
					} else {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
					}
				} else {
					$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
				}
						
				$this->L_cnt = 0;
				break;
			
			case "A";
				$this->setSwitch['A'] = true;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['X'] = false;
				$this->setSwitch['MBRX'] = false;
				
				$this->AnswerCode = null;
				$this->keyword = null;

				$this->AnswerCode = strtoupper($row['variable']);
				$keyword_arr = explode("_",$this->AnswerCode);
				
				// preverim MRBX kodo, ce je noter navodilo za sklop
				if ($row['controlCode_label'] == "MRBX" AND substr($keyword_arr[1],0,3) == "WEB") {
					// ce imam za precitat definicijo grem tole naredit
					if ($this->S_read_guide == true) {
						$this->MBRX_cnt++;
						$this->keyword = $keyword_arr[1]; 
						
						$this->db->LogWrite("S_read_guide = true --- MBRX counter:".$this->MBRX_cnt,true,"inside A, MRBX check");
					}
												
					$this->db->LogWrite("setSwitch A:".$this->setSwitch['A']." --- controlCode_label:".$row['controlCode_label'],true,"inside A, MRBX check");
				} elseif ($row['controlCode_label'] == "MRBX") {
					if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer']) AND $this->AnswerCode) {
						// check if answer should be shown (no matter if MBRX is set)
						if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_answer'])) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
							$this->db->LogWrite("show answer",true,"inside A, keyword check");
						} else {
							$this->setSwitch['A'] = false;
							$this->setSwitch['MBRX'] = true;
							$this->db->LogWrite("false",true,"inside A, set switch A (upper)");
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
						}
					} else {
						$this->setSwitch['A'] = false;
						$this->setSwitch['MBRX'] = true;
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
						$this->db->LogWrite("false",true,"inside A, set switch A (lower)");
					}
				} else {
					$this->db->LogWrite($row['controlCode_label'],true,"inside A, not MBRX");
					
					if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer']) AND $this->AnswerCode) {
						if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_answer'])) {
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 0; // hide answer
							$this->db->LogWrite("hide answer",true,"inside A, keyword check");
							$this->setSwitch['A'] = false;
						} else {
							$this->db->LogWrite($this->AnswerCode,true,"inside A, not MBRX, set to visible, array check not true");
							$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
						}
					} else {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['answers']['visible'][$this->AnswerCode] = 1; // show answer
						$this->db->LogWrite("show answer",true,"inside A, not MBRX");
					}
				}
				
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question']) AND $this->AnswerCode) {
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 1; // show question
						$this->setSwitch['A'] = true;
						$this->db->LogWrite("show question",true,"inside A, keyword check");
						
						// because question is shown additionaly, I must by default show also all answers, I hide only if somethin is psecified indide WEB3
						$this->setSwitch['MBRX_A'] = true;
					}
				}
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question']) AND $this->AnswerCode) {	
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['hide_question'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['show'] = 0; // hide question
						$this->setSwitch['A'] = false;
						$this->db->LogWrite("hide question",true,"inside A, keyword check");
					}
				}
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['multi']) AND $this->AnswerCode) {
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['multi'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['type'] = 3; // multi
						$this->db->LogWrite("multi",true,"inside A, keyword check");
					}
				}
				
				if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer']) AND $this->AnswerCode) {
					if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['must_answer'])) {
						$this->project[$this->C_cnt]['question'][$this->Qvariable]['must_answer'] = 1; // must answer
						$this->db->LogWrite("must_answer",true,"inside A, keyword check");
					}
				}
				
				$this->db->LogWrite("AnswerCode:".$this->AnswerCode." --- controlCode_label:".$row['controlCode_label'],true,"inside A");
							
				$this->L_cnt = 0;
				break;
			
			case "X";
				$this->setSwitch['X'] = true;
				$this->setSwitch['Q'] = false;
				$this->setSwitch['V'] = false;
				$this->setSwitch['A'] = false;
				$this->showLegend = false;
				$this->AnswerCode = strtoupper($row['variable']);
				
				$this->db->LogWrite("S:".$this->setSwitch['S']." - "."Q:".$this->setSwitch['Q']." - "."A:".$this->setSwitch['A']." - "."T:".$this->setSwitch['T'],true,"inside X");
				$this->db->LogWrite($this->AnswerCode." --- legend counter:".$this->Qlgn_cnt,true,"inside X, AnswerCode");					
				
				// ce imam vklopljen T moram izbrisat legendo, ker tudi odgovorov nimam, za vse jezike naenkrat
				if ($this->setSwitch['T'] == true) { 
					if (isset($this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question']) AND $this->AnswerCode) {
						if (in_array($this->AnswerCode, $this->project[$this->C_cnt]['guide'][$this->Svariable]['show_question'])) {
							$this->showLegend = true;
							$this->db->LogWrite("show legend item",true,"inside X, keyword check");
						} else {
							$this->db->LogWrite("hide legend item",true,"inside X, keyword check");
						}
					}
				}
				
				$this->L_cnt = 0;
				break;
				
			case "Z":
				// ne nardim nič, načeloma je to zadnja ddf vrstica
				
				$QuestEnd = true;
				$this->L_cnt = 0;
				break;
		}
		 
	}
	
	
	protected function getSQname($Scnt,$Qcnt) {
		if ($Scnt<10) 
			$Szero = "00".$Scnt;
		else if ($Scnt<100 AND $Scnt>9) 
			$Szero = "0".$Scnt;
		else
			$Szero = $Scnt;
			
			
		if ($Qcnt<10) 
			$Qzero = "00".$Qcnt;
		else if ($Qcnt<100 AND $Qcnt>9) 
			$Qzero = "0".$Qcnt;
		else
			$Qzero = $Qcnt;
			
		return "S".$Szero."Q".$Qzero;
	}
	
	
	protected function specCharCheck($str) {
		$str = str_replace(array("\t","\r\n","\n","\r","/"),array(" ","<br>","<br>","<br>","&#47;"),$str);
		return $str;
	}
	
	
	protected function getSname($Scnt) {
		if ($Scnt<10) 
			$Szero = "00".$Scnt;
		else if ($Scnt<100 AND $Scnt>9) 
			$Szero = "0".$Scnt;
		else
			$Szero = $Scnt;
			
		return "S".$Szero;
	}
	
	
	public function readDDF($id_project) {
		
		try {
			$sql = "SELECT * FROM ".$this->getActiveProjectName($id_project)."___import";
			$this->db->LogWrite($sql,true,"vcitam komplet DDF vprasalnik");
			$result = $this->db->SQLexecute($sql);
			while ($row = mysql_fetch_array($result)) {
				$this->checkRow($row); 
			}
			
			return true;
		}	
		catch (Exception $e)
		{
		    $this->db->LogWrite($e->getMessage(),true,"error creating XML->warpit");
		    return false;
		}
	}

}	

?>