<?php

//ini_set("display_errors","1");
/*
 *  Copyright (C) 2012
 *     Ed Rackham (http://github.com/a1phanumeric/PHP-MySQL-Class)
 *  Changes to Version 0.8.1 copyright (C) 2013
 *	Christopher Harms (http://github.com/neurotroph)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// MySQL Class v0.8.1

class db {

    // Base variables
    var $lastError;					// Holds the last error
    var $lastQuery;					// Holds the last query
    var $result;						// Holds the MySQL query result
    var $records;						// Holds the total number of records returned
    var $affected;					// Holds the total number of records affected
    var $rawResults;				// Holds raw 'arrayed' results
    var $arrayedResult;			// Holds an array of the result

    var $hostname;	// MySQL Hostname
    var $username;	// MySQL Username
    var $password;	// MySQL Password
    var $database;	// MySQL Database

    var $databaseLink;		// Database Connection Link

    private static $instance; //store the single instance of the database

    /* *******************
     * Class Constructor *
     * *******************/

    function __construct(){
        $this->database = "Warpit";
        $this->username = MYSQL_USER;
        $this->password = MYSQL_PASS;
        $this->hostname = "localhost";
		
        $this->Connect();
    }

    //this function makes sure there's only 1 instance of the Database class

	
	function ChangeDatabase($database) {
		mysql_select_db($database,$this->databaseLink);
	}
    /*function MySQL($database='u557679940_db', $username='u557679940_db', $password='hrastnik123', $hostname='mysql.2freehosting.com'){
        $this->database = $database;
        $this->username = $username;
        $this->password = $password;
        $this->hostname = $hostname;

        $this->Connect();
    }*/



    /* *******************
     * Private Functions *
     * *******************/

    // Connects class to database
    // $persistant (boolean) - Use persistant connection?
    private function Connect($persistant = false){
        if($persistant){
            $this->databaseLink = mysql_pconnect($this->hostname, $this->username, $this->password);
        }else{
            $this->databaseLink = mysql_connect($this->hostname, $this->username, $this->password);
        }

        if(!$this->databaseLink){
            $this->lastError = 'Could not connect to server: ' . mysql_error($this->databaseLink);
            return false;
        }

        if(!$this->UseDB()){
            $this->lastError = 'Could not connect to database: ' . mysql_error($this->databaseLink);
            return false;
        }
        return true;
    }


    // Select database to use
    private function UseDB(){
        if(!mysql_select_db($this->database, $this->databaseLink)){
            $this->lastError = 'Cannot select database: ' . mysql_error($this->databaseLink);
            return false;
        }else{
            return true;
        }
    }


    // Performs a 'mysql_real_escape_string' on the entire array/string
    private function SecureData($data){
        if(is_array($data)){
            foreach($data as $key=>$val){
                if(!is_array($data[$key])){
                    $data[$key] = mysql_real_escape_string($data[$key], $this->databaseLink);
                }
            }
        }else{
            $data = mysql_real_escape_string($data, $this->databaseLink);
        }
        return $data;
    }



    /* ******************
     * Public Functions *
     * ******************/

    // Executes MySQL query
    function fetchAssoc(&$result) { return mysql_fetch_assoc($result); }
	function fetchRow(&$result) { return mysql_fetch_row($result); }
	function fetchArray(&$result) { return mysql_fetch_array($result); }
	function GetError() { return $this->lastError; }
	function TableExists($tableName,$database = null)
	{
		if($database)
			$this->ChangeDatabase($database);
		$sql = "SHOW TABLES LIKE '$tableName'";
		$rs = $this->SQLexecute($sql);
		if($this->fetchRow($rs))
			return true;
		return false;
	}
	public function get($table,$row=null,$column=null,$database=null)
	{
		if($database)
			$this->ChangeDatabase($database);

		$sel = $column ? $column : '*';
		if(strpos($sel,',')==0 && trim($sel) != '*' )
		//if column does not contains commas and is not select all
			$oneColumn = true;
		else 
			$oneColumn = false;
		$byId = is_numeric($row);
		$sql = "SELECT $sel FROM $table";
		if($row)
		{
			if(is_numeric($row))
				$sql.= " WHERE id = $row";
			else
				$sql .= " WHERE $row";
		}
		//echo $sql;
		$this->LogWrite($sql,true,"DB class (get)");
		
		$res = $this->SQLexecute($sql);
		if($oneColumn)
			while ($r = $this->fetchAssoc($res))
			{
				$ans[] = $r[$sel];
			}
		else
			while ($r = $this->fetchAssoc($res))
			{
				$ans[] = $r;
			}
		//if only one column is sought and one row is fetched we return the value
		if($byId)
			return $ans[0];
			
		return $ans;
		
	}
	
	public function LogWrite($strLog,$execute=null,$title=null) {
		if (!$execute) return true;
		//return true;
		
		if ($title) $title = " - ".$title;
		$strLog = $this->GetTime().$title." - ".$strLog."\r\n";
		$str = (isset($_SESSION['id_user'])) ? $_SESSION['id_user'] : 'admin'; 
	
		if (file_put_contents("/tmp/warpit_db_log_".$str.".txt", $strLog, FILE_APPEND | LOCK_EX)) {
			return true;
		} else {
			return false;
		}
	}
	protected function GetTime() {
		return date("H:i:s:u [j.n.Y]");
	}
	
    function NumRows(&$result) { return mysql_num_rows($result); }
    function SQLexecute($query){
    	$query = $this->SecureData($query);
        $this->lastQuery 	= $query;
		echo $query;
		
        if($this->result = mysql_query($query, $this->databaseLink)){
                return $this->result;
        }else{
            $this->lastError = mysql_error($this->databaseLink);
            return false;
        }
		
    }


    // Adds a record to the database based on the array key names
    function Insert($vars, $table, $exclude = ''){

        // Catch Exclusions
        if($exclude == ''){
            $exclude = array();
        }

        array_push($exclude, 'MAX_FILE_SIZE'); // Automatically exclude this one

        // Prepare Variables
        $vars = $this->SecureData($vars);

        $query = "INSERT INTO `{$table}` SET ";
        foreach($vars as $key=>$value){
            if(in_array($key, $exclude)){
                continue;
            }
            //$query .= '`' . $key . '` = "' . $value . '", ';
            $query .= "`{$key}` = '{$value}', ";
        }

        $query = substr($query, 0, -2);

        return $this->ExecuteSQL($query);
    }

    // Deletes a record from the database
    function Delete($table, $where='', $limit='', $like=false){
        $query = "DELETE FROM `{$table}` WHERE ";
        if(is_array($where) && $where != ''){
            // Prepare Variables
            $where = $this->SecureData($where);

            foreach($where as $key=>$value){
                if($like){
                    //$query .= '`' . $key . '` LIKE "%' . $value . '%" AND ';
                    $query .= "`{$key}` LIKE '%{$value}%' AND ";
                }else{
                    //$query .= '`' . $key . '` = "' . $value . '" AND ';
                    $query .= "`{$key}` = '{$value}' AND ";
                }
            }

            $query = substr($query, 0, -5);
        }

        if($limit != ''){
            $query .= ' LIMIT ' . $limit;
        }

        return $this->ExecuteSQL($query);
    }


    // Gets a single row from $from where $where is true
    function Select($from, $where='', $orderBy='', $limit='', $like=false, $operand='AND',$cols='*'){
        // Catch Exceptions
        if(trim($from) == ''){
            return false;
        }

        $query = "SELECT {$cols} FROM `{$from}` WHERE ";

        if(is_array($where) && $where != ''){
            // Prepare Variables
            $where = $this->SecureData($where);

            foreach($where as $key=>$value){
                if($like){
                    //$query .= '`' . $key . '` LIKE "%' . $value . '%" ' . $operand . ' ';
                    $query .= "`{$key}` LIKE '%{$value}%' {$operand} ";
                }else{
                    //$query .= '`' . $key . '` = "' . $value . '" ' . $operand . ' ';
                    $query .= "`{$key}` = '{$value}' {$operand} ";
                }
            }

            $query = substr($query, 0, -(strlen($operand)+2));

        }else{
            $query = substr($query, 0, -7);
        }

        if($orderBy != ''){
            $query .= ' ORDER BY ' . $orderBy;
        }

        if($limit != ''){
            $query .= ' LIMIT ' . $limit;
        }

        return $this->ExecuteSQL($query);

    }

    // Updates a record in the database based on WHERE
    function Update($table, $set, $where, $exclude = ''){
        // Catch Exceptions
        if(trim($table) == '' || !is_array($set) || !is_array($where)){
            return false;
        }
        if($exclude == ''){
            $exclude = array();
        }

        array_push($exclude, 'MAX_FILE_SIZE'); // Automatically exclude this one

        $set 		= $this->SecureData($set);
        $where 	= $this->SecureData($where);

        // SET

        $query = "UPDATE `{$table}` SET ";

        foreach($set as $key=>$value){
            if(in_array($key, $exclude)){
                continue;
            }
            $query .= "`{$key}` = '{$value}', ";
        }

        $query = substr($query, 0, -2);

        // WHERE

        $query .= ' WHERE ';

        foreach($where as $key=>$value){
            $query .= "`{$key}` = '{$value}' AND ";
        }

        $query = substr($query, 0, -5);

        return $this->ExecuteSQL($query);
    }

    // 'Arrays' a single result
    function ArrayResult(){
        $this->arrayedResult = mysql_fetch_assoc($this->result) or die (mysql_error($this->databaseLink));
        return $this->arrayedResult;
    }

    // 'Arrays' multiple result
    function ArrayResults(){

        if($this->records == 1){
            return $this->ArrayResult();
        }
        $this->arrayedResult = array();
        while ($data = mysql_fetch_assoc($this->result)){
            $this->arrayedResult[] = $data;
        }
        return $this->arrayedResult;
    }

    // 'Arrays' multiple results with a key
    function ArrayResultsWithKey($key='id'){
        if(isset($this->arrayedResult)){
            unset($this->arrayedResult);
        }
        $this->arrayedResult = array();
        while($row = mysql_fetch_assoc($this->result)){
            foreach($row as $theKey => $theValue){
                $this->arrayedResult[$row[$key]][$theKey] = $theValue;
            }
        }
        return $this->arrayedResult;
    }

    // Returns last insert ID
    function LastInsertID(){
        return mysql_insert_id();
    }
    function ReturnData($result) { return mysql_fetch_assoc($result); }
    // Return number of rows
    function CountRows($from, $where=''){
        $result = $this->Select($from, $where, '', '', false, 'AND','count(*)');
        return $result["count(*)"];
    }

    function CheckId($table,$where='',$id){
        $result = $this->Select($table, $where, '', '', false, 'AND','count('.$id.')');
        return $result['count('.$id.')'];
    }

    // Closes the connections

}

?>