<?php
/**
 * DrupalAuthenticatorImpl.php
 *
 * @package MCImageManager.authenicators
 * @author Moxiecode
 * @copyright Copyright � 2005, Moxiecode Systems AB, All rights reserved.
 */

/**
 * This class is a RMplus authenticator implementation.
 *
 * @package MCImageManager.Authenticators
 */
class Moxiecode_RMplusAuthenticator extends Moxiecode_ManagerPlugin {
    /**#@+
	 * @access public
	 */
function Moxiecode_RMplusAuthenticator() {
	}
	

	function onAuthenticate(&$man) {
		$config =& $man->getConfig();

		include (MCMANAGER_ABSPATH."../../../../_support/class.db.php");
		include (MCMANAGER_ABSPATH."../../../../_support/class.logger.php");
		include (MCMANAGER_ABSPATH."../../../../_support/class.UserSession.php");
		include (MCMANAGER_ABSPATH."../../../../init.php");
		
		
			
		
		// Support both old and new format
		$loggedInKey = isset($config['SessionAuthenticator.logged_in_key']) ? $config['SessionAuthenticator.logged_in_key'] : $config["authenticator.session.logged_in_key"];
		$userKey = isset($config['SessionAuthenticator.user_key']) ? $config['SessionAuthenticator.user_key'] : $config["authenticator.session.user_key"];
		$pathKey = isset($config['SessionAuthenticator.path_key']) ? $config['SessionAuthenticator.path_key'] : $config["authenticator.session.path_key"];
		$rootPathKey = isset($config['SessionAuthenticator.rootpath_key']) ? $config['SessionAuthenticator.rootpath_key'] : $config["authenticator.session.rootpath_key"];
		$configPrefix = (isset($config['SessionAuthenticator.config_prefix']) ? $config['SessionAuthenticator.config_prefix'] : "mcmanager") . ".";

		// Switch path
		if (isset($_SESSION[$pathKey]))
			$config['filesystem.path'] = $_SESSION[$pathKey];

		print_r( $_SESSION);
		// Switch root
		if (isset($_SESSION['UserInfo'][$rootPathKey]))
		{
			$config['filesystem.rootpath'] = $_SESSION['UserInfo'][$rootPathKey];
			return $UserSession->IsLoggedIn();	
		}
		return false;

		$user = isset($_SESSION[$userKey]) ? $_SESSION[$userKey] : "";
		$user = preg_replace('/[\\\\\\/:]/i', '', $user);

		
		
		// Override by prefix
		foreach ($_SESSION as $key => $value) {
			if (strpos($key, $configPrefix) === 0)
				$config[substr($key, strlen($configPrefix))] = $value;
		}

		foreach ($config as $key => $value) {
			// Skip replaceing {$user} in true/false stuff
			if ($value === true || $value === false)
				continue;

			$value = str_replace('${user}', $user, $value);
			$config[$key] = $value;
		}

		// Force update of internal state
		$man->setConfig($config);
	
		return isset($_SESSION[$loggedInKey]) && checkBool($_SESSION[$loggedInKey]);
	}

	/**#@-*/
}

// Add plugin to MCManager
$man->registerPlugin("RMplusAuthenticator", new Moxiecode_RMplusAuthenticator());

?>