

	/*global Ext */
	Ext.reg('twintrigger', Ext.form.TwinTriggerField);
	Ext.ns('Ext.ux.layout');

	//some browsers do not support index of method
	if (!Array.prototype.indexOf)
	{
	  Array.prototype.indexOf = function(elt , from )
	  {
	    var len = this.length;

	    var from = Number(arguments[1]) || 0;
	    from = (from < 0)
	         ? Math.ceil(from)
	         : Math.floor(from);
	    if (from < 0)
	      from += len;

	    for (; from < len; from++)
	    {
	      if (from in this &&
	          this[from] === elt)
	        return from;
	    }
	    return -1;
	  };
	}
	
	
	Ext.override(Ext.TabPanel,{
		
		idDelimiter:'_!_'
	});
		
	//fixes the preloading of tree nodes, so that the childs are available pre-render
	Ext.tree.TreeLoader.override({
	    processResponse : function(response, node, callback){
	        var json = response.responseText;
	        try {
	            var o = eval("("+json+")");
	            node.beginUpdate();
	            for(var i = 0, len = o.length; i < len; i++){
	                var n = this.createNode(o[i]);
	                if(n){
	                    node.appendChild(n);
	                    if(this.preloadChildren){
	                        this.doPreload(n);
	                    }
	                }
	            }
	            node.endUpdate();
	            if(typeof callback == "function"){
	                callback(this, node);
	            }
	        }catch(e){
	            this.handleFailure(response);
	        }
	    }		
	});

	//Ext 3.1 bug : grid editor positions at the begining in IE
/*	Ext.override(Ext.Element, {
	    focus: function(defer,dom) {
	        var me = this,
	            dom = dom || me.dom;
	        try {
	            if (Number(defer)) {
	                me.focus.defer(defer, null, [null, dom]);
	            } else {
	                dom.focus();
	            }
	        } catch (e) { }
	        //begin override
	        if (document.selection) {
	            var range = document.selection.createRange();
	            if (dom && dom.value) { 
	             range.move('character', dom.value.length);
	             range.select();
	            }           
	        }
	        //end override
	        return me;
	    }
	});*/
	
	//override text of grid filters!
	Ext.ux.grid.GridFilters.override({
		menuFilterText :'Find'
	});
	
	
	//fixes a bug that disables multiselect with checkboxes in a grid when dragdrop is enabled!!!
	Ext.grid.GridDragZone.override({
	    handleMouseDown: function(e, t)
	    {
	        if(t.className == 'x-grid3-row-checker')
	            return false;
	        Ext.grid.GridDragZone.superclass.handleMouseDown.apply(this, arguments);
	    }
	});
	
    //the class needed for exporting and sending files from server

	Ext.override(Ext.form.FormPanel, {

	    beforeDestroy : function(){
	        this.stopMonitoring();
	        Ext.FormPanel.superclass.beforeDestroy.call(this);
	        /*
	         * Clear the items here to prevent them being destroyed again.
	         * Don't move this behaviour to BasicForm because it can be used
	         * on it's own.
	         */
	        this.form.items.clear();
	        Ext.destroy(this.form);
	    }

	});
	//hiding sort menus if sorting is disabled
	Ext.override(Ext.grid.GridView, {
		handleHdDown : function(e, target) {
        if (Ext.fly(target).hasClass('x-grid3-hd-btn')) {
            e.stopEvent();
            
            var colModel  = this.cm,
                header    = this.findHeaderCell(target),
                index     = this.getCellIndex(header),
                sortable  = colModel.isSortable(index),
                menu      = this.hmenu,
                menuItems = menu.items,
                menuCls   = this.headerMenuOpenCls;
            
            this.hdCtxIndex = index;
            
            Ext.fly(header).addClass(menuCls);
            menuItems.get('asc').setVisible(sortable);
            menuItems.get('desc').setVisible(sortable);
            
            menu.on('hide', function() {
                Ext.fly(header).removeClass(menuCls);
            }, this, {single:true});
            
            menu.show(target, 'tl-bl?');
        }
    }
	});
	
	//function for renderes which use comboboxes as editors
	var comboToRenderer = function(combo,noSelValue) 
	{ return function(value) {
		var idx = combo.store.find(combo.valueField, value);
		if(idx==-1)	return noSelValue ? noSelValue : value;
		var rec = combo.store.getAt(idx);
		return rec.get(combo.displayField);}
		;
	} 
	
	
	
	
	//global function for stripping HTML tags from a string!
	function stripHTML(str){
		var re = /(<([^>]+)>)/gi;
		return str.replace(re, "");
		}

	//an override of the return value of the checkbox from true/false to 1/0...hope this doesn't mess up anything!!!
	Ext.override(Ext.form.Checkbox,{
		getValue : function(){
	        if(this.rendered){
	            return this.el.dom.checked ? 1:0 ;
	        }
	        return this.checked ? 1:0 ;
	    		}
		} );
	//adding "fix" for treegrid, so that it doesn't throw an error on check box!!!
	//DELETE if treegrid adds suport for checkboxes!!!
	Ext.override( Ext.ux.tree.TreeGridNodeUI,{
		onCheckChange :  function(){
			       
				}
	});
	//an override of the basic tree drop behavoir!
	//droping now couses the node to be added on the first place instead of last!
	Ext.override(Ext.tree.TreeDropZone, {

			completeDrop : function(de){
	        var ns = de.dropNode, p = de.point, t = de.target;
	        if(!Ext.isArray(ns)){
	            ns = [ns];
	        }
	        var n;
	        for(var i = 0, len = ns.length; i < len; i++){
	            n = ns[i];
	            if(p == "above"){
	                t.parentNode.insertBefore(n, t);
	            }else if(p == "below"){
	                t.parentNode.insertBefore(n, t.nextSibling);
	            }else{
	                //t.appendChild(n);
	                //we change that, so that the tree inserts the node on the first place
	                t.insertBefore(n,t.firstChild);
	            }
	        }
	        n.ui.focus();
	        if(Ext.enableFx && this.tree.hlDrop){
	            n.ui.highlight();
	        }
	        t.ui.endDrop();
	        this.tree.fireEvent("nodedrop", de);
	    }

	});
   //!!!!!!!!!!!!!!!!! CUSTOM ALLROUND FUNCTION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	  //adds a style class
    function setClassStyle( css ) {
  	  var style_sheet = document.createElement('style');
  	  if (style_sheet) {
  	    style_sheet.setAttribute('type', 'text/css');
  	    var cstr =  css;
  	    var rules = document.createTextNode(cstr);
  	    if(style_sheet.styleSheet){// IE
  	      style_sheet.styleSheet.cssText = rules.nodeValue;
  	    } else {
  	      style_sheet.appendChild(rules);
  	    }
  	    var head = document.getElementsByTagName('head')[0];
  	    if (head) {
  	      head.appendChild(style_sheet);
  	    }
  	  }
  };
  	//add a style class file
  
  function setClassCss( file ) {
  	  var style_sheet = document.createElement('link');
  	  if (style_sheet) {
  	    style_sheet.setAttribute('href', file);
  	  	style_sheet.setAttribute('type', 'text/css');
  		style_sheet.setAttribute('rel', 'stylesheet');	
    	  
  	    var head = document.getElementsByTagName('head')[0];
  	    if (head) {
  	      head.appendChild(style_sheet);
  	    }
  	  }
  }; 
  
  //functions to get and set the position of a textinput!
	function setCaretPosition(elemId, caretPos) {
	    var elem = document.getElementById(elemId);

	    if(elem != null) {
	        if(elem.createTextRange) {
	            var range = elem.createTextRange();
	            range.move('character', caretPos);
	            range.select();
	        }
	        else {
	            if(elem.selectionStart) {
	                elem.focus();
	                elem.setSelectionRange(caretPos, caretPos);
	            }
	            else
	                elem.focus();
	        }
	    }
	};
	
	
	
	function getCaretPosition (elemId) {
		 var ctrl = document.getElementById(elemId);
		var CaretPos = 0;	// IE Support
		if (document.selection) {
		ctrl.focus ();
			var Sel = document.selection.createRange ();
			Sel.moveStart ('character', -ctrl.value.length);
			CaretPos = Sel.text.length;
		}
		// Firefox support
		else if (ctrl.selectionStart || ctrl.selectionStart == '0')
			CaretPos = ctrl.selectionStart;
		return (CaretPos);
	}

	//converts an answers/legend string to an data array 
	function slashDelimitedToArray(text)
	{
	//	text = text.replace("/","<*>");
	//	text = text.replace("<<+>","</");
		
		var ans = text.split('<*>');
		if(ans[0] == '' )
		{
			return [];
		}
		var arr = new Array();
		Ext.each(ans, function(fld)
			{
				var tmp = fld.split(' ');
				arr.push([tmp[0],tmp.slice(1).join(' ') ]);	
			} 
		);
		return arr;
	}
	
	Ext.Msg.RMconfirm = function(options)
	{
		if(!options) options = {};
		var opt = {};
		opt.title = options.title || "Warning";
		opt.buttons = options.buttons || Ext.Msg.YESNO;
		opt.msg = options.msg || 'Are you sure?';
		opt.fn = options.fn;
		this.show(opt);
	};
	
	function RMajax(config){
		config = config || {};
		this.url = config.url;
		this.baseParams = config.params;
		if(config.success)
			this.success = config.success.createDelegate(config.scope || this);
		else
			this.success = Ext.emptyFn;
		
		this.request = function(config){
			config = config || {};
			
			if(config.success)
				var suc = config.success.createDelegate(config.scope || this);
			else
				var suc = this.success;
			
			//var suc = config.success || this.success;
			
			var p = {};
			p = Ext.apply(p,this.baseParams);	
			p = Ext.apply(p,config.params);
			document.body.style.cursor = "wait";
			Ext.Ajax.request({
				
				url: config.url || this.url,
				params: p,
				success:function(resp,opt){
				document.body.style.cursor = "default";
					//here we can add some of our stuff
					//console.log('yeahh');
					var rsp = Ext.decode(resp.responseText )
					if(rsp.success === false)
					{
						if(rsp.error == 'sessionTimeout')
						{
							//alert('session timeout');
							//let's open the login window!
							//here we cannot undo the the action the user has pimarly done
							CallScript( '_forms/window.sessionTimeout.php',{})
						}
					}
					suc(resp,opt);
				}
			});
		};
	}
	
	   //a validator for questions
	Ext.form.VTypes["questionNameVal"] = /^[a-zA-Z][a-zA-Z0-9]{0,14}$/;
	Ext.form.VTypes["questionNameMask"] = /[a-zA-Z0-9]/;
	Ext.form.VTypes["questionNameText"] = 'Invalid name!';
	Ext.form.VTypes["questionName"] = function(v)
	{
		reservedWords = ['accessible', 'add', 'all', 'alter', 'analyze', 'and', 'as', 'asc', 'asensitive', 'before', 'between', 'bigint', 'binary', 'blob', 'both', 'by', 'call', 'cascade', 'case', 'change', 'char', 'character', 'check', 'collate', 'column', 'condition', 'connection', 'constraint', 'continue', 'convert', 'create', 'cross', 'current_date', 'current_time', 'current_timestamp', 'current_user', 'cursor', 'database', 'databases', 'day_hour', 'day_microsecond', 'day_minute', 'day_second', 'dec', 'decimal', 'declare', 'default', 'delayed', 'delete', 'desc', 'describe', 'deterministic', 'distinct', 'distinctrow', 'div', 'double', 'drop', 'dual', 'each', 'else', 'elseif', 'enclosed', 'escaped', 'exists', 'exit', 'explain', 'false', 'fetch', 'float', 'float4', 'float8', 'for', 'force', 'foreign', 'from', 'fulltext', 'goto', 'grant', 'group', 'having', 'high_priority', 'hour_microsecond', 'hour_minute', 'hour_second', 'if', 'ignore', 'in', 'index', 'infile', 'inner', 'inout', 'insensitive', 'insert', 'int', 'int1', 'int2', 'int3', 'int4', 'int8', 'integer', 'interval', 'into', 'is', 'iterate', 'join', 'key', 'keys', 'kill', 'label', 'leading', 'leave', 'left', 'like', 'limit', 'linear', 'lines', 'load', 'localtime', 'localtimestamp', 'lock', 'long', 'longblob', 'longtext', 'loop', 'low_priority', 'master_ssl_verify_server_cert', 'match', 'mediumblob', 'mediumint', 'mediumtext', 'middleint', 'minute_microsecond', 'minute_second', 'mod', 'modifies', 'natural', 'no_write_to_binlog', 'not', 'null', 'numeric', 'on', 'optimize', 'option', 'optionally', 'or', 'order', 'out', 'outer', 'outfile', 'precision', 'primary', 'procedure', 'purge', 'range', 'read', 'read_only', 'read_write', 'reads', 'real', 'references', 'regexp', 'release', 'rename', 'repeat', 'replace', 'require', 'reserved', 'restrict', 'return', 'revoke', 'right', 'rlike', 'schema', 'schemas', 'second_microsecond', 'select', 'sensitive', 'separator', 'set', 'show', 'smallint', 'spatial', 'specific', 'sql', 'sql_big_result', 'sql_calc_found_rows', 'sql_small_result', 'sqlexception', 'sqlstate', 'sqlwarning', 'ssl', 'starting', 'straight_join', 'table', 'terminated', 'then', 'tinyblob', 'tinyint', 'tinytext', 'to', 'trailing', 'trigger', 'true', 'undo', 'union', 'unique', 'unlock', 'unsigned', 'update', 'upgrade', 'usage', 'use', 'using', 'utc_date', 'utc_time', 'utc_timestamp', 'values', 'varbinary', 'varchar', 'varcharacter', 'varying', 'when', 'where', 'while', 'with', 'write', 'xor', 'year_month', 'zerofill', '__class__', '__compiler_halt_offset__', '__dir__', '__file__', '__function__', '__method__', '__namespace__', 'abday_1', 'abday_2', 'abday_3', 'abday_4', 'abday_5', 'abday_6', 'abday_7', 'abmon_1', 'abmon_10', 'abmon_11', 'abmon_12', 'abmon_2', 'abmon_3', 'abmon_4', 'abmon_5', 'abmon_6', 'abmon_7', 'abmon_8', 'abmon_9', 'abstract', 'alt_digits', 'am_str', 'array', 'assert_active', 'assert_bail', 'assert_callback', 'assert_quiet_eval', 'assert_warning', 'break', 'case_lower', 'case_upper', 'catch', 'cfunction', 'char_max', 'class', 'clone', 'codeset', 'connection_aborted', 'connection_normal', 'connection_timeout', 'const', 'count_normal', 'count_recursive', 'credits_all', 'credits_docs', 'credits_fullpage', 'credits_general', 'credits_group', 'credits_modules', 'credits_qa', 'credits_sapi', 'crncystr', 'crypt_blowfish', 'crypt_ext_des', 'crypt_md5', 'crypt_salt_length', 'crypt_std_des', 'currency_symbol', 'd_fmt', 'd_t_fmt', 'day_1', 'day_2', 'day_3', 'day_4', 'day_5', 'day_6', 'day_7', 'decimal_point', 'default_include_path', 'die', 'directory_separator', 'do', 'e_all', 'e_compile_error', 'e_compile_warning', 'e_core_error', 'e_core_warning', 'e_deprecated', 'e_error', 'e_notice', 'e_parse', 'e_strict', 'e_user_deprecated', 'e_user_error', 'e_user_notice', 'e_user_warning', 'e_warning', 'echo', 'empty', 'enddeclare', 'endfor', 'endforeach', 'endif', 'endswitch', 'endwhile', 'ent_compat', 'ent_noquotes', 'ent_quotes', 'era', 'era_d_fmt', 'era_d_t_fmt', 'era_t_fmt', 'era_year', 'eval', 'extends', 'extr_if_exists', 'extr_overwrite', 'extr_prefix_all', 'extr_prefix_if_exists', 'extr_prefix_invalid', 'extr_prefix_same', 'extr_skip', 'final', 'foreach', 'frac_digits', 'function', 'global', 'grouping', 'html_entities', 'html_specialchars', 'implements', 'include', 'include_once', 'info_all', 'info_configuration', 'info_credits', 'info_environment', 'info_general', 'info_license', 'info_modules', 'info_variables', 'ini_all', 'ini_perdir', 'ini_system', 'ini_user', 'instanceof', 'int_curr_symbol', 'int_frac_digits', 'interface', 'isset', 'lc_all', 'lc_collate', 'lc_ctype', 'lc_messages', 'lc_monetary', 'lc_numeric', 'lc_time', 'list', 'lock_ex', 'lock_nb', 'lock_sh', 'lock_un', 'log_alert', 'log_auth', 'log_authpriv', 'log_cons', 'log_crit', 'log_cron', 'log_daemon', 'log_debug', 'log_emerg', 'log_err', 'log_info', 'log_kern', 'log_local0', 'log_local1', 'log_local2', 'log_local3', 'log_local4', 'log_local5', 'log_local6', 'log_local7', 'log_lpr', 'log_mail', 'log_ndelay', 'log_news', 'log_notice', 'log_nowait', 'log_odelay', 'log_perror', 'log_pid', 'log_syslog', 'log_user', 'log_uucp', 'log_warning', 'm_1_pi', 'm_2_pi', 'm_2_sqrtpi', 'm_e', 'm_ln10', 'm_ln2', 'm_log10e', 'm_log2e', 'm_pi', 'm_pi_2', 'm_pi_4', 'm_sqrt1_2', 'm_sqrt2', 'mon_1', 'mon_10', 'mon_11', 'mon_12', 'mon_2', 'mon_3', 'mon_4', 'mon_5', 'mon_6', 'mon_7', 'mon_8', 'mon_9', 'mon_decimal_point', 'mon_grouping', 'mon_thousands_sep', 'n_cs_precedes', 'n_sep_by_space', 'n_sign_posn', 'namespace', 'negative_sign', 'new', 'noexpr', 'nostr', 'old_function', 'p_cs_precedes', 'p_sep_by_space', 'p_sign_posn', 'path_separator', 'pathinfo_basename', 'pathinfo_dirname', 'pathinfo_extension', 'pear_extension_dir', 'pear_install_dir', 'php_bindir', 'php_config_file_path', 'php_config_file_scan_dir', 'php_datadir', 'php_debug', 'php_eol', 'php_extension_dir', 'php_extra_version', 'php_int_max', 'php_int_size', 'php_libdir', 'php_localstatedir', 'php_major_version', 'php_maxpathlen', 'php_minor_version', 'php_os', 'php_output_handler_cont', 'php_output_handler_end', 'php_output_handler_start', 'php_prefix', 'php_release_version', 'php_sapi', 'php_shlib_suffix', 'php_sysconfdir', 'php_version', 'php_version_id', 'php_windows_nt_domain_controller', 'php_windows_nt_server', 'php_windows_nt_workstation', 'php_windows_version_build', 'php_windows_version_major', 'php_windows_version_minor', 'php_windows_version_platform', 'php_windows_version_producttype', 'php_windows_version_sp_major', 'php_windows_version_sp_minor', 'php_windows_version_suitemask', 'php_zts', 'pm_str', 'positive_sign', 'print', 'private', 'protected', 'public', 'radixchar', 'require_once', 'seek_cur', 'seek_end', 'seek_set', 'sort_asc', 'sort_desc', 'sort_numeric', 'sort_regular', 'sort_string', 'static', 'str_pad_both', 'str_pad_left', 'str_pad_right', 'switch', 't_fmt', 't_fmt_ampm', 'thousands_sep', 'thousep', 'throw', 'try', 'unset', 'var', 'yesexpr', 'yesstr'];
		return Ext.form.VTypes["questionNameVal"].test(v) && reservedWords.indexOf(v) == -1; 
	};
    
	   //a validator for projects and fields
	Ext.form.VTypes["fieldNameVal"] = /^[a-zA-Z][a-zA-Z0-9_]{1,35}$/;
	Ext.form.VTypes["fieldNameMask"] = /[a-zA-Z0-9_]/;
	Ext.form.VTypes["fieldNameText"] = 'Invalid name!';
	Ext.form.VTypes["fieldName"] = function(v){return Ext.form.VTypes["fieldNameVal"].test(v); };
    
	//validator for password checking
	Ext.apply(Ext.form.VTypes, {
		   password: function(value, field)
		   {
		      if (field.initialPasswordField)
		      {
		         var pwd = Ext.getCmp(field.initialPasswordField);
		         this.passwordText = 'Confirmation does not match your intial password entry.';
		         return (value == pwd.getValue());
		      }
		 
		      this.passwordText = 'Passwords must be at least 5 characters';
		 
		      var hasLength = (value.length >= 5);
		 
		      return (hasLength);
		   },
		 
		   passwordText: 'Passwords must be at least 5 characters'
		});
	
	
	 Ext.ux.Report = Ext.extend(Ext.Component, {
	        autoEl: {tag: 'iframe', cls: 'x-hidden', src: Ext.SSL_SECURE_URL},
	        load: function(config){
	        	this.getEl().dom.method = 'POST';
	            this.getEl().dom.src = config.url + (config.params ? '?' + Ext.urlEncode(config.params) : '');
	        //	this.getEl().dom.load({url:config.url,params:config.params});
	        }
	    });
	    Ext.reg('ux.report', Ext.ux.Report);

	    report = new Ext.ux.Report({
	    	  renderTo: Ext.getBody()
	    	});

	Ext.ns('Ext.util.FileOps');

	    	
	 Ext.util.FileOps.downloadFile = function(url,params, completedCallback) {
    // create hidden target iframe
    var id = 'RM_file_download_frame';    
    var frame = Ext.get(id);
    if(!frame)
    {
	    frame=document.createElement('iframe');
	    frame.id = id;
	    frame.name = id;
	    frame.className = 'x-hidden';
	    if(Ext.isIE) {
	        frame.src = Ext.SSL_SECURE_URL;
	    }
	
	    document.body.appendChild(frame);
    }
    if(Ext.isIE) {
        document.frames[id].name = id;
    }

    var form = Ext.DomHelper.append(document.body, {
        tag:'form',
        method:'post',
        action:url,
        target:id
    });

    document.body.appendChild(form);

    var callback = function(e) {

       // debugger;
        var rstatus = Ext.isIE ? this.readyState : e.type;
        
        switch(rstatus){
             case 'interactive': //IE 
            case 'loading':  //IE  has several readystate transitions, ignore these
              break;
                      
            case 'complete': //IE readyState == done
            case 'load': //Gecko, Opera, others == done
              
                var fnCleanup = function(){
                    if(Ext.isIE){
                       this.src = "javascript:false"; //cleanup
                   }
                   
                //   Ext.fly(this).remove();  //kill frame
                //   Ext.fly(form).remove(); //kill form
                 };
                   
                 if (completedCallback && typeof(completedCallback) === "function") {
                     // Call callback function if specified
                     Ext.callback(completedCallback, null, [this]); 
                     //you should pass the frame (or body.innerHTML) so the callee 
                     //gets a chance at the content before destruction
                 }
              
               // 'this' refers to the frame object, ie. the dom object not the Ext element
               fnCleanup.defer(200, this);
               break;
           
            default:
            break;
          }
    };
                
    frame[ Ext.isIE?'onreadystatechange':'onload'] = callback.createDelegate(frame);
    for (var i in params){
 
	   
	    var input = document.createElement("INPUT");
	    form.appendChild(input);
	    input.setAttribute('name',i);
	    input.setAttribute('value',params[i]);
    }
    form.submit({params:params});
    Ext.fly(form).remove(); //kill form
};

//function that opens a window for relogin if session timeout expires!!!
function sessionTimeoutLogin( username )
{
		if(Ext.getCmp('sessionTimeoutWindow' ))
		{
				var loginForm = new Ext.FormPanel({
				      
				        width: 350,
				        frame: false,
				        autoHeight: true,
				        padding: '10',
				        labelWidth: 100,
				        defaults: {
				            anchor: '95%',
				            allowBlank: false
				        },
				        items: [
				        	{xtype:'textfield',name:'pass',
				        	 fieldLabel:'Password',
				        	 inputType:'password'
				        	  }
				        ],
				        buttons: [{
				            text: 'Login',
				            handler: function(){
				            		Ext.Ajax.request({
											   url: '_ajaxManipulators/ajax.Login.php',
											   
											   success: function ( result, request ) {
											   		
											   		if(result.responseText=='true')
											   		{
												   		 win1.close();
											   		} else  {
											   				//Ext.MessageBox.ERROR('Login', 'Login Failed.')
											   				//Ext.Msg.alert('Login', 'Login Failed.');
											   				Ext.MessageBox.show({
															//	title:'Login Error',
															closable: true,
															//msg: 'testiranje',
															msg: '<div class=\'login_failed\'>Login Failed</div>',
															//msg: 'Login Failed fdsf  dfsfdsf sew rwe fds dsg ert ergf dg re tgert fg',
															icon: 'login_settings',
															//cls: 'caca',
															buttons: Ext.Msg.OK,
															width: 300
														});
	
											   		}
											   			
											   	},
											   params: { 
													   action:'login',
													   user: username ,
													   pass: loginForm.getForm().findField('pass').getValue()
													    }
											 
											});
				            }
				        },{
				            text: 'Cancel',
				            handler: function(){
				                 win1.close();
				            }
				        }]
				    });
	
	
					var win1 = new Ext.Window({
						id:'sessionTimeoutWindow',
						width:365,
				       modal:true,
				 		title: 'Session Timeout' ,
				        closeAction:'close',
				        plain: true,
						items: loginForm
	
				    }).show();
	
		}    
	

}

function RMrandomString(strLen) {
	var chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
	var string_length = strLen ? strLen : 6;
	var randomstring = '';
	for (var i=0; i<string_length; i++) {
		var rnum = Math.floor(Math.random() * chars.length);
		randomstring += chars.substring(rnum,rnum+1);
	}
	return randomstring;
};
    
Ext.override(Ext.ux.grid.GridFilters,{
	 getFilterData : function () {
    var filters = [], i, len;

    this.filters.each(function (f) {
        if (f.active) {
            var d = [].concat(f.serialize());
            d[0].RMtable = f.RMtable;
            if(f.convertNull)
            	d[0].convertNull = true;
            for (i = 0, len = d.length; i < len; i++) {
                filters.push({
                    field: f.dataIndex,
                    data: d[i]
                });
            }
        }
    });
    return filters;
}
})
