<?php
use \Curl\Curl;

class UploadLogObserver extends AbstractObserver
{
    public function __construct(\DataContainers\ActionData $actionData, \DataContainers\CurrentVersion $versions)
    {
        $this->actionData = $actionData;
        $this->versions = $versions;
    }

    public function update($data, $faild = null)
    {

        if($faild)
          $this->uploadLog(print_r($data, true));

        return true;
    }

    public function uploadLog($logData)
    {
      $curl = new Curl();

      $curl->setDefaultJsonDecoder();
      $curl->success([$this, "success"]);
      $curl->error([$this, "error"]);

      $curl->setOpt(CURLOPT_SSL_VERIFYHOST, config('ssl_verify'));
      $curl->setOpt(CURLOPT_SSL_VERIFYPEER, config('ssl_verify'));

      $data = [];
      $data['action'] = 'end';
      $data['end_version'] = $this->versions->getVersion();
      $data['id_log'] = $this->actionData->getLogId();
      $data['update_log'] = $logData;

      $curl->post(config('checkConnectionUrl'), $data);
    }
}

 ?>
