<?php

class LiveUpdate
{
  private $actionDataInstance;

  public function __construct(\DataContainers\CurrentVersion $versions, \DataContainers\CurrentProject $projects)
  {
      $this->versions = $versions;
      $this->projects = $projects;
  }

  public function setActionData(\DataContainers\ActionData $ac)
  {
      $this->actionDataInstance = $ac;
  }

  public function run()
  {
    $this->executeSteps($this->beforeDownload);

    while($this->versions->hasNext())
    {
        $this->executeSteps($this->downloadSteps);
        $this->versions->saveVersion($this->versions->current('version'));
        $this->actionDataInstance->clean();
    }

    $this->executeSteps($this->beforeUploadSteps);

    while($this->projects->hasNext())
    {
        $this->executeSteps($this->uploadSteps);
        $this->actionDataInstance->cleanUploaded();
    }

    $this->executeSteps($this->afterUploadSteps);

  }

  public function beforeDownloadEvent(\Steps\AbstractStep $step)
  {
      $this->beforeDownload[] = $step;
  }

  public function downloadEvent(\Steps\AbstractStep $step)
  {
      $this->downloadSteps[]= $step;
  }

  public function uploadEvent(\Steps\AbstractStep $step)
  {
      $this->uploadSteps[] = $step;
  }

  public function afterUploadEvent(\Steps\AbstractStep $step)
  {
    $this->afterUploadSteps[] = $step;
  }

  public function beforeUploadEvent(\Steps\AbstractStep $step)
  {
    $this->beforeUploadSteps[] = $step;
  }

  public function executeSteps(array $steps)
  {
    foreach($steps as $step)
    {
      $step->execute();
    }
  }
}
