<?php

namespace Steps;

use \ActionData;
use \db;

class UpdateLocalRecords extends AbstractStep
{
    private $db;

    private $actionData;

    public function __construct(\DataContainers\ActionData $actionData, db $db)
    {
          $this->db = $db;
          $this->actionData = $actionData;

    }

    public function execute()
    {
          $uploadedRecords = $this->actionData->getUploaded();
    //      $this->actionData->cleanUploaded();

          foreach ($uploadedRecords as $tableName => $data)
          {
            if(!count($data['uploaded'])) continue;
            $sql = "UPDATE ".$tableName." SET flag_cli = 1 WHERE id IN (" . implode(',', $data['uploaded']) .")";

            try
            {
                $this->db->SQLexecute($sql);
              //  $server->addUpdatedIds($datab, $ids);
              $this->clientStatus->markAsUploaded(array(
                  'tableName' => $tableName,
                  'forUpload' => $data['forUpload'],
                  'uploaded' => $data['uploaded']
                )
              );
            } catch (Exception $e)
            {
              $this->clientStatus->notMarkedAsUploaded(array(
                'tableName' => $tableName,
                'forUpload' => $data['forUpload'],
                'uploaded' => $data['uploaded']
              )
            );

            }

          }
    }

}
