<?php
namespace Steps;

use \ActionData;

class ExtractZip extends AbstractStep
{
  public function execute($data = null)
  {

    $version = $this->versions->current('version');
    $fileName = "version_" . $version . ".zip";

    $localPath =  config('localContainer'). $fileName;

    $extractTo = config('localContainer').$version. '/';
    $this->clientStatus->startExtract();
    $zip = new \ZipArchive();

    $res = $zip->open($localPath);

    $data['localPath'] = $localPath;
    $data['extractTo'] = $extractTo;

    if($res === TRUE)
    {
      $zip->extractTo($extractTo);
      $zip->close();

      $xmlFile = $extractTo;
      $xmlFile .= config('actionFileName');

      if(file_exists($xmlFile))
      {

        $this->clientStatus->zipFileExtractionSuccess($data);
      }
      else
      {
         $data['fileExists'] = false;
         $this->clientStatus->zipFileExtractionFaild($data);
      }
    }
    else
    {
        $data['localPath'] = $localPath;
        $data['extractTo'] = $extractTo;
        $this->clientStatus->zipFileExtractionFaild($data);
    }

  }
}
