<?php
namespace Steps;

class CleanTmpFiles extends AbstractStep
{

  public function execute()
  {
    $version = $this->versions->current('version');
    $fileName = "version_" . $version . ".zip";

    $localPath =  config('localContainer');

    /*
     We delete all files that are smaller or equal then current version. We don't want to delete
     half downloaded files buecause someon can continue with download
    */

    foreach (scandir($localPath) as $file)
    {
        if($file == '.' || $file == '..') continue;

        $fullName = $localPath . $file;
        if(is_dir($fullName))
          $this->deleteDirectory($fullName);
        else
        {
          $fileVersion = explode('_', basename($fullName, '.zip'));
          $fileVersion = $fileVersion[1];

          if($fileVersion <= $version)
            unlink($fullName);
        }
    }
  }

  private function deleteDirectory($dir)
  {
    if (!file_exists($dir)) {
        return true;
    }

    if (!is_dir($dir)) {
        return unlink($dir);
    }

    foreach (scandir($dir) as $item) {
        if ($item == '.' || $item == '..') {
            continue;
        }

        if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
            return false;
        }

    }
    return rmdir($dir);
}
}

 ?>
