<?php

//TODO dependeny injection for error reports

namespace DataContainers;

class ClientUpdateStatus extends \AbstractSubject
{

		private $updateFaild = false;

	 private $statusList = array();


	 public function addEntry($type, $data = null)
	 {
		 if(is_array($type))
		 {
			 	$this->statusList[] = $type;
		 }
		 else
		 {
			 $this->statusList[] = array(
				 'entryType' => $type,
				 'data' => $data
			 );
		 }

		 $this->notify();
	 }

   public function versionsDownloaded($data)
   {
		 		/*if(count($data['versionsToDownload']) <= 0)
				{
						//$this->setFaild();
				}*/
				$this->addEntry('versionsDownloaded', $data);
   }

   public function versionsDownloadError($data)
   {
		 	$this->setFaild();
			$this->addEntry('versionsDownloadError', $data);
   }

	 public function zipFileDownloadStarted($data)
	 {
		 	$this->addEntry('zipFileDownloadStarted', $data);
	 }

	 public function updateProgressbar($data)
	 {
		 	$this->addEntry('updateProgressbar', $data);
	 }

	 public function downloadZipFaild($data)
	 {
		 $this->setFaild();
		 $this->addEntry('downloadZipFaild', $data);

	 }

	 public function wrongChecksum($data)
	 {
		 $this->setFaild();
		 $this->addEntry('wrongChecksum', $data);
	 }

	 public function zipFileDownloadSucces($data)
	 {
		 	$this->addEntry('downloadZipSuccess', $data);
	 }

	 public function zipFileExtractionSuccess($data)
	 {
		 $this->addEntry('extractZipSuccess', $data);
	 }

	 public function zipFileExtractionFaild($data)
	 {
		 $this->setFaild();
		 $this->addEntry('extractZipFaild', $data);
	 }

	 public function xmlParseFaild($data)
	 {
		 	$this->addEntry('xmlParseFaild', $data);
			$this->setFaild();
	 }

	 public function xmlParseSuccess($data)
	 {
		 	$this->addEntry('xmlParseSuccess', $data);
	 }

	 public function filesCopied($data)
	 {
		 	$this->addEntry('filesCopied', $data);
	 }

	 public function faildToCopyFiles($data)
	 {
		 	$this->addEntry('filesFaildToCopy', $data);
			$this->setFaild();
	 }

	 public function executedSQL($sql)
	 {
		 	$this->addEntry('executedSQL',$sql);
	 }

	 public function faildToExecuteSQL($data)
	 {
		  $this->setFaild();
		 	$this->addEntry('faildToExecuteSQL', $data);
	 }

	 public function succExecutedSqls($data)
	 {
		 	$this->addEntry('allSqlsDone', $data);
	 }

	 public function scriptWrongExstension($data)
	 {
		 		$this->setFaild();
				$this->addEntry('scriptWrongExstension', $data);
	 }

	 public function scriptNotValid($data)
	 {
		 		$this->setFaild();
				$this->addEntry('scriptNotValid', $data);

	 }

	 public function scriptNotFound($data)
	 {
		 	$this->setFaild();
			$this->addEntry('scriptWrongNotFound', $data);
	 }

	 public function faildToExecuteScript()
	 {
		 	$this->setFaild();
			$this->addEntry('scriptExeFaild', $data);
	 }

	 public function scriptSuccesfullyExecuted($data)
	 {
		 	$this->addEntry('scriptExeSucc', $data);
	 }

	 public function addExcutedScript($data)
	 {
		 	$this->addEntry('executedScript', $data);
	 }

	 public function temporaryFolderFail($data)
	 {
		 	$this->setFaild();
		 	$this->addEntry("noTemporaryFolder", $data);
	 }

	 public function downloadProcessStarted()
	 {
		 	$this->addEntry('downloadProcStart');
	 }

	 public function majorVersion()
	{
		 $this->setFaild();
		 $this->addEntry('majorVersion');
	}


	 // UPLOAD

	 public function uploadStarted()
	 {
		 	$this->addEntry('uploadStarted');
	 }

	 public function uploadDisabled()
	 {
		 	$this->setFaild();
		 	$this->addEntry('uploadDisabled');
	 }

	 public function addRecord($data)
	 {
		 	$this->addEntry('addRecord', $data);
	 }

	 public function addProjectName($data)
	 {
		 	$this->addEntry('uploadProjectName', $data);
	 }

	 public function dataExists($data)
	 {
		 	$this->addEntry('dataExists', $data);
	 }

	 public function dataAboutVisits($data)
	 {
		 	$this->addEntry('visitsData', $data);
	 }

	 public function reportMissingTable($data)
	 {
		 	//$this->setFaild();
		 	$this->addEntry('missingTable', $data);
	 }

	 public function startExtract($data)
	 {
			$this->addEntry('startExtract', $data);
	 }

	 /*public function doneExtracting($data)
	 {
		 $this->addEntry('startExtract', $data);
	 }*/

	 public function sqlExecuting($data)
	 {
		 $this->addEntry('sqlExecuting', $data);
	 }

	 public function xmlReading($data)
	 {
		 		$this->addEntry('xmlReading', $data);
	 }

	 public function copyingFiles($data)
	 {
		 		$this->addEntry('copyingFiles', $data);
	 }



	 public function markAsUploaded($data)
	 {
		 	$this->addEntry('markUploaded', $data);
	 }

	 public function notMarkedAsUploaded($data)
	 {
		 	$this->setFaild();
		 	$this->addEntry('notMarkedUploaded', $data);
	 }

	 public function clientNoPendingData($data)
	 {
			$this->addEntry('clientNoPendingData', $data);
	 }

	 public function badInternetShow($data)
	 {
		 	$this->addEntry('badInternetShow', $data);
	 }

	 public function badInternetHide($data)
	 {
		 $this->addEntry('badInternetHide', $data);
	 }

	 public function isFaild()
	 {
		 		return $this->updateFaild;
	 }

	 public function setFaild()
	 {
		 		$this->updateFaild = true;
	 }

	 public function cantConnect($data)
	 {
		 	$this->setFaild();
			$this->addEntry('cantConnect', $data);
	 }

	 public function errorOnServer($data)
	 {
		 $this->setFaild();
		 $this->addEntry('errorOnServer', $data);
	 }

	 public function unknowError($data)
	 {
		 $this->setFaild();
		 $this->addEntry('unknowError', $data);
	 }

	 public function recordsUploaded($data)
	 {
		 	$this->addEntry('recordsUploaded', $data);
	 }

	 public function visitsUploaded($data)
	 {
		 	$this->addEntry('vsitsUploaded', $data);
	 }

	 public function uploadErrorOnServer($data)
	 {
		 	$this->addEntry('uploadServerError', $data);
	 }

	 public function noCurl()
	 {
		 	$this->setFaild();
			$this->addEntry('noCurl');
	 }

	 public function wrongUserType()
	 {
		 	$this->setFaild();
			$this->addEntry('wrongUserType');
	 }

	 public function noInternetConnection()
	 {
		 	$this->setFaild();
			$this->addEntry('noInternetConnection');
	 }

	 public function badInternetConnection()
	 {
		 	$this->setFaild();
			$this->addEntry('noInternetConnection');
	 }

	 public function dump()
	 {

	 }

	 public function notify()
	 {

		 foreach($this->observers as $observer)
		 {
			 	$observer->update($this->statusList, $this->isFaild());
		 }

		 if($this->isFaild())
		 {
			 		throw new \Exception("faild to preform update", 5342);
		 }

	 }

	 public function attach(\AbstractObserver $observer_in)
	 {
			 $this->observers[] = $observer_in;
	 }

	 public function detach(\AbstractObserver $observer_in)
	 {
		 $key = array_search($observer_in, $this->observers);
		 unset($this->observers[$key]);
	 }
}
