<?php
include '_dirinfo.php';
require_once (PATH_TO_ROOT.'_class/createQuestion/SingleMultiResponse.php');

	class MultiResponse extends SingleMulti
	{
		public function __construct(db $db=null,array $data = null)
		{
			parent::__construct($db,$data);
			$this->template_file = "MRtemplate.xml";
			$this->hasLegend = false;
		}
		public function addQuestion(array $data)
		{

			parent::addQuestion($data);

		}

		public function updateStructure()
		{

			include 'config.php';
			$this->db->ChangeDatabase($CATI_base);

			$answer_list=explode("/", $this->odg_sql);
			$i=count($answer_list);

			$fields = array();
			for ($answer_no=1; $answer_no<=$i; $answer_no++)
			{
				//$SQLadd_filds = $SQLadd_filds.", ".$VAR."_".$answer_no." $str_type_base($lenght_variable_base)";
				$fields[] = $this->q_name."_".$answer_no." int(3)";
			}
	  		$sql = "ALTER TABLE ".$this->project."_structure ADD (".implode(",",$fields).")";
	  		$this->db->SQLexecute($sql);
			if($this->db->IsError())
	  			{
	  				echo $this->db->GetError();
	  				return "Error";
	  			}
		}
	/**
		 * Gets the default values for some fields
		 * e.g. Open has open_sql set to 1 and type_variable_base to 2 (varchar)
		 *
		 * @return array : first element a string of fields, second element a string of values!
		 */
		public function getDefaultValues()
		{
			$arr[] = ',variableTypeBase,les_sql,open_sql';
			$arr[] = ',4,4,1';
			return $arr;
		}

		public function supportedShowTypes()
		{
			return  array(4,8);
		}

		public function getSpecialType()
		{
			if($this->leg_sql)
				return 2;
			return 1;
		}

		public function getStructureFields($row=null,$incOpen = true)
		{
			$q = $this->q_name;

			/*$ans = str_replace("/","<*>",$this->odg_sql);
			$ans = str_replace("<<*>","</",$ans);
			$ans = str_replace("<*>>","/>",$ans);

			$ans = explode('<*>',$ans);*/
			$ans = $this->answerToArray($this->odg_sql);
			$leg = $this->getLegendArray();
			//WARNING! I don't know if I use empty string detection anywhere!
			$str = array();
			if(count($leg) > 0)
			{
				for($i=1;$i<= count($ans);$i++ )
					{
						//$aId = explode(' ',$ans[$i-1],2);
						//we save the positions on which a certain ID is!
						$idToNum[ $ans[$i-1][0] ] = $i;
						for($j = 1;$j<=count($leg);$j++)
							$str[] = trim( $q.'_'.$i.'_'.$j.' '.$this->typeBase);
					}
			}
			else
			{
				for($i=1;$i<= count($ans);$i++ )
				{
					//$aId = explode(' ',$ans[$i-1],2);
					//we save the positions on which a certain ID is!
					$idToNum[ $ans[$i-1][0] ] = $i;
					$str[] = trim( $q.'_'.$i.' '.$this->typeBase);
				}

			}

			if($incOpen && $this->open_answers)
			{
				$openAns = explode(':',$this->open_answers);
				foreach ($openAns as $openAnsItem) {
					if(!$idToNum[ $openAnsItem  ]) return false;
					$str['o_'.$openAnsItem] = trim( $q.'_opn'.$idToNum[ $openAnsItem  ].' '.$this->typeOpen);
				}
			}

			return $str;

		}

		public function getAnswersForSelect(&$data,&$idToNum)
			{
				$ans = $this->answerToArray($this->odg_sql);
				$leg = $this->getLegendArray();
				$hasLeg = count($leg) > 0;

				foreach ($ans as $k=>$val) {
					if($hasLeg)
						foreach ($leg as $kL => $legVal) {
							$finD[] = ($k+1).'_'.($kL+1).' '.$val[0].' '.$val[1].' - '.$legVal[0].' '.$legVal[1];
						}

					else
	    				$finD[] = ($k+1).' '.$val[0].' '.$val[1];
	    			//we save the positions on which a certain ID is!
					$idToNum[ $val[0] ] = $k+1;
	    		}
		    	if ($finD)
		    		$data = implode('/',$finD);
		    	else
		    		return false;

				return true;
			}


	//function to get number of open answers needed for auto record
		public function getRecodeVars()
		{
			$vars = $this->getStructureFields();
			foreach ($vars as $key => $val) {
				if(substr($key,0,2) == 'o_')
					$str[] = $val;
			}
			$ans = $this->getAnswerArray();
			foreach ($ans as $var => $lab) {
				$labs[$lab[0]] = $lab[1];
			}

			return array($str,$labs);
		}

	public function getQType()
		{
			return "Multiresponse";
		}

		public function hasMultiAnswer()
		{
			return true;
		}
	public function getIconCls()
	{
		return 'icon-question_mr';
	}

		public function createAnswerGrid()
		{
		/*	if($_POST['dataIndex'] != 'odg_sql')
			{
				echo	"alert('Multiresponse questions can\'t have legend!');";
				return;
			}*/
		 	$this->createAnswerGridClass();
		 	$this->grid->addColumn('nogo','Nogo Together')->type('checkColumn');
		 	$this->grid->addConfig('saveGetData',"function(close){
			var str = new Array();
			var ng = new Array();
			var hasFilter = false;
			var filter = new Array();
			var open = new Array();
			var grp = new Array();
			$this->grid.stopEditing();
			{$this->grid->getName()}.getStore().each(function(rec){
					str.push(rec.data.pos +' '  + rec.data.ans);
					if(rec.data.nogo)
					{
						ng.push(rec.data.pos);
					}
					if(rec.data.filCnd || rec.data.filter)
					{
						hasFilter = true;
					}
				//
					/*if(rec.data.filter && !rec.data.filCnd)
					{
					    filter.push('11==1');
                        rec.set('filCnd', '1==1');
					}
					else */
                        filter.push( (rec.data.filter ? '1' : '0')+ (rec.data.filCnd ? rec.data.filCnd : '' )     );

					if(rec.data.open)
					{
						open.push(rec.data.pos);
					}
						grp.push(rec.data.group);

				});
			return {
						value:str.join('/'),
						nogo:ng.join() ,filter_answer : hasFilter ? filter.join('<!>'):'',
							open_data : open.join(':'),
							groups:grp.join()
							};


			}")
		 	->addButton('Save',"function(){ $this->grid.saveFunction(false); }")
			->addButton('Save&amp;Close',"function(){ $this->grid.saveFunction(true); }")
			->addButton('Cancel',"function(){
				Ext.getCmp('wcbqTabPanel_$this->tableName').remove({$_POST['name']});
			}");
		 	$ng = $_POST['nogo_answers'];
		 	echo "
		 			var ng = '$ng'.split(',');
		 		//	var d = {$this->grid->dataArray};
		 			for(var i=0;i<d.length;i++)
		 			{
		 				if(d[i][0] == ng[0])
		 				{
		 					d[i].push(true);
		 					ng.shift();
						}
						else
						{
							d[i].push(false);
						}
		 				//console.log(d[i]);
		 			}
		 			// {$this->grid->getName()}.getStore().loadData(d);
		 			";


		 	$this->createAnswerGridEcho();

		 	echo $this->grid->getName().".on('afteredit',function(e)
                {
                if(e.field == 'pos')
                {
                    var data = e.grid.getStore().getRange();
                    Ext.each(data, function(dat)
                    {
                        if(dat.get('pos') == e.value && e.record.id != dat.id)
                        {
                            Ext.Msg.show(
                            {
                                 title:'Warning',
                                 msg: 'You have two answers with same value',
                                 icon: Ext.MessageBox.INFO,
                                 buttons: Ext.Msg.OK
                            });
                            //e.record.set('pos', e.originalValue);
                        }
                    }    );
                }
                });";



		}

	//20150311 Tanis we calculate statistics in separate function so we can use raw data for other purposes like exporting ect.
    public function getStatisticData($rowQuestion ,$tmpName = 'warpitStatistic' )
    {
        return false;

    }

    public function exportToExcel($rowQuestion ,$tmpName = 'warpitStatistic', &$objPHPExcel)
    {

          $struct = array();
            $arr = array();
          //$q = Question::createQuestion($rowQuestion['tip_sql']);
            $fields = $this->getStructureFields($rowQuestion,false);
            $openAns = explode(':', $rowQuestion['open_answers']);
            $answers = $this->answerToArray($rowQuestion['odg_sql']);

            $legend = $this->answerToArray($rowQuestion['leg_sql']);
            $legendCount = count($legend);

            $tmpCnt = 1;
            foreach ($fields as $ansField) {
            	//20150803 Če ima odgovor vrednos 0 v statistiki pokaže kot da za ta odgvor ni v bazi zapisov čeprav so. Ta pogoj sem odstranil da stvar deluje
                $validAnsCond  = "1";
				//$validAnsCond = "$ansField>0";
            //  $ansField = $rowQuestion['q_name'];
                $sql = "SELECT $ansField AS variable,  count(*) AS freq FROM $tmpName WHERE $validAnsCond $this->filter GROUP BY $ansField";
                //echo "$sql<br>";

                If (!$resStat = $this->db->SQLexecute($sql)) {
                    //  Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
                        echo "alert(\"SQL problem: ".$this->db->getError()."\" );";
                        exit;
                }

                while ($rowStat = $this->db->fetchArray($resStat)) {
                    if ($legend) {
                        $keyAnswer = ceil($tmpCnt/$legendCount);
                        $struct[$keyAnswer][$rowStat[0]] += $rowStat[1];
                        //echo "keyAnswer:".$keyAnswer."   ---   tmpCnt:".$tmpCnt."  ---   legendCount:".$legendCount."  ---  rowStat0:".$rowStat[0]."  ---  rowStat1:".$rowStat[1]."<br>";
                    } else {
                        $struct[$rowStat[0]] = $rowStat[1];
                    }

                }
                $totalOr[] = $ansField.'>0';
                $tmpCnt++;
            }
            //echo "<br>struct:";print_r($struct);echo "<br><br>";
            $sqlTotalN =  "SELECT count(*) AS total_N FROM $tmpName WHERE ( ".implode(' OR ',$totalOr). " )  $this->filter";
            //echo "sqlTotalN: $sqlTotalN<br>";

            If (!$resTotalN = $this->db->SQLexecute($sqlTotalN)) {
                    //Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
                    echo "alert(\"SQL problem: ".$this->db->getError()."\" );";
                    exit;
            }
            $totalN = $this->db->fetchArray($resTotalN);
            $totalN = $totalN[0];

            if($totalN == 0) {
                $numerusLabel = 0;
                $totalN = 1;
            } else
                $numerusLabel = $totalN;


            $itemLegends = array();
            if ($legend) {
                foreach($legend as $itemLegend) {
                    $arr = array();

                    $keyLegend = $itemLegend[0];
                    $ansLegend = $itemLegend[1];

                    foreach ($answers as $item) {
                        $key = $item[0];
                        $ans = $item[1];

                        $freq = $struct[$key][$keyLegend];
                        if(!$freq) $freq = 0;
                        $arr[] = array( strip_tags($ans), $freq,$freq/$totalN*100 ,strip_tags(substr($ans,0,50)) );

                    }
                    parent::exportToExcel($rowQuestion,$tmpName, $objPHPExcel, array($arr,"Answers (N = $numerusLabel )", $rowQuestion['vpr_sql']." - ".$ansLegend));

                }
            } else {
                $k = 1;
                foreach ($answers as $item) {
                    $key = $item[0];
                    $ans = $item[1];

                    $freq = $struct[$key];
                    if(!$freq) $freq = 0;
                    $arr[] = array( strip_tags($ans), $freq,$freq/$totalN*100 ,strip_tags(substr($ans,0,50)) );

                    if($openAns[0] == $key) {
                        array_shift($openAns);
                        //here we create the open lari fari!!!
                        $ansField = $rowQuestion['q_name'].'_opn'.$k;
                        $sql = "SELECT $ansField AS variable,  count(*) AS freq FROM $tmpName WHERE $ansField IS NOT NULL AND $ansField != '' $this->filter GROUP BY $ansField";

                        If (!$resStat = $this->db->SQLexecute($sql)) {
                                echo "alert(\"SQL problem: ".$this->db->getError()."\" );";
                                exit;
                        }
                        while ($rowStat = $this->db->fetchArray($resStat)) {
                            $ansOpn = $rowStat[0];
                            $freqOpn = $rowStat[1];
                            $arr[] = array(strip_tags($ansOpn), $freqOpn,$freqOpn/$totalN*100 ,strip_tags(substr($ansOpn,0,50)) );
                        }
                    }
                    $k++;
                }
             //   if(!$rowQuestion['vpr_sql']) $rowQuestion['vpr_sql'] = "&nbsp;";
                //print_r($arr);echo "<br>";
//                    $this->createStatisticsGridChart($arr,$rowQuestion['vpr_sql'],"Answers (N = $numerusLabel ) ");
                    //parent::exportToExcel($arr,$rowQuestion['vpr_sql']." - ".$ansLegend,"Answers (N = $numerusLabel )");
                    parent::exportToExcel($rowQuestion,$tmpName, $objPHPExcel, array($arr, "Answers (N = $numerusLabel )", $rowQuestion['vpr_sql']." - ".$ansLegend));
            }
            return true;

    }

	public function createStatistics($rowQuestion ,$tmpName = 'warpitStatistic' ) {

		   	$struct = array();
		   	$arr = array();
		  //$q = Question::createQuestion($rowQuestion['tip_sql']);
		   	$fields = $this->getStructureFields($rowQuestion,false);
		   	$openAns = explode(':', $rowQuestion['open_answers']);
		   	$answers = $this->answerToArray($rowQuestion['odg_sql']);

		   	$legend = $this->answerToArray($rowQuestion['leg_sql']);
		   	$legendCount = count($legend);

			$tmpCnt = 1;
		   	foreach ($fields as $ansField) {

				//20150803 Če ima odgovor vrednos 0 v statistiki pokaže kot da za ta odgvor ni v bazi zapisov čeprav so. Ta pogoj sem odstranil da stvar deluje
                $validAnsCond  = "1";
              //  $validAnsCond = "$ansField>0";

			//	$ansField = $rowQuestion['q_name'];
				$sql = "SELECT $ansField AS variable,  count(*) AS freq FROM $tmpName WHERE $validAnsCond $this->filter GROUP BY $ansField";
				//echo "$sql<br>";

				If (!$resStat = $this->db->SQLexecute($sql)) {
					//	Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
						echo "alert(\"SQL problem: ".$this->db->getError()."\" );";
						exit;
				}

				while ($rowStat = $this->db->fetchArray($resStat)) {
					if ($legend) {
						$keyAnswer = ceil($tmpCnt/$legendCount);
						$struct[$keyAnswer][$rowStat[0]] += $rowStat[1];
						//echo "keyAnswer:".$keyAnswer."   ---   tmpCnt:".$tmpCnt."  ---   legendCount:".$legendCount."  ---  rowStat0:".$rowStat[0]."  ---  rowStat1:".$rowStat[1]."<br>";
					} else {
						$struct[$rowStat[0]] = $rowStat[1];
					}

				}
				$totalOr[] = $ansField.'>0';
				$tmpCnt++;
		   	}
			//echo "<br>struct:";print_r($struct);echo "<br><br>";
			$sqlTotalN =  "SELECT count(*) AS total_N FROM $tmpName WHERE ( ".implode(' OR ',$totalOr). " )  $this->filter";
			//echo "sqlTotalN: $sqlTotalN<br>";

			If (!$resTotalN = $this->db->SQLexecute($sqlTotalN)) {
					//Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
					echo "alert(\"SQL problem: ".$this->db->getError()."\" );";
					exit;
			}
			$totalN = $this->db->fetchArray($resTotalN);
			$totalN = $totalN[0];

			if($totalN == 0) {
				$numerusLabel = 0;
				$totalN = 1;
			} else
				$numerusLabel = $totalN;


			//echo "<br>answers:";print_r($answers);echo "<br><br>";
			//print_r($openAns);echo "<br>";
			$itemLegends = array();
			if ($legend) {
				foreach($legend as $itemLegend) {
					$arr = array();

					$keyLegend = $itemLegend[0];
					$ansLegend = $itemLegend[1];
					//echo "$keyLegend -> $ansLegend<br>";

					foreach ($answers as $item) {
						$key = $item[0];
						$ans = $item[1];

						$freq = $struct[$key][$keyLegend];
						//echo "freq:$freq<br>";
						if(!$freq) $freq = 0;
						$arr[] = array( strip_tags($ans), $freq,$freq/$totalN*100 ,strip_tags(substr($ans,0,50)) );

					}
					if(!$rowQuestion['vpr_sql']) $rowQuestion['vpr_sql'] = "&nbsp;";
					//echo "<br>arr for table:";print_r($arr);echo "<br><br>";
					if(!$this->Graphstat)
						$this->createStatisticsGridChart($arr,$rowQuestion['vpr_sql']." - ".$ansLegend,"Answers (N = $numerusLabel ) ");
					else
					{
						$statData = array(
						'series' => $arr,
						'rowQuest' => $rowQuestion['vpr_sql'],
						'columnName' => $ansLegend,
						'answN' => 'N = '.$numerusLabel
						);

						$itemLegends[] = $statData;
					}
				}
				if($this->Graphstat)
					return $itemLegends;
			} else {
				$k = 1;
				foreach ($answers as $item) {
					$key = $item[0];
					$ans = $item[1];

					$freq = $struct[$key];
					if(!$freq) $freq = 0;
					$arr[] = array( strip_tags($ans), $freq,$freq/$totalN*100 ,strip_tags(substr($ans,0,50)) );

					if($openAns[0] == $key) {
						array_shift($openAns);
						//here we create the open lari fari!!!
						$ansField = $rowQuestion['q_name'].'_opn'.$k;
						$sql = "SELECT $ansField AS variable,  count(*) AS freq FROM $tmpName WHERE $ansField IS NOT NULL AND $ansField != '' $this->filter GROUP BY $ansField";

						If (!$resStat = $this->db->SQLexecute($sql)) {
								echo "alert(\"SQL problem: ".$this->db->getError()."\" );";
								exit;
						}
						while ($rowStat = $this->db->fetchArray($resStat)) {
							$ansOpn = $rowStat[0];
							$freqOpn = $rowStat[1];
							$arr[] = array( "&nbsp;&nbsp;&nbsp;".strip_tags($ansOpn), $freqOpn,$freqOpn/$totalN*100 ,strip_tags(substr($ansOpn,0,50)) );
						}
					}
					$k++;
				}
				if(!$rowQuestion['vpr_sql']) $rowQuestion['vpr_sql'] = "&nbsp;";
				//print_r($arr);echo "<br>";
				if($this->Graphstat)
				{
					$statData = array(
						'series' => $arr,
						'rowQuest' => $rowQuestion['vpr_sql'],
						'answN' => 'N = '.$numerusLabel
					);
					//$this->createStatisticsGridChart($statData,'','');
					return $statData;
				}
				else
					$this->createStatisticsGridChart($arr,$rowQuestion['vpr_sql'],"Answers (N = $numerusLabel ) ");
			}

			return true;
		}

		private function answersInGroups($groups)
		{
			$tmp = array();
			foreach($groups as $key => $val)
			{
				if(in_array($val, $tmp)) $val[] = $tmp;

				if(count($tmp) > 1) return true;
			}

			return false;
		}

		public function designerDrawAnswers($xmlObj,$display)
		{

				global $onClick;
				/*
				echo "<pre>";
					var_dump($this->q_name);
				echo "</pre>";
				*/



				$fields = $this->getStructureFields();
				$ansArr = $this->answerToArray( $this->odg_sql) ;
				$ansArr = $this->designerRotateAnswers($ansArr);
				$this->designerFilterAnswers($ansArr);

				//$legArr = $this->answerToArray($this->display->readRequiredQuestionVariables( $this->leg_sql) );
				//20150324 Added by Tanis: if we readRequiredQuestionVariables before ansToArray images doesn't show
                $legArr = $this->answerToArray($this->leg_sql);
                $tmpLegArr = array();
                foreach ($legArr as &$leg)
                {
                 //$leg[1] = $this->display->readRequiredQuestionVariables($leg[1]);
                    $tmpLegArr[] = array("0" => $leg[0], "1" => $this->display->readRequiredQuestionVariables($leg[1]));
                }
                $legArr = $tmpLegArr;
			/*	print "<pre>";
                var_dump($legArr);
                print "</pre>";*/
				$hasLegend = count($legArr) > 0;
				if($hasLegend)
				{
					// I set property for class, because I need this infomration also in other functions
					// example: In must answer condition I need also information if multiresponse has legend
					// added 18.6.2012 - Soulskiner
					$this->hasLegend = true;
					// end added 18.6.2012 - Soulskiner
					$legSize = count($legArr);
					$legArr = $this->designerRotateAnswers($legArr,true);
					$this->designerFilterAnswers($legArr,true);
					$divide = count($legArr);


				}
				else
					$divide = 1;

				$this->designerDefineObjects($divide);

				$openAns = explode(':',$this->open_answers);

/*
				echo "<pre>";
					var_dump($ansArr,$legArr);
				echo "</pre>";
				*/
				$tbl = "";

				if ($hasLegend) $tbl = "<input type='hidden' name ='MultiWithLegend' id='MultiWithLegend' value='1' />";
				if ($hasLegend && ( $this->multi_nogo_answers || $this->multi_nogo_legends ) ) {


					if ($this->multi_nogo_answers) $MultiNoGoAnswers = explode(",",$this->multi_nogo_answers);
					if ($this->multi_nogo_legends) $MultiNoGoLegends = explode(",",$this->multi_nogo_legends);


					// We need to recode values in interface to index in database
					// first we prepare recode tables
					foreach ($ansArr as $sKey => $sVal) $ansNogoRecode[$sVal['0']] = $sKey + 1;
					foreach ($legArr as $sKey => $sVal) $legNogoRecode[$sVal['0']] = $sKey + 1;

					// now we prepare new ArraysForMultiNoGoAnswers
					if ($MultiNoGoAnswers) foreach ($MultiNoGoAnswers as $ar) $MultiNoGoAnswersDatabase[] = $ansNogoRecode[$ar];
					if ($MultiNoGoLegends) foreach ($MultiNoGoLegends as $ar) $MultiNoGoLegendsDatabase[] = $legNogoRecode[$ar];

					/*
					echo "<pre>";
						var_dump($MultiNoGoAnswers, $MultiNoGoAnswersDatabase);
					echo "</pre>";
					*/

					$tbl .= "
						<script>



						function clearAx(checkbox, os, aIds){

								if (aIds != '0') {
								 arrIds = aIds.split(',').map(function(item) {
										    return parseInt(item, 10);
											});

									//console.log(arrIds)
								}

								if(checkbox.checked == true)
								{
									var ime = checkbox.name;
									var res = ime.split(\"_\");		//razdeli ime checkboxa da dobimo stoplec in vrsto v tabeli, ki sta zapisani v imenu. primer: answers[t1_1_1]
									var vrsta = parseInt(res[1]);	//vrsta izbranega checkboxa
									var stolpec = parseInt(res[2]);	//stolpec izbranega checkboxa

									if(os == 'x'){					//če je argument os == x

										$('#test').find(':checkbox').each(function(){		//gremo vse checkboxa ki so v tabeli z id = test
											var imeN = this.name;
											var res = imeN.split(\"_\");		//razdeli string v polje po znaku _
											var vrstaN = parseInt(res[1]);	//vrsta checkboxa ki je navrsti za pregled
									 		var stolpecN = parseInt(res[2]);	//stolpec  checkboxa ki je navrsti za pregled

									 		if (aIds != '0') {
										 			//console.log( stolpecN , stolpec, vrsta, vrstaN, this.name, $.inArray( stolpecN , arrIds ));
										 			if ( $.inArray( stolpecN , arrIds ) != -1 && vrstaN == vrsta) {
										 			this.checked = false;
										 			}

										 	} else {

										 		if(vrstaN == vrsta){
										 			if(stolpecN != stolpec)	//preverjanje, da ne izbriše pravkar izbranega
										 			{
											 			this.checked = false;		//izbriše
										 			}
										 		}
										 	}
									    });


									}
									else if(os == 'y'){

											$('#test').find(':checkbox').each(function(){		//gremo vse checkboxa ki so v tabeli z id = test
												var imeN = this.name;
												var res = imeN.split(\"_\");
												var vrstaN = parseInt(res[1]);		//vrsta checkboxa ki je navrsti za pregled
										 		var stolpecN = parseInt(res[2]);	//stolpec  checkboxa ki je navrsti za pregled

										 		if (aIds != '0') {
										 			//console.log( stolpecN , stolpec, vrsta, vrstaN, this.name, $.inArray( stolpecN , arrIds ));
										 			if ( $.inArray( vrstaN , arrIds ) != -1 && stolpecN == stolpec) {
										 			this.checked = false;
										 			}

										 		} else {
											 		if(stolpecN == stolpec){			//preverjanje, da ne izbriše pravkar izbranega
											 			if(vrstaN != vrsta)
											 			{
												 			this.checked = false;
											 			}
											 		}
											 	}
									    });
									}
								}
							}
						</script>
					";

				}

			  	$tbl .= "<table id=\"answTable_".$this->q_name."\" ".$this->mainStyle." cellpadding=0 cellspacing=0 width=100% id=test>";

			  	// ------------------------------------------------------------------------------------------
			  	// ADDED soulskiner 4.1.2013
			  	// this part is for repaeating legened labels in answers for each group like in scale
			  	// I check if answerGroups are defined - we put answers in groups
			  	//-------------------------------------------------------------------------------------------
			  	$showLegendCondition = false;

			  	if ($this->answerGroups && $this->ansDefined && $this->les_sql != 8 && $hasLegend) {

			  		$grTmp = explode('<|>',$this->answerGroups);
			  		$groupData = explode('<*>',$grTmp[2]);
			  		$groupDataTmp = explode(",",$groupData[0]);


			  		if ( $groupDataTmp[3] == 1 ) $showLegendCondition = true;

			  	} elseif ( !$this->ansDefined && $this->les_sql != 8 && $hasLegend )  {

			  		$showLegendCondition = true;

			  	}

			  	if ( $showLegendCondition ) {
			  		$tbl .= "<tr>";
						foreach ($this->legRow->children() as $child) {
							$attr = $child->attributes();
					  				switch ($attr['type'])
						  			{
						  			    case 20:
						  			    	// val label legend in top of table of checkboxes
						  					if($this->showVal) $tbl .= "<td ".$useStyle[20]." style=\"width:20px\">".$value."</td>";
						  				break;
							  				case 21:
							  					// Titel of label in header
							  					$tbl .= "<td ".$useStyle[21]." >".$label."</td>";
							  				break;
						  				case 22:
						  					// Titels of legend items in checkbox
									  		foreach ($legArr as $index => $ans) $tbl .= "<td ".$this->legStyle[22].">".$ans[1]."</td>";
						  					break;
						  			}
							}
				  	$tbl .= "</tr>";
			  	}

			  	// ------------------------------------------------------------------------------------------
  				// #END ADDED soulskiner 4.1.2013
			  	// ------------------------------------------------------------------------------------------

			  	if(!$this->ansDefined)
				  	{
					if($this->les_sql == 8)
				  	{
					  		$pHeight = 100;
			  				$pWidth = 100;
			  				$pMargin = 10;
			  				$pBorder = 3;

			  				$tbl .= '
							<tr>

							<td id="imageCont">

							<script type="text/javascript">

							$( init );

							function init() {
							  $(\'#dropContainer\').droppable({
					  			  drop: handleDropEvent
										  } );

								$("#imageCont").droppable({
			  					drop: function(event,ui){
								var n = '.$pMargin.'+ ui.draggable.data("index")*'.($pHeight+$pMargin+2*$pBorder).';
						  		ui.draggable.position({of: ui.draggable.parent(), my: \'left top\', at: \'left top\',offset: "0 "+n.toString()});
								 document.forms["mainForm"][ui.draggable.data("name")].value = "";
								 ui.draggable.draggable("option","revert",false);
				  				}
				  				});
				  				if(window.initSelected)
				  					initSelected();

								}

								function handleDropEvent( event, ui ) {
								  var draggable = ui.draggable;

							  		var n = '.$pMargin.'+ draggable.data("index")*'.($pHeight+$pMargin+2*$pBorder).';


								 draggable.position({ of: $(this), my: \'left top\', at: \'left top\',offset: "20 "+n.toString()});
								 //draggable.position({of:draggable.parent(), offset:"50 50"});
								 draggable.draggable("option","revert",false);
								 document.forms["mainForm"][draggable.data("name")].value = draggable.data("value");
								}



							</script>';


				  	}

				  	$this->counter = 0;


				  	$_SESSION['questionFields'] = array_merge($_SESSION['questionFields'], $fields);


				  	// 26.6. Soulskiner added condition !$hasLegend
				  	// Reason: if we have multiresponse with Legend answers - Multi Multi then this conditions are not working and we need to define new one
				  	if($this->multi_nogo_answers && !$hasLegend)
				  	{

				  		//we prepare the nogo tohether answer
			  			$nogoArr = explode(',',$this->multi_nogo_answers);
				  		foreach ($ansArr as $index => $nvm) {
							if(in_array($nvm[0],$nogoArr) )
								$this->nogoNames[] = "'answers[".trim( $fields[$index])."]'";
							$fldNames[] = "'answers[".trim( $fields[$index])."]'";
			  			}

			  	/*		echo "<pre>";
				  		var_dump($this->nogoNames);
				  	echo "</pre>";*/

			  			if($this->nogoNames)
			  			{
				  			$tbl .= "<script>
				  			function contains(a, obj) {
							  var i = a.length;
							  while (i--) {
							    if (a[i] === obj) {
							      return true;
							    }
							  }
							  return false;
							}
				  			var nogoArr = [".implode(',',$nogoArr)."] ;
				  			var names = [";

				  			$tbl .= implode(',',$fldNames). "];



				  			var nogoNames = [". implode(',',$this->nogoNames)."]
				  			 var f = document.forms['mainForm'];
				  			function multiNogoChecker(colInd,val)
				  			{
				  				// 20150901 Tanis če so bili odgovori razvrščeni po grupah se vrstni red ni ujemal z vrstnim redom v variabli names.
				  				// Preberemo vse checkboxe na formi in tako dobimo tudi pravilni vrstni red odgovorov
				  				var tInputs = $('#mainForm :checkbox');
				  				var namesOrder = [];
					  			$.each(tInputs,function(index, input){
					  				if (input.id.split('_')[2] !== undefined)
					  				{
					  					var id =  input.id;
					  					id = id.slice(id.indexOf('_') + 1);
					  					namesOrder.push('answers[' + id + ']');
					  				}


					  			});
				  				//20150901 Tanis END

			  				//20150901 Tanis names -> namesOrder
				  			var col = namesOrder[colInd];

				  			//if we clicked a nogo we disable all others!
				  			if(contains( nogoArr,val ))
				  			{
				  				for(var x=0;x<".count($ansArr).";x++)
				  				{
				  					if(x != colInd)
				  					{

                                        // Matej, 2015-08-27
                                        // Calling recodeClickEvents manually here,
                                        // simulating unchecking checkboxes.
						  				//20150901 Tanis names -> namesOrder
                                        var checkbox = f[namesOrder[x]];
                                        var changed = (checkbox.checked == true);
				  						checkbox.checked = false;

                                        if (changed)
                                            recodeClickEvents(checkbox, 1);

                                        // Matej, 2015-08-26, custom inputs nogo handling (survey/javascript/custom_inputs.php)
                                        var id = checkbox.id;
                                        id = id.slice(id.indexOf('_') + 1);
                                        customInputNogoUncheck(id);
				  					}

				  				}
				  			}
							else
								for(var x=0;x<".count($this->nogoNames).";x++)
		  						{
                                    var checkbox = f[nogoNames[x]];
                                    var changed = (checkbox.checked == true);
                                    checkbox.checked = false;

                                    if (changed)
                                        recodeClickEvents(checkbox, 1);

                                    // Matej, 2015-08-26, custom inputs nogo handling
                                    var id = checkbox.id;
                                    id = id.slice(id.indexOf('_') + 1);
                                    customInputNogoUncheck(id);
			  				}
			  				";




				  			$tbl .= "} </script>";
			  			}
				  	}
				}




				$this->ansDefined = true;

				if($this->headerDisplay)
			  		{
			  			//check if there are any answers to display!
			  			 foreach ($ansArr as $index => $ans) {
			  			 	if (!$this->groups[$index]) $this->groups[$index] = 0;
				  	 		if($this->groups[$index] == $this->group ) $displayH = true;
			  			 }
			  			if($displayH) {
							$tbl .= "<tr height=$this->headerHeight><td colspan=2 style='vertical-align:bottom;'>$this->headerTitle </td>";
			  			}
			  		}

				if( $this->display->engine->LeaveQuestion === false )
			  		$fieldsValues = $_POST['answers'];
			  	else
			  		$fieldsValues = $this->display->readStructureVariables($fields,'');



		  		// prepare variable for storing multiresponse answers as values from config table
			 	unset($answersStrNames);
				//20151123 Tanis to dam stran pa da vidimo kaj bo
				/*if(count($_SESSION['answersStrNames'][$this->q_name]) > 0)
				{
					unset($_SESSION['answersStrNames'][$this->q_name]);
				}*/
				//20151123 Tanis END
			  	foreach ($ansArr as $index => $ans) {
			  		if (!$this->groups[$index]) $this->groups[$index] = 0;
			  		if( $this->groups[$index] != $this->group ) continue;
			  		$value = $ans[0];
			  		$label = $this->display->readRequiredQuestionVariables( $ans[1] );

			  		 if($this->les_sql == 8)
	  				{
	  					$ddId = "dr_".$this->q_name."_$value";
	  					$ddName= "answers[{$fields[$index]}]";
	  					$tbl .= "<div id='$ddId' style='width:100;height:100;margin:10px 0px; border:{$pBorder}px black solid;' >$label</div>
	  							<input type=\"hidden\" name=\"$ddName\" value=\"{$fieldsValues[ $fields[$index] ]}\" />
	  							<script>$('#$ddId').data('index',$this->counter).data('value',$value).data('name','$ddName')
	  							.draggable({
	  						//helper:'clone'
	  						stack:'#imageCont div',
	  						start:function(){
	  							$(this).draggable('option','revert',true);
	  						}
	  						});

	  						</script>";
						if($fieldsValues[ trim( $fields[$index]) ] == $value)
	  						$initSelcted .= "
	  							d = $('#$ddId')
	  							n = $pMargin + d.data('index')*".($pHeight+$pMargin+2*$pBorder).";

	  							d.position({ of: $('#dropContainer'), my: 'left top', at: 'left top',offset: '20 '+n.toString() });
	  							";


	  				}
	  				else
	  				{

			  		// start of tr javascript events
	  				$tbl .= "<tr id=\"tr_" . $fields[$index] . "\" onClick=\" $onClick"; //

	  				//1.10.2014 Tanis: Zakomeniral sem  del kode ki spremeni checked/unchecked
                    // 2015-07-20 Matej: zakomentiral še recodeClickEvents, se zdaj kliče v custom_inputs.php handlerju
                        if(!$hasLegend)	$tbl .=	" var tmp=document.forms['mainForm']['answers[".trim( $fields[$index])."]']; /*tmp.checked = !tmp.checked;*//*recodeClickEvents(tmp,1); */";
			  			if($this->nogoNames) $tbl .= "multiNogoChecker($this->counter,$value)";
			  		$tbl .= "\">";
			  		// #end of tr javascript events

		 		    if ($this->counter%2 == 1) // odd rows
				  		{
				  			$useRow = $this->oddRows;
				  			$useStyle = $this->oddStyle;
				  		}
			  		else
				  		{
				  			$useRow = $this->evenRows;
				  			$useStyle = $this->evenStyle;
				  		}

			  		foreach ($useRow->children() as $child) {
			  			$attr = $child->attributes();
			  				switch ($attr['type'])
				  			{
				  				case 20:
				  					if($this->showVal)
			  						{
					  					$size = $useStyle[20];
					  					$tbl .= "<td $size>$value";

					  					$tbl .= '</td>';
				  					}
				  				break;
				  				case 21:
				  					$size = $useStyle[21];
                                    // Matej, 2015-08-26: clicking on labels in multiresponse-with-legend checks unwanted checkbox?
                                    //$tbl .= "<td $size onClick=\"event.cancelBubble = true;\">$label";

                                    $tbl .= "<td $size>$label";
				  					if( in_array($value,$openAns) )
				  					{
				  						$openWidth = "250px";
				  						if ($attr['widthOpen']) $openWidth = $attr['widthOpen'];
										if ($attr['heightOpen']) $openHeight = $attr['heightOpen'];

                                        if($this->open_end_type == 1){
                                            $tbl .= "<input type='text' style='width:$openWidth;'";

                                            if($hasLegend)
                                            {
                                                    //26.5.2015 Tanis must answer didn't work becouse of wrong MA condition
                                                    $ansCndOpen[$index] = 'strlen($'.trim($fields['o_'.$value]).')>0';
                                            }
                                            else
                                            {
                                                $tbl .= "onkeydown=\"var tmp=document.forms['mainForm']['answers[".trim( $fields[$index])."]']; if(!tmp.checked) {tmp.checked = true;";
                                                if($this->nogoNames)
                                                    $tbl .= "multiNogoChecker($this->counter,$value);";
                                                $tbl .="}\" onClick=\"$onClick recodeClickEvents(this,1);event.cancelBubble=true;\" onBlur=\"recodeClickEvents(this,2);\"
                                                id='op_".$fields[$index]."' ";

                                                $this->openAnsCnd[] = " ($".trim( $fields[$index]) .' != '.$value." OR strlen( $". trim($fields['o_'.$value]).") > 0)";
                                            }
                                            $tbl .= "NAME='answers[". trim($fields['o_'.$value]) ."]' value='". $fieldsValues[trim($fields['o_'.$value]) ]."'>";
                                        }else{
                                            $tbl .= "<textarea style='width: {$openWidth};height:{$openHeight};'";
                                            if($hasLegend){
                                                //26.5.2015 Tanis must answer didn't work becouse of wrong MA condition
                                                $ansCndOpen[$index] = 'strlen($'.trim($fields['o_'.$value]).')>0';
                                            }else{
                                                $tbl .= " onkeydown=\"var tmp=document.forms['mainForm']['answers[".trim( $fields[$index])."]']; if(!tmp.checked) {tmp.checked = true;";
                                                if($this->nogoNames)
                                                    $tbl .= "multiNogoChecker($this->counter, $value);";
                                                $tbl .= "}\" onClick=\"$onClick recodeClickEvents(this, 1); event.cancelBubble=true;\" onBlur=\"recodeClickEvents(this, 2)\" id='op_".$fields[$index]."' ";

                                                $this->openAnsCnd[] = " ($".trim( $fields[$index]) .' != '.$value." OR strlen( $". trim($fields['o_'.$value]).") > 0)";
                                            }
                                            $tbl .= "NAME='answers[". trim($fields['o_'.$value]) ."]'>" .$fieldsValues[trim($fields['o_'.$value]) ];
                                            $tbl .= "</textarea>";
                                        }
				  					}
				  					$tbl .= '</td>';
				  				break;
				  				case 22:
				  					$size = $useStyle[22];
				  					$ansCndLeg = array();
				  					if($hasLegend)
				  					{
				  						//$legIndex = 0;
				  						//we go trough each legend and draw it
								  		foreach ($legArr as $legIndex => $leg) {
									  		$legVal = $leg[0];
									  		//the type of display depends on les_sql


								  			//3 and 4 needs condition for every legend option
                                            // Matej, 2015-08-26, commented out check/uncheck, added id="td_..."
                                            $tbl .= "<td id='td_" . trim($fields[$index*$legSize + $legIndex]) . "' $size onClick=\"$onClick  var tmp = document.forms['mainForm']['answers[".trim( $fields[$index*$legSize + $legIndex])."]']; /*tmp.checked = !tmp.checked;*/ ";

								  				if ( is_array($MultiNoGoAnswers) && in_array($value,$MultiNoGoAnswers) ) $tbl .= "clearAx(tmp,'y','0');";
								  				elseif ( is_array($MultiNoGoAnswers) ) $tbl .= "clearAx(tmp,'y','".implode(",",$MultiNoGoAnswersDatabase)."');";

								  				if ( is_array($MultiNoGoLegends) && in_array($legVal,$MultiNoGoLegends) ) $tbl .= "clearAx(tmp,'x','0');";
								  				elseif ( is_array($MultiNoGoLegends) ) $tbl .= "clearAx(tmp,'x','".implode(",",$MultiNoGoLegendsDatabase)."');";

								  				/*$tbl .= "
											  				clearAx(tmp,'y');
											  				clearAx(tmp,'x');
											  			";*/
								  				//$deb = $legIndex." -> ".$index." || ".$legVal." -> ".$value;

								  				/*print "<pre>";
                                                var_dump($fieldsValues);
                                                print "</pre>";*/

                                                // Matej, 2015-08-26, commented out recodeClickEvents()
                                                $tbl .= " /*recodeClickEvents(tmp,1);*/\"> ".$deb."
								  					<input type='checkbox'

								  						onClick=\" $onClick  ";

								  				if ( is_array($MultiNoGoAnswers) && in_array($value,$MultiNoGoAnswers) ) $tbl .= "clearAx(this,'y','0');";
								  				elseif ( is_array($MultiNoGoAnswers) ) $tbl .= "clearAx(this,'y','".implode(",",$MultiNoGoAnswersDatabase)."');";

								  				if ( is_array($MultiNoGoLegends) && in_array($legVal,$MultiNoGoLegends) ) $tbl .= "clearAx(this,'x','0');";
								  				elseif ( is_array($MultiNoGoLegends) ) $tbl .= "clearAx(this,'x','".implode(",",$MultiNoGoLegendsDatabase)."');";

								  				$tbl .=" 	recodeClickEvents(this,1);event.cancelBubble=true\"
								  				 			id='ct_".trim( $fields[$index*$legSize + $legIndex])."' NAME='answers[".trim( $fields[$index*$legSize + $legIndex])."]'
								  				 			value='$legVal' ";
								  				if(  $fieldsValues[  trim( $fields[$index*$legSize + $legIndex]) ]  ) $tbl .= 'checked = true';


								  				$tbl .= "></td>";

								  				//$ansCndLeg[] = "isset( $".trim( $fields[$index*$legSize + $legIndex]).")";
                                                //26.5.2015 Tanis must answer didn't work becouse of wrong MA condition
                                                if($ansCndOpen[$index])
                                                {

                                                    if($this->must_answer) {
                                                        $ansCnd = " (isset( $".trim( $fields[$index*$legSize + $legIndex]).") AND " . $ansCndOpen[$index] .") ";
                                                        $this->tmpAnsCnd[$legIndex]['normal'][] = $ansCnd;
                                                       // $this->openAnsCnd[] = $ansCnd;
                                                    } else {
                                                        $ansCnd = " (isset( $".trim( $fields[$index*$legSize + $legIndex]).") XOR " . $ansCndOpen[$index] . ") ";
                                                        $this->tmpAnsCnd[$legIndex]['normal'][] = $ansCnd;
                                                        //$this->openAnsCnd[] = $ansCnd;
                                                    }
                                                }
                                                else
                                                    $this->tmpAnsCnd[$legIndex]['normal'][] = "isset( $".trim( $fields[$index*$legSize + $legIndex]).")";
                                                //26.5.2015 Tanis End

							  				//$legIndex++;
								  		}
				  					}
				  					else
				  					{
					  					//$tbl .= "<td $size><input class=\"imageTicker\"  type='checkbox' onClick=\"$onClick event.cancelBubble=true;recodeClickEvents(this,1);";
					  					$tbl .= "<td $size><input   type='checkbox' onClick=\"$onClick event.cancelBubble=true;recodeClickEvents(this,1);";

					  					if($this->nogoNames)
				  								$tbl .= "multiNogoChecker($this->counter,$value);";
				  						$tbl .= "\" id='ct_".trim($fields[$index])."' NAME='answers[".trim( $fields[$index])."]' value='$value'";
					  					if($fieldsValues[  trim( $fields[$index]) ] == $value) $tbl .= ' checked ';

					  					$tbl .= "></td>";

					  					// collect all answers into string and post this to store for multi dihotomies 0/1
					  					if (defined('MULTI_DEFAULT_VALUE')) $answersStrNames[] = trim( $fields[$index]);
				  					}
				  			/*		echo "constant to fil multiresponse:".MULTI_DEFAULT_VALUE."<br>";
				  					echo "<pre>answersStrNames:";
				  					print_r($answersStrNames);
				  					echo "</pre>";
			  					*/break;
				  			}

				  		}



			  		$tbl .= "</tr>";

	  				}
	  			/*	if($hasLegend)
				  	{
				  	         print "<pre>";
                             var_dump($tmpAnsCnd);
                             print "</pre>";
				  			$ansCnd = '('.implode(' OR ',$ansCndLeg).')';
				  			//if open ansers is avaliable either both answers must be checked or none (!xor)
				  			if($ansCndOpen)
				  			{

				  				if($this->must_answer) {
				  					$ansCnd = ' ('.$ansCnd.' AND '.$ansCndOpen.') ';
				  					unset($ansCndOpen);
				  					$this->openAnsCnd[] = $ansCnd;
				  				} else {
				  					$ansCnd = '!('.$ansCnd.' XOR '.$ansCndOpen.')';
				  					unset($ansCndOpen);
				  					$this->openAnsCnd[] = $ansCnd;
				  				}
				  			}
				  	 }
				  	else
				  	{
				  		$ansCnd = "($".trim( $fields[$index]) .' == '.$value;
					  	$ansCnd .= ')';
				  	}*/
				  	//26.5.2015 Tanis must answer didn't work becouse of wrong MA condition
				    if(!$hasLegend)
                    {
                        $ansCnd = "($".trim( $fields[$index]) .' == '.$value;
                        $ansCnd .= ')';

                        $this->cnd[] = $ansCnd;
                    }
		            //26.5.2015 Tanis End


			  		$this->counter++;
			  	}//EO for each answers!

			  	//26.5.2015 Tanis must answer didn't work becouse of wrong MA condition
			  	if($this->tmpAnsCnd)
                {
                   /* print "<pre>";
                    print "tu sem";
                    var_dump($this->tmpAnsCnd);
                    print "</pre>";*/
                    foreach($this->tmpAnsCnd as $legIndex => $conds)
                    {
                        $ansCnd = '('.implode(' OR ',$conds['normal']).')';

                      /*  print "<pre>";
                        var_dump($ansCnd);
                        print "</pre>";*/

                     /*   if(isset($conds['open']))
                        {
                              if($this->must_answer) {
                                $ansCnd = ' ('.$ansCnd.' AND '.implode( " AND ", $conds['open']).') ';
                                //unset($ansCndOpen);
                                $this->openAnsCnd[] = $ansCnd;
                            } else {
                                $ansCnd = '!('.$ansCnd.' XOR '.implode( " AND ", $conds['open']).')';
                                $this->openAnsCnd[] = $ansCnd;
                            }
                        }*/

                        $this->cnd[] = $ansCnd;
                     }
                }
			  	//26.5.2015 Tanis End
			if($this->les_sql == 8)
			  		{
			  			$tbl .= '</td><td style="height:100%;">
							<div id="dropContainer" style="width:80%;height:100%;border:'.$pBorder.'px black solid">Drop image here</div>
							<script>
							function initSelected()
							{
								var n,d;
								'.$initSelcted.'
							}
							</script>
						</td></tr>';
			  		}




			  	$tbl .= "</table>";


			/*  $tbl .= "
						  <script>
						  $(function(){

								  $(\".imageTicker\").imageTick({
									tick_image_path: \"http://boedesign.com/demos/imagetick/images/check.gif\",
									no_tick_image_path: \"http://boedesign.com/demos/imagetick/images/no_check.gif\"
								  });
								//  $(\"input[type='checkbox']\").css('display','inline');
							  });
						  </script>
					";
			  */


			 // add hidden variable to the page, to have all necessary variable for storing answers ready
			  	if (isset($answersStrNames)) $tbl .= "<input type=hidden name=answersStrNames[] value=\"".implode(",",$answersStrNames)."\">";
			  //20150916 Tanis changed this -> see comment in _class/createQuestion/MultiResponse.php  in SaveQuestions function
					/*if (isset($answersStrNames))
			  	{
			  		if($_SESSION['answersStrNames'][$this->q_name])
						{
							xdebug_break();
							$_SESSION['answersStrNames'][$this->q_name] = array_merge($_SESSION['answersStrNames'][$this->q_name], $answersStrNames);
						}
						else
						{
							//	xdebug_break();
								$_SESSION['answersStrNames'][$this->q_name] = $answersStrNames;
						}
					//	var_dump($_SESSION['answersStrNames']);
				}*/
			  	return $tbl;
		}


		public function designerPrepareCondition()
			{
			//if($this->answers_filter) echo "tralala";
			if($this->must_answer)
			  	{

                    // print $finalCnd;
			  		if(is_array($this->cnd))
			  			$finalCnd = '('. implode( $this->hasLegend ? 'AND' : ' OR ',$this->cnd) . ')';
				  	else
			  			$finalCnd = 'false';



			  		if($this->openAnsCnd && !$this->answers_filter)
			  		{
			  			$finalCnd = '(' . $finalCnd . ' AND '. implode('AND', $this->openAnsCnd ).')';

			  		}
			  		if($_SESSION['mustAnswerCondition'])
			  			$_SESSION['mustAnswerCondition'] .= ' AND '. $finalCnd;
			  		else
			  			$_SESSION['mustAnswerCondition'] = $finalCnd;
			  		$this->answerCnd = $finalCnd;
			  	}
			  	else if($this->openAnsCnd && !$this->answers_filter)
			  	{
			  		if($_SESSION['mustAnswerCondition'])
			  			$_SESSION['mustAnswerCondition'] .= ' AND (' . implode('AND', $this->openAnsCnd ).')';
			  		else
			  			$_SESSION['mustAnswerCondition'] = '(' . implode('AND', $this->openAnsCnd ).')';
			  		$this->answerCnd = '(' . implode('AND', $this->openAnsCnd ).')';
			  	}
			  //	echo $_SESSION['mustAnswerCondition'];
			}

		protected function printEditVar($i,$value,&$arr,$isAnswered)
		{
			return "<input type=hidden name=editVal[{$this->fld[$i]}] value=0 />
			<input type=checkbox name=editVal[{$this->fld[$i]}] value=$value ".($isAnswered ? 'checked': '')." />";
		}
		protected function printEditVarOpen($i,$value,$fldValue)
		{
			return "<textarea name='editVal[{$this->fld['o_'.$fldValue]}]'>$value </textarea>";
		}
}

?>
