<?php 
include '_dirinfo.php';
require_once (PATH_TO_ROOT.'_class/createQuestion/Question.php');
include_once (PATH_TO_ROOT."webcati/init.php");

	class CustomMask extends Question {
		
		private $fieldTypes = array();
		private $filterJS = "";
		
		public function __construct(db $db=null,$data=null) {
			parent::__construct($db,$data);
			
			$this->template_file = "CStemplate.xml";
		}
		
		
		public function addQuestion(array $data) {
			parent::addQuestion($data);
		}

		
		public function updateStructure() {
			include 'config.php';
		  	$this->db->ChangeDatabase($CATI_base);
	  		
	  		$sql = "ALTER TABLE ".$this->project."_structure ADD $this->q_name int(10)";
	  		$this->db->LogWrite($sql, true, "updateStructure");
	  		
	  		$this->db->SQLexecute($sql);
			if($this->db->IsError()) {
		  		echo $this->db->GetError();
		  		return "Error";
		  	}
		}
		
		
		public function getDefaultValues() {
			$arr[] = ',variableTypeBase'; //dataType in field variableTypeBase in project table
			$arr[] = ',4'; //type int(10)
			return $arr;
		}
		
		
		/**
		 * (non-PHPdoc)
		 * @see Question::getStructureFields()
		 * 
		 * function gets the fields for the structure table from the custom mask template
		 * 
		 * @return array of structure fields
		 * 
		 */
		public function getStructureFields($row=null,$onlyMaskFields=false)
		{
			$str = array();
			if(isset($this->fields)) return $this->fields;
			if($onlyMaskFields===false)
				$str[] = $this->q_name.' int(10)'; //add the master question (custom type)
			
			$xml = $this->getMaskXML(); //loads the custom masks XML template
			
			/*foreach ($xml->attributes() as $attr => $value)
			{
				$prop[$attr] = "$value";
			}*/

			//get the custom mask structure with recursive function and add it to the result
			if($xml)
			{
				$str_res = array_merge($str,$this->getChildrenRecursive($xml));
				return $this->fields = $str_res; //return the fields array for creating the structure
			}
			else
				return $this->fields = $str;


		}
		
		
		public function getQType() {
			return "Custom";
		}
		
		
		/**
		 * 
		 * function loads the XML from the custom mask template
		 * 
		 * @return simpleXML object
		 */
		public function getMaskXML()
		{
			if($this->id_mask)
			{
				//then start adding the questions from the mask
				$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE); //change database
				$sql = "SELECT template_xml FROM ".WC_MASK_TEMPLATES." WHERE id = ".$this->id_mask; //load mask XML SQLquery
				$rs = $this->db->SQLexecute($sql); //run the SQLquery
				$row = $this->db->fetchArray($rs); //fetch results
				$curXML = $row[0]; //assign the current XML variable
				$xml = simplexml_load_string( $curXML ); //load the XML string with simpleXML
				
				return $xml; //returns simpleXML object
			}
			else
				return false;
		}
		
		
		
		/**
		 * (non-PHPdoc)
		 * @see Question::createAnswerGrid()
		 * 
		 * function responds on changing the questions properties
		 */
		public function createAnswerGrid()
		{
			//custom mask question type can't have answers
			if($_POST['dataIndex'] == 'odg_sql')
			{
		 		echo "alert('Custom questions can not have answers!');";
			}
			
			//custom mask question type can't have legend
			if($_POST['dataIndex'] == 'leg_sql')
			{
		 		echo "alert('Custom questions can\'t do that!');";
			}
		}
		
		/**
		 * Function gets the child element of a given XML element
		 * 
		 * @return array of results
		 * 
		 * 
		 */
		public function getChildrenRecursive($xmlObj,$depth=0,$parId=null,$lastChild=false,$forFilter=false)
		{
			$result = array();
			$prop = array();
			foreach ($xmlObj->attributes() as $attr => $value)
			{
				$prop[$attr] = "$value";
					//echo "{".$attr.":".$value."}, ";
			}
			
			if(count($xmlObj->children()) == 0) //object is a leaf
			{
				
				switch ($prop['type'])
				{
					case 1006: //text field
						{

							if($forFilter === false)
							{
								if($prop['textType']=="textarea")
									$result[] = $this->q_name."_".$prop['id']." text";
								else
									$result[] = $this->q_name."_".$prop['id']." varchar(255)";
							}
							else
							{
								$result[$this->q_name."_".$prop['id']] = "textfield";
							}
						
								//echo $prop['id'];
						}
						break;
						
					case 1007: //radio item
						{
							if($forFilter === false)
							{
								if($lastChild) //create the question at last radio button
									$result[] = $this->q_name."_".$parId.' varchar(50)';
							}
							else
							{
								$result[$this->q_name."_".$parId."_".$prop['id']] = "radioitem";
							}
						}
						break;
						
					case 1008: //checkbox item
						{
							if($forFilter === false)
								$result[] = $this->q_name."_".$parId."_".$prop['id'].' varchar(50)';
							else
								$result[$this->q_name."_".$parId."_".$prop['id']] = "checkboxitem";
						}
						break;
						
					case 1009: //dropdown item
						{
							if($forFilter === false)
							{
								if($lastChild) //create the question at last radio button
									$result[] = $this->q_name."_".$parId.' varchar(50)';
							}
							else
							{
								$result[$this->q_name."_".$parId."_".$prop['id']] = "dropdownitem";
							}
						}
						break;
				}
			}
			else //object has children
			{
				$numCh = count($xmlObj->children());
		  		$curCh = 0;
			  foreach($xmlObj->children() as $child)
			  {
			  	$curCh++;
			  	//echo str_repeat('-',$depth).">".$child->getName().": ".$subchild."";
			  	//return $this->str_fields[] = $this->q_name."_".$prop['id'].' int(11)';
			  	if($forFilter === true)
			  	{
			  		switch ($prop['type'])
					{
						case 1012: //radio group
						{
			  				$result[$this->q_name."_".$prop['id']] = "radiogroup";
						}
						break;
						
						case 1013: //checkbox group
						{
							$result[$this->q_name."_".$prop['id']] = "checkboxgroup";
						}
						break;
						
						case 1014: //dropdown group
						{
							$result[$this->q_name."_".$prop['id']] = "dropdowngroup";
						}
						break;
					}
			  	}
			    
			  	$result = array_merge($result, $this->getChildrenRecursive($child,$depth+1,$prop['id'],$numCh==$curCh,$forFilter));
			  }
			}
			
			return $result;
			
		}
		
		 /* Function for drawing the answers in an interview
		 *
		 * @return string
		 */
	
		public function designerDrawAnswers()
		{
			$fields = $this->getStructureFields(null);
			$strippedFields = array();
			foreach ($fields as $field)
			{
				$temp = preg_split("/[\s]+/",$field);
				$strippedFields[] = $temp[0];
			}
			
			
			if($e = $this->display->engine)
			{
				$selVals = $e->readDatabaseVariables( $strippedFields,false );
			}
			
			$this->fieldTypes = $this->getFieldTypes();
			/*echo "<pre>";
			print_r($this->fieldTypes);
			echo "</pre>";*/
			$xml = $this->getMaskXML();
			if($xml === false)
			{
				echo "ERROR: You have to select a mask for the custom question!";
				return false;
			}
			else
			{
				$tbl = $this->displayChildren($xml,0,null,null,false,$selVals);
			
				//echo htmlentities($tbl);
				//echo $this->filterJS;
				
				$tbl .= "<script>";
				
				$tbl .= "function checkFilters(){
						".$this->filterJS."
						}";
				
				
				//end of checking filters with an event trigger
				$tbl .= "
						$('#mainForm').change(function(){
							$('#mainForm').find('input', 'select', 'textarea').each(function(i){
								checkFilters();
							});
						}).keyup(function(){
								$('#mainForm').find('input', 'select', 'textarea').each(function(){
								checkFilters();
								});
						}).submit(function(){
							$('#mainForm').find('input', 'select','option','textarea').each(function(){
								$(this).attr('disabled',false);
							});
						});
						
						$(document).ready(function() {	
							$('#mainForm').find('input', 'select', 'textarea').each(function(){
								checkFilters();
								}); //on document load, check filters (initialize form)
								$.datepicker.setDefaults( $.datepicker.regional[ 'sl' ] );
						});
				</script>";
				
				return $tbl;
			}
		}
		
		
		public function designerRequiresTemplate()
		{
			return true;
		}
		
		public function displayChildren($xmlObj,$depth=0,$parId=null,$parType=null,$lastChild=false,$selectedVals=null)
		{
			/*echo "<pre>";
			print_r($selectedVals);
			echo "</pre>";*/
			$tbl = "";
			$html = "";
			$closeTags = "";
			//if parent is a horizontal box we calculate the width and set the height to 100%
			//this is because in some cases both width and height are set, altough only one should be considered
		  	if($parType == 1) 
		  	{
		  	//for 
			  	$mainSize = 'width';
			  	$secSize = 'height';
			  	 	
		  	}//vice versa for vbox
		  	else
		  	{
			  	$mainSize = 'height';
			  	$secSize = 'width';
		 
		  	}
			  
			
			$prop = array();
			foreach ($xmlObj->attributes() as $attr => $value)
			{
				$prop[$attr] = "$value";
					//echo "{".$attr.":".$value."}, ";
			}
			
			if($prop['position'] == 'relative')
			{//add percent if its relative
				$sizeUnit = '%;';
				$style = "style=\"$mainSize:".$prop[$mainSize].$sizeUnit."; $secSize:100%; ";
			}
			else if($prop['position'] == 'absolute')
			{
				$sizeUnit = 'px;';
				$style = "style=\"$mainSize:".$prop[$mainSize].$sizeUnit."; $secSize:100%; ";
			}
			else if($prop['position'] == "auto")
			{
				//let the browser handle it
				$style = "style=\"";
				
			}
			
		  	/*echo $prop['RMclass'];
		  	if($prop['RMclass'])
		  		echo " - ". $this->display->getCssStyles($prop['RMclass']);*/
		  	
		  	//start the style attribute
		  	
		  	
		  	
		  	
			if($parType == 1) //parent is a Horizontal panel, we create a new column
			  { 
			  	if($prop['RMclass'])
				{
					$style .=  $this->display->getCssStyles($prop['RMclass']);
				}
				$style .= "\"";
				$html .= "<td $elId class='RM_panel_designer_basic$this->idTemplate' $style>";
				$closeTagsPar = "</td>";
			  }//if parType == 1
			  else if($parType == 1012) //if we are in a Radio group we create a new radio row (items are one below another)
			  {
			  	$html .= "<br />";
				$closeTagsPar = "";
			  }
			  else if($parType == 1013) //if we are in a Checkbox group we create a new checkbox row (items are one below another)
			  {
			  	$html .= "<br />";
				$closeTagsPar = "";
			  }
			  else if($parType == 1014) //if we are in a Dropdown group we create a new dropdown object (items are in a dropdown)
			  {
			  	$html .= "";
				$closeTagsPar = "";
			  }
		 	  else if($parType == 2) //if we are in a Vertical panel we create a new row (items are one below another)
			  {
				  	$html .= "<tr><td $elId class='RM_panel_designer_basic$this->idTemplate' $size>";
					$closeTagsPar = "</td></tr>";
			  } //else if parType == 2
			  
			  
			  
			
			
			
				//then we write  the leaf children
				switch ($prop['type'])
				{
					//if a hbox and vbox don't have any children we create an empty cell
					case 1: //Hpanel, we create a new panel
						
						if($prop['RMclass'])
							$style .= $this->display->getCssStyles($prop['RMclass']);
						$style .="\"";
				  		$html .= "<table cellpadding=0px cellspacing=0px style=\"width:100%;height:100%\"><tr>";
				  		//$html .= "HPanel";
				  		$closeTags = "</tr></table>";
				  	break;
				  	
				  	case 2: //Vpanel
				  		$html .= "<table cellpadding=0px cellspacing=0px style=\"width:100%;height:100%\">";
				  		//$html .= "Vpanel";
				  		//echo "<br />htmlentity".htmlentities($closeTags)."<br />";
				  		$closeTags .= "</table>";
				  	break;
				  	
					case 1006: //text field
					{
						if($prop['RMclass'])
								$style = "style=\"".$this->display->getCssStyles($prop['RMclass']);
							$style .="\"";
							$html .= $prop['text']." ";
						
						if($prop['textType']=="input")
						{
								
							$html .= "<input $style type=\"text\" name=\"answers[".$this->q_name."_".$prop['id']."]\" id=\"ct_".$this->q_name."_".$prop['id']."\"".
									 " value=\"".($selectedVals[$this->q_name."_".$prop['id']]!="" ? $selectedVals[$this->q_name."_".$prop['id']]:"" )."\" />";
							
							if($prop['quickText']!="") //adding quick texts
							{
								
								$quickTexts = preg_split("/[|]/",$prop['quickText']);
								
								
								//$html .= "<span id=\"ct_".$this->q_name."_".$prop['id']."_quickTexts\">QuickText</span>";
								
								$html .= "<div id=\"ct_".$this->q_name."_".$prop['id']."_qt\" style=\"display: none;\"><b>Hitri vnos</b>";
								foreach($quickTexts as $key => $value)
								{
									$html .= "<br /><a id=\"ct_".$this->q_name."_".$prop['id']."_qt_".$key."\" href=\"#\">".$value."</a>";
								}
								$html .= "</div>";
								$html .= "<script>
									$(function() {
									$(\"#ct_".$this->q_name."_".$prop['id']."\").qtip({
										content: $(\"#ct_".$this->q_name."_".$prop['id']."_qt\"),"; //close the content field
								$html .= "position: {my: 'bottom left', at: 'right top', target: $(\"#ct_".$this->q_name."_".$prop['id']."\") },
										show: 'focus',
										hide: {event: 'blur', delay: 300}
										});";
								foreach($quickTexts as $key => $value)
								{
									$html .= "$(\"#ct_".$this->q_name."_".$prop['id']."_qt_".$key."\").click(function(){
										$(\"#ct_".$this->q_name."_".$prop['id']."\").val(function(index,val){return val + $(\"#ct_".$this->q_name."_".$prop['id']."_qt_".$key."\").text();});
								});";
									
								}
									
								$html .= "});
								</script>";
							}
						}
						elseif($prop['textType']=="textarea")
						{
							$html .= "<textarea $style name=\"answers[".$this->q_name."_".$prop['id']."]\"". 
									 "id=\"ct_".$this->q_name."_".$prop['id']."\">".($selectedVals[$this->q_name."_".$prop['id']]!="" ? $selectedVals[$this->q_name."_".$prop['id']]:"" )."</textarea>";
						}
						elseif($prop['textType']=="datepicker")
						{
							$html .= "<div id=\"datepicker_".$this->q_name."_".$prop['id']."\"></div>";
							$html .= "<input type=\"hidden\"  name=\"answers[".$this->q_name."_".$prop['id']."]\" id=\"ct_".$this->q_name."_".$prop['id']."\"".
									 " value=\"".($selectedVals[$this->q_name."_".$prop['id']]!="" ? $selectedVals[$this->q_name."_".$prop['id']]:"" )."\" />";
							$html .= "<script>
								$(function() {
								$(\"#datepicker_".$this->q_name."_".$prop['id']."\").datepicker({altField: \"#ct_".$this->q_name."_".$prop['id']."\", changeMonth: true, changeYear: true, dayNames: [  \"Nedelja\", \"Ponedeljek\", \"Torek\", \"Sreda\", \"Četrtek\", \"Petek\", \"Sobota\" ], dayNamesMin: [ \"Ne\", \"Po\", \"To\", \"Sr\", \"Če\", \"Pe\", \"So\" ], firstDay: 1 });
								 $(\"#datepicker_".$this->q_name."_".$prop['id']."\").datepicker(\"option\", \"dateFormat\", \"yy-mm-dd\");
								 $(\"#datepicker_".$this->q_name."_".$prop['id']."\").datepicker(\"setDate\", \"".($selectedVals[$this->q_name."_".$prop['id']]!="" ? $selectedVals[$this->q_name."_".$prop['id']]:"" )."\");
								});
							</script>";
						}
						
						if($prop['filterIN']!="") //initialize IN filter if it exists
							$html .= $this->initializeFilters($prop['filterIN'], $this->q_name."_".$prop['id'], "IN");
						
					}
					break;
						
					case 1007: //radio item
						{
							if($prop['value']!="")
								$itemValue = $prop['value'];
							else
								$itemValue = $prop['id'];
								
							$html .= "<input type=\"radio\" name=\"answers[".$this->q_name."_".$parId."]\" id=\"ct_".$this->q_name."_".$parId."_".$prop['id']."\"". 
									 " value=\"".$itemValue."\" ".($selectedVals[$this->q_name."_".$parId]==$itemValue ? "checked":"" )." /> ". $prop['text']; //radio item with text
							
						}
						break;
						
					case 1008: //checkbox item
						{
							if($prop['value']!="")
								$itemValue = $prop['value'];
							else
								$itemValue = $prop['id'];
								
							$html .= "<input type=\"hidden\" name=\"answers[".$this->q_name."_".$parId."_".$prop['id']."]\" value=\"0\" />";
							$html .= "<input type=\"checkbox\" name=\"answers[".$this->q_name."_".$parId."_".$prop['id']."]\" id=\"ct_".$this->q_name."_".$parId."_".$prop['id']."\"".
									" value=\"".$itemValue."\" ".($selectedVals[$this->q_name."_".$parId."_".$prop['id']]==$itemValue ? "checked":"" )." /> ". $prop['text']; //checkbox item with text
						}
						break;
						
					case 1009: //dropdown item
						{
							if($prop['value']!="")
								$itemValue = $prop['value'];
							else
								$itemValue = $prop['id'];
								
								$html .= "<option id=\"ct_".$this->q_name."_".$parId."_".$prop['id']."\" value=\"". $itemValue ."\" ".
											($selectedVals[$this->q_name."_".$parId]==$itemValue ? "selected='selected'":"" ).">" . $prop['text'] . "</option>";
						}
						break;
						
					case 1012: //radio group
						if($prop['RMclass'])
							$style .= $this->display->getCssStyles($prop['RMclass']);
						$style .="\"";
						
						if($prop['filterIN']!="") //initialize IN filter if it exists
							$html .= $this->initializeFilters($prop['filterIN'], $this->q_name."_".$prop['id'], "IN");
						
			  			$html .= "<div id=\"". $this->q_name."_".$prop['id'] ."\" ".$style.">" . $prop['name'];
			  			$html .= "<input type=\"hidden\" name=\"answers[".$this->q_name."_".$prop['id']."]\" />";
			  			$closeTags = "</div>";
			  		break;
			  		
			  		case 1013: //checkbox group
			  			if($prop['RMclass'])
							$style .= $this->display->getCssStyles($prop['RMclass']);
						$style .="\"";
						
						if($prop['filterIN']!="") //initialize IN filter if it exists
							$html .= $this->initializeFilters($prop['filterIN'], $this->q_name."_".$prop['id'], "IN");
							
			  			$html .= "<div id=\"". $this->q_name."_".$prop['id'] ."\" ".$style.">" . $prop['name'];
				  		$closeTags = "</div>";
			  		break;
						
					case 1014: //dropdown group
						if($prop['RMclass'])
							$style .= $this->display->getCssStyles($prop['RMclass']);
						$style .="\"";
						
						if($prop['filterIN']!="") //initialize IN filter if it exists
							$html .= $this->initializeFilters($prop['filterIN'], $this->q_name."_".$prop['id'], "IN");
						
			  			$html .= "<div ".$style.">". $prop['name'];
			  			$html .= "<input type=\"hidden\" name=\"answers[".$this->q_name."_".$prop['id']."]\" />";
			  			$html .= "<br /><select id=\"". $this->q_name."_".$prop['id'] ."\" name=\"answers[".$this->q_name."_".$prop['id']."]\">";
			  			$html .= "<option></option>";
			  			$closeTags = "</select></div>";
			  		break;
			  		
			  		case 1015: //label
			  			if($prop['RMclass'])
							$style .= $this->display->getCssStyles($prop['RMclass']);
						$style .="\"";
			  			$html .= "<div ".$style.">".$prop['text']."</div>";
			  		break;
				}
			
			
			
		  $objHasChild=0;
		  $numCh = count($xmlObj->children());
		  $curCh = 0;
		  $childHtml = null;
		  if($prop['type'] != 6)
			  foreach($xmlObj->children() as $child)
			  {
			  	$curCh++;
			    $childHtml .= $this->displayChildren($child,$depth+1,$prop['id'],$prop['type'],$numCh==$curCh,$selectedVals);
			    $objHasChild = true;
			  }
		  if(!$objHasChild) // if there aren't any children
		  { //if a hbox and vbox don't have any children we create an empty cell
		  	if($prop['type'] == 1)
		  	{
		  		$html .= "<td $size></td>";
		  	}
		  	else if($prop['type'] == 2)
		  	{
		  		$html .= "<tr><td></td></tr>";
		  	}
		  }
		  else if(!$childHtml)//if all children of the element are hidden, we don't show it either
			return '';
		  else $html .= $childHtml;
		  $html .= $closeTags;
		  $html .= $closeTagsPar;
		 // echo htmlentities($html);

		  return $tbl = $html;
		}

		
		/**
		 * 
		 * function gets field types to help the filter creation
		 * checkboxes and radios get checked, dropdown options get selected, text inputs have text values
		 * 
		 * @return array of fieldTypes
		 */
		public function getFieldTypes()
		{
			$xml = $this->getMaskXML(); //loads the custom masks XML template
			
			$str = array();
			
			if($xml)
			{
				$str_res = array_merge($str,$this->getChildrenRecursive($xml,0,null,false,true));
				return $this->fields = $str_res; //return the fields array for creating the structure
			}
			
			
		}
		
		/**
		 * 
		 * function takes the filter, object and direction and creates a filter in jQuery
		 * 
		 * @param string $filter
		 * @param string $object
		 * @param string $direction
		 */
		public function initializeFilters($filter, $object, $direction = 'IN')
		{
	
			$filterStructure = $this->deconstructFilter($filter);
			
			$reconstructedFilter = $this->reconstructFilter($filterStructure);
			$filterAction = $this->constructFilterAction($object,$direction);
			if($reconstructedFilter && $filterAction)
				$this->filterJS .= "if(".$reconstructedFilter.") ".$filterAction;
			
		}
		
		private function constructFilterAction($object, $direction = 'IN')
		{
			$constructedFilterAction = "";
			//echo $object.":".$this->fieldTypes[$object];
			
			switch ($this->fieldTypes[$object])
			{
				case "textfield":
				{
					$constructedFilterAction = "
					{
						$('#ct_".$object."').attr('disabled',false);
						//$('#ct_".$object."').show('highlight');
					}
					else
					{
						$('#ct_".$object."').attr('disabled',true).val('');
						//$('#ct_".$object."').hide('highlight');
					}
					";
				}
				break;
				
				case "dropdowngroup":
				{
					$constructedFilterAction = "
					{
						$('#".$object."').attr('disabled',false);
						//$('#".$object."').show('highlight');
					}
					else
					{
						$('#".$object."').attr('disabled',true).children().attr('selected',false);
						//$('#".$object."').hide('highlight');
					}
					";
				}
				break;
				
				case "radiogroup":
				case "checkboxgroup":
				{
					$constructedFilterAction = "
					{
						$('#".$object."').children().attr('disabled',false);
						//$('#".$object."').show('highlight');
					}
					else
					{
						$('#".$object."').children().attr('disabled',true).attr('checked',false);
						//$('#".$object."').hide('highlight');
					}
					";
				}
				break;
			}
			
			return $constructedFilterAction;
		}
		
		private function reconstructFilter($filterStructure)
		{
			//print_r($filterStructure);
			
			$reconstructedFilter = "";
			
			for($i=0; $i<count($filterStructure); $i++)
			{
				
				if($filterStructure[$i]=="sp")
					$reconstructedFilter .= "( ";
				else if($filterStructure[$i]=="ep")
					$reconstructedFilter .= " )";
				/*else if($filterStructure[$i]=="eq")
					$reconstructedFilter .= " == ";
				else if($filterStructure[$i]=="neq")
					$reconstructedFilter .= " != ";*/
				else if($filterStructure[$i]=="and")
					$reconstructedFilter .= " && ";
				else if($filterStructure[$i]=="or")
					$reconstructedFilter .= " || ";
				else
				{
					if($filterStructure[$i+1]=="eq" || $filterStructure[$i+1]=="neq") //left side of the operator
					{
						//find the ID of the operator
						//echo $filterStructure[$i][0];
						if($filterStructure[$i][0]=="Q" || $filterStructure[$i][0]=="q") //check if it is the ID of the operator
						{
							//construct the id of the operator (append the q_name and strip the first char from the original ID from filter
							$id_of_operator = $this->q_name."_".substr($filterStructure[$i],1,strlen($filterStructure[$i])-1); 
							 switch ($this->fieldTypes[$id_of_operator])
							 {
							 	case "radioitem":
							 	case "checkboxitem":
							 	case "dropdownitem":
							 	{
							 		$reconstructedFilter .= "$('#ct_".$id_of_operator."')";	
							 	}	
							 	break;
							 	
							 	case "textfield":
							 	{
							 		$reconstructedFilter .= "$('#ct_".$id_of_operator."')";
							 	}
							 	break;
							 }
						}
						//$reconstructedFilter .= $filterStructure[$i];
					}
					
					if($filterStructure[$i-1]=="eq") //right side of the operator equals (use .is() function)
					{
						//find the ID of the operator
						//echo $filterStructure[$i][0];
						if($filterStructure[$i-2][0]=="Q" || $filterStructure[$i-2][0]=="q") //check if it is the ID of the operator
						{
							//construct the id of the operator (append the q_name and strip the first char from the original ID from filter
							$id_of_operator = $this->q_name."_".substr($filterStructure[$i-2],1,strlen($filterStructure[$i-2])-1);
							//echo $this->fieldTypes[$id_of_operator];
							 switch ($this->fieldTypes[$id_of_operator])
							 {
							 	case "radioitem":
							 	case "checkboxitem":
							 	{
							 		$reconstructedFilter .= ".is(':checked')";	
							 	}	
							 	break;
							 	
							 	case "dropdownitem":
							 	{
							 		$reconstructedFilter .= ".is(':selected')";
							 	}
							 	break;
							 	
							 	case "textfield":
							 	{
							 		$reconstructedFilter .= ".val()==".$filterStructure[$i];
							 	}
							 	break;
							 }
						}
					}
					
					if($filterStructure[$i-1]=="neq") //right side of the operator not equals (use .not() function)
					{
						//find the ID of the operator
						//echo $filterStructure[$i][0];
						if($filterStructure[$i-2][0]=="Q" or $filterStructure[$i-2][0]=="q") //check if it is the ID of the operator
						{
							//construct the id of the operator (append the q_name and strip the first char from the original ID from filter
							$id_of_operator = $this->q_name."_".substr($filterStructure[$i-2],1,strlen($filterStructure[$i-2])-1);
							//echo $this->fieldTypes[$id_of_operator];
							 switch ($this->fieldTypes[$id_of_operator])
							 {
							 	case "radioitem":
							 	case "checkboxitem":
							 	{
							 		$reconstructedFilter .= ".is(':checked')==false";	
							 	}	
							 	break;
							 	
							 	case "dropdownitem":
							 	{
							 		$reconstructedFilter .= ".is(':selected')==false";
							 	}
							 	break;
							 	
							 	case "textfield":
							 	{
							 		$reconstructedFilter .= ".val()!=".$filterStructure[$i];
							 	}
							 	break;
							 }
						}
					}
				}
				
			}
			
			return $reconstructedFilter;
		}
		
		private function deconstructFilter($filter)
		{
			//echo $filter;
			$inString = false; //indicates if in the middle of the conditional string value
			$fromCounter = 0; //a delayed record counter, for recording actual values in the expression
			$filterStructure = array();
			$fc = $filter; //make a copy of the filter
			//echo "Filter length: ".strlen($filter);
			//echo "<br />Deconstructing<br />";
			
			for($i=0; $i<strlen($fc); $i++)
			{
				//echo $fc[$i];
				//echo "i = ".$i." and fromCounter = ".$fromCounter."<br />";
				
				
			if($fc[$i]=="\"")
				{
					//echo $fc[$i].$fc[$i+1];
					//echo $fc[$i-1];
					
					if($fc[$i-1]=="\\") //if quote is preceeded with a backslash, escape
					{
						//escaped, proceed
						//echo $i. "= ".$inString." - escaped<br />";
					}
					else
					{
						//not escaped, close or open string
						if($inString===false)
						{
							$inString = true; //open string
						}
						else
						{
							$inString = false; //close string
						}
					}
					//$filterStructure[] = "narekovaj";
					//echo $i. "= ".$inString."<br />";
				}
				
				
				
				if(preg_match("/[()!=&|]/", $fc[$i]) || ($i == strlen($fc)-1)) //check if any of controlling characters or end of condition
				{
					if($fromCounter < $i) //if there were some characters left out, let's record them now
					{
						if($fc[$fromCounter+1]=="\"" || $fc[$fromCounter]=="\"")
						{
							 //string condition, do some validation when it ends, to skip controlling characters in a string
							 //echo "inString";
						}
						
						if($inString === false)
						{
							if($i == strlen($fc)-1)
								$leftOutString = substr($fc,$fromCounter,$i-$fromCounter+1); //correction for filters not ending in a controlling character
							else
								$leftOutString = substr($fc,$fromCounter,$i-$fromCounter);
							
							$leftOutString = trim($leftOutString);
							if(strlen($leftOutString)>0)
								$filterStructure[] = $leftOutString; 
							$fromCounter = $i;
						}
					}
						//$filterStructure[] = "found $fc[$i]";
				}
				
				if($fc[$i]=="(") //starting parenthesis
				{
					if($inString===false) //escape
					{
						$filterStructure[] = "sp"; //record a starting parenthesis
						$fromCounter = $i+1;
					}
				}
				
				
				
				if($fc[$i]==")") //ending parenthesis
				{	
					if($inString===false) //escape
					{
						$filterStructure[] = "ep"; //record an ending parenthesis
						$fromCounter = $i+1;
					}
				}
				
				if($fc[$i]=="!") //exclamation point (perhaps a not equal operator? let's check)
				{
					if($inString===false) //escape
					{
						 
						if($fc[$i+1]=="=") //definitely a not equal operator. let's record
						{
							$filterStructure[] = "neq"; //record a not equal operator
							$i++; //skip the next character (we already know the value)
							$fromCounter = $i+1;
						}
					}
				}
				
				if($fc[$i]=="=") //equals sign (perhaps an equals operator? let's check)
				{
					if($inString===false) //escape
					{
						if($fc[$i+1]=="=") //definitely an equals operator. let's record
						{
							$filterStructure[] = "eq"; //record an equals operator
							$i++; //skip the next character (we already know the value)
							$fromCounter = $i+1;
						}
					}
				}
				
				if($fc[$i]=="&") //ampersand character (perhaps an AND operator? let's check)
				{
					if($inString===false) //escape
					{
						if($fc[$i+1]=="&") //definitely an AND operator. let's record
						{
							$filterStructure[] = "and"; //record an AND operator
							$i++; //skip the next character (we already know the value)
							$fromCounter = $i+1;
						}
					}
				}
				
				if($fc[$i]=="|") //pipe character (perhaps an OR operator? let's check)
				{
					if($inString===false) //escape
					{
						if($fc[$i+1]=="|") //definitely an OR operator. let's record
						{
							$filterStructure[] = "or"; //record an OR operator
							$i++; //skip the next character (we already know the value)
							$fromCounter = $i+1;
						}
					}
				}
				
			}
			
			//echo "<br /><pre>";
			//print_r($filterStructure);
			//echo "</pre>";
			
			return $filterStructure; //return the deconstructed filter structure
		}
		
		public function getIconCls() {
			return 'icon-question_sc';
		}
		
	}

?>