<?php

class liveupdate {

	public $client_project;
	private $serverAddress;
	private $versionsToDownload = array();
	private $clientVersion;
	private $zipFilesPath;
	private $localContainer;
	private $dbConfig;
	private $newLine = "\n";
	private $space = "\t";

	private $outputLog;

	private $clientRequest;

	private $currentVersion;

	private $sqlCnt;


	public function __construct($db) {
		$this->db = $db;
		// default setup, which table records should be transfered from client to server

	}

	/**
	 * Define server address
	 *
	 * @param string $aPath
	 */
	public function SetServerAddress($aPath) { $this->serverAddress = $aPath; }

	public function SetDatabaseConfig($aConfig) { $this->dbConfig = $aConfig; }

	public function SetProperty($name, $value)
	{
		$this->$name = $value;
	}

	public function GetOutputLog()
	{
		return $this->outputLog;
	}

	/**
	 * define version of program and database on client side
	 *
	 * @param string $a
	 */
	public function SetClientVersion($a, $sqlCnt = null)
	{
		$this->clientVersion = $a;
		$this->sqlCnt = $sqlCnt;
	}
	public function SaveClientVersion() {
//		$sql = "UPDATE ".DB_WARPIT_MAIN."._WarpitConfig  SET cValue = '".$this->clientVersion."' WHERE cName = 'capi_client_version'";

		$sql = "UPDATE " . DB_WARPIT_LIVEUPDATE . "._LiveUpdateClientVersion SET current_version = '" . $this->clientVersion . "', sql_count = '0'";
		//$sql = "UPDATE " . DB_WARPIT_LIVEUPDATE . "._LiveUpdateClientVersion SET current_version = '" . $this->clientVersion . "', sql_count = '" . $this->sqlCnt . "'";
		$this->db->SQLexecute($sql);
	}

	public function GetCurrentClientVersion()
	{
			$sql = "SELECT * FROM " . DB_WARPIT_LIVEUPDATE . "._LiveUpdateClientVersion LIMIT 1";
			$res = $this->db->SQLexecute($sql);
			$zad = $this->db->fetchAssoc($res);

			$this->SetClientVersion($zad['current_version'], $zad['sql_count']);
 	}

	/**
	 * define http remote path where we can find update files
	 *
	 * @param string $a
	 */
	public function SetZipFilesPath($a) { $this->zipFilesPath = $a; }

	/**
	 * absolute path to local container, where I will save updates
	 *
	 * @param string $a
	 */
	public function SetLocalFileContainer($a) { $this->localContainer = $a; }


	/**
	 * all informations from user needed to make complete live update
	 *
	 * @param unknown_type $ar
	 */
	public function SetUserParameter($ar = array()) {
		foreach ($ar as $key=>$val) $this->UserParams[$key] = $val;
	}


	/**
	 * Check for new versions on server and manage them
	 * Function returns array with all version numbers which are missing on client side
	 *
	 * @return unknown
	 */
	public function curl_getVersionControl() {

	//	$this->SetClientVersion($aCurrentVersion);

		if(!$this->clientVersion) $this->GetCurrentClientVersion();

		$this->VersionLOG['start'] = $this->clientVersion;
		$this->VersionLOG['stop'] = $this->clientVersion;
		//echo $this->serverAddress;
		$ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL,$this->serverAddress.$this->version_script."?client_version=".$this->clientVersion."&client-machine-id=".$this->UserParams['client-machine-id'] . "&user_id=" . $_SESSION['UserInfo']['id']);
	        curl_setopt($ch, CURLOPT_FAILONERROR,1);
	        curl_setopt($ch, CURLOPT_FOLLOWLOCATION,1);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
	        curl_setopt($ch, CURLOPT_TIMEOUT, $this->UserParams['connection_timeout']);
					//20160201 Tanis
					curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $this->UserParams['ssl_verify']);
					curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->UserParams['ssl_verify']);
					//20160201 Tanis END
	        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
	        $xmlValue = curl_exec($ch);
			if (!$xmlValue) {
		//		echo curl_error($ch);
				$this->versionsToDownload = array("success" => false, "error" => curl_error($ch));
				return  $this->versionsToDownload;
			}

	        curl_close($ch);
	 		// echo htmlspecialchars($xmlValue);

  		$oXML = new SimpleXMLElement($xmlValue);
			foreach ($oXML->version as $ver)
			{

			//	$this->versionsToDownload[] = $ver->file_program_ver;
				$this->versionsToDownload[] = array(
					"version" => (string)$ver->file_program_ver,
					"checksum" =>(string) $ver->checksum
				);
			}
			return $this->versionsToDownload;


	}


	function doVersionUpdate() {


		$clientUpdate = new ClientUpdate();
		$clientUpdate->addVersions($this->versionsToDownload);

		// we don't have nothing to do
		if (!$this->versionsToDownload) exit;

		// now go step by step and do next action
		// 1. download oldest update
		// 2. unpack it
		// 3. update programs
		// 4. update webprojects directory
		// 5. update sql
		// 6. execute update scripts
		// 7. define new client version

		foreach ($this->versionsToDownload as $currentVersion) {

				$ver = $currentVersion['version'];
			// 1. download update
				$downloadStatus = $this->curl_getFromServer($currentVersion);
			//	unlink($this->localContainer."version_".$ver.".zip");
			//	copy($this->localContainer."version_".$ver."_1.zip", $this->localContainer."version_".$ver.".zip");
				if ($downloadStatus['success']) {

					// 2. unpack it

					if(!file_exists($this->localContainer."version_".$ver.".zip"))
					{
							$clientUpdate->brokenZipFile("Zip file doesn't exists");
							break;
					}

					$zip = new ZipArchive();
					$res = $zip->open($this->localContainer."version_".$ver.".zip");
					if($res === TRUE)
					{
					$zip->extractTo($this->localContainer.$ver.'/');
					$zip->close();
					}
					else
					{
							$clientUpdate->brokenZipFile($res);
							break;
					}

					if(!file_exists($this->localContainer.$ver.'/file-action.xml'))
					{
							$clientUpdate->brokenXMLFile("File doesn't exists!");
							$clientUpdate->toString();
							break;
					}

					try
					{
					$oXML = new SimpleXMLElement(file_get_contents($this->localContainer.$ver.'/file-action.xml'));
					}
					catch (Exception $e)
					{
						$clientUpdate->brokenXMLFile($e);
						break;
					}

					foreach ($oXML->file as $file) {

						if ($file->type == 1) {
							// 3. update programs
							//echo WARPIT_ABSOLUTE.$file->directory."<br>";
							$p = "";
							foreach (explode("/",$file->directory) as $d) {
								if ($p) $p = $p."/".$d;
									else $p = $d;
								//echo WARPIT_ABSOLUTE.$p."<br>";
								@mkdir(WARPIT_ABSOLUTE.$p);
							}

							//mkdir(WARPIT_ABSOLUTE.$file->directory);
							if(copy($this->localContainer.$ver."/Warpit/".$file->directory.$file->filename, WARPIT_ABSOLUTE.$file->directory.$file->filename))
							{
							$clientUpdate->addFile(WARPIT_ABSOLUTE.$file->directory.$file->filename, ClientUpdate::FILETYPE_WARPIT);
							}
							else
							{
								$clientUpdate->copyFileFaild(WARPIT_ABSOLUTE.$file->directory.$file->filename, ClientUpdate::FILETYPE_WARPIT);
								break;
							}

						} elseif ($file->type == 2) {
							// 4. update webprojects
							$p = "";
							foreach (explode("/",$file->directory) as $d) {
								if ($p) $p = $p."/".$d;
									else $p = $d;
						//		echo WARPIT_WEBPROJECTS.$p."<br>";
								@mkdir(WARPIT_WEBPROJECTS.$p);
							}

					//		echo WARPIT_WEBPROJECTS.$file->directory."<br>";

							if(copy($this->localContainer.$ver."/WebProjects/".$file->directory.$file->filename, WARPIT_WEBPROJECTS.$file->directory.$file->filename))
							{
							$clientUpdate->addFile(WARPIT_ABSOLUTE.$file->directory.$file->filename, ClientUpdate::FILETYPE_WEBPROJECTS);
							}
							else
							{
								$clientUpdate->copyFileFaild(WARPIT_ABSOLUTE.$file->directory.$file->filename, ClientUpdate::FILETYPE_WEBPROJECTS);
								break;
							}
						} else {
							// 5. update sql
							// open complete file for each database and with explode i recieve sql statements in array
							$sql_statements = explode("<stat>",file_get_contents($this->localContainer.$ver.'/SQL_files/'.$file->filename));
							// now we will run every sql statement
							//echo "<b><big>".$file->database." - ".$this->dbConfig[strval($file->database)]."</big></b><br />";
							$this->db->ChangeDatabase($this->dbConfig[strval($file->database)]);

							$sql_statements = array_filter($sql_statements);
							$clientUpdate->addSQLCnt(count($sql_statements));

							$cnt = 1;
					//		$lastExecuted = 0;
							foreach ($sql_statements as $sql) {
								if($cnt > $this->sqlCnt || $this->sqlCnt == 0)
								{
										// TODO: this check is not ok.... it is only for first line in file which is always empty and returns some stupid characters
										if (strlen($sql) < 10) continue;
										//echo $sql."<hr>";
										if (substr($sql,0,7) == "#BACKUP") {
											$tmp = explode(" ",$sql);
											$sql = "SHOW TABLES LIKE '".trim($tmp[1])."'";
											//echo $sql."<br>";
											$res = $this->db->SQLexecute($sql);
											if ($this->db->NumRows($res)) {
												$sql = "CREATE TABLE BACKUP_".trim($tmp[1])."_".time()." DEFAULT CHARACTER SET 'utf8' SELECT * FROM ".trim($tmp[1]);
												//echo $sql."<br>";
											}
										}
										try
										{
											$this->db->SQLexecute($sql);
											$clientUpdate->addSQL($sql);

										} catch (Exception $e)
										{
											/*print "<pre>";
											var_dump($e);
											print "</pre>";
											*/$clientUpdate->addSQL($sql, false);
											break;
										}
									}

									$cnt++;
							}

						}
					}
					// 6. execute update scripts
					if(!$clientUpdate->isFaild())
					{
						$sql = "SELECT * FROM " . DB_WARPIT_LIVEUPDATE . "._LiveUpdateScripts WHERE active = 1";
						$res = $this->db->SQLexecute($sql);

						$executed = array();

						while ($zad = $this->db->fetchAssoc($res))
						{
								$scriptPath =  $zad['script_path'];
								$scriptId = $zad['id'];

								$path = WARPIT_WEBPROJECTS .$scriptPath;
								$exstension = pathinfo($path, PATHINFO_EXTENSION);

								$status = ScriptStatus::EXECUTION_SUCCESSFULL;
								if(strlen($scriptPath) < 5)	$status = ScriptStatus::ERROR_SCRIPT_NOT_VALID;
								else if($exstension != "php") $status = ScriptStatus::ERROR_WRONG_EXTENSION;
								else if(!file_exists($path)) $status = ScriptStatus::ERROR_SCRIPT_NOT_FOUND;
								else
								{
									//TODO better error catching
										try
										{
											//20160816 Bojan Orter - We add script parameters variable,
											//we also change include_once into include so the code works if we include same file more then once
											$scriptParams = json_decode($zad["paramsJSON"]);
											include($path);
											$status = ScriptStatus::EXECUTION_SUCCESSFULL;
											$executed[] = $scriptId;
										}
										catch (Exception $e)
										{
												$status = ScriptStatus::EXECUTION_FAILD;
										}
								}

								$clientUpdate->addScript($scriptPath, $status);

								if($status != ScriptStatus::EXECUTION_SUCCESSFULL) break;

						}

						if(count($executed))
						{
								$sql = "UPDATE " . DB_WARPIT_LIVEUPDATE . "._LiveUpdateScripts SET active = 0 WHERE id IN(" . implode(",", $executed) . ")";
								$this->db->SQLexecute($sql);
						}
					}

				//		echo "<p>Upgrade to version <b>".$ver."</b> finished</p>";
					// 7. define new client version
					$currentVersion = $clientUpdate->getLastSuccessVersion();
					$currentSqlCnt = $clientUpdate->getCurrentSQLcnt();

					//var_dump($currentVersion);
					//if the first update was not sucessfull we don't need to update version number
					if(!$currentVersion) {
							$currentVersion = $this->clientVersion;

							//if previus execution was unsecesfull we check if we have any additional sqls that were executed succcessfully. If we have them we update sql_count
							if($currentSqlCnt > 0)
							{
									//print "Current sql cnt: " . $currentSqlCnt . "<br/>";
									$currentSqlCnt += $this->sqlCnt;
							}
							else
							{
									$currentSqlCnt = $this->sqlCnt;
							}
					}

					$this->VersionLOG['upgrade'][] = $currentVersion;
					$this->VersionLOG['stop'] = $currentVersion;

					$this->SetClientVersion($currentVersion, $currentSqlCnt);
					$this->SaveClientVersion();


					/*	$this->VersionLOG['upgrade'][] = $ver;
						$this->VersionLOG['stop'] = $ver;

						$this->SetClientVersion($ver);
				//		$this->SaveClientVersion();*/
				}
				else
				{
					$reason = DownloadErrors::UNKNOWN_ERROR;
					if($downloadStatus['checksumFaild'])
					{
						$reason = DownloadErrors::WRONG_CHECKSUM;
					}
/*	$returnStatus['success'] = false;
	$returnStatus['serverError'] = true;
	$returnStatus['serverResponseCode'] = $responseCode;*/
					if($downloadStatus['serverError'])
					{
							if($downloadStatus['serverResponseCode'] == 500) $reason = DownloadErrors::SERVER_INTERNAL_ERROR;
							else if($downloadStatus['serverResponseCode'] == 404) $reason = DownloadErrors::SERVER_NOT_FOUND;
							else $reason = DownloadErrors::SERVER_OTHER_ERROR;
					}

					$clientUpdate->downloadFaild($reason);
			/*		$clientUpdate->toString();
					 print "napaka uspešno ulovljena";*/
				}

	//			var_dump($clientUpdate->isFaild());
				//if previous update faild we can't continiu with update
				if($clientUpdate->isFaild()) break;

				$clientUpdate->nextVersion();
		}

		/*$currentVersion = $clientUpdate->getLastSuccessVersion();
		$currentSqlCnt = $clientUpdate->getCurrentSQLcnt();

		//var_dump($currentVersion);
		//if the first update was not sucessfull we don't need to update version number
		if(!$currentVersion) {
				$currentVersion = $this->clientVersion;

				//if previus execution was unsecesfull we check if we have any additional sqls that were executed succcessfully. If we have them we update sql_count
				if($currentSqlCnt > 0)
				{
						//print "Current sql cnt: " . $currentSqlCnt . "<br/>";
						$currentSqlCnt += $this->sqlCnt;
				}
				else
				{
						$currentSqlCnt = $this->sqlCnt;
				}
		}

		$this->VersionLOG['upgrade'][] = $currentVersion;
		$this->VersionLOG['stop'] = $currentVersion;

		$this->SetClientVersion($currentVersion, $currentSqlCnt);
		$this->SaveClientVersion();
*/
		$log = new LiveUpdateLogDownload($clientUpdate);
		$log->buildLog();

		//$clientUpdate->toString();

		return $log;

	}

	public function curl_getFromServer($versionData) {

			$aVer = $versionData['version'];
			$checksum  = $versionData['checksum'];

			$ch = curl_init();
			$fp = fopen($this->localContainer."version_".$aVer.".zip", "w");

			curl_setopt($ch, CURLOPT_USERAGENT, "'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:15.0) Gecko/20120427 Firefox/15.0a1'");

			curl_setopt($ch, CURLOPT_URL,$this->zipFilesPath."version_".$aVer.".zip");

			curl_setopt($ch, CURLOPT_FAILONERROR, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_AUTOREFERER, true);
			curl_setopt($ch, CURLOPT_BINARYTRANSFER,true);
			curl_setopt($ch, CURLOPT_TIMEOUT, $this->UserParams['connection_timeout']);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
			//20160201 Tanis
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $this->UserParams['ssl_verify']);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->UserParams['ssl_verify']);
			//20160201 Tanis END
			curl_setopt($ch, CURLOPT_FILE, $fp);
			$status = curl_exec($ch);

			$responseCode = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
			curl_close($ch);

//			print "Response code: " . $responseCode;

			$returnStatus = array();
			if($responseCode == 200 && $status)
			{
					$returnStatus['success'] = true;
			}
			else
			{
					$returnStatus['success'] = false;
					$returnStatus['serverError'] = true;
					$returnStatus['serverResponseCode'] = $responseCode;
			}


			$localChecksum = md5_file($this->localContainer."version_".$aVer.".zip");
			if($checksum != $localChecksum)
			{

					$returnStatus['success'] = false;
					$returnStatus['checksumFaild'] = true;
					return $returnStatus;
			}

			return $returnStatus;
	}


	public function curl_sendToServer($xml, $projName = null) {

		$projDatab = DB_WARPIT_WEBCATI_BASE.".".$projName."_structure";
		//We remove records with empty subarrays
		$filteredUpdateDefine = array_filter($this->uploadUpdateDefine);
		if ($filteredUpdateDefine) {
		//if ($this->uploadUpdateDefine[$projDatab]) {

			$ch = curl_init($this->serverAddress.$this->recieve_script);
			//file_put_contents("C:/testxml.xml", urldecode($xml));
			//var_dump(sizeof(urlencode($xml)));
			curl_setopt($ch, CURLOPT_POST, 1);
			$params = array(
				'client-machine-id' => $this->UserParams['client-machine-id'],
				'user_id=' => $_SESSION['UserInfo']['id'],
				'PostData' => $xml
			);


			$this->outputLog[$projDatab][] = "Number of records send to server: ".count($ids);

			//curl_setopt($ch, CURLOPT_POSTFIELDS,"client-machine-id=".$this->UserParams['client-machine-id']."&PostData=".urlencode($xml));
			curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
			//var_dump(mb_strlen (http_build_query($params)));

			//20160201 Tanis
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $this->UserParams['ssl_verify']);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->UserParams['ssl_verify']);
			//20160201 Tanis END
			curl_setopt($ch, CURLOPT_SAFE_UPLOAD, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

			$response = curl_exec($ch);
		//	var_dump($response);
			//echo $response;
			$responseCode = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
			$server = new ServerResponse();
			$server->setProjName($projName);
			$server->parseResponse($response, $responseCode, curl_error($ch));

			if($server->updateNeeded())
			{
				$updateData = $server->getIdsForUpload();

				foreach($updateData as $datab => $ids)
				{
						$sql = "UPDATE ".$datab." SET flag_cli = 1 WHERE id IN (" . $ids .")";

						//print $sql . "</br>";

						try
						{
								$this->db->SQLexecute($sql);
								$server->addUpdatedIds($datab, $ids);
						} catch (Exception $e)
						{
								//TODO catch some error
						}

				}
			}
			$log = new LiveUpdateLogUpload($this->clientRequest, $server);
			$log->buildLog();

			return $log->toArray();
		}}
		//	$responsArray = json_decode($response, TRUE);

	//			var_dump($response);

		//		print "<br>";
		/*	var_dump($responsArray);
			if ($responsArray['success']) {
			//	echo "<h1>Upload informations</h1>";
				// because transfer of file was ok, I update all transfered records as done


				foreach ($this->uploadUpdateDefine as $datab => $ids) {
					if (count($ids)) {
		//				echo "<h2> Number of records: ".count($ids)."</h2>";

						$this->outputLog[$datab][] = $responsArray['msg'];
						$sql = "UPDATE ".$datab." SET flag_cli = 1 WHERE id IN (".implode(",",$ids).")";
				//		echo $sql."<br>";
						try
						{
								$this->db->SQLexecute($sql);
								$this->outputLog[$datab][] = "All the records are marked as uploaded: ";
						}catch(Exception $e)
						{
							$this->outputLog[$datab][] = "<span style='color:red'>Can't mark as uploaded</span>";;
						}


						//echo "<p>".$this->lab[$datab]." <b>".count($ids)."</b> record(s)</p>";
			//			$this->outputLog[] = "<p>".$this->lab[$datab]." <b>".count($ids)."</b> record(s)</p>";

					}
					else {
						$this->outputLog[$datab][] = "No data for upload";
					}

				}

				//echo "<h2>Update to server done!</h2>";
			}
			else if($responsArray['insertedIds'])
			{
					foreach($responsArray['insertedIds'] as $database => $table)
					{
							if($database == "table_warpit_webcati_base") $localDbName = DB_WARPIT_WEBCATI_BASE;
							else $localDbName = DB_WARPIT_LIVEUPDATE;

							foreach($table as $tableName => $ids)
							{
									$datab = $localDbName . "." . $tableName;
									$this->outputLog[$datab][] = "<span style='color:red'>" . $responsArray['msg'] . "</span>";
									$this->outputLog[$datab][] = "<span style='color:red'>Not all of the records were saved!</span>";
									$this->outputLog[$datab][] = "<span> We have saved " . count($ids) . " of " . count($this->uploadUpdateDefine[$datab]) ." records</span>";

									$sql = "UPDATE ".$datab." SET flag_cli = 1 WHERE id IN (".implode(",",$ids).")";

									try
									{
											$this->db->SQLexecute($sql);
											$this->outputLog[$datab][] = "<span>" . count($ids) . " of " . count($this->uploadUpdateDefine[$datab])  ." are marked as uploaded.</span>";
									}catch(Exception $e)
									{
										$this->outputLog[$datab][] = "<span style='color:red'>Can't mark as uploaded</span>";;
									}
							}

					}
			}

			else {
				//echo "<h2>".curl_error($ch)."</h2>";
					if($responsArray['msg'])
					{
				//		print $responsArray['SQL'];

						if($responsArray['database'] == "table_warpit_webcati_base") $localDbName = DB_WARPIT_WEBCATI_BASE;
						else $localDbName = DB_WARPIT_LIVEUPDATE;

						$datab = $localDbName ."." . $responsArray['table'];
						print $datab . "<br>";
						if($projectName == $datab)
							$log = "<span style='color:red'>" . $responsArray['msg'] . "</span>";
						else $this->outputLog[$projDatab][] = "No data to upload!";
					}
					else
					{
						$responseCode = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
					//	print $responseCode;
						if($responseCode == 404) $log = "<span style='color:red'>Can't connect to the server, got 404 code</span>";
						else if($responseCode == 500) $log = "<span style='color:red'>Uknown error on server, got 500 code</span>";
						else $log = "<span style='color:red'>Unknown error, got " . $responseCode . " error</span>";

						if(curl_error($ch)) $log = "<span style='color:red'>" . curl_error($ch) . "</span>";
					}
						$this->outputLog[$projDatab][] = $log;
			//	$this->outputLog[] = "<h2>".curl_error($ch)."</h2>";
			}
			curl_close($ch);

		} // end if ($this->uploadUpdateDefine)
		//else echo "<h2>No data to upload!</h2>";
		else $this->outputLog[$projDatab][] = "No data to upload!";*/

	//}

	public function prepareLocalRecords() {


		unset($this->uploadUpdateDefine);

		$this->clientRequest = new ClientRequest();


		if ($this->UserParams['user_id'] && $this->UserParams['id_project'])
		{

			$sql = "SELECT id,proj_name FROM ".DB_WARPIT_WEBCATI_BASE."._Projects WHERE id = ".$this->UserParams['id_project'];

			$res = $this->db->SQLexecute($sql);
			$zad = $this->db->fetchAssoc($res);
			$projectName = $zad['proj_name'];
			$projectId = $zad['id'];

			// visits

			$sql = "SELECT * FROM ".DB_WARPIT_WEBCATI_BASE."._Capi_interviewer_visits
						WHERE user_id = ".$this->UserParams['user_id']." AND ( flag_cli IS NULL OR flag_cli != 1 ) AND id_project = " . $this->UserParams['id_project'];
			$res = $this->db->SQLexecute($sql);

			$tb = DB_WARPIT_WEBCATI_BASE."._Capi_interviewer_visits";
			$this->lab[$tb] = "Informations about visit and appointments: ";


			if($this->db->NumRows($res))
	  		$this->outputLog[$tb][] = "<span>Informations about visit and appointments: " . $this->db->NumRows($res) . " record(s)</span>";



			while ($zad = $this->db->fetchAssoc($res)) {
				$this->clientRequest->addRecord($tb, $zad['id'], $projectName);

				$this->uploadUpdateDefine[$tb][] = $zad['id'];
				$list = array();

				$record .= "<record>".$this->newLine;
					$record .= $this->space."<database>table_warpit_webcati_base</database>".$this->newLine;
					$record .= $this->space."<table>_capi_interviewer_visits</table>".$this->newLine;
					$record .= $this->space."<fields>".$this->newLine;
						foreach ($zad as $key=>$val) { $record .= $this->space.$this->space."<".$key.">".$val."</".$key.">".$this->newLine;  $list[] = $key; }
					$record .= $this->space."</fields>".$newLine;
					$record .= $this->space."<listFields>".implode(",",$list)."</listFields>".$this->newLine;
				$record .= "</record>".$this->newLine;
			}


			/* -------------------------------------------------------------
				 ----             PROJECTS								                ----
				 -------------------------------------------------------------*/

			/*
			$sql = "SELECT * FROM ".DB_WARPIT_WEBCATI_BASE.".".$zad['proj_name']."_structure
						WHERE 	status = 1
							AND user_id = ".$this->UserParams['user_id']." AND ( flag_cli IS NULL OR flag_cli != 1 ) ";
			*/

			$tb = DB_WARPIT_WEBCATI_BASE.".".$projectName."_structure";

			$sql = "SELECT * FROM " . $tb .  "
						WHERE  user_id = ".$this->UserParams['user_id']." AND ( flag_cli IS NULL OR flag_cli != 1 ) ";

				//		print $sql;

	//		$tb = DB_WARPIT_WEBCATI_BASE.".".$projectName."_structure";
			//$sql = "SELECT * FROM ".DB_WARPIT_WEBCATI_BASE.".".$projectName."_structure ";
			//echo $sql."<br>";

			try
			{
				$res = $this->db->SQLexecute($sql);
			}
			catch (Exception $e)
			{
					$this->clientRequest->reportMissingTable($tb, $projectName);
					return $record;
			}


			//$this->lab[$tb] = "Informations about interview [<b>".$zad['proj_name']."</b>] : ";

			$this->outputLog[$tb][] = "<span style='font-size:20px'>Information for project <b>" .  $projectName. "</b>:</span>";
			$this->outputLog[$tb][] = "Number of records: " . $this->db->NumRows($res);

			$this->uploadUpdateDefine[$tb] = array();

			while ($zad_record = $this->db->fetchAssoc($res)) {

				$this->clientRequest->addRecord($tb, $zad_record['id'], $projectName);
				//echo $zad['id']."<br>";
				//echo $zad_record['id'] . "<br>";
				$list = array();

			//	if ( $zad_record['status'] == 1 ) $this->uploadUpdateDefine[$tb][] = $zad_record['id'];

				$this->uploadUpdateDefine[$tb][] = $zad_record['id'];

				$record .= "<record>".$this->newLine;
					$record .= $this->space."<database>table_warpit_webcati_base</database>".$this->newLine;
					$record .= $this->space."<table>".$projectName."_structure</table>".$this->newLine;
					$record .= $this->space."<id_project>".$projectId."</id_project>".$this->newLine;

					$record .= $this->space."<fields>".$this->newLine;
						foreach ($zad_record as $key=>$val) {
							if (is_null($val) && $key != "id_clien") continue;
							$record .= $this->space.$this->space."<".$key.">".htmlspecialchars($val)."</".$key.">".$this->newLine;
							$list[] = $key;
						}
					$record .= $this->space."</fields>".$this->newLine;
					$record .= $this->space."<listFields>".implode(",",$list)."</listFields>".$this->newLine;
				$record .= "</record>".$this->newLine;


			}
			unset($zad,$zad_record);
		}
		/* -------------------------------------------------------------
		   ----             SPECIAL DATA FROM CLIENT                ----
		   -------------------------------------------------------------*/


		// Preparing all informations for liveupdate Monitor
		$record .= "<updateMonitor>".$this->newLine;

			// time which produces php
			$record .= $this->space."<phpDate>".date("Y-m-d H:i:s")."</phpDate>".$this->newLine;

			// date time produced by mysql
			$sql = "SELECT NOW() as sqlDate";
			$res = $this->db->SQLexecute($sql);
			$zad = $this->db->fetchAssoc($res);
			$record .= $this->space."<sqlDate>".$zad['sqlDate']."</sqlDate>".$this->newLine;

			// user which is doing live update
			$record .= $this->space."<user_id>".$this->UserParams['user_id']."</user_id>".$this->newLine;


			$record .= $this->space."<browser><![CDATA[".$_SERVER['HTTP_USER_AGENT']."]]></browser>".$this->newLine;

			// Versions on capi station
			$record .= $this->space."<versions>".$this->newLine;
				$record .= $this->space.$this->space."<start>".$this->VersionLOG['start']."</start>".$this->newLine;
				$record .= $this->space.$this->space."<stop>".$this->VersionLOG['stop']."</stop>".$this->newLine;
				if ($this->VersionLOG['upgrade']) $record .= $this->space.$this->space."<upgrades>".implode(",",$this->VersionLOG['upgrade'])."</upgrades>".$this->newLine;

			$record .= $this->space."</versions>".$this->newLine;



			if ($this->UserParams['id_project']) {
				$record .= $this->space."<project>".$this->newLine;
				$record .= $this->space.$this->space."<id>".$this->UserParams['id_project']."</id>".$this->newLine;
				$record .= $this->space.$this->space."<name>".$projectName."</name>".$this->newLine;


				$sql = "ANALYZE LOCAL TABLE ".DB_WARPIT_WEBCATI_BASE.".".$projectName."_structure";
				$res = $this->db->SQLexecute($sql);
				$zad = $this->db->fetchAssoc($res);
				$record .= $this->space.$this->space."<tableCheck>".$this->newLine;
					foreach ($zad as $key=>$val)
					$record .= $this->space.$this->space.$this->space."<".$key.">".$val."</".$key.">".$this->newLine;

				$record .= $this->space.$this->space."</tableCheck>".$this->newLine;

				$record .= $this->space.$this->space."<uploadNumberRecords>".count($this->uploadUpdateDefine[$tb])."</uploadNumberRecords>".$this->newLine;
				$record .= $this->space.$this->space."<uploadIdRecords>".implode(",",$this->uploadUpdateDefine[$tb])."</uploadIdRecords>".$this->newLine;


				$sql = "SELECT count(*) as n, status FROM ".DB_WARPIT_WEBCATI_BASE.".".$projectName."_structure
							WHERE user_id = ".$this->UserParams['user_id']." GROUP BY status";
				$res = $this->db->SQLexecute($sql);
				while ($zad = $this->db->fetchAssoc($res)) {
					if (is_null($zad['status'])) $zad['status'] = 0;
					$record .= $this->space.$this->space."<statusesUser>".$this->newLine;
						$record .= $this->space.$this->space.$this->space."<status>".$zad['status']."</status>".$this->newLine;
						$record .= $this->space.$this->space.$this->space."<count>".$zad['n']."</count>".$this->newLine;
					$record .= $this->space.$this->space."</statusesUser>".$this->newLine;
				}

				// We make statistics about other users which could made also interviews on this computer.
				$sql = "SELECT count(*) as n, status, flag_cli, user_id FROM ".DB_WARPIT_WEBCATI_BASE.".".$projectName."_structure
							WHERE user_id != ".$this->UserParams['user_id']." GROUP BY status, flag_cli, user_id";
				$res = $this->db->SQLexecute($sql);
				while ($zad = $this->db->fetchAssoc($res)) {
					$record .= $this->space.$this->space."<statusesOtherUser>".$this->newLine;
						if (is_null($zad['status'])) $zad['status'] = 0;
						if (is_null($zad['flag_cli'])) $zad['flag_cli'] = 0;
						$record .= $this->space.$this->space.$this->space."<user_id>".$zad['user_id']."</user_id>".$this->newLine;
						$record .= $this->space.$this->space.$this->space."<status>".$zad['status']."</status>".$this->newLine;
						$record .= $this->space.$this->space.$this->space."<flag_cli>".$zad['flag_cli']."</flag_cli>".$this->newLine;
						$record .= $this->space.$this->space.$this->space."<count>".$zad['n']."</count>".$this->newLine;
					$record .= $this->space.$this->space."</statusesOtherUser>".$this->newLine;
				}
				$record .= $this->space."</project>".$this->newLine;
			}
		$record .= "</updateMonitor>";

		return $record;
	}

}


class ServerResponse
{

		protected $serverStatus;

		protected $curlStatusCode;

		protected $curlError;

		protected $updateData;

		public function __construct()
		{

		}

		public function getCurlStatusCode()
		{
			return $this->curlStatusCode;
		}

		public function getCurlError()
		{
			return $this->curlError;
		}

		public function getLocalDatabase($remoteDatabase)
		{
				switch($remoteDatabase)
				{
					case "table_warpit_webcati_base": return DB_WARPIT_WEBCATI_BASE; break;
					default: return DB_WARPIT_LIVEUPDATE;
				}
		}

		public function setProjName($projName)
		{
			$this->projName = $projName;
		}

		public function parseResponse($jsonResponse, $curlStatusCode, $curlError)
		{
			$this->curlStatusCode = $curlStatusCode;
			$this->curlError = $curlError;

			if($curlStatusCode == 200)
			{
					$response = json_decode($jsonResponse, TRUE);

					$this->serverStatus = array();
					$this->updateData = array();
					if($response['insertedIds'])
					{
							foreach($response['insertedIds'] as $database => $tables)
							{
								$localDatabase = $this->getLocalDatabase($database);
								foreach($tables as $tableName => $data)
								{
									$datab = $localDatabase . "." . $tableName;
									$this->serverStatus[$datab]['updatedCnt'] = count($data['ids']);
									$this->serverStatus[$datab]['msg'] = $data['msg'];
									$this->serverStatus[$datab]['ids'] = $data['ids'];
									$this->serverStatus[$datab]['projName'] = $this->projName;

									if($this->serverStatus[$datab]['updatedCnt'])
										$this->updateData[$datab] = implode(",", $data['ids']);
								}

							}
					}
				}
		}

		public function getServerStatus()
		{
			return $this->serverStatus;
		}

		public function getIdsForUpload()
		{
			return $this->updateData;
		}

		public function updateNeeded()
		{
			return count($this->updateData) > 0;
		}

		public function addUpdatedIds($datab, $ids)
		{
			$this->serverStatus[$datab]['markedAsUploaded'] = true;
		}

		public function toString()
		{
			print "<pre>";
			var_dump($this->serverStatus);
			print "</pre>";
		}
}


class ClientRequest
{
		protected $clientStatus;

		protected $hasData;

		public function __construct()
		{
			$this->clientStatus = array();
			$this->hasData = false;
			$this->missingStructureTable = false;
		}

		public function addRecord($table, $id, $projName)
		{
				if(!$this->hasData) $this->hasData = true;

				$this->clientStatus[$table]['ids'][] = $id;
				$this->clientStatus[$table]['updatedCnt']++;
				$this->clientStatus[$table]['projName'] = $projName;
		}

		public function hasData()
		{
				return $this->hasData;
		}

		public function reportMissingTable($table, $projName)
		{
				$this->clientStatus[$table]['projName'] = $projName;
				$this->clientStatus[$table]['missingStructureTable'] = true;
		}

		public function getClientStatus()
		{
			return $this->clientStatus;
		}

		public function toString()
		{
			print "<pre>";
			var_dump($this->clientStatus);
			print "</pre>";
		}
}

class ScriptStatus
{
	const EXECUTION_SUCCESSFULL = "success";

	const EXECUTION_FAILD = "faild";

	const ERROR_SCRIPT_NOT_FOUND = 5;

	const ERROR_WRONG_EXTENSION = 6;

	const ERROR_SCRIPT_NOT_VALID = 7;
}

class DownloadErrors
{
		const WRONG_CHECKSUM = 1;

		//server returned 500 error
		const SERVER_INTERNAL_ERROR = 2;

		//file not found on server gor 404 error
		const SERVER_NOT_FOUND = 3;

		//server returned other response code than 200, 500, 404
		const SERVER_OTHER_ERROR = 4;

		const UNKNOWN_ERROR = 99;
}

class ClientUpdate
{
		const FILETYPE_WARPIT = "warpit";

		const FILETYPE_WEBPROJECTS = "webprojects";

		const UPDATE_STATUS_FAILD = false;

		CONST UPDATE_STATUS_SUCCESSFULLY = true;

		protected $currentVersion;

	//	protected $latestVersion;

		protected $updateStatus;

		protected $currentStatus;

		public function __construct()
		{
			$this->currentStatus = ClientUpdate::UPDATE_STATUS_SUCCESSFULLY;
			$this->updateStatus = array();
		}

		public function addVersions($versions)
		{
				foreach($versions as $ver)
				{
					$this->updateStatus["ver_" . $ver['version']] = array();
				}
				// we sort this just in case if versions are not already in right order
				//ksort($this->updateStatus);
				$this->currentVersion = current(array_keys($this->updateStatus));
		}

		public function addFile($filename, $type)
		{
				$this->updateStatus[$this->currentVersion]['files'][$type][] = $filename;
		}

		public function copyFileFaild($filename, $type)
		{
				$this->updateStatus[$this->currentVersion]['files']['faild'][$type][] = $filename;
				$this->setStatusFaild();
		}

		public function addSQL($sql, $executed = TRUE)
		{
			$type = "executed";
			if(!$executed)
			{
					$type = "faild";
					$this->currentStatus = ClientUpdate::UPDATE_STATUS_FAILD;
			}

			$this->updateStatus[$this->currentVersion]['sqls'][$type][] = $sql;
		}

		public function addScript($script_path, $status)
		{
			$type = "executed";
			if(in_array($status, array(ScriptStatus::EXECUTION_FAILD, ScriptStatus::ERROR_WRONG_EXTENSION, ScriptStatus::ERROR_SCRIPT_NOT_VALID, ScriptStatus::ERROR_SCRIPT_NOT_FOUND)))
			{
				$this->setStatusFaild();
				$this->updateStatus[$this->currentVersion]['scripts']['error'] =  $status;
				$type = "faild";
			}

			$this->updateStatus[$this->currentVersion]['scripts'][$type][] = $script_path;
		}

		public function downloadFaild($reason)
		{
				$this->updateStatus[$this->currentVersion]['downloadFaild'] = true;
				$this->updateStatus[$this->currentVersion]['reason'] = $reason;

				$this->setStatusFaild();
		}

		public function brokenZipFile($responseCode)
		{
			$this->updateStatus[$this->currentVersion]['brokenZipFile'] = true;
			$this->updateStatus[$this->currentVersion]['error_code'] = $responseCode;

			$this->setStatusFaild();
		}

		public function brokenXMLFile($error)
		{
				$this->updateStatus[$this->currentVersion]['brokenXMLFile'] = true;
				$this->updateStatus[$this->currentVersion]['error'] = $error;

				$this->setStatusFaild();
		}

		public function versionControlFaild($error)
		{
			//	$this->updateStatusf
		}



		public function addSQLCnt($sqlCnt)
		{
			$this->updateStatus[$this->currentVersion]['sqls']['cnt'] = $sqlCnt;
		}

		private function setStatusFaild()
		{
			$this->currentStatus = ClientUpdate::UPDATE_STATUS_FAILD;
		}

		public function nextVersion()
		{
			$keys = array_keys($this->updateStatus);

			$nextKey = array_search($this->currentVersion, $keys) + 1;

			$this->currentVersion = $keys[$nextKey];
		}

		private function getPrevVersion()
		{
			$keys = array_keys($this->updateStatus);
			$prevKey = array_search($this->currentVersion, $keys) - 1;

			return $keys[$prevKey];
		}

		public function getLastSuccessVersion()
		{
			if($this->isFaild())
			{
				$prevKey = $this->getPrevVersion();
				return ClientUpdate::extractVersion($prevKey);
			}

			return $this->getCurrentVersion();
		}

		public static function extractVersion($versionString)
		{
				$exp = explode("_", $versionString);
				return intval($exp[1]);
		}

		public function getCurrentVersion()
		{
				return ClientUpdate::extractVersion($this->currentVersion);
		}

		/* returns number of the latest succcessfully executed SQL*/
		public function getCurrentSQLcnt()
		{
			if(!$this->isFaild()) return 0;

			return count($this->updateStatus[$this->currentVersion]['sqls']['executed']);
		}

		public function isFaild()
		{
			return $this->currentStatus == ClientUpdate::UPDATE_STATUS_FAILD;
		}

		public function toString()
		{
			print "<pre>";
			var_dump($this->updateStatus);
			print "</pre>";
		}

		public function getUpdateStatus()
		{
//			$this->toString();
				return $this->updateStatus;
		}
}

class LiveUpdateLogUpload extends LiveUpdateLog
{

	protected $clientRequest;

	protected $serverResponse;

	public function __construct($clientRequest, $serverResponse)
	{
			$this->clientRequest = $clientRequest;
			$this->serverResponse = $serverResponse;

			parent::__construct();
	}

	public function buildLog()
	{

		if(!$this->clientRequest->hasData())
		{
				$this->logHeader("There is no pending data for user <b>" . $_SESSION['Firstname'] . " " . $_SESSION['Surname'] . "</b> on this notebook for the server.");
				return;
		}

		$serverStatus= $this->serverResponse->getServerStatus();
		$clientStatus = $this->clientRequest->getClientStatus();

		foreach($clientStatus as $datab => $data)
		{
			$this->projName = $data['projName'];

			/*if($data['missingStructureTable'])
				$this->logError("Data table for this project is missing!");
*/
			if($this->isProject($datab))
			{
				$this->logHeader("Information for project: <b>" . $this->projName . "</b>:" );
				if($data['updatedCnt'])
					$this->logNotice("Data exist for this project [". $data['updatedCnt'] ." records] ");
			}
			else
			{
				$this->logNotice("Information about visits and appointments [". $data['updatedCnt'] ." records] ");
			}

			if($data['missingStructureTable'])
			{
				$this->logError("Data table for this project is missing!");
			}
		}

		$serverStatusCode = $this->serverResponse->getCurlStatusCode();
		if($serverStatusCode == 200)
		{
			$this->logNotice("Upload to server succcessfull!");
			foreach($serverStatus as $datab => $data)
			{
					$this->projName = $data['projName'];

					$tableLabel = $this->projName;
					if(!$this->isProject($datab))
						$tableLabel = "for visits and appointments";

					if($this->isProject($datab))
					{
							$this->logNotice($data['updatedCnt'] . " of " . $clientStatus[$datab]['updatedCnt'] . " records has been saved in data table " . $this->projName . " on server" );
					}
					else
					{
							$this->logNotice($data['updatedCnt'] . " of " . $clientStatus[$datab]['updatedCnt'] . " records about visits and appointmenst has been saved on server ." );
					}

					if($data['msg'])
						$this->logError($data['msg']);

					/*$tableLabel = "";
					if($this->isProject($this->))
*/
					if($data['markedAsUploaded'])
						$this->logNotice("Records inside data table " . $tableLabel . " has been marked as uploaded.");
					else
						$this->logError("Records inside data table " . $tableLabel . " hasn't been marked as uploaded.");

			}

		}
		else if($serverStatusCode == 404)
		{
			$this->logError("Can't connect to the server.");
		}
		else if($serverStatusCode == 500)
		{
			$this->logError("Uknown error on server");
		}
		else if($this->serverResponse->getCurlError())
		{
			$this->logError($this->serverResponse->getCurlError());
		}
		else
		{
			$this->logError("Unknown error!");
		}
	}


}

class LiveUpdateLogDownload extends LiveUpdateLog
{
	private $clientUpdate;

	public function __construct($clientUpdate)
	{
			$this->clientUpdate = $clientUpdate;

			parent::__construct();
	}

	public static function getScriptErrorMsg($error)
	{
		switch ($error)
		{
			case ScriptStatus::EXECUTION_FAILD: return "Script contains errors";
			case ScriptStatus::ERROR_SCRIPT_NOT_VALID: return "Script name is not valid";
			case ScriptStatus::ERROR_WRONG_EXTENSION: return "Script is not PHP script";
			case ScriptStatus::ERROR_SCRIPT_NOT_FOUND: return "Script not found";
		}
	}

	public function isFaild()
	{
			return $this->clientUpdate->isFaild();
	}

	public function buildLog()
	{
			$updateStatus = $this->clientUpdate->getUpdateStatus();


		//	$this->clientUpdate->toString();

			foreach ($updateStatus as $version => $data)
			{
				if($data)
				{
					$this->projName = $version;

					$this->logHeader("Update to version: <b>" . ClientUpdate::extractVersion($version) . "</b>:");

					if($data['downloadFaild'])
					{
							$this->logError("Download of the update faild");
					}

					if($data['brokenZipFile'])
					{
							$this->logError("Downloaded file broken");

							$this->clientUpdate->toString();
					}

					if($data['brokenXMLFile'])
					{
							$this->logError("XML definiton broken");
					}

					if($data['files'][ClientUpdate::FILETYPE_WARPIT])
					{
						$this->logNotice("Number of files copied into warpit folder: " . count($data['files'][ClientUpdate::FILETYPE_WARPIT]));
					}

					if($data['files'][ClientUpdate::FILETYPE_WEBPROJECTS])
					{
						$this->logNotice("Number of files copied into webprojects folder: " . count($data['files'][ClientUpdate::FILETYPE_WEBPROJECTS]));
					}

					if($data['files']['faild'][ClientUpdate::FILETYPE_WARPIT])
					{
						$this->logError("Faild to copy into warpit folder");
					}

					if($data['files']['faild'][ClientUpdate::FILETYPE_WEBPROJECTS])
					{
						$this->logError("Faild to copy into webprojects folder");
					}

					if($data['sqls'])
					{

							if(!count($data['sqls']['faild']))
							{
									$this->logNotice("Number of succcessfully executed SQLs: " . count($data['sqls']['executed']));
							}
							else
							{
								$this->logError("Error appears during SQL execution");
								$this->logNotice("Number of succcessfully executed SQLs: " . count($data['sqls']['executed']));

							}
					}

					if($data['scripts'])
					{
							if(!count($data['scripts']['faild']))
							{
									$this->logNotice("Number of succcessfully executed scripts: " . count($data['scripts']['executed']));
							}
							else
							{
								if(count($data['scripts']['executed']))
									$this->logNotice("Number of succcessfully executed scripts: " . count($data['scripts']['executed']));

								$this->logError("Error appears during script execution:");
								if($data['scripts']['error'])
								{
									$error = $this->getScriptErrorMsg($data['scripts']['error']);
									$this->logError($error);
								}
							}
					}



				}
			}

	//		$this->toString();
	}

}

abstract class LiveUpdateLog
{

		protected $outputLog;

		protected $projName;

		abstract public function buildLog();

		public function __construct()
		{
			 $this->outputLog = array();
		}

		protected function isProject($tableName)
		{
				return $tableName != DB_WARPIT_WEBCATI_BASE . "._Capi_interviewer_visits";
		}

		protected function logHeader($msg)
		{
				if($this->outputLog[$this->projName])
				{
					$header = array($this->projName => "<span style='font-size:15px;font-family:Arial;'>" . $msg . "</span>");
					$this->outputLog = array_merge_recursive($header, $this->outputLog);
				}
				else
				{
					$this->outputLog[$this->projName][] = "<span style='font-size:15px;font-family:Arial;'>" . $msg . "</span>";
				}

		}

		protected function logError($msg)
		{
				$this->outputLog[$this->projName][] = "<span style='color:red;font-size:12px;font-family:Arial;'>" . $msg . "</span>";
		}

		protected function logNotice($msg)
		{
				$this->outputLog[$this->projName][] = "<span style='font-size:12px;font-family:Arial;'>" . $msg . "</span>";
		}


		public function toArray()
		{
				if($this->outputLog)
					return $this->outputLog[$this->projName];
		}

		public function getLog()
		{
			if($this->outputLog) return $this->outputLog;
		}

		public function toString()
		{
			print "<pre>";
			var_dump($this->outputLog);
			print "</pre>";
		}


}

?>
