<?php
include_once ("_dirinfo.php");

include_once (PATH_TO_ROOT."_class/class.Extjs.php");

class MakeField
{
	public $properties;
	public $configs;
	public $listeners;
	private $table;
	function __construct($props = null)
	{
		if (isset($props))
		{
			foreach ($props as $key => $val) {

				if(method_exists($this,$key))
				{
					$this->$key($val);
				}
				else
				{
					$this->setProperty($key,$val);
				}
			}

		}
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function name($text)
	{
		$this->properties['name'] = $text;
		$this->configs[] = "RMfieldName : '$text'";
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function table($text)
	{
		$this->table = $text;
		//$this->configs[] = "name : '$text'";
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function width($num)
	{
		if($num)
		{
			$this->configs[] = "width :$num";
		}
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function height($num)
		{
			if($num)
			{
				$this->configs[] = "height :$num";
			}
			return $this;
		}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function ref($num)
		{
			if($num)
			{
				$this->configs[] = "ref :'$num'";
			}
			return $this;
		}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function fieldLabel($text)
	{
		if($text)
		{
			$this->configs[] = "fieldLabel : '$text'";
		}
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function boxLabel($text)
	{
		if($text)
		{
			$this->configs[] = "boxLabel : '$text'";
		}
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function hideLabel($bool)
	{
		if($bool)
		{
			$this->configs[] = "hideLabel : true";
		}
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function hidden($bool = true)
	{
		if($bool)
		{
			$this->configs[] = "hidden : true";
		}
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function labelSeparator($text)
	{
		if($text)
		{
			$this->configs[] = "labelSeparator : '$text'";
		}
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function xtype($text)
	{
		if($text)
		{
			$this->properties['xtype'] = $text;
			$this->configs[] = "xtype : '$text'";

			if($text == 'tinymce')
			{

			}
		}
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function anchor($text)
	{
		if($text)
		{
			$this->configs[] = "anchor : '$text'";
		}
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function inputValue($text)
	{
		if($text)
		{
			$this->configs[] = "inputValue : '$text'";
		}
		return $this;
	}

/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function tabIndex($num)
	{
		$this->configs[] = "tabIndex : $num";
		return $this;
	}
	/**
	 * Enter description here...
	 * WARNING: requiers quotes!
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function addListener($event,$function)
	{
		$this->listeners[] = "$event : $function";
		return $this;
	}
	/**
	 * Enter description here...
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function setProperty($key,$val)
	{
		$this->configs[] = "$key : $val";
		return $this;
	}
	/**
	 * Enter description here...
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function setAutoUpdate($bool = true)
	{
		$this->autoUpdate = $bool;
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function createField()
	{
		//there's an error in radio buttons!!! AAAAAAAAAAAAAAAA
		if($this->properties['xtype'] == 'radio')
			$name = $this->properties['name'];
		else
			$name = "podatki[".$this->properties['name']."]";
		if (isset($this->table)) $name.= "[$this->table]";
		;

		$this->configs[] = "name : '$name'";
		$this->configs[] = "dataIndex: '{$this->properties['name']}'" ;
		if($this->listeners )
		{
			$this->configs[] = "listeners: { ".implode(',',$this->listeners)."}";
		}
		$tmp ='{';
		if(!isset($this->properties['xtype']) )
		{
			$this->configs[] = "xtype : 'textfield'";
		}

		$tmp .= implode(',',$this->configs).'}';
		return $tmp;
	}

}

class MakeForm extends MakeComponent
{

	private $tabIndex = 1;

	public $reqUrl = '_ajaxManipulators/formDataManipulator.php';

	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeForm
	 */
	public function addSaveCancel($save='Ok',$cancel='Cancel',$removeCmp = null,$remove = true )
	{

		if(!$removeCmp) $removeCmp = $this->compName;
		if($remove)
			$removeStr = "$removeCmp.ownerCt.remove( $removeCmp );";
		if($this->treeInsert)
		{//we used this form to insert a tree node...we refresh the tree
			$removeStr .= "Ext.getCmp('$this->treeInsert')";
			if($this->treeRefreshId)
				$removeStr.= ".getNodeById($this->treeRefreshId)";
			else
				$removeStr.= ".getRootNode()";
			$removeStr .= ".reload();";

		}

		$this->addtBarItem("{iconCls:'icon_save_document' ,text:'$save',handler:function(){ $this->compName.getForm().doAction('oosubmit',{success : function(f,a)
		{ $removeStr },failure : function(f,a){ alert( Ext.decode(a.response.responseText).error ); }   }); }}");
		$this->addtBarItem("{iconCls:'RMicon_save_cancel',text:'$cancel',handler:function(){ $removeCmp.ownerCt.remove( $removeCmp ); }}");
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeForm
	 */
	public function setAutoUpdate($bool = true)
	{
		$this->autoUpdate = $bool;
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeForm
	 */
	public function labelAlign($text)
	{
		$this->addConfig('labelAlign',"'$text'") ;
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeForm
	 */
	public function labelWidth($num)
	{
		$this->addConfig('labelWidth',$num) ;
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeForm
	 */
	public function padding($text)
	{
		$this->addConfig('padding',$text) ;
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeForm
	 */
	public function addButton($text,$function){parent::addButton($text,$function);return $this;}

	private $fields;
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeField
	 */
	public function addField($props,$label = null,$type=null)
	{
		if( is_array($props))
		{
	//		$f['tabIndex'] = $this->tabIndex;
			$f = new MakeField($props);
		}
		else
		{
			$f = new MakeField(array('name'=>$props,'xtype'=>$type,'fieldLabel'=>$label/*,'tabIndex'=>$this->tabIndex*/)  );
		}
		$this->tabIndex++;
		$this->fields[] = $f;
		return $f;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeForm
	 */
	public function addItem($item)
	{
		$this->fields[] = $item;
	}
	public function createForm()
	{





		$tmp .= "//CREATE THE FORM
		var $this->compName =  new Ext.FormPanel({
			id: '$this->compName' ,
			selectedId : '$this->id',
			name: '$this->compName',
			baseParams:{RMcomp:'form',RMtable:'$this->table',database:'$this->database', action:'submit',id:'$this->id',SQL:'$this->selectSQL' $this->baseParams },
			url:'$this->reqUrl',";

	if($this->autoUpdate )
		{//WARNING!!! what if form doesn't have autoupdate but only some fields have ??? there is no function definition ?
			$this->configRMconn('form');
			foreach ($this->fields as $field) {
				if(is_a($field,'MakeField') && !isset($field->autoUpdate))
					$field->setAutoUpdate(true);
			}
			/*$this->addConfig('defaults',"	{listeners:{ change:function(fld,val){
					Ext.Ajax.request({
					url:'_ajaxManipulators/formDataManipulator.php',
					params:{ action:'update',RMtable:'$this->table',database:'$this->database',field:fld.RMfieldName,
					 value:val,id: $this->compName.selectedId }  });
					 }
		}} ");*/

			if(!$this->autoUpdateFunction)
			$this->autoUpdateFunction = "function(fld,val){
					new RMajax().request({
					url:'$this->reqUrl',
					params:{RMcomp:'form', action:'update',RMtable:'$this->table',database:'$this->database',field:fld.RMfieldName,
					 value: fld.getValue(),id: $this->compName.selectedId }  });
					 }";

		 $tmp .= "RMautoUpdate : $this->autoUpdateFunction , ";

		}

		$tmp .= "items:[";
		$fieldsTmp = array();



		foreach ($this->fields as $field) {
			if(is_a($field,'MakeField'))
			{
				if($field->autoUpdate)
				{

					if ($field->properties['xtype'] == 'combo' )
						$event = 'select';
					else {
						$event = 'change';
					}


					if($field->properties['xtype'] == 'checkbox')
					//ugly..very ugly...but it works :)
					//extjs has 2 events on checkbox change and check, but we use our own becouse of wierd behaviour
					//change has the problem taht it must loose focus before submiting, check on the other hand is called when form is rendered or loaded
						$field->addListener('render',"function(c){
							c.el.on('click',function(){ var b = $this->autoUpdateFunction ; b(c,c.getValue())
							; } );
				}");
					else
						$field->addListener($event,$this->autoUpdateFunction);
				}

				$fieldsTmp[] = $field->createField();
			}
			else
			{
				$fieldsTmp[] = $field;
			}

		}
		$tmp .= implode(',',$fieldsTmp).']';
	if($this->addTBar )
		{
			 $tmp .= ',tbar:[' . implode(',',$this->tBarItems).']';
		}
		if(!$this->configs['padding'])
		{
			$tmp .= ",padding:15";
		}

		$tmp .=$this->createConfigs();



		$tmp .= '});';
		if($this->id)
			$tmp .= "
			$this->compName.on('render',function(){
				$this->compName.getForm().load({params:{action:'load'}});
			});";



		return $tmp;
	}

}

?>