var <?php echo $gridName;?> = new Ext.grid.EditorGridPanel({
    store: new Ext.data.Store({
        url: '<?php echo $ajax;?>',         
        baseParams:{
            action: 'get'
        },
        remoteSort: true,
        autoLoad: true,
        reader: new Ext.data.JsonReader({       
                root:'rows',
                totalProperty : "results"
            },
            new Ext.data.Record.create([
                { name:"id", type: 'int' },
                { name:"agent", type:'string'},
                { name:"invited", type:'string'},
                { name:"attended", type:'string'},
                { name:"extra_attended", type:'string'},
                { name:"Not_present", type:'string'},
                { name:"realization", type:'string'},
                { name:"realization_all", type:'string'},
                { name:"checked", type:'boolean' },
                { name:"color", type: 'string'},
                { name:"project_time", type: 'string'},
                { name:"call_time", type: 'string'},
                { name:"talk_time", type: 'string'},
                { name:"callwait_time", type: 'string'},
                { name:"aftercall_time", type: 'string'},
                { name:"call_pct", type: 'string'},
                { name:"talk_pct", type: 'string'},
                { name:"callwait_pct", type: 'string'},
                { name:"aftercall_pct", type: 'string'},
            ])
        )
    }),
    id: '<?php echo $gridName;?>',
    border: false,
    region: 'center',
    closable: true,
    renderTime: function(val){
                var hours = parseInt(val / 3600);
                var days = 0;
                if(hours > 23){
                    days = parseInt(val / 86400);
                    val = parseInt(val % 86400);
                    hours = parseInt(val / 3600);
                }
                val = parseInt(val % 3600);
                var mins = parseInt(val / 60);
                var sec = parseInt(val % 60);
                
                if(days != 0)
                    return days+':'+hours+':'+mins+':'+sec;
                else
                    return hours+':'+mins+':'+sec;
    },
    columns: [{
            header: '#ID', 
            dataIndex: 'id',
            hidden: true
        },{
            header: '<?php echo $LangPack->GetLabel("statistic_grid", "agent_column_title","Agent");?>',
            dataIndex: 'agent',
            sortable: true,
            width: 130
        },{
            header: '<?php echo $LangPack->GetLabel("statistic_grid", "invited_column_title","Povabljenih");?>',
            dataIndex: 'invited',
            sortable: true,
            width: 60
        },{
            header: '<?php echo $LangPack->GetLabel("statistic_grid", "attended_column_title","Prišlo");?>',
            dataIndex: 'attended',
            sortable: true,
            width: 60
        },{
            header: '<?php echo $LangPack->GetLabel("statistic_grid", "extra_attended_column_title","Dodatno prišlo");?>',
            dataIndex:'extra_attended',
            sortable: true,
            width: 80
        },{
            header: '<?php echo $LangPack->GetLabel("statistic_grid", "not_present_column_title","Ni prišlo");?>',
            dataIndex: 'Not_present',
            sortable: true,
            width: 60
        },{
            header: '<?php echo $LangPack->GetLabel("statistic_grid", "realization_column_title","% realizacije");?>',
            dataIndex: 'realization',
            sortable: true,
            width: 80
        },{
            header: '<?php echo $LangPack->GetLabel("statistic_grid", "realization_all_column_title","% realizacije skupaj");?>',
            dataIndex: 'realization_all',
            sortable: true,
            width: 80,
            align: 'right',
            renderer: function(a, metadata, record){
                return '<div class="x-grid3-cell-inner" style="background-color:#'+record.data.color+'">' + a + '</div>';
            }
        },{
            header: 'Project time',
            dataIndex: 'project_time',
            sortable: true,
            width: 80,
            renderer: function(val){
                return Ext.getCmp('<?php echo $gridName;?>').renderTime(val);               
            }
        },{
            header: 'Call time',
            dataIndex: 'call_time',
            sortable: true,
            width: 80,
            renderer: function(val){
                return Ext.getCmp('<?php echo $gridName;?>').renderTime(val);               
            }
        },{
            header: 'Talk time',
            dataIndex: 'talk_time',
            sortable: true,
            width: 80,
            renderer: function(val){
                return Ext.getCmp('<?php echo $gridName;?>').renderTime(val);               
            }
        },{
            header: 'Call wait time',
            dataIndex: 'callwait_time',
            sortable: true,
            width: 80,
            renderer: function(val){
                return Ext.getCmp('<?php echo $gridName;?>').renderTime(val);               
            }
        },{
            header: 'After call time',
            dataIndex: 'aftercall_time',
            sortable: true,
            width: 80,
            renderer: function(val){
                return Ext.getCmp('<?php echo $gridName;?>').renderTime(val);               
            }
        },{
            header: 'Call %',
            dataIndex: 'call_pct',
            sortable: true,
            width: 80
        },{
            header: 'Talk %',
            dataIndex: 'talk_pct',
            sortable: true,
            width: 80
        },{
            header: 'Call wait %',
            dataIndex: 'callwait_pct',
            sortable: true,
            width: 80
        },{
            header: 'After call %',
            dataIndex: 'aftercall_pct',
            sortable: true,
            width: 80
        }       
    ],
    sm: new Ext.grid.RowSelectionModel({ singleSelect: true }),
    tbar:[new Ext.ux.form.LovCombo({
        title: '<?php echo $LangPack->GetLabel("statistic_filter_grid", "project_combo_select_label","Projekt");?>',
        width: 250,
        mode: 'remote',
        triggerAction: 'all',
        id: 'projectCombo',
        name: 'projectCombo',
        hiddenName: 'projectCombo',
        lazyRender: true,
        store: new Ext.data.Store({
            url: '<?php echo $ajax;?>',
            baseParams: {
                action: 'getProjects'
            },
            autoLoad: true,
            listeners:{
                load: function(comp, a, b){
                    var index = comp.find("value", '<?php echo WEEK_NAME."_".date("W")."_".date("Y"); ?>', 0, true);
                    var record = comp.getAt(index);
                    record.set('checked', true);
                    Ext.getCmp('projectCombo').setRawValue(record.data.value);
                }
            },
            reader: new Ext.data.JsonReader({       
                    root:'rows',
                    totalProperty : "results"
                },
                new Ext.data.Record.create([
                    { name:"id", type: 'id'},
                    { name:"value", type: 'string' }
                ])
            )
        }),
        valueField: 'id',
        displayField: 'value'
    }),
    {xtype: 'tbspacer', width: 10},
    {
        xtype: 'label',
        text: 'From: '          
    },
    {
        xtype: 'datefield',
        id: 'crm_dateFrom',
        format: 'd.m.Y',
        hiddenFormat: 'Y-m-d'
    },
    {xtype: 'tbspacer', width: 3},
    {
        xtype: 'timefield',
        id: 'crm_timeFrom',
        format: 'H:i',
        minValue: '06:00',
        maxValue: '22:00',
        increment: 30,
        width: 80
    },
    {xtype: 'tbspacer', width: 10},
    {
        xtype: 'label',
        text: 'To: '            
    },
    {
        xtype: 'datefield',
        id: 'crm_dateTo',
        format: 'd.m.Y',
        hiddenFormat: 'Y-m-d'
    },
    {xtype: 'tbspacer', width: 3},
    {
        xtype: 'timefield',
        id: 'crm_timeTo',
        format: 'H:i',
        minValue: '06:00',
        maxValue: '22:00',
        increment: 30,
        width: 80
    },  
    {
        xtype: 'button',
        id: 'search',
        bodyStyle: 'margin-right: 25px',
        name: 'search',
        width: 60,
        text: '<?php echo $LangPack->GetLabel("CRM_all", "CRM_search_button","Iskanje");?>',
        handler: function(){
            var dateFrom = Ext.getCmp('crm_dateFrom').getRawValue();
            var timeFrom = Ext.getCmp('crm_timeFrom').getRawValue();
            var dateTo = Ext.getCmp('crm_dateTo').getRawValue();
            var timeTo = Ext.getCmp('crm_timeTo').getRawValue();
            var grid = Ext.getCmp('<?php echo $gridName;?>');
            if(Ext.getCmp('projectCombo').getValue() != ""){
               // grid.getEl().mask('<?php echo $LangPack->GetLabel("CRM_all", "loading_mask_text","Posodabljanje...");?>');
                grid.getStore().reload({params: { project: Ext.getCmp('projectCombo').getValue(),dateFrom:dateFrom,timeFrom:timeFrom,dateTo:dateTo,timeTo:timeTo}, callback: function(resp, opt, success){
                    if(success){
                 //       grid.getEl().unmask();
                    }
                }});
            }
        }
    },'->',{
        xtype:'button',
        text:'<?php echo $LangPack->GetLabel("CRM_all", "CRM_export_button","Export");?>',
        handler: function(){
            window.open('<?php echo $export;?>?action=export&project='+Ext.getCmp('projectCombo').getCheckedValue(), '_blank');
        }
    },{
        xtpye:'button',
        text:'<?php echo $LangPack->GetLabel("CRM_all", "CRM_settings_button","Settings");?>',
        handler: function(){
            CallScript('<?php echo CRM_RPATH; ?>_forms/visitStatistic/window.settings.php');
        }
    }]
});

