<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");

include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once(PATH_TO_ROOT."CRM/class/class.checkString.php");


$LangPack = new LanguagePack($db, $aLanguage);

$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);

$ajax = "CRM/_forms/telephoneUsers/_ajax/ajax.prisotnost.php";
$export = "CRM/_export/exportTable.php";

$compName = "VabilaUserGrid".$suffix;
?>

Ext.ns('Ext.ux.grid');
Ext.ux.grid.CheckColumn = Ext.extend(Ext.grid.Column, {
	processEvent: function(name, e, grid, rowIndex, colIndex){
		if(name == 'mousedown'){
			var record = grid.store.getAt(rowIndex);
			record.set(this.dataIndex, !record.data[this.dataIndex]);
			return false;
		}else{
			return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
		}
	},
	renderer: function(v, p, record){
		p.css += ' x-grid3-check-col-td';
		return String.format('<div class="x-grid3-check-col{0}">&#160;</div>',v ? '-on' : '');
	},
	init: Ext.emptyFn
});
Ext.preg('checkcolumn', Ext.ux.grid.CheckColumn);
Ext.grid.CheckColumn = Ext.ux.grid.CheckColumn;
Ext.grid.Column.types.checkcolumn = Ext.ux.grid.CheckColumn;

var sm = new Ext.grid.CheckboxSelectionModel();

var <?php echo $compName;?> = new Ext.grid.EditorGridPanel({
        
    	store: new Ext.data.Store({
			url: '<?php echo $ajax;?>',			
			baseParams:{
				action: 'get',
				project_id: '<?php echo $projectId;?>'
				<?php if(isset($dan)) echo ", dan: '$dan'";?>
				<?php if(isset($ura)) echo ", ura: '$ura'";?>
				<?php if(isset($cati_location)) echo ", cati_location: '$cati_location'";?>
			},
			reader: new Ext.data.JsonReader({		
					root:'rows',
					totalProperty : "results"
				},
				new Ext.data.Record.create([
					{ name:"id", type: 'id'},
				 	{ name:"id_tel", type: 'id' },
				 	{ name:"oseba_1", type:'string'},	
					{ name:"oseba_2", type: 'string' },
					{ name:"color", type: 'string'},
					{ name:"attended", type: 'bool' },
					{ name:"kraj", type:'string' },
					{ name:"posta", type:'string' },
					{ name:"dogodek", type:'string' },
					{ name:"dan", type:'string' },
					{ name:"ura", type:'string' }
				])
			)
    	}),
        id: '<?php echo $compName;?>',
        updateStore: function(){
        	Ext.getCmp('<?php echo $compName;?>').getStore().reload();
        },
        border: false,
      	columns: [
      		sm,
      		{header: '<?php echo $LangPack->GetLabel("User_grid_panel", "name_title","Ime"); ?>', sortable: true, dataIndex: 'oseba_1' },
      		{header: '<?php echo $LangPack->GetLabel("User_grid_panel", "address_title","Naslov"); ?>', sortable: true, dataIndex: 'oseba_2'},
      		{header: '<?php echo $LangPack->GetLabel("User_grid_panel", "post_code_title","Pošta"); ?>',dataIndex: 'posta', width: 50},
      		{header: '<?php echo $LangPack->GetLabel("User_grid_panel", "city_title","Kraj"); ?>',dataIndex: 'kraj'},
      		{header: '<?php echo $LangPack->GetLabel("User_grid_panel", "event_title","Dogodek"); ?>',	dataIndex: 'dogodek'},
      		{
      			header: '<?php echo $LangPack->GetLabel("User_grid_panel", "day_title","Dan"); ?>',	
      			dataIndex: 'dan', 
      			renderer : function(a, metaData, record) {
	                var st = Ext.getCmp('danCombo<?php echo $suffix;?>').getStore();
	                if(st.find('id',a) != -1){
	                	var r = st.getAt(st.find('id',a));
	                	return r.data.value;
	                }
                }, 
                editor: new Ext.form.ComboBox({
	      			mode: 'local',
	  				triggerAction: 'all',
	  				editable: false,
	  				id: 'danCombo<?php echo $suffix;?>',
	  				lazyRender: true,
	  				store: new Ext.data.ArrayStore({
	  					fields:['id', 'value'],
						data:[
							<?php
								$a = array();
								foreach ($days as $day) {
									if($day['id'] != null && $day['id'] != '')
										array_push($a, "['".$day['id']."', '".$day['label']."']");
								}
								echo implode(",",$a);
							?>
						  ]
	  				}),
	  				valueField: 'id',
	  				displayField: 'value',
	  				dataIndex: 'dan'
      			})
      		},
      		{
      			header: '<?php echo $LangPack->GetLabel("User_grid_panel", "hour_title","Ura"); ?>', 
      			dataIndex: 'ura', 
      			width: 70,
      			renderer : function(a, metaData, record) {
	                var st = Ext.getCmp('uraCombo<?php echo $suffix;?>').getStore();
	                if(st.find('id',a) != -1){
	                	var r = st.getAt(st.find('id',a));
	                	return r.data.value;
	                }
                }, 
                editor: new Ext.form.ComboBox({
	      			mode: 'local',
	  				triggerAction: 'all',
	  				editable: false,
	  				id: 'uraCombo<?php echo $suffix;?>',
	  				lazyRender: true,
	  				store: new Ext.data.ArrayStore({
	  					fields:['id', 'value'],
						data:[
							<?php
								$a = array();
								foreach ($time as $t) {
									if($t['id'] != null && $t['id'] != '')
										array_push($a, "['".$t['id']."', '".$t['label']."']");
								}
								echo implode(",",$a);
								
							?>
						  ]
	  				}),
	  				dataIndex: 'ura',
	  				valueField: 'id',
	  				displayField: 'value'
      			})
      		},
      		{header: '<?php echo $LangPack->GetLabel("User_grid_panel", "attended_title","Attended"); ?>', xtype: 'checkcolumn', hidden: true, dataIndex: 'attended', width: 50}
        ],
        forceFit:true,
        sm: sm,
        tbar:[{
        	xtype: 'button',
        	text: '<?php echo $LangPack->GetLabel("User_grid_panel", "print_invatation_button","Printanje vabil"); ?>',
        	iconCls: 'RMicon_printer',
        	handler: function(){
        		var selected = <?php echo $compName;?>.getSelectionModel().selections;
        		if(selected.length != 0){
        			var userIDs = new Array();
        			var i= 0;
        			Ext.each(selected.items, function(item){
        				userIDs[i] = item.data.id_tel;
        				i++;
        			});
        			Ext.Ajax.request({
        				url: '<?php echo $ajax;?>',
        				params:{
        					action: 'updateAction',
        					project_id: '<?php echo $projectId;?>',
        					id_tel: userIDs.join(','),
        					print_id: 1
        					<?php if(isset($cati_location)) echo ", cati_location: '$cati_location'";?>
        				},
        				success: function(resp, opt){
        					Ext.getCmp('<?php echo $compName;?>').getStore().reload();
        					Ext.getCmp('HistoryTab<?php echo $suffix;?>').getStore().reload();					
		        			window.open('CRM/PDFGenerator.php?printId=' + resp.responseText +'&pId=<?php echo $projectId;?>').focus();	
        				}
        			});
        		}else{
        			Ext.Msg.alert('<?php echo $LangPack->GetLabel("User_grid_panel", "no_user_selected_title","Izberi osebo"); ?>', '<?php echo $LangPack->GetLabel("User_grid_panel", "no_user_selected_msg","Prosim prvo izberite vsaj eno osebo"); ?>');
        		}
        	}
        },{
        	xtype:'button',
        	text:'<?php echo $LangPack->GetLabel("User_grid_panel", "export_button","Izvozi");?>',
        	handler: function(){
        		<?php if(isset($cati_location)){ ?>
        			window.open('<?php echo $export; ?>?action=export&project_id=<?php echo $projectId;?>&filter_id=<?php echo $cati_location; ?>&dan=<?php echo $dan;?>&ura=<?php echo $ura;?>', '_blank').focus();
        		<?php } else{ ?>
        			window.open('<?php echo $export; ?>?action=export&project_id=<?php echo $projectId;?>', '_blank').focus();
        		<?php }?>
        		
           	}
        },{
        	xtype:'button',
        	text:'<?php echo $LangPack->GetLabel("User_grid_panel", "show_all_button","Prikaži vse");?>',
        	hidden: true,
        	enableToggle: true,
        	handler: function(){
        		Ext.getCmp('<?php echo $compName;?>').getStore().load({params: { showAll: this.pressed }});
        	}
        },'->',
        	new Ext.form.TwinTriggerField({
        		trigger2Class:'x-form-clear-trigger',
        		trigger1Class:'x-form-search-trigger',
				onTrigger1Click:function(){
					var l = <?php echo $compName;?>.getStore();
				 	l.baseParams.filter = this.getValue();
					Ext.getCmp('<?php echo $compName?>').getEl().mask({msg:"<?php echo $LangPack->GetLabel("CRM_all", "loading_mask_text","Posodabljanje...");?>"});
					l.load({callback: function(records, operation, success){
						if(success){
							Ext.getCmp('<?php echo $compName?>').getEl().unmask();
						}
					}});
				},
				onTrigger2Click:function(){
					var l = <?php echo $compName;?>.getStore();
					delete l.baseParams.filter;
					this.setValue('');
					l.load(); 
				},
				listeners: {
	                specialkey: function(field, e){
	                    // e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
	                    // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
	                    if (e.getKey() == e.ENTER) {
	                       field.onTrigger1Click();
	                    }
	                }
	            }
			})
         ],
       	listeners: {
       		afteredit : function(e) {
       			Ext.Ajax.request({
       				url:'<?php echo $ajax;?>',
       				params: { 
       					action: 'update' ,
						  id	: e.record.data.id,
					   field	: e.field,
						value 	: e.value,
						table   : '<?php echo $projectName;?>'					
       				},
					success : function(resp,opt){ 
						e.record.commit();
						Ext.getCmp('<?php echo $compName;?>').getStore().reload();
					}							  							
				})
			}	
		}     
    });
    
    
<?php echo $compName; ?>.getStore().reload();  