<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");

$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
$compName = "HistoryTab".$suffix;

if(isset($cati_location) && $cati_location != "")
	$export = "CRM/_export/exportTable.php?"."action=export&project_id=".$projectId."&filter_id=".$cati_location."&dan=".$dan."&ura=".$ura."&history";
else
	$export = "CRM/_export/exportTable.php?"."action=export&project_id=".$projectId."&history";
	

function echoSpace($c){
	$a = array();
	for($i=0;$i<$c;$i++){
		array_push($a, "&nbsp;");
	}
	echo implode(" ", $a);
}
?>
var sm = new Ext.grid.RowSelectionModel();
var historyPageLimit = 50;

var historyStore = new Ext.data.GroupingStore({
	autoLoad: true,
	pageSize: historyPageLimit,
	url: '<?php echo $ajax;?>',
	groupField: 'actionDate',
	groupDir: 'DESC',
	baseParams: {
		action: 'getHistory',
		projectId: '<?php echo $projectId;?>',
		start: 0,
		limit: historyPageLimit
		<?php if(isset($dan)) echo ", dan: '$dan'";?>
		<?php if(isset($ura)) echo ", ura: '$ura'";?>
		<?php if(isset($cati_location)) echo ", cati_location: '$cati_location'";?>
	},
	reader: new Ext.data.JsonReader({		
			root:'rows',
			totalProperty : "results"
		},
		new Ext.data.Record.create([
		 	{ name:"id", type: 'id' },
		 	{ name:"actionDate", type: 'string' },
		 	{ name:"name", type:'string' },	
			{ name:"address", type: 'string' },
			{ name:"id_print", type: 'int'},
			{ name:"id_tel", type:'int'},
			{ name:"kraj", type:'string' },
			{ name:"posta", type:'string' },
			{ name:"dogodek", type:'string' },
			{ name:"dan", type:'string' },
			{ name:"ura", type:'string' }
		])
	)
});
var <?php echo $compName;?> = new Ext.grid.EditorGridPanel({
	loadMask: true,
	sm: sm,
	store: historyStore,
	id:'<?php echo $compName;?>',
	title: '<?php echo $LangPack->GetLabel("history_tab_panel", "panel_title","Zgodovina");?>',
	columns:[{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "date_title","Datum");?>',
		hidden: true,
		dataIndex: 'actionDate'
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "name_title","Ime");?>',
		dataIndex: 'name'
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "address_title","Naslov");?>',
		dataIndex: 'address'
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "post_code_title","Pošta");?>',
		width: 50,
		dataIndex: 'posta'
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "city_title","Kraj");?>',
		dataIndex: 'kraj'
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "event_title","Dogodek");?>',
		dataIndex: 'dogodek'
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "day_title","Dan");?>',
		dataIndex: 'dan'
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "ura_title","Ura");?>',
		dataIndex: 'ura',
		width: 70
	},{
		header: '<?php echo $LangPack->GetLabel("history_tab_panel", "print_title","Tiskaj");?>',
		width: 50,
		renderer: function(x, val, record){
			return "<a href='CRM/PDFGenerator.php?userId="+x+"&pId=<?php echo $projectId;?>' target='_blank'>Tiskaj</a>";
		},
		dataIndex: 'id_tel'
	}],
	view: new Ext.grid.GroupingView({
        showGroupName: false,
        enableNoGroups: false,
		enableGroupingMenu: false,
        hideGroupedColumn: true,
        groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Vabila" : "Vabilo"]}) <?php echoSpace(2);?>-><?php echoSpace(5);?><a target=_blank href=CRM/PDFGenerator.php?printId={[values.rs[0].data["id_print"]]}&pId=<?php echo $projectId;?>><?php echo $LangPack->GetLabel("history_tab_panel", "print_all_title","Tiskaj vse");?></a> <?php echoSpace(5);?><a target=_blank href=<?php echo $export;?>&printId={[values.rs[0].data["id_print"]]}><?php echo $LangPack->GetLabel("history_tab_panel", "export_title","Export");?></a>'
    }),
	tbar:[
		new Ext.form.DateField({
			format: 'd.m.Y',
			editable: false,
			id: 'dateField<?php echo $suffix;?>',
			listeners:{
				'select': function(datefield, date){
					<?php echo $compName;?>.getStore().load({ params: { date: datefield.value }});
				}
			}
		}),{
			xtype: 'button',
			cls:'td.x-date-bottom',
    		text: "<?php echo $LangPack->GetLabel("history_tab_panel", "clear_date_button","Izbriši datum");?>",
    		handler:function(){
    			Ext.getCmp('dateField<?php echo $suffix;?>').setValue('');
    			var store = <?php echo $compName;?>.getStore();
    			store.baseParams.date = '';
    			store.load();
    		}
		},
		'->',
		new Ext.form.TwinTriggerField({
			trigger2Class:'x-form-clear-trigger',
			trigger1Class:'x-form-search-trigger',
			onTrigger1Click:function(){
				var l = <?php echo $compName;?>.getStore();
			 	l.baseParams.filter = this.getValue();
				l.load(); 
			},
			onTrigger2Click:function(){
				var l = <?php echo $compName;?>.getStore();
				delete l.baseParams.filter;
				this.setValue('');
				l.load(); 
			},
			listeners: {
	            specialkey: function(field, e){
	                // e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
	                // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
	                if (e.getKey() == e.ENTER) {
	                   field.onTrigger1Click();
	                }
	            }
	        }
		})
	],
	bbar: new Ext.PagingToolbar({
        pageSize: historyPageLimit,
        store: historyStore,
        displayInfo: true,
        displayMsg: '<?php echo $LangPack->GetLabel("history_tab_panel", "pagger_display_msg","Zgodovina vabil");?> {0} - {1} of {2}',
        emptyMsg: "<?php echo $LangPack->GetLabel("history_tab_panel", "pagger_empty_msg","Ni zgodovine");?>"
    })
});
