
var <?php echo $gridName;?> = new Ext.grid.EditorGridPanel({
	store: new Ext.data.Store({
		url: '<?php echo $ajax;?>',			
		baseParams:{
			action: 'get'
		},
		reader: new Ext.data.JsonReader({		
				root:'rows',
				totalProperty : "results"
			},
			new Ext.data.Record.create([
			 	{ name:"id", type: 'int' },
			 	{ name:"team", type:'string'},
			 	{ name:"teamId", type:'int'},
			 	{ name:"team_name", type:'string'},
			 	{ name:"city", type:'string'},
			 	{ name:"location", type:'string' },
			 	{ name:"presentation", type:'string' },
			 	{ name:"invited", type:'string' },
				{ name:"attendance", type: 'string' },
				{ name:"undecidedly", type: 'string' },
				{ name:"companions", type: 'string' },
				{ name:"male", type: 'string' },
				{ name:"female", type: 'string' },
				{ name:"not_present", type: 'string' },
				{ name:"alone", type: 'string'},
				{ name:"spouse", type: 'string'},
				{ name:"other", type: 'string'},
				{ name:"order", type: 'string'},
				{ name:"allOrders", type:'string'},
				{ name:"delivery", type: 'string'},
				{ name:"total", type: 'string' },
				{ name:"storno", type: 'string'},
				{ name:"delayed", type: 'string'},
				{ name:"corporate_card", type: 'string'},
				{ name:'loan_credit', type:'string'},
				{ name:"appeared_average", type: 'string'},
				{ name:"customer_avarage", type: 'string'},
				{ name:"traffic_avarage", type: 'string'},
				{ name:"realization", type: 'string'},
				{ name:"storno_percent", type: 'string'},
				{ name:"order_amount", type: 'string'},
				{ name:"recognized_income", type: 'string'},
				{ name:"color", type: 'string'}
			])
		)
	}),
    id: '<?php echo $gridName;?>',
    border: false,
    region: 'center',
    //collapsed: true,
    closable: true,
    tbar:['->'
    <?php if($_SESSION['UserInfo']['id'] == 1 && $_SESSION['UserInfo']['user_type'] == 1){?>
    	,{
    		text: 'Export row',
    		handler: function(){
    			var grid = Ext.getCmp('<?php echo $gridName;?>').selModel.selections.items;
    			if(grid.length > 0){
    				var data = grid[0].data;		
    				var fromDate = Ext.getCmp('time_from').getRawValue();
    				var toDate = Ext.getCmp('time_to').getRawValue();		
					var basedOn = Ext.getCmp('based_on_group').getValue().getGroupValue();
    				window.open('<?php echo $export;?>?action=exportRow&fromDate='+fromDate+'&toDate='+toDate+'&basedOn='+basedOn+'&location='+data.location+'&team='+data.teamId,'_blank');
    			}
    		}
    	}	
    <?php }?>
    ,{
    	text: '<?php echo $LangPack->GetLabel("statistic_grid", "export_button","Izvozi");?>',
    	id: 'export_statistic',
    	handler: function(){
    		var grid = Ext.getCmp('<?php echo $gridName;?>');
    		if(Ext.getCmp('time_from').isValid() && Ext.getCmp('time_to').isValid()){
    			var status = new Array();
    			var comp = Ext.getCmp('status_checkgroup');
				Ext.each(comp.items.items,function(c){
					if(c.checked){
						status.push(c.name);
					}
				});
    			
    			var fromDate = Ext.getCmp('time_from').getRawValue();
    			var toDate = Ext.getCmp('time_to').getRawValue();
				var basedOn = Ext.getCmp('based_on_group').getValue().getGroupValue();
				var teamF = Ext.getCmp('teamFilter').getValue();
				var locationF = Ext.getCmp('locationFilter').getRawValue();
    			window.open('<?php echo $export?>?action=export&fromDate='+fromDate+'&toDate='+toDate+'&basedOn='+basedOn+'&status='+Ext.encode(status)+'&teamF='+teamF+'&locationF='+locationF, '_blank');
    		}
    	}
    }],
    viewConfig: {    
		getRowClass: function(record, rowIndex, rp, ds){    	
			str = '';
			var all = Ext.getCmp('<?php echo $gridName;?>').getStore().data.length;
			if(record.get('color') == "true")
				str = 'StatisticStatusYellow';
			else if((all - 1) == rowIndex)
				str = 'StatisticStatusGray';
			return str;    
		}
    },
  	columns: [{
  			header: '#ID', 
  			width: 20, 
  			dataIndex: 'teamId',
  			hidden: true
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_team_label","Ekipa");?>', 
  			id: 'c_team',
  			dataIndex: 'team',
  			sortable: true
   		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_team_name_label","Ime ekipe");?>', 
  			sortable: true, 
  			id: 'c_team_name',
  			dataIndex: 'team_name'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_city_label","Kraj");?>',
   			sortable: true,
  			dataIndex: 'city',
  			id: 'c_city'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_location_label","Locakija");?>', 
  			sortable: true,
  			dataIndex: 'location',
  			id: 'c_location'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_presentation_label","Pedstavitev");?>', 
  			sortable: true,
  			width: 80,
  			dataIndex: 'presentation',
  			id: 'c_presentation'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_invited_label","Povabljeni");?>', 
  			sortable: true,
  			dataIndex: 'invited',
  			width: 70,
  			id: 'c_invited'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_not_present_label","Ne prisotni");?>', 
  			sortable: true,
  			dataIndex: 'not_present',
  			width: 70,
  			id: 'c_not_present'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_attendance_register_label","Udeleženi");?>', 
  			sortable: true,
  			width: 60,
  			dataIndex: 'attendance',
  			id: 'c_attendance'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_appeared_label","Spremljevalci");?>',  
  			sortable: true,
  			width: 60,
  			dataIndex: 'companions',
  			id: 'c_companions'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_total_label","Vsi prisotni");?>',  
  			sortable: true,
  			width: 60,
  			dataIndex: 'total',
  			id: 'c_total'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_male_label","Moški");?>',  
  			sortable: true,
  			width: 40,
  			dataIndex: 'male',
  			id: 'c_male'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_female_label","Ženske");?>',  
  			sortable: true,
  			width: 50,
  			dataIndex: 'female',
  			id: 'c_female'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_undecidedly_label","Neodločni");?>',  
  			sortable: true,
  			width: 70,
  			dataIndex: 'undecidedly',
  			id: 'c_undecidedly'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_alone_label","Sami");?>',  
  			sortable: true,
  			width: 50,
  			dataIndex: 'alone',
  			id: 'c_alone'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_spouse_label","Zakonec");?>',  
  			sortable: true,
  			width: 60,
  			dataIndex: 'spouse',
  			id: 'c_spouse'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_other_label","Ostalo");?>',  
  			sortable: true,
  			width: 60,
  			dataIndex: 'other',
  			id: 'c_other'
  		},{
  			header:'<?php echo $LangPack->GetLabel("statistic_grid", "column_orderAll_label","Vsa naročila");?>',
  			hidden: true,
  			width: 60,
  			dataIndex: 'allOrders',
  			id: 'c_allOrders'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_order_label","Naročila");?>',  
  			sortable: true,
  			width: 60,
  			dataIndex: 'order',
  			renderer:function(a, b, c, rowIndex){
  				var all = Ext.getCmp('<?php echo $gridName;?>').getStore().data.length;
  				if((all - 2) != rowIndex)
	  				return '<div class="x-grid3-cell-inner" style="font-weight: bold; text-align: center;width: 26px; border-radius: 10px; background-color:#3399FF;"><span style="color:white;">' + a + '</span></div>';
	  			return a;
  			},
  			id: 'c_order'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_delivery_label","Dostava");?>',  
  			sortable: true,
  			width: 60,
  			dataIndex: 'delivery',
  			id: 'c_delivery'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_storno_label","Storno");?>',  
  			sortable: true,
  			width: 80,
  			dataIndex: 'storno',
  			id: 'c_storno'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_delayed_label","Zamuda");?>',  
  			sortable: true,
  			width: 60,
  			dataIndex: 'delayed',
  			id: 'c_delayed'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_corporate_card_label","Podjetna kartica");?>',  
  			sortable: true,
  			dataIndex: 'corporate_card',
  			width:120,
  			id: 'c_corporate_card'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_loan_credit_label","Loan Credit");?>',
  			sortable: 'true',
  			dataIndex: 'loan_credit',
  			width: 100,
  			id:'c_loan_credit'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_appered_avarage_label","Povprečna pojava");?>',  
  			sortable: true,
  			width: 140,
  			dataIndex: 'appeared_average',
  			id: 'c_appeared_average'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_customer_avarage_label","Povprečnih kupcev");?>',  
  			sortable: true,
  			width: 110,
  			dataIndex: 'customer_avarage',
  			id: 'c_customer_avarage'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_traffic_avarage_label","Povprečni promet");?>',  
  			sortable: true,
  			width: 110,
  			dataIndex: 'traffic_avarage',
  			renderer: function(a){
  				return a + '<?php echo MONEY_VALUE;?>';
  			},
  			id: 'c_traffic_avarage'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_realization_label","Realizacija");?>',  
  			sortable: true,
  			width: 80,
  			dataIndex: 'realization',
  			id: 'c_realization'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_storno_precent_label","Storno");?>',  
  			sortable: true,
  			width: 80,
  			dataIndex: 'storno_percent',
  			id: 'c_storno_percent'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_order_amount_label","Znesek naročila");?>',  
  			sortable: true,
  			width: 90,
  			renderer: function(a){
  				return a + '<?php echo MONEY_VALUE;?>';
  			},
  			dataIndex: 'order_amount',
  			id: 'c_order_amount'
  		},{
  			header: '<?php echo $LangPack->GetLabel("statistic_grid", "column_recognized_income_label","Priznani prihodek");?>',  
  			sortable: true,
  			width: 120,
  			renderer: function(a){
  				return a + '<?php echo MONEY_VALUE;?>';
  			},
  			dataIndex: 'recognized_income',
  			id: 'c_recognized_income'
  		}
    ],
 	sm: new Ext.grid.RowSelectionModel({ singleSelect: true }) 
});

