<?php

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");

include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once(PATH_TO_ROOT."CRM/class/class.checkString.php");

$LangPack = new LanguagePack($db, $aLanguage);

$gridName = "previewActivitiesGrid";
$ajax = CRM_RPATH."_forms/prisotnost/_ajax/ajax.activities.php";
$windowId = "previewActivitiesWin";
$id = StringChecker::Check($_POST['id']);
$mainGrid = StringChecker::Check($_POST['gridName']);
?>
var sm = new Ext.grid.RowSelectionModel();
var <?php echo $gridName;?> = new Ext.grid.EditorGridPanel({
	id: '<?php echo $gridName;?>',
	bodyStyle:'padding: 10px',
    border: false,
    store: new Ext.data.Store({
		url: '<?php echo $ajax;?>',			
		autoLoad: true,
		baseParams:{
			action: 'get',
			customerId: '<?php echo $id;?>'
		},
		reader: new Ext.data.JsonReader({		
				root:'rows',
				totalProperty : "results"
			},
			new Ext.data.Record.create([
				{ name:"id", type: 'id' },
				{ name:"customerId", type:'int'},
			 	{ name:"activity", type: 'string' },
			 	{ name:"inputDate", type: 'string' },
			 	{ name:"addedDate", type: 'string' },
			 	{ name:"fileLocation", type:'string' },
			 	{ name:"comment", type: 'string'},
			 	{ name:"filename", type:'string'} 
			])
		)
	}),
	sm: sm,
    id: '<?php echo $gridName;?>',
    border: false,
    region: 'west',
  	columns: [{
		header: '#ID',
		dataIndex: 'id',
		hidden: true
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "customerId_title","Uporabnik id");?>',
		dataIndex: 'customerId',
		hidden: true,
		width: 50
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "activity_title","Aktivnost");?>',
		dataIndex: 'activity',
		width: 150
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "inputDate_title","Datum");?>',
		dataIndex: 'inputDate',
		renderer: Ext.util.Format.dateRenderer("d.m.Y"),
		width: 100
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "addedDate_title","Datum dodaje");?>',
		dataIndex: 'addedDate',
		hidden: true,
		width: 100
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "file_title","Datoteka");?>',
		dataIndex: 'fileLocation',
		renderer: function(a, metainfo, record){
			var temp = a.split("").reverse().join("");
			temp = temp.split(".")[0].split("").reverse().join("").toLowerCase();
			if(temp == "jpg" || temp == "jpeg" || temp == "png" || temp == "bmp" || temp == "gif")
				return "<img src='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' atl='"+a+"' style='width:100px; height:100px;'>";
			else if(temp == "pdf"){
				return "<a href='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' target='_blank'>"+record.data.filename+"</a>";
			}else if(temp == "doc" || temp == "docx"){
				return "<a href='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' target='_blank'>"+record.data.filename+"</a>";
			}else if(temp == "xlr" || temp == "xls" || temp == "xlsx"){
				return "<a href='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' target='_blank'>"+record.data.filename+"</a>";
			}else if(record.data.activityId == 6){
				return record.data.activity;
			}
			return "UNKNOWN";
		}
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "comment_title","Komentar");?>',
		dataIndex: 'comment',
		width: 200,
		editor: new Ext.form.TextArea()
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "filename_title","Ime datoteke");?>',
		dataIndex: 'filename',
		width: 150
	}],
	listeners:{
		celldblclick: function(grid, rowIndex, columnIndex){
			if(columnIndex != 6){
				var record = grid.getStore().getAt(rowIndex);
				window.open('<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>' + record.data.fileLocation).focus();
			}	
		},
		afteredit : function(e) {
   			Ext.Ajax.request({
   				url:'<?php echo $ajax;?>',
   				params: { 
   					action: 'update',
					id		: e.record.id,
				    field	: e.field,
					value 	: e.value,
					oldValue: e.originalValue			
   				},
				success : function(resp,opt){ 
					e.record.commit();
				}							  							
			})
		}	
	},
	tbar:['->',{
		text: '<?php echo $LangPack->GetLabel("preview_activities_window", "delete_button_title","Brisanje");?>',
		iconCls: 'icon-delete-record',
		handler: function(){
			var selection = Ext.getCmp('<?php echo $gridName;?>').selModel.selections;
			if(selection.item.length>0){
				Ext.Ajax.request({
	   				url:'<?php echo $ajax;?>',
	   				params: { 
	   					action: 'deleteActivity',
						id		: selection.items[0].data.id		
	   				},
					success : function(resp,opt){ 
						Ext.getCmp('<?php echo $gridName;?>').getStore().reload();
					}				
				})
			}
		}
	}]
});

var <?php echo $windowId;?> = new Ext.Window({
   	title:'<?php echo $LangPack->GetLabel("preview_activities_window", "window_title","Pregled");?>',
    id		: '<?php echo $windowId;?>',
    width	: 750,
    height	: 400,
    plain	: true,
    layout: 'fit',
    frame: true,
    modal: true,
    items:[<?php echo $gridName;?>],
	listeners: {
		afterRender: function(grid){
			var X = (screen.width/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().width)/2);
			var Y = (screen.height/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().height)/2);
			Ext.getCmp('<?php echo $windowId;?>').setPosition(X, Y);
		}
	}
}).show();