<?php

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");

include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once(PATH_TO_ROOT."CRM/class/class.ZipChecker.php");
include_once(PATH_TO_ROOT."CRM/class/class.checkString.php");

$LangPack = new LanguagePack($db, $aLanguage);

$zipChecker = new ZipChecker($db, "postna_st", "kraj");

$zipAjax = CRM_RPATH."_forms/_ajax/ajax.zipCheck.php";

$suffix = StringChecker::Check($_POST['suffix']);
$gridName = "OsebaTab".$suffix;
$ajax = CRM_RPATH."_forms/prisotnost/_ajax/ajax.oseba.php";
$windowId = "windowOsebaId";

$zipId = StringChecker::Check($_POST['zipId']);
$dan = StringChecker::Check($_POST['dan']);
$ura = StringChecker::Check($_POST['ura']);

$cati_location = StringChecker::Check($_POST['cati_location']);
$projectId = StringChecker::Check($_POST['projectId']);
$id_tel = StringChecker::Check($_POST['id_tel']);
?>
var <?php echo $gridName;?> = new Ext.form.FormPanel({
	id:'<?php echo $gridName;?>',
	bodyStyle:'padding: 20px',
	border: false,
	region: 'center',
	autoScroll: true,
	labelAlign: 'left',
	labelWidth: 150,
	items:[{
		layout:'form',
		anchor: '-0',
		xtype: 'fieldset',
		autoHeight: true,
		title: '<?php echo $LangPack->GetLabel("edit_user_window", "user_fiedset_title","Podatki o osebi");?>',
        items:[{
        	name: 'ime',
        	xtype: 'textfield',
			hideTrigger: true,
        	triggerAction: 'all',
        	mode: 'remote',
        	store: new Ext.data.JsonStore({
                url : '<?php echo $ajax; ?>',
                root : 'rows',
                baseParams: {
                    action: 'getByName',
					dan: <?php echo $dan;?>,
					ura: <?php echo $ura;?>,
					cati_location: '<?php echo $cati_location;?>'
                },
             //   autoLoad: true,
                fields:[
					{ name:"id", type: 'int' },
					{ name:"name", type: 'string'},
					{ name:"table", type: 'string'}
                ]
            }),
            listeners:{
            	select: function(comp, a, b){
                    var comboStore = comp.getStore();
                    var data = comboStore.getAt(comboStore.findExact('id', comp.getValue())).data;
            		selectFunction(data.id,data.table);
            	}
            },
            valueField: 'id',
            displayField: 'name',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "name_title","Ime");?>'
        	<?php if(isset($_POST['addType'])) echo ", allowBlank: false" ?>
		},{
        	name: 'priimek',
        	xtype: 'textfield',
			hideTrigger: true,
        	triggerAction: 'all',
        	mode: 'remote',
        	store: new Ext.data.JsonStore({
                url : '<?php echo $ajax; ?>',
                root : 'rows',
                baseParams: {
                    action: 'getBySurname',
					dan: <?php echo $dan;?>,
					ura: <?php echo $ura;?>,
					cati_location: '<?php echo $cati_location;?>'
                },
               // autoLoad: true,
                fields:[
					{ name:"id", type: 'int' },
					{ name:"name", type: 'string'},
					{ name:"table", type: 'string'}
                ]
            }),
            listeners:{
            	select: function(comp, a, b){
                    var comboStore = comp.getStore();
                    var data = comboStore.getAt(comboStore.findExact('id', comp.getValue())).data;
            		selectFunction(data.id,data.table);
            	}
            },
            valueField: 'id',
            displayField: 'name',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "surname_title","Priimek");?>'
        	<?php if(isset($_POST['addType'])) echo ", allowBlank: false" ?>
		},{
			xtype: 'radiogroup',
        	name: 'spol',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "gender_title","Spol");?>',
        	id: 'spol<?php echo $suffix;?>',
        	items: [
        		{ boxLabel: '<?php echo $LangPack->GetLabel("CRM_all", "male_gender_title","Moški");?>', name: 'spol', inputValue: 1 },
        		{ boxLabel: '<?php echo $LangPack->GetLabel("CRM_all", "female_gender_title","Ženski");?>', name: 'spol', inputValue: 2 }
        	]
		},{
        	name: 'naslov',
        	xtype: 'textfield',
			hideTrigger: true,
        	triggerAction: 'all',
        	mode: 'remote',
        	store: new Ext.data.JsonStore({
                url : '<?php echo $ajax; ?>',
                root : 'rows',
                baseParams: {
                    action: 'getByAddress',
					dan: <?php echo $dan;?>,
					ura: <?php echo $ura;?>,
					cati_location: '<?php echo $cati_location;?>'
                },
                autoLoad: true,
                fields:[
					{ name:"id", type: 'int' },
					{ name:"name", type: 'string'},
					{ name:"table", type: 'string'}
                ]
            }),
            listeners:{
            	select: function(comp, a, b){
                    var comboStore = comp.getStore();
                    var data = comboStore.getAt(comboStore.findExact('id', comp.getValue())).data;
            		selectFunction(data.id,data.table);
            	}
            },
            valueField: 'id',
            displayField: 'name',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "address_title","Naslov");?>',
        	anchor: '100%'
		},{
			xtype: 'numberfield',
        	name: 'postna_st',
        	id: 'postna_st',
        	enableKeyEvents: true,
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "post_code_title","Poštna številka");?>',
			minValue: 0,
			width: 50
		},{
        	name: 'kraj',
        	id: 'kraj',
        	xtype: 'combo',
			hideTrigger: true,
        	triggerAction: 'all',
        	mode: 'remote',
        	store: new Ext.data.JsonStore({
                url : '<?php echo $zipAjax; ?>',
                root : 'rows',
                baseParams: {
                    action: 'getCity'
                },
                autoLoad: true,
                fields:[
					{ name:"textColumn", type: 'string' },
					{ name:"codeColumn", type: 'int'}
                ]
            }),
            valueField: 'textColumn',
            displayField: 'textColumn',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "city_title","Kraj");?>'
		},{
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "email_title","Email");?>',
            name: 'email',
            vtype:'email',
            xtype: 'textfield'
		},{
			xtype: 'textfield',
        	name: 'poklic',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "occupation_title","Poklic");?>'
		},{
			xtype: 'radiogroup',
        	name: 'zakonski_stan',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "marital_status_title","Zakonski stan");?>',
        	id: 'stan<?php echo $suffix;?>',
        	items: [
        		{ boxLabel: '<?php echo $LangPack->GetLabel("CRM_all", "marital_status_single_title","Samski");?>', name: 'stan', inputValue: 1 },
        		{ boxLabel: '<?php echo $LangPack->GetLabel("CRM_all", "marital_status_maried_title","Pročen");?>', name: 'stan', inputValue: 2 }
        	]
		},{
			xtype: 'compositefield',
			items: [
	            new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "date_of_birth_title","Datum rojstva");?>',
				    width: 50,
				    name: 'dan_rojstva',
				    id: 'dan_rojstva',
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store: new Ext.data.ArrayStore({
				        fields: [ 'dan' ],
				        data: [<?php $d = array(); for($i=1; $i<=31; $i++) { array_push($d, '['.$i.']'); } echo implode(', ', $d); ?>]
				    }),
				    valueField: 'dan',
				    displayField: 'dan'
				}),
		        new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    width: 50,
				    name: 'mesec_rojstva',
				    id: 'mesec_rojstva',
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store: new Ext.data.ArrayStore({
				        fields: [ 'mesec' ],
				        data: [<?php $d = array(); for($i=1; $i<=12; $i++) { array_push($d, '['.$i.']'); } echo implode(', ', $d); ?>]
				    }),
				    valueField: 'mesec',
				    displayField: 'mesec'
				}),
		        new Ext.form.ComboBox({
				    typeAhead: true,
				    width: 100,
				    name: 'leto_rojstva',
				    id: 'leto_rojstva',
				    triggerAction: 'all',
				    lazyRender:true,
				    selectOnFocus: true,
				    mode: 'local',
				    listeners: {
				    	expand: function(cm){
				    		cm.setValue('1963');
				    	}
				    },
				    store: new Ext.data.ArrayStore({
				        fields: [ 'leto' ],
				        data: [<?php $d = array(); for($i=date('Y'); $i>=1900; $i--) { array_push($d, '['.$i.']'); } echo implode(', ', $d); ?>]
				    }),
				    valueField: 'leto',
				    displayField: 'leto'
				})
			]
		},{
			xtype: 'checkbox',
        	name: 'trzenje_omogoceno',
        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "direct_marketing_title","Neposredno trženje omogočeno");?>'
		},{
        	name: 'tel1',
        	xtype: 'textfield',
			hideTrigger: true,
        	triggerAction: 'all',
        	mode: 'remote',
        	store: new Ext.data.JsonStore({
                url : '<?php echo $ajax; ?>',
                root : 'rows',
                baseParams: {
                    action: 'getByPhone',
					dan: <?php echo $dan;?>,
					ura: <?php echo $ura;?>,
					cati_location: '<?php echo $cati_location;?>'
                },
                autoLoad: true,
                fields:[
					{ name:"id", type: 'int' },
					{ name:"name", type: 'string'},
					{ name:"table", type: 'string'}
                ]
            }),
            listeners:{
            	select: function(comp, a, b){
                    var comboStore = comp.getStore();
                    var data = comboStore.getAt(comboStore.findExact('id', comp.getValue())).data;
            		selectFunction(data.id,data.table);
            	}
            },
            valueField: 'id',
            displayField: 'name',
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "phone1_title","Telefonska številka 1");?>',
		},{
			xtype: 'textfield',
        	name: 'tel2',
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "phone2_title","Telefonska številka 2");?>',
		},{
			xtype: 'textfield',
        	name: 'tel3',
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "phone3_title","Telefonska številka 3");?>',
		},{
			xtype: 'textfield',
        	name: 'Termogram1',
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "termogram1_title","Termogram 1");?>',
		},{
			xtype: 'textfield',
        	name: 'Termogram2',
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "termogram2_title","Termogram 2");?>',
		},{
			xtype: 'textfield',
        	name: 'kisik1',
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "oxygen1_title","Kisik 1");?>',
		},{
			xtype: 'textfield',
        	name: 'kisik2',
			fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "oxygen2_title","Kisik 2");?>',
		}]
	}]
});
<?php if(!isset($_POST['addType'])) {?>
Ext.getCmp('<?php echo $gridName;?>').getForm().load({
	url: '<?php echo $ajax;?>',
	params:{
		action: 'get',
		id_tel: '<?php echo $id_tel;?>',
		projectId: '<?php echo $projectId;?>'
	}
});
<?php }?>
var <?php echo $windowId;?> = new Ext.Window({
   	title:'<?php echo $LangPack->GetLabel("edit_user_window", "window_title","Oseba");?>',
    id		: '<?php echo $windowId;?>',
    width	: 460,
    height	: 520,
    plain	: true,
    layout	: 'border',
    frame: true,
    modal: true,
    items	: [
		<?php echo $gridName;?>
	],
	listeners: {
		afterRender: function(grid){
			var X = (screen.width/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().width)/2);
			var Y = (screen.height/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().height)/2);
			Ext.getCmp('<?php echo $windowId;?>').setPosition(X, Y);
			if(Ext.getCmp('addUserWindow')){
				Ext.getCmp('addUserWindow').close();
			}
		}
	},
	buttons:[{
		text:'<?php echo $LangPack->GetLabel("CRM_all", "CRM_cancle_button","Prekliči"); ?>',
		handler: function(){
			<?php echo $windowId;?>.close();
		}
	},{
		text: '<?php echo $LangPack->GetLabel("CRM_all","CRM_save_button","Shrani");?>',
		handler: function(){
			if(Ext.getCmp('<?php echo $gridName;?>').getForm().isValid()){
				Ext.getCmp('<?php echo $gridName;?>').getForm().submit({
					url: '<?php echo $ajax;?>', 
					params: { 
						action: '<?php if(isset($_POST['addType'])) echo "addNew"; else echo "submit"; ?>', 
						id_tel: '<?php echo $id_tel;?>',
						id_tel_type: '<?php if(isset($_POST['addType'])) { if($_POST['addType'] == 'add') echo "1"; else echo "2"; } else echo "1";?>',
						projectId: '<?php echo $projectId;?>', 
						suffix: '<?php echo $suffix; ?>',
						cati_location: '<?php echo $cati_location;?>' 
						<?php if(isset($_POST['addType'])) echo ",dan: ".$dan.", ura: ".$ura; ?>
						<?php if(isset($_POST['id_tel'])) echo ", id_tel: ".$id_tel; ?>
					},
					clientValidation: true,
					success: function(form, action) {
				        Ext.Msg.alert('Success', action.result.msg);
				        Ext.getCmp('PrisotnostUserGrid<?php echo $suffix;?>').getStore().reload();
				        Ext.getCmp('SubUserGrid<?php echo $suffix;?>').getStore().reload();
				        Ext.getCmp('StatisticGrid').getEl().mask('<?php echo $LangPack->GetLabel("CRM_all", "loading_mask_text","Posodabljanje..."); ?>');
						
						Ext.getCmp('StatisticGrid').getStore().load({
							params: { 
								action: 'get',
								project_id: '<?php echo $projectId; ?>',
								dan: '<?php echo $dan;?>',
								ura: '<?php echo $ura;?>',
								cati_location: '<?php echo $cati_location; ?>'
							},
							callback: function(store, opt, success){
								if(success){
									Ext.getCmp('StatisticGrid').getEl().unmask();
								}
							}
						});
						if(action.result.close)
							Ext.getCmp('<?php echo $windowId;?>').close();
				    },
				    failure: function(form, action) {
				        switch (action.failureType) {
				            case Ext.form.Action.CLIENT_INVALID:
				                Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
				                break;
				            case Ext.form.Action.CONNECT_FAILURE:
				                Ext.Msg.alert('Failure', 'Ajax communication failed');
				                break;
				            case Ext.form.Action.SERVER_INVALID:
				               Ext.Msg.alert('Failure', action.result.msg);
				               break;
				       }
				    }
				});
			}
		}
	}]
}).show();

var selectFunction = function(id, table){
	Ext.getCmp('<?php echo $gridName;?>').getForm().load({
		url: '<?php echo $ajax;?>',
		params:{
			action: 'loadFromSelect',
			id: id,
			table: table
		}
	});
}

<?php $zipChecker->SetUp(); ?>