<?php

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");

include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once(PATH_TO_ROOT."CRM/class/class.checkString.php");

$LangPack = new LanguagePack($db, $aLanguage);

$suffix = StringChecker::Check($_POST['suffix']);
$gridName = "LoanTab".$suffix;
$ajax = CRM_RPATH."_forms/prisotnost/_ajax/ajax.creditLoan.php";
$windowId = "windowLoan";
$mainGrid = StringChecker::Check($_POST['gridName']);
?>

var <?php echo $gridName;?> = new Ext.grid.EditorGridPanel({
	store: new Ext.data.Store({
		url: '<?php echo $ajax;?>',			
		autoLoad: true,
		baseParams:{
			action: 'get',
			id: '<?php echo $_POST['userId'];?>'
		},
		reader: new Ext.data.JsonReader({		
			root:'rows',
			totalProperty : "results"
		},
		new Ext.data.Record.create([
			{ name:"id", type: 'id' },
			{ name:"opis", type:'string'},
			{ name:"Glavnica", type: 'float'},
			{ name:"Obresti", type: 'float'},
			{ name:"Skupaj", type: 'float'},
			{ name:"Zapade", type:'string'}
			])
		)
	}),
	region: 'center',
	id: '<?php echo $gridName;?>',
	columns:[{
		header: '<?php echo $LangPack->GetLabel("loan_calculate_window", "description_title","Opis");?>',
		dataIndex: 'opis'
	},{
		header: '<?php echo $LangPack->GetLabel("loan_calculate_window", "principal_title","Glavnica");?>',
		renderer:function(a){
			return a + ' <?php echo MONEY_VALUE;?>';
		},
		dataIndex: 'Glavnica'
	},{
		header: '<?php echo $LangPack->GetLabel("loan_calculate_window", "interest_title","Obresti");?>',
		renderer:function(a){
			return a + ' <?php echo MONEY_VALUE;?>';
		},
		dataIndex: 'Obresti'
	},{
		header: '<?php echo $LangPack->GetLabel("loan_calculate_window", "total_title","Skupaj");?>',
		renderer:function(a){
			return a + ' <?php echo MONEY_VALUE;?>';
		},
		dataIndex: 'Skupaj'
	},{
		header: '<?php echo $LangPack->GetLabel("loan_calculate_window", "due_title","Zapade");?>',
		dataIndex: 'Zapade'
	}]
});

var <?php echo $windowId;?> = new Ext.Window({
   	title:'<?php echo $LangPack->GetLabel("loan_calculate_window", "window_title","Amortizacijski načrt");?>',
    id		: '<?php echo $windowId;?>',
    width	: 540,
    height	: 520,
    plain	: true,
    layout: 'fit',
    frame: true,
    modal: true,
    items:[<?php echo $gridName;?>],
	listeners: {
		afterRender: function(grid){
			var X = (screen.width/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().width)/2);
			var Y = (screen.height/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().height)/2);
			Ext.getCmp('<?php echo $windowId;?>').setPosition(X, Y);
		}
	}
}).show();