<?php 
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once(PATH_TO_ROOT."CRM/class/class.checkString.php");

$LangPack = new LanguagePack($db, $aLanguage);

$ajax = CRM_RPATH."_forms/prisotnost/_ajax/ajax.users.php";
$windowId = "addUserWindow";	
$cati_location = StringChecker::Check($_POST['cati_location']);
?>
var userPageSize = 50;
var userStore = new Ext.data.Store({
	pageSize: userPageSize,
	url: '<?php echo $ajax;?>',			
	baseParams:{
		action: 'getExisting',
		start: 0,
		limit: userPageSize
	},
	reader: new Ext.data.JsonReader({		
			root:'rows',
			totalProperty : "results"
		},
		new Ext.data.Record.create([
			{ name: "id", type: 'id'},
			{ name: "name", type: 'string' },
			{ name: "town", type: 'string' },
			{ name: "zip", type: 'int' },
			{ name: "address", type: 'string' }
		])
	)
});
var grid = new Ext.grid.EditorGridPanel({
    region: 'center', 
    id: 'userSearchGridId',
    store: userStore,
	loadMask: true,
	sm: new Ext.grid.RowSelectionModel({ singleSelect: true}),
    defaults:{autoScroll:true},
    columns:[{
    	header: '<?php echo $LangPack->GetLabel("user_add_window", "name_column","Ime");?>',
    	dataIndex: 'name'
    },{
    	header: '<?php echo $LangPack->GetLabel("user_add_window", "address_column","Naslov");?>',
    	dataIndex: 'address'
    },{
    	header: '<?php echo $LangPack->GetLabel("user_add_window", "post_code_column","Pošta");?>',
    	dataIndex: 'zip'
    },{
    	header: '<?php echo $LangPack->GetLabel("user_add_window", "city_column","Kraj");?>',
    	dataIndex: 'town'
    }],
    bbar: new Ext.PagingToolbar({
        pageSize: userPageSize,
        store: userStore,
        displayInfo: true,
        displayMsg: '<?php echo $LangPack->GetLabel("user_add_window", "pagging_display_msg","Prikazane osebe");?> {0} - {1} of {2}',
        emptyMsg: "<?php echo $LangPack->GetLabel("user_add_window", "pagging_emtpy_msg","Ni rezultatov");?>"
    })
});
var nav = new Ext.form.FormPanel({
    region: 'west',
    split: true,
    width: 250,
    id: 'userFormPanelId',
    padding: 10,
    items:[{
    	xtype: 'fieldset',
		autoHeight: true,
		title: '<?php echo $LangPack->GetLabel("user_add_window", "fieldset_search_title","Iskanje");?>',
		defaults: {anchor: '95%'},
		labelWidth: 50,
		defaultType: 'textfield',
		items:[{
			fieldLabel: '<?php echo $LangPack->GetLabel("user_add_window", "city_title","Kraj");?>',
	    	id: 'mestoFieldId'
	    },{
	    	fieldLabel: '<?php echo $LangPack->GetLabel("user_add_window", "surname_title","Priimek");?>',
	    	id: 'surnameFieldId'
	    },{
	    	fieldLabel: '<?php echo $LangPack->GetLabel("user_add_window", "name_title","Ime");?>',
	    	id: 'nameFieldId'
	    },{
	    	fieldLabel: '<?php echo $LangPack->GetLabel("user_add_window", "address_title","Naslov");?>',
	    	id: 'naslovFieldId'
	    },{
	    	xtype:'button',
	    	text: '<?php echo $LangPack->GetLabel("CRM_all", "CRM_search_button","Iskanje");?>',
	    	handler: function(){
	    		var name = Ext.getCmp('nameFieldId').getValue();
	    		var surname = Ext.getCmp('surnameFieldId').getValue();
	    		var mesto = Ext.getCmp('mestoFieldId').getValue();
	    		var naslov = Ext.getCmp('naslovFieldId').getValue();
				grid.getEl().mask({msg:"<?php echo $LangPack->GetLabel("CRM_all", "search_mask_text","Iskanje..."); ?>"});
	    		grid.getStore().load({params: { Name: name, Surname: surname, City: mesto, Address: naslov }, callback: function(records, operation, success){
	    			if(success){
						grid.getEl().unmask();
					}
	    		}});
	    	}
	    }]
    },{
		xtype:'button',
		anchor: '100%',
		text: '<?php echo $LangPack->GetLabel("user_add_window", "add_person_title","Dodaj novo osebo");?>',
		handler: function(){
			CallScript('<?php echo CRM_RPATH; ?>_forms/prisotnost/window.editUser.php', { 
				projectId: '<?php echo StringChecker::Check($_POST['projectId']);?>', 
				addType: '<?php echo StringChecker::Check($_POST['action']);?>', 
				dan: '<?php echo StringChecker::Check($_POST['dan']);?>', 
				ura: '<?php echo StringChecker::Check($_POST['ura']);?>',
				cati_location: '<?php echo StringChecker::Check($_POST['cati_location']);?>',
				cati_location: '<?php echo $cati_location;?>',
				suffix: '<?php echo StringChecker::Check($_POST['suffix']);?>'
				<?php if(isset($_POST['id_tel'])) echo ", id_tel: '".StringChecker::Check($_POST['id_tel'])."'";?>
			});
		}
    }]
});

var <?php echo $windowId;?> = new Ext.Window({
    title	: '<?php echo $LangPack->GetLabel("user_add_window", "window_title","Dodaj");?>',
    id		: '<?php echo $windowId;?>',
    width	: 700,
    height	: 550,
    plain	: true,
    layout	: 'border',
    frame: true,
    modal: true,
    items	: [
    	nav, 
    	grid
	],
	listeners: {
		afterRender: function(grid){
			var X = (screen.width/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().width)/2);
			var Y = (screen.height/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().height)/2);
			Ext.getCmp('<?php echo $windowId;?>').setPosition(X, Y);
		}
	},
	buttons:[{
		text: '<?php echo $LangPack->GetLabel("CRM_all", "CRM_add_button","Dodaj"); ?>',
		handler: function(){
			var sel = Ext.getCmp('userSearchGridId').getSelectionModel().selections;
			if(sel.length != 0){
				var data = sel.items[0].data;
				var ime = data.name.split(' ');
				
				Ext.Ajax.request({
	    				url: '<?php echo $ajax;?>',
	    				params:{
	    					action: 'addNewUser',
	    					projectId: '<?php echo StringChecker::Check($_POST['projectId']);?>',
	    					id: data.id,
	    					name: ime[0],
	    					surname: ime[1],
	    					address: data.address,
	    					cati_location: '<?php echo $cati_location;?>',
	    					town: data.town,
	    					addType: '<?php echo StringChecker::Check($_POST['action']); ?>',
	    					dan: <?php echo StringChecker::Check($_POST['dan']);?>,
	    					ura: <?php echo StringChecker::Check($_POST['ura']);?>,
	    					cati_location: '<?php echo StringChecker::Check($_POST['cati_location']);?>'
	    					<?php if(isset($_POST['id_tel'])) echo ", id_tel: ".StringChecker::Check($_POST['id_tel']); ?>
	    				},
	    				success: function(resp, opt){
	    					var json = Ext.decode(resp.responseText);
	    					if(json.response == 1){
	    						Ext.Msg.alert('<?php echo $LangPack->GetLabel("user_add_window", "user_exists_title","Uporabnik obstaja"); ?>', '<?php echo $LangPack->GetLabel("user_add_window", "user_exists_msg","Ta uporabnik je že v bazi!"); ?>');
	    					}else{
	    						Ext.getCmp('<?php echo $windowId;?>').close();
	    						Ext.getCmp('PrisotnostUserGrid<?php echo StringChecker::Check($_POST['suffix']);?>').getStore().reload();
	    						Ext.getCmp('SubUserGrid<?php echo StringChecker::Check($_POST['suffix']);?>').getStore().reload();
	    					}
	    				}
	    			});
				
			}else{
				Ext.Msg.alert('<?php echo $LangPack->GetLabel("user_add_window", "no_user_selected_title","Izberi osebo"); ?>', '<?php echo $LangPack->GetLabel("user_add_window", "no_user_selected_msg","Prosim izberite eno osebo iz seznama"); ?>');
			}
		}
	}]
}).show();