<?php 
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once(PATH_TO_ROOT."CRM/class/class.checkString.php");

/* Language Pack */
$langPack = new LanguagePack($db,$aLanguage);


$ajax = "CRM/_forms/nastavitve/_ajax/ajax.translation.php";
$table = "_TranslationTabel";
$idField = "id" ; 
$compName = "TranslationGrid";

?>

var translatePageLimit = 50;
var sm = new Ext.grid.RowSelectionModel();
var translateStore = new Ext.data.GroupingStore({
	pageSize: translatePageLimit,
	url: '<?php echo $ajax;?>',
	groupField: 'area',
	groupDir: 'DESC',
	baseParams: {
		action: 'get',
		start: 0,
		limit: translatePageLimit
	},
	reader: new Ext.data.JsonReader({		
			root:'rows',
			totalProperty : "results"
		},
		new Ext.data.Record.create([
		 	{name:'id', type:'id'},
			{name:'area', type:'string'},
			{name:'langKey', type:'string'},
			{name:'en', type:'string'},
			{name:'si', type:'string'},
			{name:'hr', type:'string'}
		])
	)
});
var <?php echo $compName;?> = new Ext.grid.EditorGridPanel({
	id:'<?php echo $compName;?>',
	store: translateStore,
	sm: sm,
	title: '<?php echo StringChecker::Check($_POST['tabName']);?>',
	closable: true,
	columns:[{
		header: '<?php echo $langPack->GetLabel("Transalte_Table", "area_title", "Area");?>',
		dataIndex: 'area',
		editor: new Ext.form.TextField()
	},{
		header: '<?php echo $langPack->GetLabel("Transalte_Table", "lang_key_title", "lang-Key");?>',
		dataIndex: 'langKey'
	},{
		header: '<?php echo $langPack->GetLabel("Transalte_Table", "en_title", "English");?>',
		dataIndex: 'en',
		editor: new Ext.form.TextField()
	},{
		header: '<?php echo $langPack->GetLabel("Transalte_Table", "si_title", "Slovensko");?>',
		dataIndex: 'si',
		editor: new Ext.form.TextField()
	},{
		header: '<?php echo $langPack->GetLabel("Transalte_Table", "hr_title", "Hrvatski");?>',
		dataIndex: 'hr',
		editor: new Ext.form.TextField()
	}],
	view: new Ext.grid.GroupingView({
		forceFit: true,
        showGroupName: true,
        enableNoGroups: false,
		enableGroupingMenu: false,
        hideGroupedColumn: true,
        groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Prevodi" : "Prevod"]})'
    }),
	tbar:['->',
		new Ext.form.TwinTriggerField({
		trigger2Class:'x-form-clear-trigger',
		trigger1Class:'x-form-search-trigger',
		onTrigger1Click:function(){
			var l = <?php echo $compName;?>.getStore();
		 	l.baseParams.filter = this.getValue();
		 	
		 	Ext.getCmp('<?php echo $compName?>').getEl().mask({msg:"<?php echo $langPack->GetLabel("CRM_all", "search_mask_text","Iskanje..."); ?>"});
			l.load({callback: function(records, operation, success){
				if(success){
					Ext.getCmp('<?php echo $compName?>').getEl().unmask();
				}
			}});

		},
		onTrigger2Click:function(){
			var l = <?php echo $compName;?>.getStore();
			delete l.baseParams.filter;
			this.setValue('');
			l.load(); 
		},
		listeners: {
            specialkey: function(field, e){
                // e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
                // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
                if (e.getKey() == e.ENTER) {
                   field.onTrigger1Click();
                }
            }
        }
	})],
	bbar: new Ext.PagingToolbar({
        pageSize: translatePageLimit,
        store: translateStore,
        displayInfo: true,
        displayMsg: '<?php echo $langPack->GetLabel("Transalte_Table", "pagger_display_msg","Število prevodov");?> {0} - {1} of {2}',
        emptyMsg: "<?php echo $langPack->GetLabel("Transalte_Table", "pagger_empty_msg","ni prevodov");?>"
   }),
	listeners: {
   		afteredit : function(e) {
   			Ext.Ajax.request({
   				url:'<?php echo $ajax;?>',
   				params: { 
   					action: 'update',
					id		: e.record.id,
				    field	: e.field,
					value 	: e.value,
					oldValue: e.originalValue,
					table 	:'<?php echo WARPIT_CRM."._TranslationTabel";?>'					
   				},
				success : function(resp,opt){ 
					e.record.commit();
				}							  							
			})
		}	
	}   
});
<?php echo $compName;?>.getStore().reload();
Ext.getCmp('NastavitveTabPanel').add(<?php echo $compName;?>);
Ext.getCmp('NastavitveTabPanel').setActiveTab(<?php echo $compName;?>);