<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."config.php");
include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Permissions.php");
	
$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
$ajax = CRM_RPATH."_forms/kartoteka/_ajax/ajax.kartoteka.php"; 

include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");

$LangPack = new LanguagePack($db, $aLanguage);
$p = new Permissions($db);
$windowId = "WindowSelectPerson";
$gridName = "UserSearchGrid";
?>

var pageLimit = 50;

var store = new Ext.data.Store({
			    url: '<?php echo $ajax;?>',
			    mode: 'remote',         
			    autoLoad: true,
			    baseParams:{
			        action: 'searchPerson',
			        start: 0,
			        limit: pageLimit
			    },
			    reader: new Ext.data.JsonReader({       
			            root:'rows',
			            totalProperty : 'results'
			        },
			        new Ext.data.Record.create([
			            { name:'id', type: 'id' },
			            { name:'ime', type:'string'},
			            { name:'priimek', type:'string'},
			            { name:'naslov', type:'string'},
			            { name:'mesto', type:'string'},
			            { name:'posta', type:'string'},
			            { name:'datum_pristopa', type: 'string'},
			            { name:'color', type:'string'}
			        ])
			    )
			});

var <?php echo $windowId;?> = new Ext.Window({
	title: '<?php echo $LangPack->GetLabel("Kartoteka", "window_title","Izbira osebe"); ?>',
    id		: '<?php echo $windowId;?>',
    width	:800,
    height	: 500,
    plain	: true,
    layout	: 'fit',
    frame: true,
    modal: true,
    items:[new Ext.grid.GridPanel({
			flex: 1,
			store: store,
			region: 'center',
			viewConfig: {
				forceFit: true,
				getRowClass: function(record, rowIndex, rp, ds){
					str = '';
					if (record.get('color') == "green") str = 'OrderStatusGreen';
					else if(record.get('color') == "red") str = 'OrderStatusRed';
					else if(record.get('color') == "gray") str = 'OrderStatusGray'; 
					return 'x-grid3-row-collapsed ' + str;  
				} 
			},
			name: 'selectPersonGrid',
			id: 'selectPersonGrid',
			columns: [{
				header: '#ID',
				dataIndex: 'id',
				hidden: true
			},{
				header: '<?php echo $LangPack->GetLabel("Kartoteka", "firstname_column_title","Ime"); ?>',
				dataIndex: 'ime',
				width: 100
			},{
				header: '<?php echo $LangPack->GetLabel("Kartoteka", "surname_column_title","Priimek"); ?>',
				dataIndex: 'priimek'
			},{
				header: '<?php echo $LangPack->GetLabel("Kartoteka", "address_column_title","Naslov"); ?>',
				dataIndex: 'naslov',
				width: 250
			},{
				header: '<?php echo $LangPack->GetLabel("Kartoteka", "city_column_title","Mesto"); ?>',
				dataIndex: 'mesto'
			},{
				header: '<?php echo $LangPack->GetLabel("Kartoteka", "post_code_column_title","Poštna št."); ?>',
				dataIndex: 'posta'
			},{
			  header: '<?php echo $LangPack->GetLabel("Kartoteka", "attended_date_column_title","Datum pristopa"); ?>',
			  dataIndex: 'datum_pristopa'  
			},{
				header:'#COLOR',
				hidden: true,
				dataIndex: 'color'
			}],
			listeners: {
				'rowclick': function(){
					Ext.getCmp('select').enable();
				},
				'rowdblclick': function(grid, index, rec){
		    		var val = Ext.getCmp('selectPersonGrid').getSelectionModel().selections.items[0].data.id;
		    		<?php if($_SESSION['CRM_login']) { ?>
                        Ext.getCmp('west-panel').collapse();
                        CallScript('<?php echo CRM_RPATH; ?>_forms/kartoteka/forms.main.panel.php', { id: val });
                    <?php } else {?>
                        addTabAuto('KartotekaPanel_'+val,'<?php echo CRM_RPATH; ?>_forms/kartoteka/forms.main.panel.php', { id: val });
                    <?php }?>
		    		//CallScript('<?php echo CRM_RPATH; ?>_forms/kartoteka/forms.main.panel.php', { id: val });
		    		Ext.getCmp('<?php echo $windowId;?>').close();
		    	}
			}
	})],
	bbar: new Ext.PagingToolbar({
        pageSize: pageLimit,
        store: store,
        displayInfo: true,
        displayMsg: '<?php echo $LangPack->GetLabel("Kartoteka", "pagger_display_msg","Osebe");?> {0} - {1} of {2}',
        emptyMsg: '<?php echo $LangPack->GetLabel("Kartoteka", "pagger_empty_msg","Ni oseb");?>'
    }),
    tbar: [
    	'->',
    	{
    	    xtype: 'datefield',
    	    format: 'd.m.Y',
    	    id: 'attendedDate',
    	    emptyText: '<?php echo $LangPack->GetLabel("Kartoteka", "attended_date_column_title","Datum pristopa"); ?>',
    	    name: 'attendedDate',
    	    listeners:{
    	        blur: function(comp){
    	            if(comp.getRawValue() == ""){
    	                var s = Ext.getCmp('selectPersonGrid').getStore();
    	                delete s.baseParams.date;
    	                s.load();
    	            }
    	        },
    	        select: function(comp){
    	            var s = Ext.getCmp('selectPersonGrid').getStore();
    	            s.baseParams.date = comp.getRawValue();
                    Ext.getCmp('WindowSelectPerson').bottomToolbar.changePage(1);       	
                }
    	    }
    	},
    	new Ext.form.Label({
			text: '<?php echo $LangPack->GetLabel("Kartoteka", "searcher_label","Iskanje: ");?>',    		
    	}),
    	new Ext.form.TwinTriggerField({
			trigger2Class:'x-form-clear-trigger',
			trigger1Class:'x-form-search-trigger',
			id: 'personSearcher',
			onTrigger1Click: function(){
				//iskanje
				var s = Ext.getCmp('selectPersonGrid').getStore();
				s.baseParams.query = this.getValue();
				//s.reload();
				Ext.getCmp('WindowSelectPerson').bottomToolbar.changePage(1);
			},
			onTrigger2Click: function(){
				//preklic iskanja
				this.setValue('');
				Ext.getCmp('attendedDate').setRawValue('');
				Ext.getCmp('attendedDate').setValue('');
				var s = Ext.getCmp('selectPersonGrid').getStore();
				delete s.baseParams.query;
				delete s.baseParams.date;
				s.load()
			},
			listeners: {
                 specialkey: function(field, e){
                     if (e.getKey() == e.ENTER) {
                        field.onTrigger1Click();
                     }
                 }
             }
         })
    ],
    listeners: {
		afterRender: function(grid){
			var X = (screen.width/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().width)/2);
			var Y = (screen.height/2) - ((Ext.getCmp('<?php echo $windowId;?>').getSize().height)/2);
			Ext.getCmp('<?php echo $windowId;?>').setPosition(X, Y);
		}
	},
	buttons:[{
		text: '<?php echo $LangPack->GetLabel("CRM_all", "CRM_cancle_button","Prekliči"); ?>',
		handler: function(){
			Ext.getCmp('<?php echo $windowId;?>').close();
		}
	},{
		text:'<?php echo $LangPack->GetLabel("CRM_all", "CRM_select_button","Izberi"); ?>',
		id: 'select',
		disabled: true,
		handler: function(){
			var val = Ext.getCmp('selectPersonGrid').getSelectionModel().selections.items[0].data.id;
			Ext.getCmp('<?php echo $windowId;?>').close();
			<?php if($_SESSION['CRM_login']) { ?>
				Ext.getCmp('west-panel').collapse();
				CallScript('<?php echo CRM_RPATH; ?>_forms/kartoteka/forms.main.panel.php', { id: val });
			<?php } else {?>
				addTabAuto('KartotekaPanel_'+val,'<?php echo CRM_RPATH; ?>_forms/kartoteka/forms.main.panel.php', { id: val });
			<?php }?>
		}
	}]
}).show();
