<?php
$gridName = "ActivitiesGrid_".$id;
$table = "_customerActivities";
?>
var <?php echo $gridName;?> = new Ext.grid.EditorGridPanel({
	id: '<?php echo $gridName;?>',
    border: false,
    store: new Ext.data.Store({
		url: '<?php echo $activityAjax;?>',			
		autoLoad: true,
		baseParams:{
			action: 'get',
			customerId: '<?php echo $id;?>'
		},
		reader: new Ext.data.JsonReader({		
				root:'rows',
				totalProperty : "results"
			},
			new Ext.data.Record.create([
				{ name:"id", type: 'id' },
				{ name:"customerId", type:'int'},
				{ name:"activityId", type: 'int' },
			 	{ name:"activity", type: 'string' },
			 	{ name:"inputDate", type: 'string' },
			 	{ name:"addedDate", type: 'string' },
			 	{ name:"fileLocation", type:'string' },
			 	{ name:"comment", type: 'string'},
			 	{ name:"filename", type:'string'} 
			])
		)
	}),
	sm: new Ext.grid.RowSelectionModel(),
    id: '<?php echo $gridName;?>',
    border: false,
    region: 'west',
  	columns: [{
		header: '#ID',
		dataIndex: 'id',
		hidden: true
	},{
		header: '#ID',
		dataIndex: 'activityId',
		hidden: true
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "customerId_title","Uporabnik id");?>',
		dataIndex: 'customerId',
		hidden: true,
		width: 50
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "activity_title","Aktivnost");?>',
		dataIndex: 'activity',
		width: 150
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "inputDate_title","Datum");?>',
		dataIndex: 'inputDate',
		renderer: Ext.util.Format.dateRenderer("d.m.Y"),
		width: 100
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "addedDate_title","Datum dodaje");?>',
		dataIndex: 'addedDate',
		hidden: true,
		width: 100
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "file_title","Datoteka");?>',
		dataIndex: 'fileLocation',
		renderer: function(a,metadata, record){
			var temp = a.split("").reverse().join("");
			temp = temp.split(".")[0].split("").reverse().join("").toLowerCase();
			if(temp == "jpg" || temp == "jpeg" || temp == "png" || temp == "bmp" || temp == "gif")
				return "<img src='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' atl='"+a+"' style='width:100px; height:100px;'>";
			else if(temp == "pdf"){
				return "<a href='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' target='_blank'>"+record.data.filename+"</a>";
			}else if(temp == "doc" || temp == "docx"){
				return "<a href='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' target='_blank'>"+record.data.filename+"</a>";
			}else if(temp == "xlr" || temp == "xls" || temp == "xlsx"){
				return "<a href='<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>"+a+"' target='_blank'>"+record.data.filename+"</a>";
			}else if(record.data.activityId == 6){
				return record.data.activity;
			}
			return "UNKNOWN";
		}
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "comment_title","Komentar");?>',
		dataIndex: 'comment',
		width: 200
	},{
		header: '<?php echo $LangPack->GetLabel("preview_activities_window", "filename_title","Ime datoteke");?>',
		dataIndex: 'filename',
		width: 150
	}],
	listeners:{
		celldblclick: function(grid, rowIndex, columnIndex){
			if(columnIndex == 6){
				var record = grid.getStore().getAt(rowIndex);
				var field = record.fields.items[columnIndex];
				//console.log(record);
				if(record.data.activityId == 1 || record.data.activityId == 2)
    				window.open('<?php echo ACTIVITE_UPLOAD_WWW_PATH;?>' + record.data.fileLocation).focus();
    			else if(record.data.activityId == 6){
    			    CallScript('<?php echo CRM_RPATH; ?>_forms/kartoteka/window.editComment.php', { 
                        field: 'comment', 
                        rowIndex: rowIndex, 
                        id: record.id,
                        gridName: '<?php echo $gridName;?>' 
                    });
    			}
			}
			else if(columnIndex == 7){  
			    var record = grid.getStore().getAt(rowIndex);
			    CallScript('<?php echo CRM_RPATH; ?>_forms/kartoteka/window.editComment.php', { 
			        field: 'comment', 
                    rowIndex: rowIndex, 
                    id: record.id,
                    gridName: '<?php echo $gridName;?>' 
                });
			}	
		},
		afteredit : function(e) {
   			Ext.Ajax.request({
   				url:'<?php echo $activityAjax;?>',
   				params: { 
   					action: 'update',
					id		: e.record.id,
				    field	: e.field,
					value 	: e.value,
					oldValue: e.originalValue,
					table: '<?php echo $table; ?>',
					idField : 'id' 		
   				},
				success : function(resp,opt){ 
					e.record.commit();
				}							  							
			})
		}	
	},
	tbar:[{
		text: '<?php echo $LangPack->GetLabel("preview_activities_window", "add_button_title","Dodaj");?>',
		handler: function(){
			CallScript('<?php echo CRM_RPATH; ?>_forms/kartoteka/window.addActivities.php', { id: <?php echo $_POST['id'];?>, gridName: '<?php echo $gridName;?>' });
		}
	},{
		text: '<?php echo $LangPack->GetLabel("preview_activities_window", "delete_button_title","Brisanje");?>',
		handler: function(){
			var selection = Ext.getCmp('<?php echo $gridName;?>').selModel.selections;
			if(selection.item.length>0){
				Ext.Msg.confirm('<?php echo $LangPack->GetLabel("preview_activities_window", "CRM_delete_message_title","Brisanje"); ?>', '<?php echo $LangPack->GetLabel("CRM_attendance_panel", "CRM_delete_message_msg","Ali res želite izbrisati to osebo?"); ?> ('+selection.items[0].data.activity +')', function(btn){
					if(btn == "yes"){
						Ext.Ajax.request({
			   				url:'<?php echo $ajax;?>',
			   				params: { 
			   					action: 'deleteActivity',
								id		: selection.items[0].data.id		
			   				},
							success : function(resp,opt){ 
								Ext.getCmp('<?php echo $gridName;?>').getStore().reload();
							}				
						})
					}
				});
			}
		}
	},'->',{
		text: '<?php echo $LangPack->GetLabel("preview_activities_window", "html_export_button_title","Izvoz v HTML");?>',
		handler: function(){
			window.open('<?php echo CRM_RPATH; ?>_forms/kartoteka/viewActivities.php?a=<?php echo $id;?>', '_blank').focus();
		}
	}]
});
