<?php

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");

include_once (PATH_TO_ROOT."CRM/_CRM_config.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once (PATH_TO_ROOT."CRM/class/class.checkString.php");

$LangPack = new LanguagePack($db, $aLanguage);

$gridName = "FinancialTab".$suffix;
$ajax = CRM_RPATH."_forms/orders/_ajax/ajax.window.search-filter.php";
$windowId = "windowOsebaId";

?>
var <?php echo $gridName;?> = new Ext.form.FormPanel({
	id:'<?php echo $gridName;?>',
	bodyStyle:'padding: 20px',
	border: false,
	region: 'center',
	autoScroll: true,
	labelAlign: 'left',
	labelWidth: 150,
	items:
	[
		{
			layout:'form',
			anchor: '-0',
			xtype: 'fieldset',
			collapsed:true,
			collapsible: true,
			autoHeight: true,
			title: '<?php echo $LangPack->GetLabel("edit_user_window", "user_fiedset_title","Podatki o osebi");?>',
	        items:
	        [
		        {
					xtype: 'textfield',
		        	name: 'ime',
		        	flex:1,
		        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "name_title","Ime");?>'
		        	<?php if(isset(StringChecker::Check($_POST['addType']))) echo ", allowBlank: false" ?>
				},{
					xtype: 'textfield',
		        	name: 'priimek',
		        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "surname_title","Priimek");?>'
		        	<?php if(isset(StringChecker::Check($_POST['addType']))) echo ", allowBlank: false" ?>
				},{
					xtype: 'textfield',
		        	name: 'naslov',
		        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "address_title","Naslov");?>',
		        	anchor: '100%'
				},{
					xtype: 'numberfield',
		        	name: 'postna_st',
					fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "post_code_title","Poštna številka");?>',
					minValue: 0,
					width: 50
				},{
					xtype: 'textfield',
		        	name: 'kraj',
		        	fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "city_title","Kraj");?>'
				},{
					fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "email_title","Email");?>',
		            name: 'email',
		            vtype:'email',
		            xtype: 'textfield'
				},{
					xtype: 'textfield',
		        	name: 'tel1',
					fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "phone1_title","Telefonska številka 1");?>',
				},{
					xtype: 'textfield',
		        	name: 'tel2',
					fieldLabel: '<?php echo $LangPack->GetLabel("edit_user_window", "phone2_title","Telefonska številka 2");?>',
				}
			]
		},
		
		{
			layout:'form',
			anchor: '-0',
			xtype: 'fieldset',
			collapsible: true,
			collapsed:true,
			autoHeight: true,
			title: '<?php echo $LangPack->GetLabel("window_order_search_filter", "team-presentation-title","Ekipa / Prezentacija");?>',
	        items:
	        [
		        
				 new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "team_name_title","Ekipa");?>',
				    width: 100,
				    name: 'tp_name',   
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store:
				    [
				    
				     <?php
		       			$presentationGroup = array();
						$sql = "SELECT * FROM ".DB_WARPIT_WEBCATI_BASE."._groups 
									WHERE id_sup = ".WARPIT_PRESENTATION_GROUP_ID;
						if ($_SESSION['UserInfo']['user_type'] == 0) {
							$sql .=  " AND id IN ( SELECT id_group FROM ".DB_WARPIT_WEBCATI_BASE."._group_link WHERE id = ".$_SESSION['UserInfo']['id']." AND id_type=0) ";
						}
						$sql .="	ORDER BY orderBy";
						$res = $db->SQLexecute($sql);
						while($dat = $db->fetchAssoc($res)){
							array_push($presentationGroup, '["'.$dat['id'].'", "'.$dat['idLab'].'"]');
						}
						echo implode(", ", $presentationGroup);
		       		  ?> 
	                ]
				   
				}),
				 new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "city_name_title","Kraj");?>',
				    width: 100,
				    name: 'tp_city',   
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store:
				    [
	                   [1, 'Ljubljana'],
	                   [2, 'Nova Gorica']
	                ]
				   
				}),
				 new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "presentation_date","Datum");?>',
				    width: 100,
				    name: 'tp_date',   
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store:
				    [
	                   [1, '2013-12-17'],
	                   [2, '2013-12-18'],
	                   [3, '2013-12-18'],
	                   [4, '2013-12-19'],
	                   [5, '2013-12-20']
	                ]
				   
				}),
				 new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "presentation_time","Čas");?>',
				    width: 100,
				    name: 'tp_time',   
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store:
				    [
	                   [1, '8:30'],
	                   [2, '15:30']
	                ]
				   
				})
			]
		} ,
		{
			layout:'form',
			anchor: '-0',
			collapsible: true,
			collapsed:true,
			xtype: 'fieldset',
			autoHeight: true,
			title: '<?php echo $LangPack->GetLabel("window_order_search_filter", "order-title","Podatki o  naročilu");?>',
	        items:
	        [
		        
				{
					xtype: 'textfield',
		        	name: 'order_article_code',
		        	fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "article_code","Šifra izdelka");?>'
				},
				{
					xtype: 'textfield',
		        	name: 'order_article_amount',
		        	width: 30,
		        	fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "article_amount","Količina");?>'
				},
				{
					xtype: 'textfield',
		        	name: 'order_article_price',
		        	width: 60,
		        	fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "article_price","Cena");?>'
				}, 
				
				new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "order_type","Način plačila");?>',
				    width: 200,
				    name: 'order_type',   
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store:
				    [
	                   <?php
		       			$tipiPlacila = array();
						$sql = "SELECT * FROM ". WARPIT_CRM."._tipiPlacila WHERE deleted = 0 ORDER BY orderBy";
						$res = $db->SQLexecute($sql);
						while($dat = $db->fetchAssoc($res)){
							array_push($tipiPlacila, '["'.$dat['id'].'", "'.$dat['naziv_placila'].'"]');
						}
						echo implode(", ", $tipiPlacila);
		       			?>
	                ]
				   
				}),
				new Ext.form.ComboBox({
				    typeAhead: true,
				    editable: false,
				    fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "order_status","Status naročila");?>',
				    width: 200,
				    name: 'order_status',   
				    triggerAction: 'all',
				    lazyRender:true,
				    mode: 'local',
				    store:
				    [
	                   [1, '<?php echo $LangPack->GetLabel("CRM_order_status", "ordered","Naročeno");?>'],
	                   [2, '<?php echo $LangPack->GetLabel("CRM_order_status", "delivered","Dostavljeno");?>'],
	                   [3, '<?php echo $LangPack->GetLabel("CRM_order_status", "date_delivery_change","Sprememba datuma");?>'],
	                   [4, '<?php echo $LangPack->GetLabel("CRM_order_status", "storno_team","Storno ekipa");?>'],
	                   [5, '<?php echo $LangPack->GetLabel("CRM_order_status", "storno_delivery","Storno dostava");?>'],
	                   [6, '<?php echo $LangPack->GetLabel("CRM_order_status", "product_refund","Vračilo izdelek");?>'],
	                   [7, '<?php echo $LangPack->GetLabel("CRM_order_status", "credit_refusal","Zavrnitev kredita");?>']
	                
	                ]
				   
				}),
				
				new Ext.form.DateField({
					format: 'd.m.Y',
					editable: false,
				
					
					name: 'dorder_date_from',
					width: 100,
					
					fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "order_date_from","Datum naročil od");?>'
				}),
				new Ext.form.DateField({
					format: 'd.m.Y',
					editable: false,
				
					
					name: 'dorder_date_to',
					width: 100,
					
					fieldLabel: '<?php echo $LangPack->GetLabel("window_order_search_filter", "order_date_to","Datum naročil do");?>'
				})
			]
		}
	]
});


var <?php echo $windowId;?> = new Ext.Window({
   	title:'<?php echo $LangPack->GetLabel("window_order_search_filter", "window_title","Iskanje / Filter");?>',
    id		: '<?php echo $windowId;?>',
    width	: 460,
    height	: 520,
    plain	: true,
    layout	: 'border',
    frame: true,
    modal: true,
    items	: [
		<?php echo $gridName;?>
	],
	
	buttons:[{
		text:'<?php echo $LangPack->GetLabel("CRM_all", "CRM_cancle_button","Prekliči"); ?>',
		handler: function(){
			<?php echo $windowId;?>.close();
		}
	},{
		text: '<?php echo $LangPack->GetLabel("CRM_all","CRM_filter_button","Filtriraj");?>',
		handler: function(){
			var data = Ext.getCmp('<?php echo $gridName;?>').getForm().getFieldValues();
			Ext.getCmp('<?php echo StringChecker::Check($_POST['grid']);?>').getStore().reload({params: {
				ime: data.ime,
				priimek: data.priimek,
				dorder_date_to: data.dorder_date_to,
				dorder_date_from: data.dorder_date_from,
				email: data.email,
				kraj: data.kraj,
				naslov: data.naslov,
				order_article_amount: data.order_article_amount,
				order_article_price: data.order_article_price,
				order_article_code: data.order_article_code,
				order_type: data.order_type,
				order_status: data.order_status,
				postna_st: data.postna_st,
				tel1: data.tel1,
				tel2: data.tel2,
				tp_city: data.tp_city,
				tp_date: data.tp_date,
				tp_time: data.tp_time
			}});
			Ext.getCmp('<?php echo $windowId;?>').close();
		}
	}]
}).show();