<?php

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once (PATH_TO_ROOT."CRM/_CRM_config.php");


$LangPack = new LanguagePack($db, $aLanguage);
$compName = "deliveryContract".$suffix;
$tabName = "deliveryContractTab";

$ajaxDeliveryContract = CRM_RPATH."_forms/deliveryContract/_ajax/ajax.deliveryContract.php";
$ajaxFilter = CRM_RPATH."_forms/filter/_ajax/ajax.filter.php";
$ajaxReturnDate = CRM_RPATH."_forms/deliveryContract/_ajax/ajax.deliveryReturnDate.php";
$suffix = uniqid();
$deliveryContract = true;

?>
Ext.ns('Ext.ux.grid');
Ext.ux.grid.CheckColumn = Ext.extend(Ext.grid.Column, {
    processEvent : function(name, e, grid, rowIndex, colIndex){
        if (name == 'click') {
            var record = grid.store.getAt(rowIndex);
            record.set(this.dataIndex, !record.data[this.dataIndex]);
            var field = grid.getColumnModel().getDataIndex(colIndex);
            var t = field.slice(-11);
            if(t != 'ReturnCheck'){
	            var fieldValue = record.data.month3Check;
	            if(field == "month3Check"){
	            	fieldValue = record.data.month3Check;
	            }else if(field == "month6Check"){
	            	fieldValue = record.data.month6Check;
	            }else if(field == "month9Check"){
	            	fieldValue = record.data.month9Check;
	            }else if(field == "month15Check"){
	            	fieldValue = record.data.month15Check;
	            }
	            Ext.Ajax.request({
	            	url:'<?php echo $ajaxDeliveryContract;?>',
	   				params: { 
	   					action: 'update' ,
						id		: record.data.id,
					    field	: field,
				    	oldValue: !fieldValue,
						value 	: fieldValue == true ? 1 : 0,
						table: '<?php echo WARPIT_CRM."._visitStatistic";?>'					
	   				}
	            });
	        }else{
	        	var fieldValue = record.data.month3Check;
	        	if(field == "month3ReturnCheck"){
	            	fieldValue = record.data.month3ReturnCheck;
	            }else if(field == "month6ReturnCheck"){
	            	fieldValue = record.data.month6ReturnCheck;
	            }else if(field == "month9ReturnCheck"){
	            	fieldValue = record.data.month9ReturnCheck;
	            }else if(field == "month15ReturnCheck"){
	            	fieldValue = record.data.month15ReturnCheck;
	            }
	            if(fieldValue){
		        	CallScript('<?php echo CRM_RPATH;?>_forms/deliveryContract/window.changeReturnDate.php', { 
		        		id: record.data.id, 
		        		value: true, 
		        		gridName: '<?php echo $compName;?>',
		        		field: field
		        	 });
	        	 }else{
	        	 	Ext.Ajax.request({
	        	 		url: '<?php echo $ajaxReturnDate;?>',
	        	 		params:{
	        	 			action: 'update',
	        	 			id: record.data.id,
	        	 			field: field,
	        	 			table: '<?php echo WARPIT_CRM."._visitStatistic";?>'
	        	 		}
	        	 	})
	        	 }
	        }
            record.commit();
            return false; // Cancel row selection.
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },

    renderer : function(v, p, record){
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    },

    init: Ext.emptyFn
});
Ext.preg('checkcolumn', Ext.ux.grid.CheckColumn);
Ext.grid.CheckColumn = Ext.ux.grid.CheckColumn;
Ext.grid.Column.types.checkcolumn = Ext.ux.grid.CheckColumn;


var deliveryContractPageLimit = 10;

var deliveryContractStore = new Ext.data.Store({
	url: '<?php echo $ajaxDeliveryContract;?>',			
	baseParams:{
		action: 'get',
		start: 0,
		limit: deliveryContractPageLimit
	},
	pageSize: deliveryContractPageLimit,
	reader: new Ext.data.JsonReader({		
		root:'rows',
		totalProperty : 'results'
	},
	new Ext.data.Record.create([
	 	{ name:"id", type: 'int' },
	 	{ name:"firstname", type:'string'},
	 	{ name:"surname", type:'string'},
	 	{ name:"gender", type:'int'},
	 	{ name:"post_code", type:'int'},
	 	{ name:"city", type:'string'},
	 	{ name:"address", type:'string'},
	 	{ name:"marital_status", type:'int'},
	 	{ name:"birth_date", type:'string'},
	 	{ name:"email", type:'string'},
	 	{ name:"datum_dostave", type:'string'},
	 	{ name:"phone1", type:'string'},
	 	{ name:"productName", type:'string'},
	 	{ name:"product_price", type:'float'},
	 	{ name:"month3Date", type:'string'},
	 	{ name:"month3Check", type:'bool'},
	 	{ name:"month3ReturnCheck", type:'bool'},
	 	{ name:"month6Date", type:'string'},
	 	{ name:"month6Check", type:'bool'},
	 	{ name:"month6ReturnCheck", type:'bool'},
	 	{ name:"month9Date", type:'string'},
	 	{ name:"month9Check", type:'bool'},
	 	{ name:"month9ReturnCheck", type:'bool'},
	 	{ name:"month15Date", type:'string'},
	 	{ name:"month15Check", type:'bool'},
	 	{ name:"month15ReturnCheck", type:'bool'}	
		])
	)
}); 

var <?php echo $compName;?> = new Ext.grid.EditorGridPanel({
	store: deliveryContractStore,
    id: '<?php echo $compName;?>',
    border: false,
    closable: true,
    region: 'center',
    viewConfig: {    
		getRowClass: function(record, rowIndex, rp, ds){    	
			str = '';
			var now = new Date();
			var date = new Date(record.get('datum_dostave'));
			var date3 = new Date(date.getFullYear(), date.getMonth()+3, date.getDate());
			var date6 = new Date(date.getFullYear(), date.getMonth()+6, date.getDate());
			var date9 = new Date(date.getFullYear(), date.getMonth()+9, date.getDate());
			var date15 = new Date(date.getFullYear(), date.getMonth()+15, date.getDate());

			if(record.get('month3Check') && record.get('month9Check') && record.get('month15Check'))
				str = 'OrderStatusGreen';
			if(now > date3 && !record.get('month3Check'))
				str = 'OrderStatusRed';
			if(now > date9 && !record.get('month9Check'))
				str = 'OrderStatusRed';
			if(now > date6 && !record.get('month6Check'))
				str = 'OrderStatusRed';
			if(now > date15 && !record.get('month15Check'))
				str = 'OrderStatusRed';
		
			if(this.showPreview){                   
				 return 'x-grid3-row-expanded ' + str;       
			}
			return 'x-grid3-row-collapsed ' + str;  
		}
    },
  	columns: [{
		header: '#ID', 
		width: 20, 
		dataIndex: 'id',
		hidden: true 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "firstname_column_text","Ime");?>', 
		width: 100, 
		sortable: true,
		dataIndex: 'firstname'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "surname_column_text","Priimek");?>', 
		width: 130, 
		sortable: true,
		dataIndex: 'surname'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "gender_column_text","Spol");?>', 
		width: 60, 
		sortable: true,
		renderer: function(a){
        	if(a=="1") return '<?php echo $LangPack->GetLabel("CRM_all", "male_gender_title","Moški");?>';
        	else if(a=="2") return '<?php echo $LangPack->GetLabel("CRM_all", "female_gender_title","Ženski");?>';
        },
		dataIndex: 'gender'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "post_code_column_text","Poštna številka");?>', 
		width: 100, 
		sortable: true,
		dataIndex: 'post_code'	
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "city_column_text","Mesto");?>', 
		width: 130, 
		sortable: true,
		hidden: true,
		dataIndex: 'city' 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "address_column_text","Naslov");?>', 
		width: 150, 
		sortable: true,
		dataIndex: 'address',
		hidden: true 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "marital_status_column_text","Zakonski stan");?>', 
		width: 80, 
		hidden: true,
		sortable: true,
		renderer: function(a){
        	if(a==2) return '<?php echo $LangPack->GetLabel("CRM_all", "marital_status_maried_title","Poročen");?>';
        	else if(a==1) return '<?php echo $LangPack->GetLabel("CRM_all", "marital_status_single_title","Samski");?>';
        },
		dataIndex: 'marital_status',
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "birth_date_column_text","Rojstni dan");?>', 
		width: 100, 
		sortable: true,
		hidden: true,
		renderer: function(a)  {
			if(a != '0000-00-00'){
				return Ext.util.Format.date(a, 'd.m.Y');
			}
		},
		dataIndex: 'birth_date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "email_column_text","Email");?>', 
		width: 130, 
		sortable: true,
		hidden: true,
		dataIndex: 'email'
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "phone1_column_text","Telefon");?>', 
		width: 130, 
		sortable: true,
		hidden: true,
		dataIndex: 'phone1'		 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "productName_column_text","Product");?>', 
		width: 130, 
		sortable: true,
		dataIndex: 'productName'		 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "product_price_column_text","Cena (enega)");?>', 
		width: 120, 
		sortable: true,
		renderer: function(a){
			return a + '<?php echo MONEY_VALUE;?>';
		},
		dataIndex: 'product_price'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month3Date_column_text","3 mesce od dostave");?>', 
		width: 120, 
		sortable: true,
		dataIndex: 'month3Date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month3Check_column_text","3 mesce");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month3Check',
		xtype: 'checkcolumn'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month3ReturnCheck_column_text","3 mesce vrnitev");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month3ReturnCheck',
		xtype: 'checkcolumn'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month6Date_column_text","6 mescov od dostave");?>', 
		width: 120, 
		sortable: true,
		dataIndex: 'month6Date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month6Check_column_text","6 mescov");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month6Check',
		xtype: 'checkcolumn'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month6ReturnCheck_column_text","6 mescov vrnitev");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month6ReturnCheck',
		xtype: 'checkcolumn'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month9Date_column_text","9 mesce od dostave");?>', 
		width: 120, 
		sortable: true,
		dataIndex: 'month9Date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month9Check_column_text","9 mesce");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month9Check',
		xtype: 'checkcolumn'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month9ReturnCheck_column_text","9 mescov vrnitev");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month9ReturnCheck',
		xtype: 'checkcolumn'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month15Date_column_text","15 mesce od dostave");?>', 
		width: 120, 
		sortable: true,
		dataIndex: 'month15Date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month15Check_column_text","15 mesce");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month15Check',
		xtype: 'checkcolumn'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month15ReturnCheck_column_text","15 mescov vrnitev");?>', 
		width: 50, 
		sortable: true,
		dataIndex: 'month15ReturnCheck',
		xtype: 'checkcolumn'   			 
  	}],
 	sm: new Ext.grid.RowSelectionModel(),
    flex: 1,
    tbar:[{
    	xtype:'button',
    	enableToggle: true,
    	id: 'showLateButton',
    	text: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "show_late_button", "Show late");?>',
    	handler: function(){
    		Ext.getCmp('<?php echo $compName;?>').getStore().load({ params: { 
                    action : 'get', 
                    showLate: this.pressed, 
                    time_from: Ext.getCmp('time_from_<?php echo $suffix; ?>').getRawValue(),
	                time_to: Ext.getCmp('time_to_<?php echo $suffix; ?>').getRawValue(),
	                firstname: Ext.getCmp('firstname_<?php echo $suffix;?>').getValue(),
                    surname: Ext.getCmp('surname_<?php echo $suffix;?>').getValue() 
                }
            });
    	}
    },'->',{
    	xtype:'button',
    	text:'<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "print_button","Printanje"); ?>',
    	handler: function(){
            var time_from = Ext.getCmp('time_from_<?php echo $suffix; ?>').getRawValue();
            var time_to = Ext.getCmp('time_to_<?php echo $suffix; ?>').getRawValue();
            var firstname = Ext.getCmp('firstname_<?php echo $suffix;?>').getValue();
            var surname = Ext.getCmp('surname_<?php echo $suffix;?>').getValue(); 
            var dateChecked = Ext.getCmp('dateChecked_<?php echo $suffix;?>').getValue();
            
            var urlParams = "&time_from="+time_from+"&time_to="+time_to+"&firstname="+firstname+"&surname="+surname+"&dateChecked="+dateChecked;
            
    		window.open("<?php echo $ajaxDeliveryContract; ?>?action=print&showLate="+Ext.getCmp('showLateButton').pressed+urlParams, '_blank').focus();
    	}
    },{
    	xtype: 'button',
    	text:'<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "print_history_button","Zgodovina prinotv"); ?>',
    	handler: function(){
    		CallScript('CRM/_forms/deliveryContract/window.printHistory.php');
    	}
    },{
    	xtype: 'button',
    	id: 'export_button',
    	text: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "export_button","Izvozi"); ?>',
    	handler: function(){
    		var time_from = Ext.getCmp('time_from_<?php echo $suffix; ?>').getRawValue();
            var time_to = Ext.getCmp('time_to_<?php echo $suffix; ?>').getRawValue();
            var firstname = Ext.getCmp('firstname_<?php echo $suffix;?>').getValue();
            var surname = Ext.getCmp('surname_<?php echo $suffix;?>').getValue(); 
            var dateChecked = Ext.getCmp('dateChecked_<?php echo $suffix;?>').getValue();
            
            var urlParams = "&time_from="+time_from+"&time_to="+time_to+"&firstname="+firstname+"&surname="+surname+"&dateChecked="+dateChecked;
            
    		window.open('<?php echo $ajaxDeliveryContract; ?>?action=export&showLate='+Ext.getCmp('showLateButton').pressed+urlParams, '_blank').focus();
    	}
    }],
   	listeners: {
   		afteredit : function(e) {
   			Ext.Ajax.request({
   				url:'<?php echo $ajaxDeliveryContract;?>',
   				params: { 
   					action: 'update' ,
					id		: e.record.data.id,
				    field	: e.field,
					value 	: e.value,
					oldValue: e.originalValue					
   				},
				success : function(resp,opt){ 
					e.record.commit();
				}							  							
			})
		}	
	}     
});


var <?php echo $tabName;?> = new Ext.Panel({
	id:'<?php echo $tabName;?>',
	title: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "tab_title","Dobavne pogodbe");?>',
	defaults:{split:true,border:false, bodyStyle: 'padding: 10px'},
	layout:'border',
	border: false,
	autoSroll: true,
	closable:true,
	items:[ <?php include(PATH_TO_ROOT."CRM/_forms/filter/panell.filter.php"); ?>, <?php echo $compName;?> ]
});
  
Ext.getCmp('mainTabPanel').add(<?php echo $tabName; ?>).show();
<?php
$d = new DateTime(); 
$weekday = $d->format('w'); 
$diff = ($weekday == 0 ? 6 : $weekday -1);
$d->modify("-$diff day");   
?>
Ext.getCmp('<?php echo $compName;?>').getEl().mask('<?php echo $LangPack->GetLabel("CRM_all", "loading_mask_text","Posodabljanje...");?>');
Ext.getCmp('<?php echo $compName; ?>').getStore().load({params:{ time_from: '<?php echo date("d.m.Y");?>', time_to: '<?php $d->modify('+6 day'); echo $d->format("d.m.Y");?>' }, callback: function(resp, opt, success){
	if(success){
		Ext.getCmp('<?php echo $compName;?>').getEl().unmask();
	}
}});