<?php

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."CRM/class/class.Language-Pack.php");
include_once (PATH_TO_ROOT."CRM/_CRM_config.php");

$LangPack = new LanguagePack($db, $aLanguage);
$compName = "deliveryContract".$suffix;
$tabName = "deliveryContract";

$ajaxDeliveryContract = CRM_RPATH."_forms/deliveryContract/_ajax/ajax.deliveryContract.php";
$ajaxFilter = CRM_RPATH."_forms/filter/_ajax/ajax.filter.php";
$export = CRM_RPATH."_forms/filter/_ajax/ajax.filter.php";
$suffix = uniqid();
$finance = true;

?>

var deliveryContractPageLimit = 10;

var deliveryContractStore = new Ext.data.Store({
	url: '<?php echo $ajaxDeliveryContract;?>',			
	baseParams:{
		action: 'get',
		start: 0,
		limit: deliveryContractPageLimit
	},
	pageSize: deliveryContractPageLimit,
	reader: new Ext.data.JsonReader({		
		root:'rows',
		totalProperty : 'results'
	},
	new Ext.data.Record.create([
	 	{ name:"id", type: 'int' },
	 	{ name:"firstname", type:'string'},
	 	{ name:"surname", type:'string'},
	 	{ name:"gender", type:'int'},
	 	{ name:"post_code", type:'int'},
	 	{ name:"city", type:'string'},
	 	{ name:"address", type:'string'},
	 	{ name:"marital_status", type:'int'},
	 	{ name:"birth_day", type:'string'},
	 	{ name:"email", type:'string'},
	 	{ name:"phone1", type:'string'},
	 	{ name:"month3Date", type:'string'},
	 	{ name:"month3Check", type:'bool'},
	 	{ name:"month9Date", type:'string'},
	 	{ name:"month9Check", type:'bool'},
	 	{ name:"month15Date", type:'string'},
	 	{ name:"month15Check", type:'bool'}	
		)
	)
}); 

var <?php echo $compName;?> = new Ext.grid.EditorGridPanel({
	store: deliveryContractStore,
    id: '<?php echo $compName;?>',
    border: false,
    closable: true,
    region: 'center',
  	columns: [{
		header: '#ID', 
		width: 20, 
		dataIndex: 'id',
		hidden: true 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "firstname_column_text","Ime");?>', 
		width: 130, 
		sortable: true,
		dataIndex: 'firstname'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "surname_column_text","Priimek");?>', 
		width: 130, 
		sortable: true,
		dataIndex: 'surname'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "gender_column_text","Spol");?>', 
		width: 200, 
		sortable: true,
		dataIndex: 'gender'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "post_code_column_text","Poštna številka");?>', 
		width: 100, 
		sortable: true,
		dataIndex: 'post_code'	
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "city_column_text","Mesto");?>', 
		width: 200, 
		sortable: true,
		dataIndex: 'city' 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "address_column_text","Naslov");?>', 
		width: 150, 
		sortable: true,
		dataIndex: 'address',
		hidden: true 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "marital_status_column_text","Zakonski stan");?>', 
		width: 150, 
		sortable: true,
		dataIndex: 'marital_status',
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "birth_day_column_text","Rojstni dan");?>', 
		width: 100, 
		sortable: true,
		dataIndex: 'birth_day'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "email_column_text","Email");?>', 
		width: 90, 
		sortable: true,
		dataIndex: 'email'
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "phone1_column_text","Telefon");?>', 
		width: 200, 
		sortable: true,
		dataIndex: 'phone1'		 
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month3Date_column_text","3 mesce od dpstave");?>', 
		width: 200, 
		sortable: true,
		dataIndex: 'month3Date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month3Check_column_text","3 mesce");?>', 
		width: 340, 
		sortable: true,
		dataIndex: 'month3Check'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month9Date_column_text","9 mesce od dpstave");?>', 
		width: 200, 
		sortable: true,
		dataIndex: 'month9Date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month9Check_column_text","9 mesce");?>', 
		width: 340, 
		sortable: true,
		dataIndex: 'month9Check'   			 
  	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month15Date_column_text","15 mesce od dpstave");?>', 
		width: 200, 
		sortable: true,
		dataIndex: 'month15Date'
	},{
		header: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "month15Check_column_text","15 mesce");?>', 
		width: 340, 
		sortable: true,
		dataIndex: 'month15Check'   			 
  	}],
 	sm: new Ext.grid.RowSelectionModel(),
    flex: 1,
    tbar:['->',{
    	xtype: 'button',
    	id: 'export_button',
    	text: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "export_button","Izvozi"); ?>',
    	handler: function(){
    		var form = Ext.getCmp('FilterPanel<?php echo $suffix; ?>').getForm();
            var formValues = form.getValues();
    		window.open('<?php echo $export; ?>?dataExport=true&orders=true&filterValues=' + Ext.encode(formValues), '_blank').focus();
    	}
    }],
    bbar: new Ext.PagingToolbar({
        pageSize: deliveryContractPageLimit,
        store: deliveryContractStore,
        displayInfo: true,
        displayMsg: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "pagger_display_msg","Dobavne pogodbe");?> {0} - {1} of {2}',
        emptyMsg: "<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "pagger_empty_msg","Ni pogodb");?>"
    }),
   	listeners: {
   		afteredit : function(e) {
   			Ext.Ajax.request({
   				url:'<?php echo $ajaxDeliveryContract;?>',
   				params: { 
   					action: 'update' ,
					id		: e.record.data.id,
				    field	: e.field,
					value 	: e.value,
					oldValue: e.originalValue					
   				},
				success : function(resp,opt){ 
					e.record.commit();
					
				}							  							
			})
		}	
	}     
});
<?php echo $compName; ?>.getStore().load();

var <?php echo $tabName;?> = new Ext.Panel({
	id:'<?php echo $tabName;?>',
	title: '<?php echo $LangPack->GetLabel("CRM_deliveryContract_panel", "tab_title","Dobavne pogodbe");?>',
	defaults:{split:true,border:false, bodyStyle: 'padding: 10px'},
	layout:'border',
	border: false,
	autoSroll: true,
	closable:true,
	items:[ <?php include(PATH_TO_ROOT."CRM/_forms/filter/panell.filter.php"); ?>, <?php echo $compName;?> ]
});
  
Ext.getCmp('mainTabPanel').add(<?php echo $tabName; ?>).show();