var <?php echo $formName;?> = new Ext.form.FormPanel({
    region: 'north',
    bodyStyle: 'padding: 20px',
    height: 135,
    items:[{
        xtype: 'container',
        layout: 'column',
        defaults:{
            style: 'margin-right: 20px; margin-bottom: 15px'
        },
        items:[{
            xtype: 'button',
            id: 'today_clubMembers',
            name: 'today',
            width: 80,
            enableToggle: true,
            text: '<?php echo $LangPack->GetLabel("filter_delivery_grid", "today_button_text","Danes");?>',
            handler: function(){
                Ext.getCmp('time_from_clubMembers').setValue(new Date());
                Ext.getCmp('time_to_clubMembers').setValue(new Date());
            },
            listeners: {
                click: function(comp){
                    if(comp.pressed == true){
                        if(Ext.getCmp('yesterday_clubMembers').pressed == true){
                            Ext.getCmp('yesterday_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_week_clubMembers').pressed == true){
                            Ext.getCmp('this_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('last_week_clubMembers').pressed == true){
                            Ext.getCmp('last_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_month_clubMembers').pressed == true){
                            Ext.getCmp('this_month_clubMembers').toggle();    
                        }
                        if(Ext.getCmp('last_month_clubMembers').pressed == true){
                            Ext.getCmp('last_month_clubMembers').toggle();    
                        } 
                    }
                    Ext.getCmp('clubMembersExportButton').disable();
                }
            }
        },{
            xtype: 'button',
            id: 'yesterday_clubMembers',
            name: 'yesterday',
            width: 80,
            enableToggle: true,
            text: '<?php echo $LangPack->GetLabel("filter_delivery_grid", "yesterday_button_text","Včeraj");?>',
            handler: function(){
                <?php
                    $now = new DateTime();
                    $now->modify("-1 day");
                ?>
                Ext.getCmp('time_from_clubMembers').setValue('<?php echo $now->format("d.m.Y");?>');
                Ext.getCmp('time_to_clubMembers').setValue('<?php echo $now->format("d.m.Y");?>');
            },
            listeners: {
                click: function(comp){
                    if(comp.pressed == true){
                        if(Ext.getCmp('today_clubMembers').pressed == true){
                            Ext.getCmp('today_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_week_clubMembers').pressed == true){
                            Ext.getCmp('this_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('last_week_clubMembers').pressed == true){
                            Ext.getCmp('last_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_month_clubMembers').pressed == true){
                            Ext.getCmp('this_month_clubMembers').toggle();    
                        }
                        if(Ext.getCmp('last_month_clubMembers').pressed == true){
                            Ext.getCmp('last_month_clubMembers').toggle();    
                        } 
                    }
                    Ext.getCmp('clubMembersExportButton').disable();
                }
            }
        },{
            xtype: 'button',
            id: 'this_week_clubMembers',
            name: 'this_week',
            width: 80,
            enableToggle: true,
            text: '<?php echo $LangPack->GetLabel("filter_delivery_grid", "this_week_button_text","Ta teden");?>',
            handler: function(){
                var now = new Date();
                var day = now.getDay(),
                diff = now.getDate() - day + (day == 0 ? -6:1); // adjust when day is sunday
                var start = new Date(now.setDate(diff));
                var end = new Date(now.setDate(diff+6));        
                <?php 
                    $d = new DateTime(); 
                    $weekday = $d->format('w'); 
                    $diff = ($weekday == 0 ? 6 : $weekday -1);
                    $d->modify("-$diff day");   
                ?>      
                
                Ext.getCmp('time_from_clubMembers').setValue('<?php echo $d->format("d.m.Y");?>');
                Ext.getCmp('time_to_clubMembers').setValue('<?php $d->modify('+6 day'); echo $d->format("d.m.Y");?>');
            },
            listeners: {
                click: function(comp){
                    if(comp.pressed == true){
                        if(Ext.getCmp('yesterday_clubMembers').pressed == true){
                            Ext.getCmp('yesterday_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('today_clubMembers').pressed == true){
                            Ext.getCmp('today_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('last_week_clubMembers').pressed == true){
                            Ext.getCmp('last_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_month_clubMembers').pressed == true){
                            Ext.getCmp('this_month_clubMembers').toggle();    
                        }
                        if(Ext.getCmp('last_month_clubMembers').pressed == true){
                            Ext.getCmp('last_month_clubMembers').toggle();    
                        } 
                    }
                    Ext.getCmp('clubMembersExportButton').disable();
                }
            }
        },{
            xtype: 'button',
            id: 'last_week_clubMembers',
            name: 'last_week',
            pressed: true,
            width: 80,
            enableToggle: true,
            text: '<?php echo $LangPack->GetLabel("filter_delivery_grid", "last_week_button_text","Prejšnji teden");?>',
            handler: function(){            
                <?php 
                    $d = new DateTime(); 
                    $weekday = $d->format('w'); 
                    $diff = 7 + ($weekday == 0 ? 6 : $weekday -1); 
                    $d->modify("-$diff day");  
                ?>
                Ext.getCmp('time_from_clubMembers').setValue('<?php echo $d->format("d.m.Y");?>');
                Ext.getCmp('time_to_clubMembers').setValue('<?php $d->modify("+6 day"); echo $d->format("d.m.Y");?>');
            },
            listeners: {
                click: function(comp){
                    if(comp.pressed == true){
                        if(Ext.getCmp('yesterday_clubMembers').pressed == true){
                            Ext.getCmp('yesterday_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_week_clubMembers').pressed == true){
                            Ext.getCmp('this_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('today_clubMembers').pressed == true){
                            Ext.getCmp('today_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_month_clubMembers').pressed == true){
                            Ext.getCmp('this_month_clubMembers').toggle();    
                        }
                        if(Ext.getCmp('last_month_clubMembers').pressed == true){
                            Ext.getCmp('last_month_clubMembers').toggle();    
                        } 
                    }
                    Ext.getCmp('clubMembersExportButton').disable();
                }
            }
        },{
            xtype: 'button',
            id: 'this_month_clubMembers',
            name: 'this_month',
            width: 80,
            enableToggle: true,
            text: '<?php echo $LangPack->GetLabel("filter_delivery_grid", "this_month_button_text","Ta mesec");?>',
            handler: function(){
                var date = new Date();
                var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);         
                
                Ext.getCmp('time_from_clubMembers').setValue(firstDay);
                Ext.getCmp('time_to_clubMembers').setValue(lastDay);
            },
            listeners: {
                click: function(comp){
                    if(comp.pressed == true){
                        if(Ext.getCmp('yesterday_clubMembers').pressed == true){
                            Ext.getCmp('yesterday_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_week_clubMembers').pressed == true){
                            Ext.getCmp('this_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('last_week_clubMembers').pressed == true){
                            Ext.getCmp('last_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('today_clubMembers').pressed == true){
                            Ext.getCmp('today_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('last_month_clubMembers').pressed == true){
                            Ext.getCmp('last_month_clubMembers').toggle();    
                        } 
                    }
                    Ext.getCmp('clubMembersExportButton').disable();
                }
            }
        },{
            xtype: 'button',
            id: 'last_month_clubMembers',
            name: 'last_month',
            width: 80,
            enableToggle: true,
            text: '<?php echo $LangPack->GetLabel("filter_delivery_grid", "last_month_button_text","Prejšnji mesec");?>',
            handler: function(){
                var date = new Date();
                var firstDay = new Date(date.getFullYear(), date.getMonth()-1, 1);
                var lastDay = new Date(date.getFullYear(), date.getMonth(), 0);         
                
                Ext.getCmp('time_from_clubMembers').setValue(firstDay);
                Ext.getCmp('time_to_clubMembers').setValue(lastDay);
            },
            listeners: {
                click: function(comp){
                    if(comp.pressed == true){
                        if(Ext.getCmp('yesterday_clubMembers').pressed == true){
                            Ext.getCmp('yesterday_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_week_clubMembers').pressed == true){
                            Ext.getCmp('this_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('last_week_clubMembers').pressed == true){
                            Ext.getCmp('last_week_clubMembers').toggle(); 
                        }
                        if(Ext.getCmp('this_month_clubMembers').pressed == true){
                            Ext.getCmp('this_month_clubMembers').toggle();    
                        }
                        if(Ext.getCmp('today_clubMembers').pressed == true){
                            Ext.getCmp('today_clubMembers').toggle(); 
                        }
                    }
                    Ext.getCmp('clubMembersExportButton').disable();
                }
            }
        }]},{
        xtype:'container',
        layout:'column',
        style: 'margin-left:16px',
        items:[{
            xtpye: 'container',
            layout:'form',
            border: false,
            items:[{
                xtype:'datefield',
                fieldLabel: '<?php echo $LangPack->GetLabel("clubMembersTab", "date_from_label", "Date from");?>',
                name: 'date_from',
                id: 'time_from_clubMembers',
                listeners:{
                    select: function(comp, a, b){
                        Ext.getCmp('clubMembersExportButton').disable();
                    }  
                },
                format: 'd.m.Y'
            }]
        },{
            xtpye: 'container',
            layout:'form',
            border: false,
            style: 'margin-left:20px',
            items:[{
                xtype:'datefield',
                fieldLabel: '<?php echo $LangPack->GetLabel("clubMembersTab", "date_to_label", "Date to");?>',
                name: 'date_to',
                id: 'time_to_clubMembers',
                listeners:{
                    select: function(comp, a, b){
                        Ext.getCmp('clubMembersExportButton').disable();
                    }  
                },
                format: 'd.m.Y'
            }]
        }]
    },{
        xtype: 'container',
        anchor: '60%',
        items: [{
            xtype: 'radiogroup',
            id: 'radioGroupClubMembers',
            cls: 'x-check-group-alt',
            listeners: {
                change: function(comp, a, b){
                    Ext.getCmp('clubMembersExportButton').disable();
                }  
            },
            items: [{
                name: 'dateType',
                id:'radioGroupClubMembers1',
                boxLabel: '<?php echo $LangPack->GetLabel("clubMembersTab", "delivery_date_radio_label", "Delivery date");?>',
                checked: true,
                style: { marginLeft: '15px' },
                width: 150 
            },{
                name: 'dateType',
                id:'radioGroupClubMembers2',
                hidden: true,
                boxLabel: '<?php echo $LangPack->GetLabel("clubMembersTab", "order_date_radio_label", "Order date");?>',
                style: { marginLeft: '10px' },
                width: 200                  
            },{
                name: 'dateType',
                id:'radioGroupClubMembers3',
                boxLabel: '<?php echo $LangPack->GetLabel("clubMembersTab", "activity_added_date_radio_label", "Activity added date");?>',
                style: { marginLeft: '10px' },
                width: 200 
            }]
        }]
    },{
    	xtype: 'container',
    	layout:'column',
        style: 'margin-left:15px; margin-top: 10px',
    	items: [
    	{
    	  xtype: 'checkbox',
    	  id: 'ClubMembersHolderCheckbox',
    	  listeners:{
    	      check: function(comp, a, b){
    	          Ext.getCmp('clubMembersExportButton').disable();
    	      }
    	  },
    	  checked: true,
    	  boxLabel: '<?php echo $LangPack->GetLabel("clubMembersTab", "show_holder_checkbox", "Prikazi nosilce");?>'  
    	},
    	{
    	  xtype: 'checkbox',
    	  style: { marginLeft: '20px'},
    	  listeners:{
              check: function(comp, a, b){
                  Ext.getCmp('clubMembersExportButton').disable();
              }
          },
    	  id: 'ClubMembersCompanionCheckbox',
    	  boxLabel: '<?php echo $LangPack->GetLabel("clubMembersTab", "show_companions_checkbox", "Prikazi spremljevalce");?>'  
    	}
    	
    	
    	
    	,{
    		xtype: 'button',
    		style: { marginLeft: '20px'},
	        text:'<?php echo $LangPack->GetLabel("CRM_all", "CRM_search_button", "Search");?>',
	        handler: function(){
	            var store = Ext.getCmp('<?php echo $gridName;?>').getStore();
	            var dF = Ext.getCmp('time_from_clubMembers').getRawValue();
	            var dT = Ext.getCmp('time_to_clubMembers').getRawValue();
	            var rG = 1;
	            Ext.each(Ext.getCmp('radioGroupClubMembers').items.items, function(i){
	                if(i.checked){
	                    rG = i.id[i.id.length-1];
	                }
	            });
	            delete store.baseParams.windowFilter;
	            delete store.baseParams.dateField;
	            delete store.baseParams.date_from;
	            delete store.baseParams.date_to;
	            store.baseParams.companions = Ext.getCmp('ClubMembersCompanionCheckbox').checked;
	            store.baseParams.holders = Ext.getCmp('ClubMembersHolderCheckbox').checked;
	            
	            store.baseParams.dateField = rG;
	            if(dF != ""){
	                store.baseParams.date_from = dF;
	            }
	            if(dT != ""){
	                store.baseParams.date_to = dT;
	            }
	            
				store.reload();
				Ext.getCmp('clubMembersExportButton').enable();
	        }
    	}]
    }]
});